/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.util;

import java.lang.ref.SoftReference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.cojen.util.BeanIntrospector;
import org.cojen.util.BeanProperty;
import org.cojen.util.BeanPropertyAccessor;
import org.cojen.util.Cache;
import org.cojen.util.WeakIdentityCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BeanPropertyMapFactory<B> {
    private static final Cache<Class, SoftReference<BeanPropertyMapFactory>> cFactories = new WeakIdentityCache<Class, SoftReference<BeanPropertyMapFactory>>(17);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <B> BeanPropertyMapFactory<B> forClass(Class<B> clazz) {
        Cache<Class, SoftReference<BeanPropertyMapFactory>> cache = cFactories;
        synchronized (cache) {
            Map<String, BeanProperty> properties;
            BeanPropertyMapFactory factory;
            SoftReference<BeanPropertyMapFactory> ref = cFactories.get(clazz);
            if (ref != null && (factory = ref.get()) != null) {
                return factory;
            }
            Map<String, BeanProperty> supportedProperties = properties = BeanIntrospector.getAllProperties(clazz);
            for (Map.Entry<String, BeanProperty> entry : properties.entrySet()) {
                BeanProperty property = entry.getValue();
                if (property.getReadMethod() != null && property.getWriteMethod() != null && !BeanPropertyAccessor.throwsCheckedException(property.getReadMethod()) && !BeanPropertyAccessor.throwsCheckedException(property.getWriteMethod())) continue;
                if (supportedProperties == properties) {
                    supportedProperties = new HashMap<String, BeanProperty>(properties);
                }
                supportedProperties.remove(entry.getKey());
            }
            factory = supportedProperties.size() == 0 ? Empty.INSTANCE : new Standard<B>(BeanPropertyAccessor.forClass(clazz, BeanPropertyAccessor.PropertySet.READ_WRITE_UNCHECKED_EXCEPTIONS), supportedProperties);
            cFactories.put(clazz, new SoftReference<Standard<B>>(factory));
            return factory;
        }
    }

    public static SortedMap<String, Object> asMap(Object bean) {
        if (bean == null) {
            throw new IllegalArgumentException();
        }
        BeanPropertyMapFactory<?> factory = BeanPropertyMapFactory.forClass(bean.getClass());
        return factory.createMap(bean);
    }

    public abstract SortedMap<String, Object> createMap(B var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SubMap<B>
    extends BeanMap<B> {
        final String mFromKey;
        final String mToKey;

        SubMap(B bean, BeanPropertyAccessor<B> accessor, SortedSet<String> propertyNames, String fromKey, String toKey) {
            super(bean, accessor, propertyNames);
            this.mFromKey = fromKey;
            this.mToKey = toKey;
        }

        @Override
        public SortedMap<String, Object> subMap(String fromKey, String toKey) {
            if (this.mFromKey != null && this.mFromKey.compareTo(fromKey) > 0) {
                fromKey = this.mFromKey;
            }
            if (this.mToKey != null && this.mToKey.compareTo(toKey) < 0) {
                toKey = this.mToKey;
            }
            return new SubMap<Object>(this.mBean, this.mAccessor, this.mPropertyNames.subSet(fromKey, toKey), fromKey, toKey);
        }

        @Override
        public SortedMap<String, Object> headMap(String toKey) {
            if (this.mToKey != null && this.mToKey.compareTo(toKey) < 0) {
                toKey = this.mToKey;
            }
            return new SubMap<Object>(this.mBean, this.mAccessor, this.mPropertyNames.headSet(toKey), this.mFromKey, toKey);
        }

        @Override
        public SortedMap<String, Object> tailMap(String fromKey) {
            if (this.mFromKey != null && this.mFromKey.compareTo(fromKey) > 0) {
                fromKey = this.mFromKey;
            }
            return new SubMap<Object>(this.mBean, this.mAccessor, this.mPropertyNames.tailSet(fromKey), fromKey, this.mToKey);
        }

        @Override
        public boolean containsKey(Object key) {
            if (key == null) {
                return false;
            }
            String strKey = (String)key;
            if (this.mFromKey != null && this.mFromKey.compareTo(strKey) > 0) {
                return false;
            }
            if (this.mToKey != null && this.mToKey.compareTo(strKey) <= 0) {
                return false;
            }
            return this.mAccessor.hasReadableProperty(strKey);
        }

        @Override
        public boolean containsValue(Object value) {
            for (String key : this.keySet()) {
                Object propValue = this.mAccessor.getPropertyValue(this.mBean, key);
                if (!(propValue == null ? value == null : propValue.equals(value))) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object get(Object key) {
            if (key == null) {
                return null;
            }
            String strKey = (String)key;
            if (this.mFromKey != null && this.mFromKey.compareTo(strKey) > 0) {
                return null;
            }
            if (this.mToKey != null && this.mToKey.compareTo(strKey) <= 0) {
                return null;
            }
            return this.mAccessor.tryGetPropertyValue(this.mBean, strKey);
        }

        @Override
        public Object put(String key, Object value) {
            if (key != null) {
                if (this.mFromKey != null && this.mFromKey.compareTo(key) > 0) {
                    throw this.rangeError(key);
                }
                if (this.mToKey != null && this.mToKey.compareTo(key) <= 0) {
                    throw this.rangeError(key);
                }
            }
            Object old = this.mAccessor.tryGetPropertyValue(this.mBean, key);
            this.mAccessor.setPropertyValue(this.mBean, key, value);
            return old;
        }

        private IllegalArgumentException rangeError(String key) {
            String range = this.mFromKey == null ? "," + this.mToKey : (this.mToKey == null ? this.mFromKey + "," : this.mFromKey + "," + this.mToKey);
            return new IllegalArgumentException("Key out of range: key=" + key + ", range=[" + range + ')');
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BeanMap<B>
    extends AbstractMap<String, Object>
    implements SortedMap<String, Object> {
        final B mBean;
        final BeanPropertyAccessor mAccessor;
        final SortedSet<String> mPropertyNames;

        BeanMap(B bean, BeanPropertyAccessor<B> accessor, SortedSet<String> propertyNames) {
            this.mBean = bean;
            this.mAccessor = accessor;
            this.mPropertyNames = propertyNames;
        }

        @Override
        public Comparator<? super String> comparator() {
            return null;
        }

        @Override
        public SortedMap<String, Object> subMap(String fromKey, String toKey) {
            return new SubMap<B>(this.mBean, this.mAccessor, this.mPropertyNames.subSet(fromKey, toKey), fromKey, toKey);
        }

        @Override
        public SortedMap<String, Object> headMap(String toKey) {
            return new SubMap<B>(this.mBean, this.mAccessor, this.mPropertyNames.headSet(toKey), null, toKey);
        }

        @Override
        public SortedMap<String, Object> tailMap(String fromKey) {
            return new SubMap<B>(this.mBean, this.mAccessor, this.mPropertyNames.tailSet(fromKey), fromKey, null);
        }

        @Override
        public String firstKey() {
            return this.mPropertyNames.first();
        }

        @Override
        public String lastKey() {
            return this.mPropertyNames.last();
        }

        @Override
        public int size() {
            return this.mPropertyNames.size();
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean containsKey(Object key) {
            return this.mAccessor.hasReadableProperty((String)key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.mAccessor.hasPropertyValue(this.mBean, value);
        }

        @Override
        public Object get(Object key) {
            return this.mAccessor.tryGetPropertyValue(this.mBean, (String)key);
        }

        @Override
        public Object put(String key, Object value) {
            Object old = this.mAccessor.tryGetPropertyValue(this.mBean, key);
            this.mAccessor.setPropertyValue(this.mBean, key, value);
            return old;
        }

        @Override
        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<String> keySet() {
            return this.mPropertyNames;
        }

        @Override
        public Collection<Object> values() {
            return new AbstractCollection<Object>(){

                @Override
                public Iterator<Object> iterator() {
                    return new Iterator<Object>(){
                        private final Iterator<String> mPropIterator;
                        {
                            this.mPropIterator = BeanMap.this.keySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.mPropIterator.hasNext();
                        }

                        @Override
                        public Object next() {
                            return BeanMap.this.get(this.mPropIterator.next());
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public int size() {
                    return BeanMap.this.size();
                }

                @Override
                public boolean isEmpty() {
                    return false;
                }

                @Override
                public boolean contains(Object v) {
                    return BeanMap.this.containsValue(v);
                }

                @Override
                public boolean remove(Object e) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void clear() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return new AbstractSet<Map.Entry<String, Object>>(){

                @Override
                public Iterator<Map.Entry<String, Object>> iterator() {
                    return new Iterator<Map.Entry<String, Object>>(){
                        private final Iterator<String> mPropIterator;
                        {
                            this.mPropIterator = BeanMap.this.keySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.mPropIterator.hasNext();
                        }

                        @Override
                        public Map.Entry<String, Object> next() {
                            final String property = this.mPropIterator.next();
                            final Object value = BeanMap.this.get(property);
                            return new Map.Entry<String, Object>(){
                                Object mutableValue;
                                {
                                    this.mutableValue = value;
                                }

                                @Override
                                public String getKey() {
                                    return property;
                                }

                                @Override
                                public Object getValue() {
                                    return this.mutableValue;
                                }

                                @Override
                                public Object setValue(Object value2) {
                                    Object old = BeanMap.this.put(property, value2);
                                    this.mutableValue = value2;
                                    return old;
                                }

                                @Override
                                public boolean equals(Object obj) {
                                    if (this == obj) {
                                        return true;
                                    }
                                    if (obj instanceof Map.Entry) {
                                        Map.Entry other = (Map.Entry)obj;
                                        return (this.getKey() == null ? other.getKey() == null : this.getKey().equals(other.getKey())) && (this.getValue() == null ? other.getValue() == null : this.getValue().equals(other.getValue()));
                                    }
                                    return false;
                                }

                                @Override
                                public int hashCode() {
                                    return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
                                }

                                public String toString() {
                                    return property + "=" + this.mutableValue;
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public int size() {
                    return BeanMap.this.size();
                }

                @Override
                public boolean isEmpty() {
                    return false;
                }

                @Override
                public boolean contains(Object e) {
                    Map.Entry entry = (Map.Entry)e;
                    String key = (String)entry.getKey();
                    if (BeanMap.this.containsKey(key)) {
                        Object value = BeanMap.this.get(key);
                        return value == null ? entry.getValue() == null : value.equals(entry.getValue());
                    }
                    return false;
                }

                @Override
                public boolean add(Map.Entry<String, Object> e) {
                    BeanMap.this.put(e.getKey(), e.getValue());
                    return true;
                }

                @Override
                public boolean remove(Object e) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void clear() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Standard<B>
    extends BeanPropertyMapFactory<B> {
        final BeanPropertyAccessor mAccessor;
        final SortedSet<String> mPropertyNames;

        public Standard(BeanPropertyAccessor<B> accessor, Map<String, BeanProperty> properties) {
            this.mAccessor = accessor;
            TreeSet<String> propertyNames = new TreeSet<String>();
            for (BeanProperty property : properties.values()) {
                if (property.getReadMethod() == null) continue;
                propertyNames.add(property.getName());
            }
            this.mPropertyNames = Collections.unmodifiableSortedSet(propertyNames);
        }

        @Override
        public SortedMap<String, Object> createMap(B bean) {
            if (bean == null) {
                throw new IllegalArgumentException();
            }
            return new BeanMap<B>(bean, this.mAccessor, this.mPropertyNames);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Empty
    extends BeanPropertyMapFactory {
        static final Empty INSTANCE = new Empty();
        static final SortedMap<String, Object> EMPTY_MAP = Collections.unmodifiableSortedMap(new TreeMap());

        private Empty() {
        }

        public SortedMap<String, Object> createMap(Object bean) {
            if (bean == null) {
                throw new IllegalArgumentException();
            }
            return EMPTY_MAP;
        }
    }
}

