/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.classfile.attribute;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.cojen.classfile.Attribute;
import org.cojen.classfile.ConstantPool;
import org.cojen.classfile.MethodInfo;
import org.cojen.classfile.TypeDesc;
import org.cojen.classfile.constant.ConstantClassInfo;

public class StackMapTableAttr
extends Attribute {
    private final InitialFrame mInitialFrame;
    private int mSize;
    private int mLength;

    public StackMapTableAttr(ConstantPool cp) {
        super(cp, "StackMapTable");
        this.mInitialFrame = new InitialFrame();
    }

    public StackMapTableAttr(ConstantPool cp, String name, int length, DataInput din) throws IOException {
        super(cp, name);
        InitialFrame first;
        int size = din.readUnsignedShort();
        StackMapFrame last = first = new InitialFrame();
        for (int i = 0; i < size; ++i) {
            StackMapFrame frame = StackMapFrame.read(last, cp, din);
            if (frame == null) continue;
            last = frame;
        }
        this.mInitialFrame = first;
        this.mSize = size;
        this.mLength = length;
    }

    public int getLength() {
        if (this.mLength < 0) {
            if (this.mInitialFrame.getNext() == null) {
                this.mLength = 0;
            } else {
                int length = 2;
                for (StackMapFrame frame = this.mInitialFrame; frame != null; frame = frame.getNext()) {
                    length += ((StackMapFrame)frame).getLength();
                }
                this.mLength = length;
            }
        }
        return this.mLength;
    }

    public void writeTo(DataOutput dout) throws IOException {
        if (this.mSize == 0) {
            return;
        }
        super.writeTo(dout);
    }

    public void writeDataTo(DataOutput dout) throws IOException {
        dout.writeShort(this.mSize);
        for (StackMapFrame frame = this.mInitialFrame; frame != null; frame = frame.getNext()) {
            ((StackMapFrame)frame).writeTo(dout);
        }
    }

    public StackMapFrame getInitialFrame() {
        return this.mInitialFrame;
    }

    public void setInitialFrame(MethodInfo method) {
        this.mInitialFrame.set(this.getConstantPool(), method);
    }

    private static class UninitVariableInfo
    extends VerificationTypeInfo {
        private final int mOffset;

        UninitVariableInfo(ConstantPool cp, DataInput din) throws IOException {
            this.mOffset = din.readUnsignedShort();
        }

        public int getLength() {
            return 3;
        }

        public TypeDesc getType() {
            return null;
        }

        public boolean isUninitialized() {
            return true;
        }

        public void writeTo(DataOutput dout) throws IOException {
            dout.writeByte(8);
            dout.writeShort(this.mOffset);
        }

        public String toString() {
            return "<uninitialized>";
        }
    }

    private static class ObjectVariableInfo
    extends VerificationTypeInfo {
        private final ConstantClassInfo mClassInfo;

        ObjectVariableInfo(ConstantPool cp, DataInput din) throws IOException {
            this.mClassInfo = (ConstantClassInfo)cp.getConstant(din.readUnsignedShort());
        }

        ObjectVariableInfo(ConstantPool cp, TypeDesc desc) {
            this.mClassInfo = cp.addConstantClass(desc);
        }

        public int getLength() {
            return 3;
        }

        public TypeDesc getType() {
            return this.mClassInfo.getType();
        }

        public void writeTo(DataOutput dout) throws IOException {
            dout.writeByte(7);
            dout.writeShort(this.mClassInfo.getIndex());
        }
    }

    private static class UninitThisVariableInfo
    extends VerificationTypeInfo {
        static final UninitThisVariableInfo THE = new UninitThisVariableInfo();

        private UninitThisVariableInfo() {
        }

        public TypeDesc getType() {
            return null;
        }

        public boolean isThis() {
            return true;
        }

        public boolean isUninitialized() {
            return true;
        }

        public void writeTo(DataOutput dout) throws IOException {
            dout.writeByte(6);
        }

        public String toString() {
            return "<uninitialized this>";
        }
    }

    private static class NullVariableInfo
    extends VerificationTypeInfo {
        static final NullVariableInfo THE = new NullVariableInfo();

        private NullVariableInfo() {
        }

        public TypeDesc getType() {
            return null;
        }

        public void writeTo(DataOutput dout) throws IOException {
            dout.writeByte(5);
        }

        public String toString() {
            return "<null>";
        }
    }

    private static class DoubleVariableInfo
    extends VerificationTypeInfo {
        static final DoubleVariableInfo THE = new DoubleVariableInfo();

        private DoubleVariableInfo() {
        }

        public TypeDesc getType() {
            return TypeDesc.DOUBLE;
        }

        public void writeTo(DataOutput dout) throws IOException {
            dout.writeByte(3);
        }
    }

    private static class LongVariableInfo
    extends VerificationTypeInfo {
        static final LongVariableInfo THE = new LongVariableInfo();

        private LongVariableInfo() {
        }

        public TypeDesc getType() {
            return TypeDesc.LONG;
        }

        public void writeTo(DataOutput dout) throws IOException {
            dout.writeByte(4);
        }
    }

    private static class FloatVariableInfo
    extends VerificationTypeInfo {
        static final FloatVariableInfo THE = new FloatVariableInfo();

        private FloatVariableInfo() {
        }

        public TypeDesc getType() {
            return TypeDesc.FLOAT;
        }

        public void writeTo(DataOutput dout) throws IOException {
            dout.writeByte(2);
        }
    }

    private static class IntegerVariableInfo
    extends VerificationTypeInfo {
        static final IntegerVariableInfo THE = new IntegerVariableInfo();

        private IntegerVariableInfo() {
        }

        public TypeDesc getType() {
            return TypeDesc.INT;
        }

        public void writeTo(DataOutput dout) throws IOException {
            dout.writeByte(1);
        }
    }

    private static class TopVariableInfo
    extends VerificationTypeInfo {
        static final TopVariableInfo THE = new TopVariableInfo();

        private TopVariableInfo() {
        }

        public TypeDesc getType() {
            return null;
        }

        public boolean isTop() {
            return true;
        }

        public void writeTo(DataOutput dout) throws IOException {
            dout.writeByte(0);
        }

        public String toString() {
            return "<top>";
        }
    }

    public static abstract class VerificationTypeInfo {
        static final VerificationTypeInfo[] EMPTY_ARRAY = new VerificationTypeInfo[0];

        static VerificationTypeInfo read(ConstantPool cp, DataInput din) throws IOException {
            int type = din.readUnsignedByte();
            switch (type) {
                case 0: {
                    return TopVariableInfo.THE;
                }
                case 1: {
                    return IntegerVariableInfo.THE;
                }
                case 2: {
                    return FloatVariableInfo.THE;
                }
                case 3: {
                    return DoubleVariableInfo.THE;
                }
                case 4: {
                    return LongVariableInfo.THE;
                }
                case 5: {
                    return NullVariableInfo.THE;
                }
                case 6: {
                    return UninitThisVariableInfo.THE;
                }
                case 7: {
                    return new ObjectVariableInfo(cp, din);
                }
                case 8: {
                    return new UninitVariableInfo(cp, din);
                }
            }
            return null;
        }

        static VerificationTypeInfo forType(ConstantPool cp, TypeDesc type) {
            switch (type.getTypeCode()) {
                default: {
                    return TopVariableInfo.THE;
                }
                case 0: {
                    return new ObjectVariableInfo(cp, type);
                }
                case 4: 
                case 5: 
                case 8: 
                case 9: 
                case 10: {
                    return IntegerVariableInfo.THE;
                }
                case 11: {
                    return LongVariableInfo.THE;
                }
                case 6: {
                    return FloatVariableInfo.THE;
                }
                case 7: 
            }
            return DoubleVariableInfo.THE;
        }

        private static VerificationTypeInfo[] read(ConstantPool cp, DataInput din, int num) throws IOException {
            VerificationTypeInfo[] infos = new VerificationTypeInfo[num];
            for (int i = 0; i < num; ++i) {
                infos[i] = VerificationTypeInfo.read(cp, din);
            }
            return infos;
        }

        VerificationTypeInfo() {
        }

        int getLength() {
            return 1;
        }

        public abstract TypeDesc getType();

        public boolean isTop() {
            return false;
        }

        public boolean isThis() {
            return false;
        }

        public boolean isUninitialized() {
            return false;
        }

        public abstract void writeTo(DataOutput var1) throws IOException;

        public String toString() {
            return this.getType().getFullName();
        }
    }

    private static class FullFrame
    extends StackMapFrame {
        private final int mOffsetDelta;
        private final VerificationTypeInfo[] mLocalInfos;
        private final VerificationTypeInfo[] mStackItemInfos;

        FullFrame(StackMapFrame prev, ConstantPool cp, DataInput din) throws IOException {
            super(prev);
            this.mOffsetDelta = din.readUnsignedShort();
            int numLocals = din.readUnsignedShort();
            this.mLocalInfos = VerificationTypeInfo.read(cp, din, numLocals);
            int numStackItems = din.readUnsignedShort();
            this.mStackItemInfos = VerificationTypeInfo.read(cp, din, numStackItems);
        }

        public int getLength() {
            int length = 7;
            for (VerificationTypeInfo info : this.mLocalInfos) {
                length += info.getLength();
            }
            for (VerificationTypeInfo info : this.mStackItemInfos) {
                length += info.getLength();
            }
            return length;
        }

        public int getOffsetDelta() {
            return this.mOffsetDelta;
        }

        public VerificationTypeInfo[] getLocalInfos() {
            return (VerificationTypeInfo[])this.mLocalInfos.clone();
        }

        public VerificationTypeInfo[] getStackItemInfos() {
            return (VerificationTypeInfo[])this.mStackItemInfos.clone();
        }

        public void writeTo(DataOutput dout) throws IOException {
            dout.writeByte(255);
            dout.writeShort(this.mOffsetDelta);
            dout.writeShort(this.mLocalInfos.length);
            for (VerificationTypeInfo info : this.mLocalInfos) {
                info.writeTo(dout);
            }
            dout.writeShort(this.mStackItemInfos.length);
            for (VerificationTypeInfo info : this.mStackItemInfos) {
                info.writeTo(dout);
            }
        }
    }

    private static class AppendFrame
    extends StackMapFrame {
        private final int mOffsetDelta;
        private final VerificationTypeInfo[] mAppendInfos;
        private transient VerificationTypeInfo[] mLocalInfos;

        AppendFrame(StackMapFrame prev, int numLocals, ConstantPool cp, DataInput din) throws IOException {
            super(prev);
            this.mOffsetDelta = din.readUnsignedShort();
            this.mAppendInfos = VerificationTypeInfo.read(cp, din, numLocals);
        }

        public int getLength() {
            int length = 3;
            for (VerificationTypeInfo info : this.mAppendInfos) {
                length += info.getLength();
            }
            return length;
        }

        public int getOffsetDelta() {
            return this.mOffsetDelta;
        }

        public VerificationTypeInfo[] getLocalInfos() {
            if (this.mLocalInfos == null) {
                VerificationTypeInfo[] prevInfos = this.getPrevious().getLocalInfos();
                VerificationTypeInfo[] infos = new VerificationTypeInfo[prevInfos.length + this.mAppendInfos.length];
                System.arraycopy(prevInfos, 0, infos, 0, prevInfos.length);
                System.arraycopy(this.mAppendInfos, 0, infos, prevInfos.length, this.mAppendInfos.length);
                this.mLocalInfos = infos;
            }
            return (VerificationTypeInfo[])this.mLocalInfos.clone();
        }

        public VerificationTypeInfo[] getStackItemInfos() {
            return VerificationTypeInfo.EMPTY_ARRAY;
        }

        public void writeTo(DataOutput dout) throws IOException {
            dout.writeByte(251 + this.mAppendInfos.length);
            dout.writeShort(this.mOffsetDelta);
            for (VerificationTypeInfo info : this.mAppendInfos) {
                info.writeTo(dout);
            }
        }
    }

    private static class SameFrameExtended
    extends StackMapFrame {
        private final int mOffsetDelta;

        SameFrameExtended(StackMapFrame prev, DataInput din) throws IOException {
            super(prev);
            this.mOffsetDelta = din.readUnsignedShort();
        }

        public int getLength() {
            return 3;
        }

        public int getOffsetDelta() {
            return this.mOffsetDelta;
        }

        public VerificationTypeInfo[] getLocalInfos() {
            return this.getPrevious().getLocalInfos();
        }

        public VerificationTypeInfo[] getStackItemInfos() {
            return VerificationTypeInfo.EMPTY_ARRAY;
        }

        public void writeTo(DataOutput dout) throws IOException {
            dout.writeByte(251);
            dout.writeShort(this.mOffsetDelta);
        }
    }

    private static class ChopFrame
    extends StackMapFrame {
        private final int mOffsetDelta;
        private final int mChop;
        private transient VerificationTypeInfo[] mLocalInfos;

        ChopFrame(StackMapFrame prev, int chop, DataInput din) throws IOException {
            super(prev);
            this.mOffsetDelta = din.readUnsignedShort();
            this.mChop = chop;
        }

        public int getLength() {
            return 3;
        }

        public int getOffsetDelta() {
            return this.mOffsetDelta;
        }

        public VerificationTypeInfo[] getLocalInfos() {
            if (this.mLocalInfos == null) {
                VerificationTypeInfo[] prevInfos = this.getPrevious().getLocalInfos();
                VerificationTypeInfo[] infos = new VerificationTypeInfo[prevInfos.length - this.mChop];
                System.arraycopy(prevInfos, 0, infos, 0, infos.length);
                this.mLocalInfos = infos;
            }
            return (VerificationTypeInfo[])this.mLocalInfos.clone();
        }

        public VerificationTypeInfo[] getStackItemInfos() {
            return VerificationTypeInfo.EMPTY_ARRAY;
        }

        public void writeTo(DataOutput dout) throws IOException {
            dout.writeByte(251 - this.mChop);
            dout.writeShort(this.mOffsetDelta);
        }
    }

    private static class SameLocalsOneStackItemFrameExtended
    extends StackMapFrame {
        private final int mOffsetDelta;
        private final VerificationTypeInfo mStackItemInfo;

        SameLocalsOneStackItemFrameExtended(StackMapFrame prev, ConstantPool cp, DataInput din) throws IOException {
            super(prev);
            this.mOffsetDelta = din.readUnsignedShort();
            this.mStackItemInfo = VerificationTypeInfo.read(cp, din);
        }

        public int getLength() {
            return 3 + this.mStackItemInfo.getLength();
        }

        public int getOffsetDelta() {
            return this.mOffsetDelta;
        }

        public VerificationTypeInfo[] getLocalInfos() {
            return this.getPrevious().getLocalInfos();
        }

        public VerificationTypeInfo[] getStackItemInfos() {
            return new VerificationTypeInfo[]{this.mStackItemInfo};
        }

        public void writeTo(DataOutput dout) throws IOException {
            dout.writeByte(257);
            dout.writeShort(this.mOffsetDelta);
            this.mStackItemInfo.writeTo(dout);
        }
    }

    private static class SameLocalsOneStackItemFrame
    extends StackMapFrame {
        private final int mOffsetDelta;
        private final VerificationTypeInfo mStackItemInfo;

        SameLocalsOneStackItemFrame(StackMapFrame prev, int offsetDelta, ConstantPool cp, DataInput din) throws IOException {
            super(prev);
            this.mOffsetDelta = offsetDelta;
            this.mStackItemInfo = VerificationTypeInfo.read(cp, din);
        }

        public int getLength() {
            return 1 + this.mStackItemInfo.getLength();
        }

        public int getOffsetDelta() {
            return this.mOffsetDelta;
        }

        public VerificationTypeInfo[] getLocalInfos() {
            return this.getPrevious().getLocalInfos();
        }

        public VerificationTypeInfo[] getStackItemInfos() {
            return new VerificationTypeInfo[]{this.mStackItemInfo};
        }

        public void writeTo(DataOutput dout) throws IOException {
            dout.writeByte(64 + this.mOffsetDelta);
            this.mStackItemInfo.writeTo(dout);
        }
    }

    private static class SameFrame
    extends StackMapFrame {
        private final int mOffsetDelta;

        SameFrame(StackMapFrame prev, int offsetDelta) {
            super(prev);
            this.mOffsetDelta = offsetDelta;
        }

        public int getLength() {
            return 1;
        }

        public int getOffsetDelta() {
            return this.mOffsetDelta;
        }

        public VerificationTypeInfo[] getLocalInfos() {
            return this.getPrevious().getLocalInfos();
        }

        public VerificationTypeInfo[] getStackItemInfos() {
            return VerificationTypeInfo.EMPTY_ARRAY;
        }

        public void writeTo(DataOutput dout) throws IOException {
            dout.writeByte(this.mOffsetDelta);
        }
    }

    private static class InitialFrame
    extends StackMapFrame {
        private VerificationTypeInfo[] mLocalInfos;

        InitialFrame() {
            super(null);
            this.mOffset = 0;
        }

        public int getLength() {
            return 0;
        }

        public int getOffsetDelta() {
            return 0;
        }

        public VerificationTypeInfo[] getLocalInfos() {
            if (this.mLocalInfos == null) {
                return VerificationTypeInfo.EMPTY_ARRAY;
            }
            return (VerificationTypeInfo[])this.mLocalInfos.clone();
        }

        public VerificationTypeInfo[] getStackItemInfos() {
            return VerificationTypeInfo.EMPTY_ARRAY;
        }

        public void writeTo(DataOutput dout) {
        }

        void set(ConstantPool cp, MethodInfo info) {
            int offset;
            VerificationTypeInfo[] infos;
            TypeDesc[] paramTypes = info.getMethodDescriptor().getParameterTypes();
            if (info.getModifiers().isStatic()) {
                infos = new VerificationTypeInfo[paramTypes.length];
                offset = 0;
            } else {
                infos = new VerificationTypeInfo[1 + paramTypes.length];
                infos[0] = info.getName().equals("<init>") ? UninitThisVariableInfo.THE : VerificationTypeInfo.forType(cp, info.getClassFile().getType());
                offset = 1;
            }
            for (int i = 0; i < paramTypes.length; ++i) {
                infos[offset + i] = VerificationTypeInfo.forType(cp, paramTypes[i]);
            }
            this.mLocalInfos = infos;
        }
    }

    public static abstract class StackMapFrame {
        private final StackMapFrame mPrev;
        StackMapFrame mNext;
        int mOffset = -1;

        static StackMapFrame read(StackMapFrame prev, ConstantPool cp, DataInput din) throws IOException {
            int frameType = din.readUnsignedByte();
            if (frameType <= 63) {
                return new SameFrame(prev, frameType);
            }
            if (frameType <= 127) {
                return new SameLocalsOneStackItemFrame(prev, frameType - 64, cp, din);
            }
            if (frameType <= 246) {
                return null;
            }
            if (frameType == 247) {
                return new SameLocalsOneStackItemFrameExtended(prev, cp, din);
            }
            if (frameType <= 250) {
                return new ChopFrame(prev, 251 - frameType, din);
            }
            if (frameType == 251) {
                return new SameFrameExtended(prev, din);
            }
            if (frameType <= 254) {
                return new AppendFrame(prev, frameType - 251, cp, din);
            }
            return new FullFrame(prev, cp, din);
        }

        StackMapFrame(StackMapFrame prev) {
            this.mPrev = prev;
            if (this.mPrev != null) {
                prev.mNext = this;
            }
        }

        abstract int getLength();

        public final int getOffset() {
            if (this.mOffset < 0) {
                this.mOffset = this.mPrev == null || this.mPrev instanceof InitialFrame ? this.getOffsetDelta() : this.mPrev.getOffset() + 1 + this.getOffsetDelta();
            }
            return this.mOffset;
        }

        abstract int getOffsetDelta();

        public abstract VerificationTypeInfo[] getLocalInfos();

        public abstract VerificationTypeInfo[] getStackItemInfos();

        public final StackMapFrame getPrevious() {
            return this.mPrev;
        }

        public final StackMapFrame getNext() {
            return this.mNext;
        }

        public abstract void writeTo(DataOutput var1) throws IOException;
    }
}

