/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.noop;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import junit.framework.Assert;
import org.apache.commons.logging.AbstractLogTest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.NoOpLog;

public class NoOpLogTestCase
extends AbstractLogTest {
    public void setUp() throws Exception {
        LogFactory.releaseAll();
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.NoOpLog");
    }

    public void tearDown() {
        LogFactory.releaseAll();
        ((Hashtable)System.getProperties()).remove("org.apache.commons.logging.Log");
    }

    public Log getLogObject() {
        return new NoOpLog(((Object)((Object)this)).getClass().getName());
    }

    public void testSerializable() throws Exception {
        Log log = LogFactory.getLog((String)((Object)((Object)this)).getClass().getName());
        this.checkLog(log);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(log);
        oos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        log = (Log)ois.readObject();
        ois.close();
        this.checkLog(log);
    }

    private void checkLog(Log log) {
        Assert.assertNotNull((String)"Log exists", (Object)log);
        Assert.assertEquals((String)"Log class", (String)"org.apache.commons.logging.impl.NoOpLog", (String)log.getClass().getName());
        Assert.assertFalse((boolean)log.isTraceEnabled());
        Assert.assertFalse((boolean)log.isDebugEnabled());
        Assert.assertFalse((boolean)log.isInfoEnabled());
        Assert.assertFalse((boolean)log.isWarnEnabled());
        Assert.assertFalse((boolean)log.isErrorEnabled());
        Assert.assertFalse((boolean)log.isFatalEnabled());
    }
}

