static const sparc_entry_t ultra4plus_pe[] = {
	/* These two must always be first.  */
	{	.name = "Cycle_cnt",
		.desc = "Accumulated cycles",
		.ctrl = PME_CTRL_S0 | PME_CTRL_S1,
		.code = 0x0,
	},
	{	.name = "Instr_cnt",
		.desc = "Number of instructions completed",
		.ctrl = PME_CTRL_S0 | PME_CTRL_S1,
		.code = 0x1,
	},

	/* PIC0 UltraSPARC-IV+ events */
	{
		.name = "Dispatch0_IC_miss",
		.desc = "I-buffer is empty from I-Cache miss",
		.ctrl = PME_CTRL_S0,
		.code = 0x2,
	},
	{
		.name = "IU_stat_jmp_correct_pred",
		.desc = "Retired non-annulled register indirect jumps predicted correctly",
		.ctrl = PME_CTRL_S0,
		.code = 0x3,
	},
	{
		.name = "Dispatch0_2nd_br",
		.desc = "Stall cycles due to having two branch instructions line-up in one 4-instruction group causing the second branch in the group to be re-fetched, delaying it's entrance into the I-buffer",
		.ctrl = PME_CTRL_S0,
		.code = 0x4,
	},
	{
		.name = "Rstall_storeQ",
		.desc = "R-stage stall for a store instruction which is the next instruction to be executed, but it stalled due to the store queue being full",
		.ctrl = PME_CTRL_S0,
		.code = 0x5,
	},
	{
		.name = "Rstall_IU_use",
		.desc = "R-stage stall for an event that the next instruction to be executed depends on the result of a preceding integer instruction in the pipeline that is not yet available",
		.ctrl = PME_CTRL_S0,
		.code = 0x6,
	},
	{
		.name = "IU_stat_ret_correct_pred",
		.desc = "Retired non-annulled returns predicted correctly",
		.ctrl = PME_CTRL_S0,
		.code = 0x7,
	},
	{
		.name = "IC_ref",
		.desc = "I-cache references",
		.ctrl = PME_CTRL_S0,
		.code = 0x8,
	},
	{
		.name = "DC_rd",
		.desc = "D-cache read references (including accesses that subsequently trap)",
		.ctrl = PME_CTRL_S0,
		.code = 0x9,
	},
	{
		.name = "Rstall_FP_use",
		.desc = "R-stage stall for an event that the next instruction to be executed depends on the result of a preceding floating-point instruction in the pipeline that is not yet available",
		.ctrl = PME_CTRL_S0,
		.code = 0xa,
	},
	{
		.name = "SW_pf_instr",
		.desc = "Retired SW prefetch instructions",
		.ctrl = PME_CTRL_S0,
		.code = 0xb,
	},
	{
		.name = "L2_ref",
		.desc = "L2-cache references",
		.ctrl = PME_CTRL_S0,
		.code = 0xc,
	},
	{
		.name = "L2_write_hit_RTO",
		.desc = "L2-cache exclusive requests that hit L2-cache in S, O, or Os state and thus, do a read-to-own bus transaction",
		.ctrl = PME_CTRL_S0,
		.code = 0xd,
	},
	{
		.name = "L2_snoop_inv_sh",
		.desc = "L2 cache lines that were written back to the L3 cache due to requests from both cores",
		.ctrl = PME_CTRL_S0,
		.code = 0xe,
	},
	{
		.name = "L2_rd_miss",
		.desc = "L2-cache miss events (including atomics) from D-cache events",
		.ctrl = PME_CTRL_S0,
		.code = 0xf,
	},
	{
		.name = "PC_rd",
		.desc = "P-cache cacheable loads",
		.ctrl = PME_CTRL_S0,
		.code = 0x10,
	},
	{
		.name = "SI_snoop_sh",
		.desc = "Counts snoops from remote processor(s) including RTS, RTSR, RTO, RTOR, RS, RSR, RTSM, and WS",
		.ctrl = PME_CTRL_S0,
		.code = 0x11,
	},
	{
		.name = "SI_ciq_flow_sh",
		.desc = "Counts system clock cycles when the flow control (PauseOut) signal is asserted",
		.ctrl = PME_CTRL_S0,
		.code = 0x12,
	},
	{
		.name = "Re_DC_miss",
		.desc = "Stall due to loads that miss D-cache and get recirculated",
		.ctrl = PME_CTRL_S0,
		.code = 0x13,
	},
	{
		.name = "SW_count_NOP0",
		.desc = "Retired, non-annulled special software NOP instructions (which is equivalent to 'sethi %hi(0xfc000), %g0' instruction)",
		.ctrl = PME_CTRL_S0,
		.code = 0x14,
	},
	{	.name = "IU_Stat_Br_miss_taken",
		.desc = "Retired branches that were predicted to be taken, but in fact were not taken",
		.ctrl = PME_CTRL_S0,
		.code = 0x15,
	},
	{	.name = "IU_Stat_Br_Count_taken",
		.desc = "Retired taken branches",
		.ctrl = PME_CTRL_S0,
		.code = 0x16,
	},
	{	.name = "HW_pf_exec",
		.desc = "Hardware prefetches enqueued in the prefetch queue",
		.ctrl = PME_CTRL_S0,
		.code = 0x17,
	},
	{
		.name = "FA_pipe_completion",
		.desc = "Instructions that complete execution on the FPG ALU pipelines",
		.ctrl = PME_CTRL_S0,
		.code = 0x18,
	},
	{
		.name = "SSM_L3_wb_remote",
		.desc = "L3 cache line victimizations from this core which generate R_WB transactions to non-LPA (remote physical address) regions",
		.ctrl = PME_CTRL_S0,
		.code = 0x19,
	},
	{
		.name = "SSM_L3_miss_local",
		.desc = "L3 cache misses to LPA (local physical address) from this core which generate an RTS, RTO, or RS transaction",
		.ctrl = PME_CTRL_S0,
		.code = 0x1a,
	},
	{
		.name = "SSM_L3_miss_mtag_remote",
		.desc = "L3 cache misses to LPA (local physical address) from this core which generate retry (R_*) transactions including R_RTS, R_RTO, and R_RS",
		.ctrl = PME_CTRL_S0,
		.code = 0x1b,
	},
	{
		.name = "SW_pf_str_trapped",
		.desc = "Strong software prefetch instructions trapping due to TLB miss",
		.ctrl = PME_CTRL_S0,
		.code = 0x1c,
	},
	{
		.name = "SW_pf_PC_installed",
		.desc = "Software prefetch instructions that installed lines in the P-cache",
		.ctrl = PME_CTRL_S0,
		.code = 0x1d,
	},
	{
		.name = "IPB_to_IC_fill",
		.desc = "I-cache fills from the instruction prefetch buffer",
		.ctrl = PME_CTRL_S0,
		.code = 0x1e,
	},
	{
		.name = "L2_write_miss",
		.desc = "L2-cache misses from this core by cacheable store requests",
		.ctrl = PME_CTRL_S0,
		.code = 0x1f,
	},
	{
		.name = "MC_reads_0_sh",
		.desc = "Read requests completed to memory bank 0",
		.ctrl = PME_CTRL_S0,
		.code = 0x20,
	},
	{
		.name = "MC_reads_1_sh",
		.desc = "Read requests completed to memory bank 1",
		.ctrl = PME_CTRL_S0,
		.code = 0x21,
	},
	{
		.name = "MC_reads_2_sh",
		.desc = "Read requests completed to memory bank 2",
		.ctrl = PME_CTRL_S0,
		.code = 0x22,
	},
	{
		.name = "MC_reads_3_sh",
		.desc = "Read requests completed to memory bank 3",
		.ctrl = PME_CTRL_S0,
		.code = 0x23,
	},
	{
		.name = "MC_stalls_0_sh",
		.desc = "Clock cycles that requests were stalled in the MCU queues because bank 0 was busy with a previous request",
		.ctrl = PME_CTRL_S0,
		.code = 0x24,
	},
	{
		.name = "MC_stalls_2_sh",
		.desc = "Clock cycles that requests were stalled in the MCU queues because bank 2 was busy with a previous request",
		.ctrl = PME_CTRL_S0,
		.code = 0x25,
	},
	{
		.name = "L2_hit_other_half",
		.desc = "L2 cache hits from this core to the ways filled by the other core when the cache is in the pseudo-split mode",
		.ctrl = PME_CTRL_S0,
		.code = 0x26,
	},
	{
		.name = "L3_rd_miss",
		.desc = "L3 cache misses sent out to SIU from this code by cacheable I-cache, D-cache, PO-cache, and W-cache (excluding block store) requests",
		.ctrl = PME_CTRL_S0,
		.code = 0x28,
	},
	{
		.name = "Re_L2_miss",
		.desc = "Stall cycles due to recirculation of cacheable loads that miss both D-cache and L2 cache",
		.ctrl = PME_CTRL_S0,
		.code = 0x29,
	},
	{
		.name = "IC_miss_cancelled",
		.desc = "I-cache miss requests cancelled due to new fetch stream",
		.ctrl = PME_CTRL_S0,
		.code = 0x2a,
	},
	{
		.name = "DC_wr_miss",
		.desc = "D-cache store accesses that miss D-cache",
		.ctrl = PME_CTRL_S0,
		.code = 0x2b,
	},
	{
		.name = "L3_hit_I_state_sh",
		.desc = "Tag hits in L3 cache when the line is in I state",
		.ctrl = PME_CTRL_S0,
		.code = 0x2c,
	},
	{
		.name = "SI_RTS_src_data",
		.desc = "Local RTS transactions due to I-cache, D-cache, or P-cache requests from this core where data is from the cache of another processor on the system, not from memory",
		.ctrl = PME_CTRL_S0,
		.code = 0x2d,
	},
	{
		.name = "L2_IC_miss",
		.desc = "L2 cache misses from this code by cacheable I-cache requests",
		.ctrl = PME_CTRL_S0,
		.code = 0x2e,
	},
	{
		.name = "SSM_new_transaction_sh",
		.desc = "New SSM transactions (RTSU, RTOU, UGM) observed by this processor on the Fireplane Interconnect",
		.ctrl = PME_CTRL_S0,
		.code = 0x2f,
	},
	{
		.name = "L2_SW_pf_miss",
		.desc = "L2 cache misses by software prefetch requests from this core",
		.ctrl = PME_CTRL_S0,
		.code = 0x30,
	},
	{
		.name = "L2_wb",
		.desc = "L2 cache lines that were written back to the L3 cache because of requests from this core",
		.ctrl = PME_CTRL_S0,
		.code = 0x31,
	},
	{
		.name = "L2_wb_sh",
		.desc = "L2 cache lines that were written back to the L3 cache because of requests from both cores",
		.ctrl = PME_CTRL_S0,
		.code = 0x32,
	},
	{
		.name = "L2_snoop_cb_sh",
		.desc = "L2 cache lines that were copied back due to other processors",
		.ctrl = PME_CTRL_S0,
		.code = 0x33,
	},

	/* PIC1 UltraSPARC-IV+ events */
	{
		.name = "Dispatch0_other",
		.desc = "Stall cycles due to the event that no instructions are dispatched because the I-queue is empty due to various other events, including branch target address fetch and various events which cause an instruction to be refetched",
		.ctrl = PME_CTRL_S1,
		.code = 0x2,
	},
	{
		.name = "DC_wr",
		.desc = "D-cache write references by cacheable stores (excluding block stores)",
		.ctrl = PME_CTRL_S1,
		.code = 0x3,
	},
	{
		.name = "Re_DC_missovhd",
		.desc = "Stall cycles due to D-cache load miss",
		.ctrl = PME_CTRL_S1,
		.code = 0x4,
	},
	{
		.name = "Re_FPU_bypass",
		.desc = "Stall due to recirculation when an FPU bypass condition that does not have a direct bypass path occurs",
		.ctrl = PME_CTRL_S1,
		.code = 0x5,
	},
	{
		.name = "L3_write_hit_RTO",
		.desc = "L3 cache hits in O, Os, or S state by cacheable store requests from this core that do a read-to-own (RTO) bus transaction",
		.ctrl = PME_CTRL_S1,
		.code = 0x6,
	},
	{
		.name = "L2L3_snoop_inv_sh",
		.desc = "L2 and L3 cache lines that were invalidated due to other processors doing RTO, RTOR, RTOU, or WS transactions",
		.ctrl = PME_CTRL_S1,
		.code = 0x7,
	},
	{
		.name = "IC_L2_req",
		.desc = "I-cache requests sent to L2 cache",
		.ctrl = PME_CTRL_S1,
		.code = 0x8,
	},
	{
		.name = "DC_rd_miss",
		.desc = "Cacheable loads (excluding atomics and block loads) that miss D-cache as well as P-cache (for FP loads)",
		.ctrl = PME_CTRL_S1,
		.code = 0x9,
	},
	{
		.name = "L2_hit_I_state_sh",
		.desc = "Tag hits in L2 cache when the line is in I state",
		.ctrl = PME_CTRL_S1,
		.code = 0xa,
	},
	{
		.name = "L3_write_miss_RTO",
		.desc = "L3 cache misses from this core by cacheable store requests that do a read-to-own (RTO) bus transaction.  This count does not include RTO requests for prefetch (fcn=2,3/22,23) instructions",
		.ctrl = PME_CTRL_S1,
		.code = 0xb,
	},
	{
		.name = "L2_miss",
		.desc = "L2 cache misses from this core by cacheable I-cache, D-cache, P-cache, and W-cache (excluding block stores) requests",
		.ctrl = PME_CTRL_S1,
		.code = 0xc,
	},
	{
		.name = "SI_owned_sh",
		.desc = "Number of times owned_in is asserted on bus requests from the local processor",
		.ctrl = PME_CTRL_S1,
		.code = 0xd,
	},
	{
		.name = "SI_RTO_src_data",
		.desc = "Number of local RTO transactions due to W-cache or P-cache requests from this core where data is from the cache of another processor on the system, not from memory",
		.ctrl = PME_CTRL_S1,
		.code = 0xe,
	},
	{
		.name = "SW_pf_duplicate",
		.desc = "Number of software prefetch instructions that were dropped because the prefetch request matched an outstanding requests in the prefetch queue or the request hit the P-cache",
		.ctrl = PME_CTRL_S1,
		.code = 0xf,
	},
	{
		.name = "IU_stat_jmp_mispred",
		.desc = "Number of retired non-annulled register indirect jumps mispredicted",
		.ctrl = PME_CTRL_S1,
		.code = 0x10,
	},
	{
		.name = "ITLB_miss",
		.desc = "I-TLB misses",
		.ctrl = PME_CTRL_S1,
		.code = 0x11,
	},
	{
		.name = "DTLB_miss",
		.desc = "D-TLB misses",
		.ctrl = PME_CTRL_S1,
		.code = 0x12,
	},
	{
		.name = "WC_miss",
		.desc = "W-cache misses",
		.ctrl = PME_CTRL_S1,
		.code = 0x13,
	},
	{
		.name = "IC_fill",
		.desc = "Number of I-cache fills excluding fills from the instruction prefetch buffer.  This is the best approximation of the number of I-cache misses for instructions that were actually executed",
		.ctrl = PME_CTRL_S1,
		.code = 0x14,
	},
	{
		.name = "IU_stat_ret_mispred",
		.desc = "Number of retired non-annulled returns mispredicted",
		.ctrl = PME_CTRL_S1,
		.code = 0x15,
	},
	{
		.name = "Re_L3_miss",
		.desc = "Stall cycles due to recirculation of cacheable loads that miss D-cache, L2, and L3 cache",
		.ctrl = PME_CTRL_S1,
		.code = 0x16,
	},
	{
		.name = "Re_PFQ_full",
		.desc = "Stall cycles due to recirculation of prefetch instructions because the prefetch queue (PFQ) was full",
		.ctrl = PME_CTRL_S1,
		.code = 0x17,
	},
	{
		.name = "PC_soft_hit",
		.desc = "Number of cacheable FP loads that hit a P-cache line that was prefetched by a software prefetch instruction",
		.ctrl = PME_CTRL_S1,
		.code = 0x18,
	},
	{
		.name = "PC_inv",
		.desc = "Number of P-cache lines that were invalidated due to external snoops, internal stores, and L2 evictions",
		.ctrl = PME_CTRL_S1,
		.code = 0x19,
	},
	{
		.name = "PC_hard_hit",
		.desc = "Number of FP loads that hit a P-cache line that was fetched by a FP load or a hardware prefetch, irrespective of whether the loads hit or miss the D-cache",
		.ctrl = PME_CTRL_S1,
		.code = 0x1a,
	},
	{
		.name = "IC_pf",
		.desc = "Number of I-cache prefetch requests sent to L2 cache",
		.ctrl = PME_CTRL_S1,
		.code = 0x1b,
	},
	{
		.name = "SW_count_NOP1",
		.desc = "Retired, non-annulled special software NOP instructions (which is equivalent to 'sethi %hi(0xfc000), %g0' instruction)",
		.ctrl = PME_CTRL_S1,
		.code = 0x1c,
	},
	{
		.name = "IU_stat_br_miss_untaken",
		.desc = "Number of retired non-annulled conditional branches that were predicted to be not taken, but in fact were taken",
		.ctrl = PME_CTRL_S1,
		.code = 0x1d,
	},
	{
		.name = "IU_stat_br_count_taken",
		.desc = "Number of retired non-annulled conditional branches that were taken",
		.ctrl = PME_CTRL_S1,
		.code = 0x1e,
	},
	{
		.name = "PC_miss",
		.desc = "Number of cacheable FP loads that miss P-cache, irrespective of whether the loads hit or miss the D-cache",
		.ctrl = PME_CTRL_S1,
		.code = 0x1f,
	},
	{
		.name = "MC_writes_0_sh",
		.desc = "Number of write requests complete to memory bank 0",
		.ctrl = PME_CTRL_S1,
		.code = 0x20,
	},
	{
		.name = "MC_writes_1_sh",
		.desc = "Number of write requests complete to memory bank 1",
		.ctrl = PME_CTRL_S1,
		.code = 0x21,
	},
	{
		.name = "MC_writes_2_sh",
		.desc = "Number of write requests complete to memory bank 2",
		.ctrl = PME_CTRL_S1,
		.code = 0x22,
	},
	{
		.name = "MC_writes_3_sh",
		.desc = "Number of write requests complete to memory bank 3",
		.ctrl = PME_CTRL_S1,
		.code = 0x23,
	},
	{
		.name = "MC_stalls_1_sh",
		.desc = "Number of processor cycles that requests were stalled in the MCU queues because bank 0 was busy with a previous requests",
		.ctrl = PME_CTRL_S1,
		.code = 0x24,
	},
	{
		.name = "MC_stalls_3_sh",
		.desc = "Number of processor cycles that requests were stalled in the MCU queues because bank 3 was busy with a previous requests",
		.ctrl = PME_CTRL_S1,
		.code = 0x25,
	},
	{
		.name = "Re_RAW_miss",
		.desc = "Stall cycles due to recirculation when there is a load instruction in the E-stage of the pipeline which has a non-bypassable read-after-write (RAW) hazard with an earlier store instruction",
		.ctrl = PME_CTRL_S1,
		.code = 0x26,
	},
	{
		.name = "FM_pipe_completion",
		.desc = "Number of retired instructions that complete execution on the FLoat-Point/Graphics Multiply pipeline",
		.ctrl = PME_CTRL_S1,
		.code = 0x27,
	},
	{
		.name = "SSM_L3_miss_mtag_remote",
		.desc = "Number of L3 cache misses to LPA (local physical address) from this core which generate retry (R_*) transactions including R_RTS, R_RTO, and R_RS",
		.ctrl = PME_CTRL_S1,
		.code = 0x28,
	},
	{
		.name = "SSM_L3_miss_remote",
		.desc = "Number of L3 cache misses from this core which generate retry (R_*) transactions to non-LPA (non-local physical address) address space, or R_WS transactions due to block store (BST) / block store commit (BSTC) to any address space (LPA or non-LPA), or R_RTO due to atomic request on Os state to LPA space.",
		.ctrl = PME_CTRL_S1,
		.code = 0x29,
	},
	{
		.name = "SW_pf_exec",
		.desc = "Number of retired, non-trapping software prefetch instructions that completed, i.e. number of retired prefetch instructions that were not dropped due to the prefecth queue being full",
		.ctrl = PME_CTRL_S1,
		.code = 0x2a,
	},
	{
		.name = "SW_pf_str_exec",
		.desc = "Number of retired, non-trapping strong prefetch instructions that completed",
		.ctrl = PME_CTRL_S1,
		.code = 0x2b,
	},
	{
		.name = "SW_pf_dropped",
		.desc = "Number of software prefetch instructions dropped due to TLB miss or due to the prefetch queue being full",
		.ctrl = PME_CTRL_S1,
		.code = 0x2c,
	},
	{
		.name = "SW_pf_L2_installed",
		.desc = "Number of software prefetch instructions that installed lines in the L2 cache",
		.ctrl = PME_CTRL_S1,
		.code = 0x2d,
	},
	{
		.name = "L2_HW_pf_miss",
		.desc = "Number of L2 cache misses by hardware prefetch requests from this core",
		.ctrl = PME_CTRL_S1,
		.code = 0x2f,
	},
	{
		.name = "L3_miss",
		.desc = "Number of L3 cache misses sent out to SIU from this core by cacheable I-cache, D-cache, P-cache, and W-cache (excluding block stores) requests",
		.ctrl = PME_CTRL_S1,
		.code = 0x31,
	},
	{
		.name = "L3_IC_miss",
		.desc = "Number of L3 cache misses by cacheable I-cache requests from this core",
		.ctrl = PME_CTRL_S1,
		.code = 0x32,
	},
	{
		.name = "L3_SW_pf_miss",
		.desc = "Number of L3 cache misses by software prefetch requests from this core",
		.ctrl = PME_CTRL_S1,
		.code = 0x33,
	},
	{
		.name = "L3_hit_other_half",
		.desc = "Number of L3 cache hits from this core to the ways filled by the other core when the cache is in pseudo-split mode",
		.ctrl = PME_CTRL_S1,
		.code = 0x34,
	},
	{
		.name = "L3_wb",
		.desc = "Number of L3 cache lines that were written back because of requests from this core",
		.ctrl = PME_CTRL_S1,
		.code = 0x35,
	},
	{
		.name = "L3_wb_sh",
		.desc = "Number of L3 cache lines that were written back because of requests from both cores",
		.ctrl = PME_CTRL_S1,
		.code = 0x36,
	},
	{
		.name = "L2L3_snoop_cb_sh",
		.desc = "Total number of L2 and L3 cache lines that were copied back due to other processors",
		.ctrl = PME_CTRL_S1,
		.code = 0x37,
	},
};
#define PME_SPARC_ULTRA4PLUS_EVENT_COUNT	   (sizeof(ultra4plus_pe)/sizeof(sparc_entry_t))
