/*++
/* NAME
/*	mail_server 3h
/* SUMMARY
/*	skeleton servers
/* SYNOPSIS
/*	#include <mail_server.h>
/* DESCRIPTION
/* .nf

 /*
  * Utility library.
  */
#include <vstream.h>

 /*
  * Global library.
  */
#include <mail_conf.h>

 /*
  * External interface. Tables are defined in mail_conf.h.
  */
#define MAIL_SERVER_INT_TABLE	1
#define MAIL_SERVER_STR_TABLE	2
#define MAIL_SERVER_BOOL_TABLE	3
#define MAIL_SERVER_TIME_TABLE	4
#define MAIL_SERVER_RAW_TABLE	5
#define MAIL_SERVER_NINT_TABLE	6
#define MAIL_SERVER_NBOOL_TABLE	7
#define MAIL_SERVER_LONG_TABLE	8

#define	MAIL_SERVER_PRE_INIT	10
#define MAIL_SERVER_POST_INIT	11
#define MAIL_SERVER_LOOP	12
#define MAIL_SERVER_EXIT	13
#define MAIL_SERVER_PRE_ACCEPT	14
#define MAIL_SERVER_SOLITARY	15
#define MAIL_SERVER_UNLIMITED	16
#define MAIL_SERVER_PRE_DISCONN	17
#define MAIL_SERVER_PRIVILEGED	18
#define MAIL_SERVER_WATCHDOG	19

#define MAIL_SERVER_IN_FLOW_DELAY	20
#define MAIL_SERVER_SLOW_EXIT	21
#define MAIL_SERVER_BOUNCE_INIT	22
#define MAIL_SERVER_RETIRE_ME	23

typedef void (*MAIL_SERVER_INIT_FN) (char *, char **);
typedef int (*MAIL_SERVER_LOOP_FN) (char *, char **);
typedef void (*MAIL_SERVER_EXIT_FN) (char *, char **);
typedef void (*MAIL_SERVER_ACCEPT_FN) (char *, char **);
typedef void (*MAIL_SERVER_DISCONN_FN) (VSTREAM *, char *, char **);
typedef void (*MAIL_SERVER_SLOW_EXIT_FN) (char *, char **);

/* Type-checked API for external use. */
#define CA_MAIL_SERVER_INT_TABLE(v)	MAIL_SERVER_INT_TABLE, CHECK_CPTR(MAIL_SERVER, CONFIG_INT_TABLE, (v))
#define CA_MAIL_SERVER_STR_TABLE(v)	MAIL_SERVER_STR_TABLE, CHECK_CPTR(MAIL_SERVER, CONFIG_STR_TABLE, (v))
#define CA_MAIL_SERVER_BOOL_TABLE(v)	MAIL_SERVER_BOOL_TABLE, CHECK_CPTR(MAIL_SERVER, CONFIG_BOOL_TABLE, (v))
#define CA_MAIL_SERVER_TIME_TABLE(v)	MAIL_SERVER_TIME_TABLE, CHECK_CPTR(MAIL_SERVER, CONFIG_TIME_TABLE, (v))
#define CA_MAIL_SERVER_RAW_TABLE(v)	MAIL_SERVER_RAW_TABLE, CHECK_CPTR(MAIL_SERVER, CONFIG_RAW_TABLE, (v))
#define CA_MAIL_SERVER_NINT_TABLE(v)	MAIL_SERVER_NINT_TABLE, CHECK_CPTR(MAIL_SERVER, CONFIG_NINT_TABLE, (v))
#define CA_MAIL_SERVER_NBOOL_TABLE(v)	MAIL_SERVER_NBOOL_TABLE, CHECK_CPTR(MAIL_SERVER, CONFIG_NBOOL_TABLE, (v))
#define CA_MAIL_SERVER_LONG_TABLE(v)	MAIL_SERVER_LONG_TABLE, CHECK_CPTR(MAIL_SERVER, CONFIG_LONG_TABLE, (v))
#define CA_MAIL_SERVER_PRE_INIT(v)	MAIL_SERVER_PRE_INIT, CHECK_VAL(MAIL_SERVER, MAIL_SERVER_INIT_FN, (v))
#define CA_MAIL_SERVER_POST_INIT(v)	MAIL_SERVER_POST_INIT, CHECK_VAL(MAIL_SERVER, MAIL_SERVER_INIT_FN, (v))
#define CA_MAIL_SERVER_LOOP(v)		MAIL_SERVER_LOOP, CHECK_VAL(MAIL_SERVER, MAIL_SERVER_LOOP_FN, (v))
#define CA_MAIL_SERVER_EXIT(v)		MAIL_SERVER_EXIT, CHECK_VAL(MAIL_SERVER, MAIL_SERVER_EXIT_FN, (v))
#define CA_MAIL_SERVER_PRE_ACCEPT(v)	MAIL_SERVER_PRE_ACCEPT, CHECK_VAL(MAIL_SERVER, MAIL_SERVER_ACCEPT_FN, (v))
#define CA_MAIL_SERVER_SOLITARY	MAIL_SERVER_SOLITARY
#define CA_MAIL_SERVER_UNLIMITED	MAIL_SERVER_UNLIMITED
#define CA_MAIL_SERVER_PRE_DISCONN(v)	MAIL_SERVER_PRE_DISCONN, CHECK_VAL(MAIL_SERVER, MAIL_SERVER_DISCONN_FN, (v))
#define CA_MAIL_SERVER_PRIVILEGED	MAIL_SERVER_PRIVILEGED
#define CA_MAIL_SERVER_WATCHDOG(v)	MAIL_SERVER_WATCHDOG, CHECK_PTR(MAIL_SERVER, int, (v))
#define CA_MAIL_SERVER_IN_FLOW_DELAY	MAIL_SERVER_IN_FLOW_DELAY
#define CA_MAIL_SERVER_SLOW_EXIT(v)	MAIL_SERVER_SLOW_EXIT, CHECK_VAL(MAIL_SERVER, MAIL_SERVER_SLOW_EXIT_FN, (v))
#define CA_MAIL_SERVER_BOUNCE_INIT(v, w) MAIL_SERVER_BOUNCE_INIT, CHECK_PTR(MAIL_SERVER, char, (v)), CHECK_PPTR(MAIL_SERVER, char, (w))
#define CA_MAIL_SERVER_RETIRE_ME	MAIL_SERVER_RETIRE_ME

CHECK_VAL_HELPER_DCL(MAIL_SERVER, MAIL_SERVER_SLOW_EXIT_FN);
CHECK_VAL_HELPER_DCL(MAIL_SERVER, MAIL_SERVER_LOOP_FN);
CHECK_VAL_HELPER_DCL(MAIL_SERVER, MAIL_SERVER_INIT_FN);
CHECK_VAL_HELPER_DCL(MAIL_SERVER, MAIL_SERVER_EXIT_FN);
CHECK_VAL_HELPER_DCL(MAIL_SERVER, MAIL_SERVER_DISCONN_FN);
CHECK_VAL_HELPER_DCL(MAIL_SERVER, MAIL_SERVER_ACCEPT_FN);
CHECK_PTR_HELPER_DCL(MAIL_SERVER, int);
CHECK_PTR_HELPER_DCL(MAIL_SERVER, char);
CHECK_PPTR_HELPER_DCL(MAIL_SERVER, char);
CHECK_CPTR_HELPER_DCL(MAIL_SERVER, CONFIG_TIME_TABLE);
CHECK_CPTR_HELPER_DCL(MAIL_SERVER, CONFIG_STR_TABLE);
CHECK_CPTR_HELPER_DCL(MAIL_SERVER, CONFIG_RAW_TABLE);
CHECK_CPTR_HELPER_DCL(MAIL_SERVER, CONFIG_NINT_TABLE);
CHECK_CPTR_HELPER_DCL(MAIL_SERVER, CONFIG_NBOOL_TABLE);
CHECK_CPTR_HELPER_DCL(MAIL_SERVER, CONFIG_LONG_TABLE);
CHECK_CPTR_HELPER_DCL(MAIL_SERVER, CONFIG_INT_TABLE);
CHECK_CPTR_HELPER_DCL(MAIL_SERVER, CONFIG_BOOL_TABLE);

 /*
  * single_server.c
  */
typedef void (*SINGLE_SERVER_FN) (VSTREAM *, char *, char **);
extern NORETURN single_server_main(int, char **, SINGLE_SERVER_FN,...);

 /*
  * multi_server.c
  */
typedef void (*MULTI_SERVER_FN) (VSTREAM *, char *, char **);
extern NORETURN multi_server_main(int, char **, MULTI_SERVER_FN,...);
extern void multi_server_disconnect(VSTREAM *);
extern int multi_server_drain(void);

 /*
  * event_server.c
  */
typedef void (*EVENT_SERVER_FN) (VSTREAM *, char *, char **);
extern NORETURN event_server_main(int, char **, EVENT_SERVER_FN,...);
extern void event_server_disconnect(VSTREAM *);
extern int event_server_drain(void);

 /*
  * trigger_server.c
  */
typedef void (*TRIGGER_SERVER_FN) (char *, ssize_t, char *, char **);
extern NORETURN trigger_server_main(int, char **, TRIGGER_SERVER_FN,...);

#define TRIGGER_BUF_SIZE	1024

/* LICENSE
/* .ad
/* .fi
/*	The Secure Mailer license must be distributed with this software.
/* AUTHOR(S)
/*	Wietse Venema
/*	IBM T.J. Watson Research
/*	P.O. Box 704
/*	Yorktown Heights, NY 10598, USA
/*
/*	Wietse Venema
/*	Google, Inc.
/*	111 8th Avenue
/*	New York, NY 10011, USA
/*--*/
