/*
 * Decompiled with CFR 0.152.
 */
package sun.swing.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableCellRenderer;
import sun.swing.DefaultLookup;

public class DefaultTableCellHeaderRenderer
extends DefaultTableCellRenderer
implements UIResource {
    private boolean horizontalTextPositionSet;
    private Icon sortArrow;
    private EmptyIcon emptyIcon = new EmptyIcon();

    public DefaultTableCellHeaderRenderer() {
        this.setHorizontalAlignment(0);
    }

    public void setHorizontalTextPosition(int n) {
        this.horizontalTextPositionSet = true;
        super.setHorizontalTextPosition(n);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Object object2;
        Icon icon = null;
        boolean bl3 = false;
        if (jTable != null) {
            Object object3;
            object2 = jTable.getTableHeader();
            if (object2 != null) {
                object3 = null;
                Color color = null;
                if (bl2) {
                    object3 = DefaultLookup.getColor(this, this.ui, "TableHeader.focusCellForeground");
                    color = DefaultLookup.getColor(this, this.ui, "TableHeader.focusCellBackground");
                }
                if (object3 == null) {
                    object3 = ((Component)object2).getForeground();
                }
                if (color == null) {
                    color = ((Component)object2).getBackground();
                }
                this.setForeground((Color)object3);
                this.setBackground(color);
                this.setFont(((Component)object2).getFont());
                bl3 = ((JComponent)object2).isPaintingForPrint();
            }
            if (!bl3 && jTable.getRowSorter() != null) {
                if (!this.horizontalTextPositionSet) {
                    this.setHorizontalTextPosition(10);
                }
                if ((object3 = DefaultTableCellHeaderRenderer.getColumnSortOrder(jTable, n2)) != null) {
                    switch (1.$SwitchMap$javax$swing$SortOrder[((Enum)object3).ordinal()]) {
                        case 1: {
                            icon = DefaultLookup.getIcon(this, this.ui, "Table.ascendingSortIcon");
                            break;
                        }
                        case 2: {
                            icon = DefaultLookup.getIcon(this, this.ui, "Table.descendingSortIcon");
                            break;
                        }
                        case 3: {
                            icon = DefaultLookup.getIcon(this, this.ui, "Table.naturalSortIcon");
                        }
                    }
                }
            }
        }
        this.setText(object == null ? "" : object.toString());
        this.setIcon(icon);
        this.sortArrow = icon;
        object2 = null;
        if (bl2) {
            object2 = DefaultLookup.getBorder(this, this.ui, "TableHeader.focusCellBorder");
        }
        if (object2 == null) {
            object2 = DefaultLookup.getBorder(this, this.ui, "TableHeader.cellBorder");
        }
        this.setBorder((Border)object2);
        return this;
    }

    public static SortOrder getColumnSortOrder(JTable jTable, int n) {
        SortOrder sortOrder = null;
        if (jTable.getRowSorter() == null) {
            return sortOrder;
        }
        List<RowSorter.SortKey> list = jTable.getRowSorter().getSortKeys();
        if (list.size() > 0 && list.get(0).getColumn() == jTable.convertColumnIndexToModel(n)) {
            sortOrder = list.get(0).getSortOrder();
        }
        return sortOrder;
    }

    public void paintComponent(Graphics graphics) {
        boolean bl = DefaultLookup.getBoolean(this, this.ui, "TableHeader.rightAlignSortArrow", false);
        if (bl && this.sortArrow != null) {
            this.emptyIcon.width = this.sortArrow.getIconWidth();
            this.emptyIcon.height = this.sortArrow.getIconHeight();
            this.setIcon(this.emptyIcon);
            super.paintComponent(graphics);
            Point point = this.computeIconPosition(graphics);
            this.sortArrow.paintIcon(this, graphics, point.x, point.y);
        } else {
            super.paintComponent(graphics);
        }
    }

    private Point computeIconPosition(Graphics graphics) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        Insets insets = this.getInsets();
        rectangle.x = insets.left;
        rectangle.y = insets.top;
        rectangle.width = this.getWidth() - (insets.left + insets.right);
        rectangle.height = this.getHeight() - (insets.top + insets.bottom);
        SwingUtilities.layoutCompoundLabel(this, fontMetrics, this.getText(), this.sortArrow, this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getVerticalTextPosition(), this.getHorizontalTextPosition(), rectangle, rectangle3, rectangle2, this.getIconTextGap());
        int n = this.getWidth() - insets.right - this.sortArrow.getIconWidth();
        int n2 = rectangle3.y;
        return new Point(n, n2);
    }

    private class EmptyIcon
    implements Icon,
    Serializable {
        int width = 0;
        int height = 0;

        private EmptyIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }

        public int getIconWidth() {
            return this.width;
        }

        public int getIconHeight() {
            return this.height;
        }
    }
}

