/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Graphics;
import java.awt.Shape;
import java.util.Vector;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AsyncBoxView;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StateInvariantError;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class ZoneView
extends BoxView {
    int maxZoneSize = 8192;
    int maxZonesLoaded = 3;
    Vector loadedZones = new Vector();

    public ZoneView(Element element, int n) {
        super(element, n);
    }

    public int getMaximumZoneSize() {
        return this.maxZoneSize;
    }

    public void setMaximumZoneSize(int n) {
        this.maxZoneSize = n;
    }

    public int getMaxZonesLoaded() {
        return this.maxZonesLoaded;
    }

    public void setMaxZonesLoaded(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("ZoneView.setMaxZonesLoaded must be greater than 0.");
        }
        this.maxZonesLoaded = n;
        this.unloadOldZones();
    }

    protected void zoneWasLoaded(View view) {
        this.loadedZones.addElement(view);
        this.unloadOldZones();
    }

    void unloadOldZones() {
        while (this.loadedZones.size() > this.getMaxZonesLoaded()) {
            View view = (View)this.loadedZones.elementAt(0);
            this.loadedZones.removeElementAt(0);
            this.unloadZone(view);
        }
    }

    protected void unloadZone(View view) {
        view.removeAll();
    }

    protected boolean isZoneLoaded(View view) {
        return view.getViewCount() > 0;
    }

    protected View createZone(int n, int n2) {
        Document document = this.getDocument();
        Zone zone = null;
        try {
            zone = new Zone(this.getElement(), document.createPosition(n), document.createPosition(n2));
        }
        catch (BadLocationException badLocationException) {
            throw new StateInvariantError(badLocationException.getMessage());
        }
        return zone;
    }

    protected void loadChildren(ViewFactory viewFactory) {
        Document document = this.getDocument();
        int n = this.getStartOffset();
        int n2 = this.getEndOffset();
        this.append(this.createZone(n, n2));
        this.handleInsert(n, n2 - n);
    }

    protected int getViewIndexAtPosition(int n) {
        int n2 = this.getViewCount();
        if (n == this.getEndOffset()) {
            return n2 - 1;
        }
        for (int i = 0; i < n2; ++i) {
            View view = this.getView(i);
            if (n < view.getStartOffset() || n >= view.getEndOffset()) continue;
            return i;
        }
        return -1;
    }

    void handleInsert(int n, int n2) {
        int n3 = this.getViewIndex(n, Position.Bias.Forward);
        View view = this.getView(n3);
        int n4 = view.getStartOffset();
        int n5 = view.getEndOffset();
        if (n5 - n4 > this.maxZoneSize) {
            this.splitZone(n3, n4, n5);
        }
    }

    void handleRemove(int n, int n2) {
    }

    void splitZone(int n, int n2, int n3) {
        Element element = this.getElement();
        Document document = element.getDocument();
        Vector<View> vector = new Vector<View>();
        int n4 = n2;
        do {
            n2 = n4;
            n4 = Math.min(this.getDesiredZoneEnd(n2), n3);
            vector.addElement(this.createZone(n2, n4));
        } while (n4 < n3);
        View view = this.getView(n);
        Object[] objectArray = new View[vector.size()];
        vector.copyInto(objectArray);
        this.replace(n, 1, (View[])objectArray);
    }

    int getDesiredZoneEnd(int n) {
        Element element = this.getElement();
        int n2 = element.getElementIndex(n + this.maxZoneSize / 2);
        Element element2 = element.getElement(n2);
        int n3 = element2.getStartOffset();
        int n4 = element2.getEndOffset();
        if (n4 - n > this.maxZoneSize && n3 > n) {
            return n3;
        }
        return n4;
    }

    protected boolean updateChildren(DocumentEvent.ElementChange elementChange, DocumentEvent documentEvent, ViewFactory viewFactory) {
        return false;
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.handleInsert(documentEvent.getOffset(), documentEvent.getLength());
        super.insertUpdate(documentEvent, shape, viewFactory);
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.handleRemove(documentEvent.getOffset(), documentEvent.getLength());
        super.removeUpdate(documentEvent, shape, viewFactory);
    }

    class Zone
    extends AsyncBoxView {
        private Position start;
        private Position end;

        public Zone(Element element, Position position, Position position2) {
            super(element, ZoneView.this.getAxis());
            this.start = position;
            this.end = position2;
        }

        public void load() {
            if (!this.isLoaded()) {
                this.setEstimatedMajorSpan(true);
                Element element = this.getElement();
                ViewFactory viewFactory = this.getViewFactory();
                int n = element.getElementIndex(this.getStartOffset());
                int n2 = element.getElementIndex(this.getEndOffset());
                View[] viewArray = new View[n2 - n + 1];
                for (int i = n; i <= n2; ++i) {
                    viewArray[i - n] = viewFactory.create(element.getElement(i));
                }
                this.replace(0, 0, viewArray);
                ZoneView.this.zoneWasLoaded(this);
            }
        }

        public void unload() {
            this.setEstimatedMajorSpan(true);
            this.removeAll();
        }

        public boolean isLoaded() {
            return this.getViewCount() != 0;
        }

        protected void loadChildren(ViewFactory viewFactory) {
            this.setEstimatedMajorSpan(true);
            Element element = this.getElement();
            int n = element.getElementIndex(this.getStartOffset());
            int n2 = element.getElementIndex(this.getEndOffset());
            int n3 = n2 - n;
            View view = viewFactory.create(element.getElement(n));
            view.setParent(this);
            float f = view.getPreferredSpan(0);
            float f2 = view.getPreferredSpan(1);
            if (this.getMajorAxis() == 0) {
                f *= (float)n3;
            } else {
                f2 += (float)n3;
            }
            this.setSize(f, f2);
        }

        protected void flushRequirementChanges() {
            if (this.isLoaded()) {
                super.flushRequirementChanges();
            }
        }

        public int getViewIndex(int n, Position.Bias bias) {
            boolean bl = bias == Position.Bias.Backward;
            n = bl ? Math.max(0, n - 1) : n;
            Element element = this.getElement();
            int n2 = element.getElementIndex(n);
            int n3 = element.getElementIndex(this.getStartOffset());
            return n2 - n3;
        }

        protected boolean updateChildren(DocumentEvent.ElementChange elementChange, DocumentEvent documentEvent, ViewFactory viewFactory) {
            Element[] elementArray = elementChange.getChildrenRemoved();
            Element[] elementArray2 = elementChange.getChildrenAdded();
            Element element = this.getElement();
            int n = element.getElementIndex(this.getStartOffset());
            int n2 = element.getElementIndex(this.getEndOffset() - 1);
            int n3 = elementChange.getIndex();
            if (n3 >= n && n3 <= n2) {
                int n4 = n3 - n;
                int n5 = Math.min(n2 - n + 1, elementArray2.length);
                int n6 = Math.min(n2 - n + 1, elementArray.length);
                View[] viewArray = new View[n5];
                for (int i = 0; i < n5; ++i) {
                    viewArray[i] = viewFactory.create(elementArray2[i]);
                }
                this.replace(n4, n6, viewArray);
            }
            return true;
        }

        public AttributeSet getAttributes() {
            return ZoneView.this.getAttributes();
        }

        public void paint(Graphics graphics, Shape shape) {
            this.load();
            super.paint(graphics, shape);
        }

        public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
            this.load();
            return super.viewToModel(f, f2, shape, biasArray);
        }

        public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
            this.load();
            return super.modelToView(n, shape, bias);
        }

        public int getStartOffset() {
            return this.start.getOffset();
        }

        public int getEndOffset() {
            return this.end.getOffset();
        }

        public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            if (this.isLoaded()) {
                super.insertUpdate(documentEvent, shape, viewFactory);
            }
        }

        public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            if (this.isLoaded()) {
                super.removeUpdate(documentEvent, shape, viewFactory);
            }
        }

        public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            if (this.isLoaded()) {
                super.changedUpdate(documentEvent, shape, viewFactory);
            }
        }
    }
}

