/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.GTKColorType;
import com.sun.java.swing.plaf.gtk.GTKConstants;
import com.sun.java.swing.plaf.gtk.GTKEngine;
import com.sun.java.swing.plaf.gtk.GTKLookAndFeel;
import com.sun.java.swing.plaf.gtk.GTKStyle;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.Serializable;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;

public class GTKDefaultEngine
extends GTKEngine {
    static final int[] DEFAULT_FOCUS_PATTERN = new int[]{1, 1};

    static int adjustAxisForComponentOrientation(JComponent jComponent, int n) {
        if (jComponent.getComponentOrientation().isLeftToRight()) {
            return n;
        }
        switch (n) {
            case 3: {
                return 7;
            }
            case 7: {
                return 3;
            }
        }
        return n;
    }

    public void paintArrow(Graphics graphics, SynthContext synthContext, Region region, int n, GTKConstants.ShadowType shadowType, GTKConstants.ArrowType arrowType, String string, int n2, int n3, int n4, int n5) {
        int n6 = n4 / 4 + 1;
        int n7 = n5 / 4 + 1;
        int n8 = Math.max(2, Math.min(n6, n7));
        switch (arrowType) {
            case UP: 
            case DOWN: {
                n2 += (n4 - n8 * 2 + 1) / 2;
                n3 += (n5 - n8) / 2;
                break;
            }
            case LEFT: 
            case RIGHT: {
                n2 += (n4 - n8) / 2;
                n3 += (n5 - n8 * 2 + 1) / 2;
            }
        }
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n9 = n8 * 2 - 2;
        graphics.translate(n2, n3);
        if (n == 8) {
            graphics.setColor(gTKStyle.getGTKColor(synthContext, n, GTKColorType.WHITE));
        } else {
            graphics.setColor(gTKStyle.getGTKColor(synthContext, n, GTKColorType.FOREGROUND));
        }
        switch (arrowType) {
            case UP: {
                for (int i = 0; i < n8; ++i) {
                    graphics.drawLine(i, n8 - i - 1, n9 - i, n8 - i - 1);
                }
                break;
            }
            case DOWN: {
                for (int i = 0; i < n8; ++i) {
                    graphics.drawLine(i, i, n9 - i, i);
                }
                break;
            }
            case LEFT: {
                int n10 = 0;
                int n11 = n8 - 1;
                while (n11 >= 0) {
                    graphics.drawLine(n11, n10, n11, n9 - n10);
                    --n11;
                    ++n10;
                }
                break;
            }
            case RIGHT: {
                for (int i = 0; i < n8; ++i) {
                    graphics.drawLine(i, i, i, n9 - i);
                }
                break;
            }
        }
        graphics.translate(-n2, -n3);
    }

    public void paintBox(Graphics graphics, SynthContext synthContext, Region region, int n, GTKConstants.ShadowType shadowType, String string, int n2, int n3, int n4, int n5) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        if (string == "menuitem" && n == 2 && GTKLookAndFeel.is2_2()) {
            this.paintBackground(graphics, synthContext, region, n, gTKStyle.getGTKColor(synthContext, 2, GTKColorType.BACKGROUND), n2, n3, n4, n5);
        } else {
            this.paintBackground(graphics, synthContext, region, n, gTKStyle.getGTKColor(synthContext, n, GTKColorType.BACKGROUND), n2, n3, n4, n5);
        }
        this.paintShadow(graphics, synthContext, region, n, shadowType, string, n2, n3, n4, n5);
    }

    public void paintBoxGap(Graphics graphics, SynthContext synthContext, Region region, int n, GTKConstants.ShadowType shadowType, String string, int n2, int n3, int n4, int n5, GTKConstants.PositionType positionType, int n6, int n7) {
        this._paintBoxGap(synthContext, graphics, n, shadowType, n2, n3, n4, n5, positionType, n6, n7, GTKColorType.BACKGROUND, GTKColorType.LIGHT, GTKColorType.BLACK, GTKColorType.DARK, false);
    }

    void _paintBoxGap(SynthContext synthContext, Graphics graphics, int n, GTKConstants.ShadowType shadowType, int n2, int n3, int n4, int n5, GTKConstants.PositionType positionType, int n6, int n7, ColorType colorType, ColorType colorType2, ColorType colorType3, ColorType colorType4, boolean bl) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        this.paintBackground(graphics, synthContext, synthContext.getRegion(), n, gTKStyle.getGTKColor(synthContext, n, colorType), n2, n3, n4, n5);
        int n8 = n6 + n7;
        Color color = gTKStyle.getGTKColor(synthContext, n, colorType2);
        Color color2 = gTKStyle.getGTKColor(synthContext, n, colorType3);
        Color color3 = gTKStyle.getGTKColor(synthContext, n, colorType4);
        Color color4 = gTKStyle.getGTKColor(synthContext, n, GTKColorType.WHITE);
        graphics.translate(n2, n3);
        if (positionType == GTKConstants.PositionType.TOP) {
            graphics.setColor(color2);
            graphics.drawLine(0, n5 - 1, n4 - 1, n5 - 1);
            graphics.setColor(color3);
            graphics.drawLine(1, n5 - 2, n4 - 2, n5 - 2);
            graphics.setColor(color);
            graphics.drawLine(0, 0, 0, n5 - 2);
            if (bl) {
                graphics.setColor(color4);
                graphics.drawLine(1, 0, 1, n5 - 3);
            }
            graphics.setColor(color2);
            graphics.drawLine(n4 - 1, 0, n4 - 1, n5 - 1);
            graphics.setColor(color3);
            graphics.drawLine(n4 - 2, 0, n4 - 2, n5 - 2);
            if (n6 > 1) {
                graphics.setColor(color);
                graphics.drawLine(0, 0, n6 - 2, 0);
            }
            graphics.setColor(color);
            graphics.drawLine(n8 - 1, 0, n4 - 2, 0);
            if (bl) {
                graphics.setColor(color4);
                if (n6 > 0) {
                    graphics.drawLine(0, 1, n6, 1);
                }
                graphics.drawLine(n8, 1, n4 - 2, 1);
            }
        } else if (positionType == GTKConstants.PositionType.BOTTOM) {
            graphics.setColor(color);
            graphics.drawLine(0, 0, n4 - 1, 0);
            if (bl) {
                graphics.setColor(color4);
                graphics.drawLine(0, 1, n4 - 1, 1);
            }
            graphics.setColor(color);
            graphics.drawLine(0, 0, 0, n5 - 1);
            if (bl) {
                graphics.setColor(color4);
                graphics.drawLine(1, 1, 1, n5 - 2);
            }
            graphics.setColor(color2);
            graphics.drawLine(n4 - 1, 0, n4 - 1, n5 - 1);
            graphics.setColor(color3);
            graphics.drawLine(n4 - 2, 1, n4 - 2, n5 - 2);
            if (n6 > 1) {
                graphics.setColor(color2);
                graphics.drawLine(0, n5 - 1, n6 - 2, n5 - 1);
                graphics.setColor(color3);
                graphics.drawLine(n6 - 1, n5 - 1, n6 - 1, n5 - 1);
                graphics.drawLine(1, n5 - 2, n6 - 2, n5 - 2);
            }
            graphics.setColor(color2);
            graphics.drawLine(n8 - 1, n5 - 1, n4 - 1, n5 - 1);
            graphics.setColor(color3);
            graphics.drawLine(n8 - 2, n5 - 1, n8 - 2, n5 - 1);
            graphics.drawLine(n8 - 1, n5 - 2, n4 - 2, n5 - 2);
        } else if (positionType == GTKConstants.PositionType.RIGHT) {
            graphics.setColor(color);
            graphics.drawLine(0, 0, n4 - 1, 0);
            if (bl) {
                graphics.setColor(color4);
                graphics.drawLine(0, 1, n4 - 1, 1);
            }
            graphics.setColor(color2);
            graphics.drawLine(0, n5 - 1, n4 - 1, n5 - 1);
            graphics.setColor(color3);
            graphics.drawLine(1, n5 - 2, n4 - 2, n5 - 2);
            graphics.setColor(color);
            graphics.drawLine(0, 0, 0, n5 - 2);
            if (bl) {
                graphics.setColor(color4);
                graphics.drawLine(1, 1, 1, n5 - 3);
            }
            if (n6 > 1) {
                graphics.setColor(color2);
                graphics.drawLine(n4 - 1, 0, n4 - 1, n6 - 2);
                graphics.setColor(color3);
                graphics.drawLine(n4 - 1, n6 - 1, n4 - 1, n6 - 1);
                graphics.drawLine(n4 - 2, 1, n4 - 2, n6 - 2);
            }
            graphics.setColor(color2);
            graphics.drawLine(n4 - 1, n8 - 1, n4 - 1, n5 - 1);
            graphics.setColor(color3);
            graphics.drawLine(n4 - 1, n8 - 2, n4 - 1, n8 - 2);
            graphics.drawLine(n4 - 2, n8 - 1, n4 - 2, n5 - 2);
        } else if (positionType == GTKConstants.PositionType.LEFT) {
            graphics.setColor(color);
            graphics.drawLine(0, 0, n4 - 2, 0);
            if (bl) {
                graphics.setColor(color4);
                graphics.drawLine(0, 1, n4 - 2, 1);
            }
            graphics.setColor(color2);
            graphics.drawLine(0, n5 - 1, n4 - 1, n5 - 1);
            graphics.setColor(color3);
            graphics.drawLine(1, n5 - 2, n4 - 2, n5 - 2);
            graphics.setColor(color2);
            graphics.drawLine(n4 - 1, 1, n4 - 1, n5 - 1);
            graphics.setColor(color3);
            graphics.drawLine(n4 - 2, 0, n4 - 2, n5 - 2);
            if (n6 > 1) {
                graphics.setColor(color);
                graphics.drawLine(0, 0, 0, n6 - 2);
            }
            graphics.setColor(color);
            graphics.drawLine(0, n8 - 1, 0, n5 - 2);
            if (bl) {
                graphics.setColor(color4);
                if (n6 > 1) {
                    graphics.drawLine(1, 0, 1, n6 - 1);
                }
                graphics.drawLine(1, n8 - 1, 1, n5 - 3);
            }
        }
        graphics.translate(-n2, -n3);
    }

    public void paintCheck(Graphics graphics, SynthContext synthContext, Region region, int n, GTKConstants.ShadowType shadowType, String string, int n2, int n3, int n4, int n5) {
        int n6;
        int n7 = synthContext.getComponentState();
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        if ("checkbutton" == string) {
            n6 = (n7 & 4) == 0 ? 1 : 4;
            this.paintFlatBox(graphics, synthContext, region, n6, GTKConstants.ShadowType.ETCHED_OUT, string, n2, n3, n4, n5, ColorType.TEXT_BACKGROUND);
            this.paintShadow(graphics, synthContext, region, n6, GTKConstants.ShadowType.IN, string, n2, n3, n4, n5);
        }
        graphics.translate(n2, n3);
        n6 = n5 / 2 - 1;
        if ((n7 & 0x200) != 0) {
            graphics.setColor(gTKStyle.getGTKColor(synthContext, n, GTKColorType.FOREGROUND));
            graphics.drawLine(3, n6 + 2, 4, n6 + 2);
            graphics.drawLine(5, n6 + 3, 6, n6 + 3);
            graphics.drawLine(6, n6 + 2, 6, n6 + 4);
            graphics.drawLine(7, n6 + 1, 7, n6);
            graphics.drawLine(7, n6, 8, n6);
            graphics.drawLine(8, n6, 8, n6 - 1);
            graphics.drawLine(8, n6 - 1, 9, n6 - 1);
            graphics.drawLine(9, n6 - 1, 9, n6 - 2);
            if (!GTKLookAndFeel.is2_2()) {
                if ((n7 & 4) != 0) {
                    graphics.setColor(gTKStyle.getGTKColor(synthContext, 4, GTKColorType.DARK));
                } else {
                    graphics.setColor(gTKStyle.getGTKColor(synthContext, 1, GTKColorType.DARK));
                }
            }
            graphics.drawLine(3, n6 + 1, 4, n6 + 1);
            graphics.drawLine(4, n6 + 3, 4, n6 + 3);
            graphics.drawLine(5, n6 + 2, 5, n6 + 2);
            graphics.drawLine(6, n6 + 1, 6, n6 + 1);
            graphics.drawLine(7, n6 + 2, 7, n6 + 2);
            graphics.drawLine(10, n6 - 2, 10, n6 - 2);
        }
        graphics.translate(-n2, -n3);
    }

    public void paintExtension(Graphics graphics, SynthContext synthContext, Region region, int n, GTKConstants.ShadowType shadowType, String string, int n2, int n3, int n4, int n5, GTKConstants.PositionType positionType, int n6) {
        this._paintExtension(synthContext, graphics, n, shadowType, n2, n3, n4, n5, positionType, GTKColorType.LIGHT, GTKColorType.BACKGROUND, GTKColorType.BLACK, GTKColorType.DARK, false, n6);
    }

    void _paintExtension(SynthContext synthContext, Graphics graphics, int n, GTKConstants.ShadowType shadowType, int n2, int n3, int n4, int n5, GTKConstants.PositionType positionType, ColorType colorType, ColorType colorType2, ColorType colorType3, ColorType colorType4, boolean bl, int n6) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        Region region = synthContext.getRegion();
        int n7 = gTKStyle.getXThickness();
        int n8 = gTKStyle.getYThickness();
        if (n7 < 0 && n8 < 0) {
            return;
        }
        Color color = gTKStyle.getGTKColor(synthContext, n, colorType);
        Color color2 = gTKStyle.getGTKColor(synthContext, n, colorType2);
        Color color3 = gTKStyle.getGTKColor(synthContext, n, colorType3);
        Color color4 = gTKStyle.getGTKColor(synthContext, n, colorType4);
        Color color5 = gTKStyle.getGTKColor(synthContext, n, GTKColorType.WHITE);
        int n9 = ((JTabbedPane)synthContext.getComponent()).getSelectedIndex();
        graphics.translate(n2, n3);
        if (positionType == GTKConstants.PositionType.BOTTOM) {
            this.paintBackground(graphics, synthContext, region, n, color2, 0, 1, n4, n5);
            if (n6 == n9 || n6 == 0) {
                graphics.setColor(color);
                graphics.drawLine(0, 1, 0, n5 - 1);
                graphics.drawLine(1, 0, n4 - 2, 0);
                if (bl) {
                    graphics.setColor(color5);
                    graphics.drawLine(1, 1, 1, n5 - 1);
                    graphics.drawLine(1, 1, n4 - 3, 1);
                }
            } else {
                graphics.setColor(color);
                graphics.drawLine(0, 0, n4 - 2, 0);
                if (bl) {
                    graphics.setColor(color5);
                    graphics.drawLine(0, 1, n4 - 3, 1);
                }
            }
            if (n6 + 1 != n9) {
                graphics.setColor(color4);
                graphics.drawLine(n4 - 2, 2, n4 - 2, n5 - 1);
                graphics.setColor(color3);
                graphics.drawLine(n4 - 1, 1, n4 - 1, n5 - 1);
            }
        } else if (positionType == GTKConstants.PositionType.TOP) {
            this.paintBackground(graphics, synthContext, region, n, color2, 0, 0, n4, n5 - 1);
            if (n6 == n9 || n6 == 0) {
                graphics.setColor(color);
                graphics.drawLine(0, 0, 0, n5 - 2);
                graphics.setColor(color3);
                graphics.drawLine(1, n5 - 1, n4 - 2, n5 - 1);
                graphics.setColor(color4);
                graphics.drawLine(2, n5 - 2, n4 - 2, n5 - 2);
                if (bl) {
                    graphics.setColor(color5);
                    graphics.drawLine(1, 0, 1, n5 - 2);
                }
            } else {
                graphics.setColor(color3);
                graphics.drawLine(0, n5 - 1, n4 - 2, n5 - 1);
                graphics.setColor(color4);
                graphics.drawLine(0, n5 - 2, n4 - 2, n5 - 2);
                if (bl) {
                    graphics.setColor(color5);
                    graphics.drawLine(0, 0, 0, n5 - 2);
                }
            }
            if (n6 + 1 != n9) {
                graphics.setColor(color3);
                graphics.drawLine(n4 - 1, 0, n4 - 1, n5 - 2);
                graphics.setColor(color4);
                graphics.drawLine(n4 - 2, 0, n4 - 2, n5 - 2);
            }
        } else if (positionType == GTKConstants.PositionType.RIGHT) {
            this.paintBackground(graphics, synthContext, region, n, color2, 1, 0, n4, n5);
            if (n6 == n9 || n6 == 0) {
                graphics.setColor(color);
                graphics.drawLine(1, 0, n4 - 1, 0);
                graphics.drawLine(0, 1, 0, n5 - 2);
                if (bl) {
                    graphics.setColor(color5);
                    graphics.drawLine(1, 1, n4, 1);
                    graphics.drawLine(1, 1, 1, n5 - 3);
                }
            } else {
                graphics.setColor(color);
                graphics.drawLine(0, 0, 0, n5 - 2);
                if (bl) {
                    graphics.setColor(color5);
                    graphics.drawLine(1, 1, 1, n5 - 3);
                }
            }
            if (n6 + 1 != n9) {
                graphics.setColor(color3);
                graphics.drawLine(1, n5 - 1, n4 - 1, n5 - 1);
                graphics.setColor(color4);
                graphics.drawLine(2, n5 - 2, n4 - 1, n5 - 2);
            }
        } else if (positionType == GTKConstants.PositionType.LEFT) {
            this.paintBackground(graphics, synthContext, region, n, color2, 0, 0, n4 - 1, n5);
            if (n6 == n9 || n6 == 0) {
                graphics.setColor(color);
                graphics.drawLine(0, 0, n4 - 2, 0);
                graphics.setColor(color3);
                graphics.drawLine(n4 - 1, 1, n4 - 1, n5 - 2);
                graphics.setColor(color4);
                graphics.drawLine(n4 - 2, 2, n4 - 2, n5 - 2);
                if (bl) {
                    graphics.setColor(color5);
                    graphics.drawLine(0, 1, n4 - 2, 1);
                    graphics.drawLine(n4 - 2, 1, n4 - 2, n5 - 3);
                }
            } else {
                graphics.setColor(color3);
                graphics.drawLine(n4 - 1, 0, n4 - 1, n5 - 2);
                graphics.setColor(color4);
                graphics.drawLine(n4 - 2, 0, n4 - 2, n5 - 2);
                if (bl) {
                    graphics.setColor(color5);
                    graphics.drawLine(n4 - 2, 1, n4 - 2, n5 - 3);
                }
            }
            if (n6 + 1 != n9) {
                graphics.setColor(color3);
                graphics.drawLine(0, n5 - 1, n4 - 2, n5 - 1);
                graphics.setColor(color4);
                graphics.drawLine(0, n5 - 2, n4 - 2, n5 - 2);
            }
        }
        graphics.translate(-n2, -n3);
    }

    public void paintFlatBox(Graphics graphics, SynthContext synthContext, Region region, int n, GTKConstants.ShadowType shadowType, String string, int n2, int n3, int n4, int n5, ColorType colorType) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        graphics.setColor(gTKStyle.getGTKColor(synthContext, n, colorType));
        if (string == "cell_odd") {
            graphics.fillRect(n2, n3, n4, n5);
        } else {
            this.paintBackground(graphics, synthContext, region, n, graphics.getColor(), n2, n3, n4, n5);
        }
        if (string == "tooltip") {
            graphics.setColor(Color.BLACK);
            graphics.drawRect(n2, n3, n4 - 1, n5 - 1);
        }
    }

    public void paintFocus(Graphics graphics, SynthContext synthContext, Region region, int n, String string, int n2, int n3, int n4, int n5) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int[] nArray = (int[])gTKStyle.getClassSpecificValue(synthContext, "focus-line-pattern");
        int n6 = gTKStyle.getClassSpecificIntValue(synthContext, "focus-line-width", 1);
        if (nArray == null) {
            nArray = DEFAULT_FOCUS_PATTERN;
        }
        if (n6 <= 0) {
            return;
        }
        graphics.setColor(this.getFocusColor(synthContext, n));
        this._paintFocus(graphics, n2, n3, n4, n5, nArray, n6);
    }

    void _paintFocus(Graphics graphics, int n, int n2, int n3, int n4, int[] nArray, int n5) {
        int n6;
        graphics.translate(n, n2);
        int n7 = n6 = n5 / 2;
        int n8 = 0;
        int n9 = n3 - n5;
        int n10 = n9 + n4 - n5;
        int n11 = n10 + n3 - n5;
        int n12 = n11 + n4;
        while (n7 < n12) {
            int n13 = n7 + nArray[n8];
            if (n8 % 2 == 0) {
                int n14;
                int n15;
                if (n7 < n9) {
                    graphics.fillRect(n7, 0, Math.min(n13, n3) - n7, n5);
                    n7 = Math.min(n13, n9);
                }
                if (n7 != n13 && n7 < n10) {
                    graphics.fillRect(n3 - n5, n7 - n9, n5, Math.min(n10, n13) - n7);
                    n7 = Math.min(n10, n13);
                }
                if (n7 != n13 && n7 < n11) {
                    n15 = n3 - (n7 - n10);
                    n14 = Math.min(n13 - n7, n11 - n7);
                    graphics.fillRect(n15 - n14, n4 - n5, n14, n5);
                    n7 += n14;
                }
                if (n7 != n13) {
                    n15 = n4 - (n7 - n11);
                    n14 = Math.min(n13 - n7, n12 - n7);
                    graphics.fillRect(0, n15 - n14, n5, n14);
                    n7 += n14;
                }
            } else {
                n7 = n13;
            }
            n8 = (n8 + 1) % nArray.length;
        }
        graphics.translate(-n, -n2);
    }

    Color getFocusColor(SynthContext synthContext, int n) {
        return ((GTKStyle)synthContext.getStyle()).getGTKColor(synthContext, n, ColorType.FOREGROUND);
    }

    public void paintHandle(Graphics graphics, SynthContext synthContext, Region region, int n, GTKConstants.ShadowType shadowType, String string, int n2, int n3, int n4, int n5, GTKConstants.Orientation orientation) {
        this.paintBox(graphics, synthContext, region, n, shadowType, string, n2, n3, n4, n5);
        graphics.translate(n2, n3);
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        Color color = gTKStyle.getGTKColor(synthContext, n, GTKColorType.LIGHT);
        Color color2 = gTKStyle.getGTKColor(synthContext, n, GTKColorType.DARK);
        Color color3 = gTKStyle.getGTKColor(synthContext, n, GTKColorType.BLACK);
        if (string == "paned") {
            int n6;
            int n7;
            JSplitPane jSplitPane = (JSplitPane)synthContext.getComponent();
            int n8 = 33;
            if (orientation == GTKConstants.Orientation.HORIZONTAL) {
                n7 = n4 / 2 - n8 / 2;
                n6 = jSplitPane.getDividerSize() / 2 - 1;
            } else {
                n7 = jSplitPane.getDividerSize() / 2 - 1;
                n6 = n5 / 2 - n8 / 2;
            }
            for (int i = 0; i < 7; ++i) {
                if (orientation == GTKConstants.Orientation.HORIZONTAL) {
                    n7 += 5;
                } else {
                    n6 += 5;
                }
                graphics.setColor(color);
                graphics.fillRect(n7, n6, 2, 2);
                graphics.setColor(color3);
                graphics.fillRect(n7 + 1, n6 + 1, 2, 2);
                graphics.setColor(color2);
                graphics.fillRect(n7 + 1, n6 + 1, 1, 1);
            }
        } else if (string == "handlebox") {
            int n9;
            int n10;
            JToolBar jToolBar = (JToolBar)synthContext.getComponent();
            if (jToolBar.getOrientation() == 0) {
                for (n10 = 2; n10 < n5; n10 += 3) {
                    graphics.setColor(color2);
                    graphics.fillRect(n9 + 1, n10 + 1, 2, 2);
                    graphics.fillRect(n9 + 4, n10 + 2, 2, 2);
                    graphics.setColor(color);
                    graphics.fillRect(n9, n10, 2, 2);
                    graphics.fillRect(n9 + 3, n10 + 1, 2, 2);
                }
            } else {
                boolean bl = true;
                for (n9 = 2; n9 < n4; n9 += 3) {
                    graphics.setColor(color2);
                    graphics.fillRect(n9 + 1, n10 + 1, 2, 2);
                    graphics.fillRect(n9 + 1, n10 + 4, 2, 2);
                    graphics.setColor(color);
                    graphics.fillRect(n9, n10, 2, 2);
                    graphics.fillRect(n9, n10 + 3, 2, 2);
                    if (bl) {
                        ++n10;
                        bl = false;
                        continue;
                    }
                    --n10;
                    bl = true;
                }
            }
            this.paintShadow(graphics, synthContext, region, n, shadowType, string, 0, 0, n4, n5);
        }
        graphics.translate(-n2, -n3);
    }

    public void paintOption(Graphics graphics, SynthContext synthContext, Region region, int n, GTKConstants.ShadowType shadowType, String string, int n2, int n3, int n4, int n5) {
        graphics.translate(n2, n3);
        int n6 = synthContext.getComponentState();
        int n7 = n5 / 2 - 1;
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n8 = (n6 & 4) == 0 ? 1 : 4;
        graphics.setColor(gTKStyle.getGTKColor(synthContext, n8, GTKColorType.TEXT_BACKGROUND));
        if (synthContext.getRegion() != Region.RADIO_BUTTON_MENU_ITEM) {
            graphics.fillRect(3, n7 - 3, 9, 9);
            graphics.fillRect(13, n7 - 1, 1, 4);
            graphics.fillRect(12, n7 + 3, 1, 2);
            graphics.fillRect(9, n7 + 6, 2, 1);
            graphics.fillRect(5, n7 + 7, 4, 1);
            graphics.setColor(gTKStyle.getGTKColor(synthContext, 1, GTKColorType.DARK));
            graphics.fillRect(5, n7 - 5, 4, 1);
            graphics.fillRect(3, n7 - 4, 3, 1);
            graphics.fillRect(2, n7 - 3, 1, 2);
            graphics.fillRect(1, n7 - 1, 1, 4);
            graphics.fillRect(2, n7 + 4, 1, 1);
            graphics.fillRect(3, n7 + 5, 2, 1);
            graphics.fillRect(5, n7 + 6, 4, 1);
            graphics.fillRect(9, n7 + 5, 2, 1);
            graphics.fillRect(11, n7 + 3, 1, 2);
            graphics.fillRect(12, n7 - 1, 1, 4);
            graphics.fillRect(11, n7 - 3, 1, 2);
            graphics.fillRect(10, n7 - 4, 1, 1);
            graphics.setColor(gTKStyle.getGTKColor(synthContext, n, GTKColorType.BLACK));
            graphics.fillRect(5, n7 - 4, 5, 1);
            graphics.fillRect(10, n7 - 3, 1, 1);
            graphics.fillRect(3, n7 - 3, 2, 1);
            graphics.fillRect(3, n7 - 2, 1, 1);
            graphics.fillRect(2, n7 - 1, 1, 5);
            graphics.fillRect(3, n7 + 4, 1, 1);
        }
        if ((n6 & 0x200) != 0) {
            graphics.setColor(gTKStyle.getGTKColor(synthContext, 1, GTKColorType.FOREGROUND));
            graphics.fillRect(5, n7, 5, 3);
            graphics.fillRect(6, n7 - 1, 3, 1);
            graphics.fillRect(6, n7 + 3, 3, 1);
        }
        graphics.translate(-n2, -n3);
    }

    public void paintShadow(Graphics graphics, SynthContext synthContext, Region region, int n, GTKConstants.ShadowType shadowType, String string, int n2, int n3, int n4, int n5) {
        if (string == "buttondefault") {
            graphics.setColor(((GTKStyle)synthContext.getStyle()).getGTKColor(synthContext, n, GTKColorType.BLACK));
            graphics.drawRect(n2, n3, n4 - 1, n5 - 1);
            return;
        }
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        JComponent jComponent = synthContext.getComponent();
        int n6 = gTKStyle.getXThickness();
        int n7 = gTKStyle.getYThickness();
        if (string == "trough" || string == "spinbutton" && jComponent instanceof JButton) {
            n7 = 1;
            n6 = 1;
        }
        if (n6 < 0 && n7 < 0) {
            return;
        }
        Color color = null;
        Color color2 = null;
        Color color3 = null;
        Color color4 = null;
        switch (shadowType) {
            case IN: {
                if (string == "spinbutton" && jComponent instanceof JButton) {
                    color4 = color = gTKStyle.getGTKColor(synthContext, n, GTKColorType.DARK);
                    color3 = gTKStyle.getGTKColor(synthContext, n, GTKColorType.BLACK);
                    break;
                }
                color = gTKStyle.getGTKColor(synthContext, n, GTKColorType.DARK);
                color2 = gTKStyle.getGTKColor(synthContext, n, GTKColorType.BLACK);
                color3 = gTKStyle.getGTKColor(synthContext, n, GTKColorType.LIGHT);
                color4 = gTKStyle.getGTKColor(synthContext, n, GTKColorType.BACKGROUND);
                break;
            }
            case OUT: {
                color = gTKStyle.getGTKColor(synthContext, n, GTKColorType.LIGHT);
                color2 = gTKStyle.getGTKColor(synthContext, n, GTKColorType.BACKGROUND);
                color3 = gTKStyle.getGTKColor(synthContext, n, GTKColorType.BLACK);
                color4 = gTKStyle.getGTKColor(synthContext, n, GTKColorType.DARK);
                break;
            }
        }
        if (string == "spinbutton" && jComponent instanceof JButton) {
            this._paintSpinButtonShadow(graphics, n2, n3, n4, n5, n6, n7, color, color2, color3, color4);
        } else {
            this._paintShadow(graphics, n2, n3, n4, n5, n6, n7, color, color2, color3, color4);
        }
    }

    void _paintShadow(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, Color color, Color color2, Color color3, Color color4) {
        graphics.translate(n, n2);
        graphics.setColor(color);
        if (n5 > 0) {
            graphics.drawLine(0, 0, 0, n4 - 1);
        }
        if (n6 > 0) {
            graphics.drawLine(1, 0, n3 - 1, 0);
        }
        if (n5 > 1 || n6 > 1) {
            graphics.setColor(color2);
            if (n5 > 1) {
                graphics.drawLine(1, 1, 1, n4 - 2);
            }
            if (n6 > 1) {
                graphics.drawLine(2, 1, n3 - 2, 1);
            }
        }
        graphics.setColor(color3);
        if (n5 > 0) {
            graphics.drawLine(n3 - 1, 1, n3 - 1, n4 - 1);
        }
        if (n6 > 0) {
            graphics.drawLine(1, n4 - 1, n3 - 2, n4 - 1);
        }
        if (n5 > 1 || n6 > 1) {
            graphics.setColor(color4);
            if (n5 > 1) {
                graphics.drawLine(n3 - 2, 2, n3 - 2, n4 - 2);
            }
            if (n6 > 1) {
                graphics.drawLine(2, n4 - 2, n3 - 3, n4 - 2);
            }
        }
        graphics.translate(-n, -n2);
    }

    void _paintSpinButtonShadow(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, Color color, Color color2, Color color3, Color color4) {
        graphics.translate(n, n2);
        graphics.setColor(color);
        graphics.drawLine(0, 0, n3 - 1, 0);
        graphics.setColor(color4);
        graphics.drawLine(0, n4 - 1, n3 - 1, n4 - 1);
        graphics.setColor(color3);
        graphics.drawLine(0, 0, 0, n4 - 1);
        graphics.drawLine(n3 - 1, 0, n3 - 1, n4 - 1);
        graphics.translate(-n, -n2);
    }

    public void paintExpander(Graphics graphics, SynthContext synthContext, Region region, int n, GTKConstants.ExpanderStyle expanderStyle, String string, int n2, int n3, int n4, int n5) {
        if (expanderStyle == GTKConstants.ExpanderStyle.COLLAPSED) {
            if (n != 2) {
                this.paintHollowTriangle(synthContext, graphics, n, n2, n3, Math.min(n4, n5), GTKDefaultEngine.adjustAxisForComponentOrientation(synthContext.getComponent(), 3));
            }
        } else if (n != 2) {
            this.paintHollowTriangle(synthContext, graphics, n, n2, n3, Math.min(n4, n5), 5);
        }
    }

    private void paintHollowTriangle(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n6 = n4 / 2;
        int n7 = n4 / 2 + 1;
        int n8 = Math.max(1, n4 / 7);
        graphics.translate(n2, n3);
        Color color = gTKStyle.getGTKColor(synthContext, n, GTKColorType.FOREGROUND);
        Color color2 = gTKStyle.getGTKColor(synthContext, n, GTKColorType.BACKGROUND);
        switch (n5) {
            case 1: {
                int n9;
                int n10;
                int n11 = n4 / 2 + n7 / 2 - 1;
                graphics.setColor(color2);
                for (n10 = n7 - 1; n10 > 0; --n10) {
                    graphics.drawLine(n6 - n10 + 1, n11, n6 + n10 - 1, n11);
                    --n11;
                }
                graphics.setColor(color);
                n11 = n4 / 2 + n7 / 2 - 1;
                int n12 = n8 - 1;
                for (n9 = 0; n9 < n8; ++n9) {
                    graphics.drawLine(0 - n12, n11 - n9, n4 + n12, n11 - n9);
                    --n12;
                }
                --n11;
                for (n10 = n7 - 1; n10 > 0; --n10) {
                    for (n9 = 0; n9 < n8; ++n9) {
                        graphics.drawLine(n6 - n10 + 1 - n9, n11, n6 - n10 + 1 - n9, n11);
                        graphics.drawLine(n6 + n10 - 1 + n9, n11, n6 + n10 - 1 + n9, n11);
                    }
                    --n11;
                }
                if (n8 <= 1) break;
                for (n9 = n8 - 2; n9 >= 0; --n9) {
                    graphics.drawLine(n6 - n9, n11, n6 + n9, n11);
                    --n11;
                }
                break;
            }
            case 5: {
                int n13;
                int n14;
                int n15 = n4 / 2 - n7 / 2 - 1;
                graphics.setColor(color2);
                for (n14 = n7 - 1; n14 > 0; --n14) {
                    graphics.drawLine(n6 - n14 + 1, n15, n6 + n14 - 1, n15);
                    ++n15;
                }
                graphics.setColor(color);
                n15 = n4 / 2 - n7 / 2 - 1;
                int n16 = n8 - 1;
                for (n13 = 0; n13 < n8; ++n13) {
                    graphics.drawLine(0 - n16, n15 + n13, n4 + n16, n15 + n13);
                    --n16;
                }
                ++n15;
                for (n14 = n7 - 1; n14 > 0; --n14) {
                    for (n13 = 0; n13 < n8; ++n13) {
                        graphics.drawLine(n6 - n14 + 1 - n13, n15, n6 - n14 + 1 - n13, n15);
                        graphics.drawLine(n6 + n14 - 1 + n13, n15, n6 + n14 - 1 + n13, n15);
                    }
                    ++n15;
                }
                if (n8 <= 1) break;
                for (n13 = n8 - 2; n13 >= 0; --n13) {
                    graphics.drawLine(n6 - n13, n15, n6 + n13, n15);
                    ++n15;
                }
                break;
            }
            case 7: {
                int n17;
                int n18;
                int n19 = n4 / 2 + n7 / 2 - 1;
                graphics.setColor(color2);
                for (n18 = n7 - 1; n18 > 0; --n18) {
                    graphics.drawLine(n19, n6 - n18 + 1, n19, n6 + n18 - 1);
                    --n19;
                }
                graphics.setColor(color);
                n19 = n4 / 2 + n7 / 2 - 1;
                int n20 = n8 - 1;
                for (n17 = 0; n17 < n8; ++n17) {
                    graphics.drawLine(n19 - n17, 0 - n20, n19 - n17, n4 + n20);
                    --n20;
                }
                --n19;
                for (n18 = n7 - 1; n18 > 0; --n18) {
                    for (n17 = 0; n17 < n8; ++n17) {
                        graphics.drawLine(n19, n6 - n18 + 1 - n17, n19, n6 - n18 + 1 - n17);
                        graphics.drawLine(n19, n6 + n18 - 1 + n17, n19, n6 + n18 - 1 + n17);
                    }
                    --n19;
                }
                if (n8 <= 1) break;
                for (n17 = n8 - 2; n17 >= 0; --n17) {
                    graphics.drawLine(n19, n6 - n17, n19, n6 + n17);
                    --n19;
                }
                break;
            }
            case 3: {
                int n21;
                int n22;
                int n23 = n4 / 2 - n7 / 2 - 1;
                graphics.setColor(color2);
                for (n22 = n7 - 1; n22 > 0; --n22) {
                    graphics.drawLine(n23, n6 - n22 + 1, n23, n6 + n22 - 1);
                    ++n23;
                }
                graphics.setColor(color);
                n23 = n4 / 2 - n7 / 2 - 1;
                int n24 = n8 - 1;
                for (n21 = 0; n21 < n8; ++n21) {
                    graphics.drawLine(n23 + n21, 0 - n24, n23 + n21, n4 + n24);
                    --n24;
                }
                ++n23;
                for (n22 = n7 - 1; n22 > 0; --n22) {
                    for (n21 = 0; n21 < n8; ++n21) {
                        graphics.drawLine(n23, n6 - n22 + 1 - n21, n23, n6 - n22 + 1 - n21);
                        graphics.drawLine(n23, n6 + n22 - 1 + n21, n23, n6 + n22 - 1 + n21);
                    }
                    ++n23;
                }
                if (n8 <= 1) break;
                for (n21 = n8 - 2; n21 >= 0; --n21) {
                    graphics.drawLine(n23, n6 - n21, n23, n6 + n21);
                    ++n23;
                }
                break;
            }
        }
        graphics.translate(-n2, -n3);
    }

    public void paintSlider(Graphics graphics, SynthContext synthContext, Region region, int n, GTKConstants.ShadowType shadowType, String string, int n2, int n3, int n4, int n5, GTKConstants.Orientation orientation) {
        this.paintBox(graphics, synthContext, region, n, shadowType, string, n2, n3, n4, n5);
        if (synthContext.getRegion() == Region.SLIDER_THUMB) {
            if (orientation == GTKConstants.Orientation.HORIZONTAL) {
                this.paintVline(graphics, synthContext, region, n, string, n2 + n4 / 2 - 1, n3 + 2, 2, n5 - 4);
            } else {
                this.paintHline(graphics, synthContext, region, n, string, n2 + 2, n3 + n5 / 2 - 1, n4 - 4, 2);
            }
        }
    }

    public void paintHline(Graphics graphics, SynthContext synthContext, Region region, int n, String string, int n2, int n3, int n4, int n5) {
        graphics.translate(n2, n3);
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n6 = n5 / 2;
        if (n5 == 2) {
            n6 = 0;
        }
        graphics.setColor(gTKStyle.getGTKColor(synthContext, n, GTKColorType.DARK));
        graphics.drawLine(0, n6, n4 - 2, n6);
        graphics.setColor(gTKStyle.getGTKColor(synthContext, n, GTKColorType.LIGHT));
        graphics.drawLine(0, n6 + 1, n4 - 1, n6 + 1);
        graphics.drawLine(n4 - 1, n6, n4 - 1, n6 + 1);
        graphics.translate(-n2, -n3);
    }

    public void paintVline(Graphics graphics, SynthContext synthContext, Region region, int n, String string, int n2, int n3, int n4, int n5) {
        graphics.translate(n2, n3);
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        int n6 = n4 / 2;
        graphics.setColor(gTKStyle.getGTKColor(synthContext, n, GTKColorType.DARK));
        graphics.drawLine(n6, 0, n6, n5 - 2);
        graphics.drawLine(n6, 0, n6 + 1, 0);
        graphics.setColor(gTKStyle.getGTKColor(synthContext, n, GTKColorType.LIGHT));
        graphics.drawLine(n6 + 1, 1, n6 + 1, n5 - 1);
        graphics.drawLine(n6, n5 - 1, n6 + 1, n5 - 1);
        graphics.translate(-n2, -n3);
    }

    public void paintBackground(Graphics graphics, SynthContext synthContext, Region region, int n, Color color, int n2, int n3, int n4, int n5) {
        GTKStyle gTKStyle = (GTKStyle)synthContext.getStyle();
        if (gTKStyle.fillBackground(synthContext, n)) {
            graphics.setColor(color);
            graphics.fillRect(n2, n3, n4, n5);
        } else {
            int n6;
            int n7;
            Image image = gTKStyle.getBackgroundImage(synthContext, n);
            if (image != null && (n7 = image.getWidth(null)) > 0 && (n6 = image.getHeight(null)) > 0) {
                Serializable serializable;
                int n8 = n2;
                int n9 = n3;
                Container container = synthContext.getComponent().getParent();
                while (container != null && !(container instanceof Window) && !(container instanceof Applet)) {
                    serializable = container.getParent();
                    if (container instanceof JRootPane && !(serializable instanceof Window) && !(serializable instanceof Applet)) {
                        n8 += container.getX();
                        n9 += container.getY();
                    }
                    container = serializable;
                }
                n8 %= n7;
                n9 %= n6;
                serializable = graphics.getClipBounds();
                int n10 = ((Rectangle)serializable).x;
                int n11 = ((Rectangle)serializable).y;
                int n12 = n10 + ((Rectangle)serializable).width;
                int n13 = n11 + ((Rectangle)serializable).height;
                int n14 = n9;
                int n15 = n3 + n5;
                for (int i = n3; i < n15; i += n6 - n14) {
                    int n16 = n8;
                    int n17 = n2 + n4;
                    for (int j = n2; j < n17; j += n7 - n16) {
                        int n18 = Math.min(n17, j + n7 - n16);
                        int n19 = Math.min(n15, i + n6 - n14);
                        if (n18 > n10 && n19 > n11 && n12 > j && n13 > i) {
                            graphics.drawImage(image, j, i, n18, n19, n16, n14, n16 + n18 - j, n14 + n19 - i, null);
                        }
                        n16 = 0;
                    }
                    n14 = 0;
                }
            }
        }
    }
}

