/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.cache.MemoryCache;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public class CachedJarFile14
extends JarFile {
    private Reference certificatesRef;
    private Reference signerMapCertRef = null;
    private Reference manifestRef = null;
    private String resourceURL;

    public String getName() {
        String string = super.getName();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return string;
        }
        try {
            securityManager.checkPermission(new RuntimePermission("accessDeploymentCache"));
            return string;
        }
        catch (SecurityException securityException) {
            return "";
        }
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            return new CachedJarFile14(new File(super.getName()), this.certificatesRef, this.signerMapCertRef, this.manifestRef, this.resourceURL);
        }
        catch (IOException iOException) {
            throw new CloneNotSupportedException();
        }
    }

    private CachedJarFile14(File file, Reference reference, Reference reference2, Reference reference3, String string) throws IOException {
        super(file, false);
        this.certificatesRef = reference;
        this.signerMapCertRef = reference2;
        this.manifestRef = reference3;
        this.resourceURL = string;
        MemoryCache.addResourceReference(this, string);
    }

    protected CachedJarFile14(CacheEntry cacheEntry) throws IOException {
        super(new File(cacheEntry.getResourceFilename()), false);
        this.resourceURL = cacheEntry.getURL();
        Certificate[] certificateArray = cacheEntry.getCertificates();
        Map map = cacheEntry.getCertificateMap();
        Manifest manifest = cacheEntry.getManifest();
        this.certificatesRef = certificateArray != null ? new SoftReference<Certificate[]>(certificateArray) : null;
        this.signerMapCertRef = map != null ? new SoftReference<Map>(map) : null;
        if (manifest != null) {
            this.manifestRef = new SoftReference<Manifest>(manifest);
        }
        MemoryCache.addResourceReference(this, this.resourceURL);
    }

    public ZipEntry getEntry(String string) {
        ZipEntry zipEntry = super.getEntry(string);
        if (zipEntry != null) {
            return new JarFileEntry(zipEntry);
        }
        return null;
    }

    public Enumeration entries() {
        final Enumeration<JarEntry> enumeration = super.entries();
        return new Enumeration(){

            public boolean hasMoreElements() {
                return enumeration.hasMoreElements();
            }

            public Object nextElement() {
                try {
                    ZipEntry zipEntry = (ZipEntry)enumeration.nextElement();
                    return new JarFileEntry(zipEntry);
                }
                catch (InternalError internalError) {
                    throw new InternalError("Error in CachedJarFile entries");
                }
            }
        };
    }

    private CacheEntry getCacheEntry() {
        if (this.resourceURL == null) {
            return null;
        }
        CacheEntry cacheEntry = (CacheEntry)MemoryCache.getLoadedResource(this.resourceURL);
        if (cacheEntry == null) {
            Trace.println("Missing CacheEntry for " + this.resourceURL + "\n" + cacheEntry, TraceLevel.CACHE);
        }
        return cacheEntry;
    }

    public Manifest getManifest() throws IOException {
        if (this.manifestRef == null) {
            return null;
        }
        Manifest manifest = (Manifest)this.manifestRef.get();
        if (manifest == null) {
            CacheEntry cacheEntry = this.getCacheEntry();
            if (cacheEntry != null) {
                manifest = cacheEntry.getManifest();
            }
            if (manifest != null) {
                this.manifestRef = new SoftReference<Manifest>(manifest);
            }
        }
        return manifest;
    }

    private Map getCertificateMap() {
        CacheEntry cacheEntry;
        if (this.signerMapCertRef == null) {
            return null;
        }
        Map map = (Map)this.signerMapCertRef.get();
        if (map == null && (cacheEntry = this.getCacheEntry()) != null && (map = cacheEntry.getCertificateMap()) != null) {
            this.signerMapCertRef = new SoftReference<Map>(map);
        }
        return map;
    }

    private Certificate[] getCertificates() {
        CacheEntry cacheEntry;
        if (this.certificatesRef == null) {
            return null;
        }
        Certificate[] certificateArray = (Certificate[])this.certificatesRef.get();
        if (certificateArray == null && (cacheEntry = this.getCacheEntry()) != null && (certificateArray = cacheEntry.getCertificates()) != null) {
            this.certificatesRef = new SoftReference<Certificate[]>(certificateArray);
        }
        return certificateArray;
    }

    private class JarFileEntry
    extends JarEntry {
        JarFileEntry(ZipEntry zipEntry) {
            super(zipEntry);
        }

        public Attributes getAttributes() throws IOException {
            Manifest manifest = CachedJarFile14.this.getManifest();
            if (manifest != null) {
                return manifest.getAttributes(this.getName());
            }
            return null;
        }

        public Certificate[] getCertificates() {
            int[] nArray;
            Certificate[] certificateArray = null;
            Map map = CachedJarFile14.this.getCertificateMap();
            Certificate[] certificateArray2 = CachedJarFile14.this.getCertificates();
            if (map != null && !map.isEmpty() && (nArray = (int[])map.get(this.getName())) != null) {
                certificateArray = new Certificate[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    certificateArray[i] = certificateArray2[nArray[i]];
                }
            }
            return certificateArray;
        }
    }
}

