/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.resolver;

import com.sun.org.apache.xml.internal.resolver.CatalogEntry;
import com.sun.org.apache.xml.internal.resolver.CatalogException;
import com.sun.org.apache.xml.internal.resolver.CatalogManager;
import com.sun.org.apache.xml.internal.resolver.helpers.FileURL;
import com.sun.org.apache.xml.internal.resolver.helpers.PublicId;
import com.sun.org.apache.xml.internal.resolver.readers.CatalogReader;
import com.sun.org.apache.xml.internal.resolver.readers.SAXCatalogReader;
import com.sun.org.apache.xml.internal.resolver.readers.TR9401CatalogReader;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.SAXParserFactory;

public class Catalog {
    public static final int BASE = CatalogEntry.addEntryType("BASE", 1);
    public static final int CATALOG = CatalogEntry.addEntryType("CATALOG", 1);
    public static final int DOCUMENT = CatalogEntry.addEntryType("DOCUMENT", 1);
    public static final int OVERRIDE = CatalogEntry.addEntryType("OVERRIDE", 1);
    public static final int SGMLDECL = CatalogEntry.addEntryType("SGMLDECL", 1);
    public static final int DELEGATE_PUBLIC = CatalogEntry.addEntryType("DELEGATE_PUBLIC", 2);
    public static final int DELEGATE_SYSTEM = CatalogEntry.addEntryType("DELEGATE_SYSTEM", 2);
    public static final int DELEGATE_URI = CatalogEntry.addEntryType("DELEGATE_URI", 2);
    public static final int DOCTYPE = CatalogEntry.addEntryType("DOCTYPE", 2);
    public static final int DTDDECL = CatalogEntry.addEntryType("DTDDECL", 2);
    public static final int ENTITY = CatalogEntry.addEntryType("ENTITY", 2);
    public static final int LINKTYPE = CatalogEntry.addEntryType("LINKTYPE", 2);
    public static final int NOTATION = CatalogEntry.addEntryType("NOTATION", 2);
    public static final int PUBLIC = CatalogEntry.addEntryType("PUBLIC", 2);
    public static final int SYSTEM = CatalogEntry.addEntryType("SYSTEM", 2);
    public static final int URI = CatalogEntry.addEntryType("URI", 2);
    public static final int REWRITE_SYSTEM = CatalogEntry.addEntryType("REWRITE_SYSTEM", 2);
    public static final int REWRITE_URI = CatalogEntry.addEntryType("REWRITE_URI", 2);
    public static final int SYSTEM_SUFFIX = CatalogEntry.addEntryType("SYSTEM_SUFFIX", 2);
    public static final int URI_SUFFIX = CatalogEntry.addEntryType("URI_SUFFIX", 2);
    protected URL base;
    protected URL catalogCwd;
    protected Vector catalogEntries = new Vector();
    protected boolean default_override = true;
    protected CatalogManager catalogManager = CatalogManager.getStaticManager();
    protected Vector catalogFiles = new Vector();
    protected Vector localCatalogFiles = new Vector();
    protected Vector catalogs = new Vector();
    protected Vector localDelegate = new Vector();
    protected Hashtable readerMap = new Hashtable();
    protected Vector readerArr = new Vector();

    public Catalog() {
    }

    public Catalog(CatalogManager catalogManager) {
        this.catalogManager = catalogManager;
    }

    public CatalogManager getCatalogManager() {
        return this.catalogManager;
    }

    public void setCatalogManager(CatalogManager catalogManager) {
        this.catalogManager = catalogManager;
    }

    public void setupReaders() {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(true);
        sAXParserFactory.setValidating(false);
        SAXCatalogReader sAXCatalogReader = new SAXCatalogReader(sAXParserFactory);
        sAXCatalogReader.setCatalogParser(null, "XMLCatalog", "com.sun.org.apache.xml.internal.resolver.readers.XCatalogReader");
        sAXCatalogReader.setCatalogParser("urn:oasis:names:tc:entity:xmlns:xml:catalog", "catalog", "com.sun.org.apache.xml.internal.resolver.readers.OASISXMLCatalogReader");
        this.addReader("application/xml", sAXCatalogReader);
        TR9401CatalogReader tR9401CatalogReader = new TR9401CatalogReader();
        this.addReader("text/plain", tR9401CatalogReader);
    }

    public void addReader(String string, CatalogReader catalogReader) {
        if (this.readerMap.containsKey(string)) {
            Integer n = (Integer)this.readerMap.get(string);
            this.readerArr.set(n, catalogReader);
        } else {
            this.readerArr.add(catalogReader);
            Integer n = new Integer(this.readerArr.size() - 1);
            this.readerMap.put(string, n);
        }
    }

    protected void copyReaders(Catalog catalog) {
        Object object;
        Vector<String> vector = new Vector<String>(this.readerMap.size());
        for (int i = 0; i < this.readerMap.size(); ++i) {
            vector.add(null);
        }
        Enumeration enumeration = this.readerMap.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            object = (Integer)this.readerMap.get(string);
            vector.set((Integer)object, string);
        }
        for (int i = 0; i < vector.size(); ++i) {
            object = (String)vector.get(i);
            Integer n = (Integer)this.readerMap.get(object);
            catalog.addReader((String)object, (CatalogReader)this.readerArr.get(n));
        }
    }

    protected Catalog newCatalog() {
        String string = this.getClass().getName();
        try {
            Catalog catalog = (Catalog)Class.forName(string).newInstance();
            catalog.setCatalogManager(this.catalogManager);
            this.copyReaders(catalog);
            return catalog;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.catalogManager.debug.message(1, "Class Not Found Exception: " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.catalogManager.debug.message(1, "Illegal Access Exception: " + string);
        }
        catch (InstantiationException instantiationException) {
            this.catalogManager.debug.message(1, "Instantiation Exception: " + string);
        }
        catch (ClassCastException classCastException) {
            this.catalogManager.debug.message(1, "Class Cast Exception: " + string);
        }
        catch (Exception exception) {
            this.catalogManager.debug.message(1, "Other Exception: " + string);
        }
        Catalog catalog = new Catalog();
        catalog.setCatalogManager(this.catalogManager);
        this.copyReaders(catalog);
        return catalog;
    }

    public String getCurrentBase() {
        return this.base.toString();
    }

    public String getDefaultOverride() {
        if (this.default_override) {
            return "yes";
        }
        return "no";
    }

    public void loadSystemCatalogs() throws MalformedURLException, IOException {
        Vector vector = this.catalogManager.getCatalogFiles();
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                this.catalogFiles.addElement(vector.elementAt(i));
            }
        }
        if (this.catalogFiles.size() > 0) {
            String string = (String)this.catalogFiles.lastElement();
            this.catalogFiles.removeElement(string);
            this.parseCatalog(string);
        }
    }

    public synchronized void parseCatalog(String string) throws MalformedURLException, IOException {
        this.default_override = this.catalogManager.getPreferPublic();
        this.catalogManager.debug.message(4, "Parse catalog: " + string);
        this.catalogFiles.addElement(string);
        this.parsePendingCatalogs();
    }

    public synchronized void parseCatalog(String string, InputStream inputStream) throws IOException, CatalogException {
        this.default_override = this.catalogManager.getPreferPublic();
        this.catalogManager.debug.message(4, "Parse " + string + " catalog on input stream");
        CatalogReader catalogReader = null;
        if (this.readerMap.containsKey(string)) {
            int n = (Integer)this.readerMap.get(string);
            catalogReader = (CatalogReader)this.readerArr.get(n);
        }
        if (catalogReader == null) {
            String string2 = "No CatalogReader for MIME type: " + string;
            this.catalogManager.debug.message(2, string2);
            throw new CatalogException(6, string2);
        }
        catalogReader.readCatalog(this, inputStream);
        this.parsePendingCatalogs();
    }

    public synchronized void parseCatalog(URL uRL) throws IOException {
        this.catalogCwd = uRL;
        this.base = uRL;
        this.default_override = this.catalogManager.getPreferPublic();
        this.catalogManager.debug.message(4, "Parse catalog: " + uRL.toString());
        DataInputStream dataInputStream = null;
        boolean bl = false;
        for (int i = 0; !bl && i < this.readerArr.size(); ++i) {
            CatalogReader catalogReader = (CatalogReader)this.readerArr.get(i);
            try {
                dataInputStream = new DataInputStream(uRL.openStream());
            }
            catch (FileNotFoundException fileNotFoundException) {
                break;
            }
            try {
                catalogReader.readCatalog(this, dataInputStream);
                bl = true;
            }
            catch (CatalogException catalogException) {
                if (catalogException.getExceptionType() == 7) break;
            }
            try {
                dataInputStream.close();
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (bl) {
            this.parsePendingCatalogs();
        }
    }

    protected synchronized void parsePendingCatalogs() throws MalformedURLException, IOException {
        Enumeration<Object> enumeration;
        Object object;
        if (!this.localCatalogFiles.isEmpty()) {
            object = new Vector();
            enumeration = this.localCatalogFiles.elements();
            while (enumeration.hasMoreElements()) {
                ((Vector)object).addElement(enumeration.nextElement());
            }
            for (int i = 0; i < this.catalogFiles.size(); ++i) {
                String string = (String)this.catalogFiles.elementAt(i);
                ((Vector)object).addElement(string);
            }
            this.catalogFiles = object;
            this.localCatalogFiles.clear();
        }
        if (this.catalogFiles.isEmpty() && !this.localDelegate.isEmpty()) {
            object = this.localDelegate.elements();
            while (object.hasMoreElements()) {
                this.catalogEntries.addElement(object.nextElement());
            }
            this.localDelegate.clear();
        }
        while (!this.catalogFiles.isEmpty()) {
            object = (String)this.catalogFiles.elementAt(0);
            try {
                this.catalogFiles.remove(0);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (this.catalogEntries.size() == 0 && this.catalogs.size() == 0) {
                try {
                    this.parseCatalogFile((String)object);
                }
                catch (CatalogException catalogException) {
                    System.out.println("FIXME: " + catalogException.toString());
                }
            } else {
                this.catalogs.addElement(object);
            }
            if (!this.localCatalogFiles.isEmpty()) {
                enumeration = new Vector();
                Enumeration enumeration2 = this.localCatalogFiles.elements();
                while (enumeration2.hasMoreElements()) {
                    ((Vector)((Object)enumeration)).addElement(enumeration2.nextElement());
                }
                for (int i = 0; i < this.catalogFiles.size(); ++i) {
                    object = (String)this.catalogFiles.elementAt(i);
                    ((Vector)((Object)enumeration)).addElement(object);
                }
                this.catalogFiles = enumeration;
                this.localCatalogFiles.clear();
            }
            if (this.localDelegate.isEmpty()) continue;
            enumeration = this.localDelegate.elements();
            while (enumeration.hasMoreElements()) {
                this.catalogEntries.addElement(enumeration.nextElement());
            }
            this.localDelegate.clear();
        }
        this.catalogFiles.clear();
    }

    protected synchronized void parseCatalogFile(String string) throws MalformedURLException, IOException, CatalogException {
        try {
            this.catalogCwd = FileURL.makeURL("basename");
        }
        catch (MalformedURLException malformedURLException) {
            String string2 = System.getProperty("user.dir");
            string2.replace('\\', '/');
            this.catalogManager.debug.message(1, "Malformed URL on cwd", string2);
            this.catalogCwd = null;
        }
        try {
            this.base = new URL(this.catalogCwd, this.fixSlashes(string));
        }
        catch (MalformedURLException malformedURLException) {
            try {
                this.base = new URL("file:" + this.fixSlashes(string));
            }
            catch (MalformedURLException malformedURLException2) {
                this.catalogManager.debug.message(1, "Malformed URL on catalog filename", this.fixSlashes(string));
                this.base = null;
            }
        }
        this.catalogManager.debug.message(2, "Loading catalog", string);
        this.catalogManager.debug.message(4, "Default BASE", this.base.toString());
        string = this.base.toString();
        DataInputStream dataInputStream = null;
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; !bl && i < this.readerArr.size(); ++i) {
            CatalogReader catalogReader = (CatalogReader)this.readerArr.get(i);
            try {
                bl2 = false;
                dataInputStream = new DataInputStream(this.base.openStream());
            }
            catch (FileNotFoundException fileNotFoundException) {
                bl2 = true;
                break;
            }
            try {
                catalogReader.readCatalog(this, dataInputStream);
                bl = true;
            }
            catch (CatalogException catalogException) {
                if (catalogException.getExceptionType() == 7) break;
            }
            try {
                dataInputStream.close();
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!bl) {
            if (bl2) {
                this.catalogManager.debug.message(3, "Catalog does not exist", string);
            } else {
                this.catalogManager.debug.message(1, "Failed to parse catalog", string);
            }
        }
    }

    public void addEntry(CatalogEntry catalogEntry) {
        int n = catalogEntry.getEntryType();
        if (n == BASE) {
            String string = catalogEntry.getEntryArg(0);
            URL uRL = null;
            if (this.base == null) {
                this.catalogManager.debug.message(5, "BASE CUR", "null");
            } else {
                this.catalogManager.debug.message(5, "BASE CUR", this.base.toString());
            }
            this.catalogManager.debug.message(4, "BASE STR", string);
            try {
                string = this.fixSlashes(string);
                uRL = new URL(this.base, string);
            }
            catch (MalformedURLException malformedURLException) {
                try {
                    uRL = new URL("file:" + string);
                }
                catch (MalformedURLException malformedURLException2) {
                    this.catalogManager.debug.message(1, "Malformed URL on base", string);
                    uRL = null;
                }
            }
            if (uRL != null) {
                this.base = uRL;
            }
            this.catalogManager.debug.message(5, "BASE NEW", this.base.toString());
        } else if (n == CATALOG) {
            String string = this.makeAbsolute(catalogEntry.getEntryArg(0));
            this.catalogManager.debug.message(4, "CATALOG", string);
            this.localCatalogFiles.addElement(string);
        } else if (n == PUBLIC) {
            String string = PublicId.normalize(catalogEntry.getEntryArg(0));
            String string2 = this.makeAbsolute(this.normalizeURI(catalogEntry.getEntryArg(1)));
            catalogEntry.setEntryArg(0, string);
            catalogEntry.setEntryArg(1, string2);
            this.catalogManager.debug.message(4, "PUBLIC", string, string2);
            this.catalogEntries.addElement(catalogEntry);
        } else if (n == SYSTEM) {
            String string = this.normalizeURI(catalogEntry.getEntryArg(0));
            String string3 = this.makeAbsolute(this.normalizeURI(catalogEntry.getEntryArg(1)));
            catalogEntry.setEntryArg(1, string3);
            this.catalogManager.debug.message(4, "SYSTEM", string, string3);
            this.catalogEntries.addElement(catalogEntry);
        } else if (n == URI) {
            String string = this.normalizeURI(catalogEntry.getEntryArg(0));
            String string4 = this.makeAbsolute(this.normalizeURI(catalogEntry.getEntryArg(1)));
            catalogEntry.setEntryArg(1, string4);
            this.catalogManager.debug.message(4, "URI", string, string4);
            this.catalogEntries.addElement(catalogEntry);
        } else if (n == DOCUMENT) {
            String string = this.makeAbsolute(this.normalizeURI(catalogEntry.getEntryArg(0)));
            catalogEntry.setEntryArg(0, string);
            this.catalogManager.debug.message(4, "DOCUMENT", string);
            this.catalogEntries.addElement(catalogEntry);
        } else if (n == OVERRIDE) {
            this.catalogManager.debug.message(4, "OVERRIDE", catalogEntry.getEntryArg(0));
            this.catalogEntries.addElement(catalogEntry);
        } else if (n == SGMLDECL) {
            String string = this.makeAbsolute(this.normalizeURI(catalogEntry.getEntryArg(0)));
            catalogEntry.setEntryArg(0, string);
            this.catalogManager.debug.message(4, "SGMLDECL", string);
            this.catalogEntries.addElement(catalogEntry);
        } else if (n == DELEGATE_PUBLIC) {
            String string = PublicId.normalize(catalogEntry.getEntryArg(0));
            String string5 = this.makeAbsolute(this.normalizeURI(catalogEntry.getEntryArg(1)));
            catalogEntry.setEntryArg(0, string);
            catalogEntry.setEntryArg(1, string5);
            this.catalogManager.debug.message(4, "DELEGATE_PUBLIC", string, string5);
            this.addDelegate(catalogEntry);
        } else if (n == DELEGATE_SYSTEM) {
            String string = this.normalizeURI(catalogEntry.getEntryArg(0));
            String string6 = this.makeAbsolute(this.normalizeURI(catalogEntry.getEntryArg(1)));
            catalogEntry.setEntryArg(0, string);
            catalogEntry.setEntryArg(1, string6);
            this.catalogManager.debug.message(4, "DELEGATE_SYSTEM", string, string6);
            this.addDelegate(catalogEntry);
        } else if (n == DELEGATE_URI) {
            String string = this.normalizeURI(catalogEntry.getEntryArg(0));
            String string7 = this.makeAbsolute(this.normalizeURI(catalogEntry.getEntryArg(1)));
            catalogEntry.setEntryArg(0, string);
            catalogEntry.setEntryArg(1, string7);
            this.catalogManager.debug.message(4, "DELEGATE_URI", string, string7);
            this.addDelegate(catalogEntry);
        } else if (n == REWRITE_SYSTEM) {
            String string = this.normalizeURI(catalogEntry.getEntryArg(0));
            String string8 = this.makeAbsolute(this.normalizeURI(catalogEntry.getEntryArg(1)));
            catalogEntry.setEntryArg(0, string);
            catalogEntry.setEntryArg(1, string8);
            this.catalogManager.debug.message(4, "REWRITE_SYSTEM", string, string8);
            this.catalogEntries.addElement(catalogEntry);
        } else if (n == REWRITE_URI) {
            String string = this.normalizeURI(catalogEntry.getEntryArg(0));
            String string9 = this.makeAbsolute(this.normalizeURI(catalogEntry.getEntryArg(1)));
            catalogEntry.setEntryArg(0, string);
            catalogEntry.setEntryArg(1, string9);
            this.catalogManager.debug.message(4, "REWRITE_URI", string, string9);
            this.catalogEntries.addElement(catalogEntry);
        } else if (n == SYSTEM_SUFFIX) {
            String string = this.normalizeURI(catalogEntry.getEntryArg(0));
            String string10 = this.makeAbsolute(this.normalizeURI(catalogEntry.getEntryArg(1)));
            catalogEntry.setEntryArg(0, string);
            catalogEntry.setEntryArg(1, string10);
            this.catalogManager.debug.message(4, "SYSTEM_SUFFIX", string, string10);
            this.catalogEntries.addElement(catalogEntry);
        } else if (n == URI_SUFFIX) {
            String string = this.normalizeURI(catalogEntry.getEntryArg(0));
            String string11 = this.makeAbsolute(this.normalizeURI(catalogEntry.getEntryArg(1)));
            catalogEntry.setEntryArg(0, string);
            catalogEntry.setEntryArg(1, string11);
            this.catalogManager.debug.message(4, "URI_SUFFIX", string, string11);
            this.catalogEntries.addElement(catalogEntry);
        } else if (n == DOCTYPE) {
            String string = this.makeAbsolute(this.normalizeURI(catalogEntry.getEntryArg(1)));
            catalogEntry.setEntryArg(1, string);
            this.catalogManager.debug.message(4, "DOCTYPE", catalogEntry.getEntryArg(0), string);
            this.catalogEntries.addElement(catalogEntry);
        } else if (n == DTDDECL) {
            String string = PublicId.normalize(catalogEntry.getEntryArg(0));
            catalogEntry.setEntryArg(0, string);
            String string12 = this.makeAbsolute(this.normalizeURI(catalogEntry.getEntryArg(1)));
            catalogEntry.setEntryArg(1, string12);
            this.catalogManager.debug.message(4, "DTDDECL", string, string12);
            this.catalogEntries.addElement(catalogEntry);
        } else if (n == ENTITY) {
            String string = this.makeAbsolute(this.normalizeURI(catalogEntry.getEntryArg(1)));
            catalogEntry.setEntryArg(1, string);
            this.catalogManager.debug.message(4, "ENTITY", catalogEntry.getEntryArg(0), string);
            this.catalogEntries.addElement(catalogEntry);
        } else if (n == LINKTYPE) {
            String string = this.makeAbsolute(this.normalizeURI(catalogEntry.getEntryArg(1)));
            catalogEntry.setEntryArg(1, string);
            this.catalogManager.debug.message(4, "LINKTYPE", catalogEntry.getEntryArg(0), string);
            this.catalogEntries.addElement(catalogEntry);
        } else if (n == NOTATION) {
            String string = this.makeAbsolute(this.normalizeURI(catalogEntry.getEntryArg(1)));
            catalogEntry.setEntryArg(1, string);
            this.catalogManager.debug.message(4, "NOTATION", catalogEntry.getEntryArg(0), string);
            this.catalogEntries.addElement(catalogEntry);
        } else {
            this.catalogEntries.addElement(catalogEntry);
        }
    }

    public void unknownEntry(Vector vector) {
        if (vector != null && vector.size() > 0) {
            String string = (String)vector.elementAt(0);
            this.catalogManager.debug.message(2, "Unrecognized token parsing catalog", string);
        }
    }

    public void parseAllCatalogs() throws MalformedURLException, IOException {
        Object object;
        for (int i = 0; i < this.catalogs.size(); ++i) {
            object = null;
            try {
                object = (Catalog)this.catalogs.elementAt(i);
                continue;
            }
            catch (ClassCastException classCastException) {
                String string = (String)this.catalogs.elementAt(i);
                object = this.newCatalog();
                ((Catalog)object).parseCatalog(string);
                this.catalogs.setElementAt(object, i);
                ((Catalog)object).parseAllCatalogs();
            }
        }
        Enumeration enumeration = this.catalogEntries.elements();
        while (enumeration.hasMoreElements()) {
            object = (CatalogEntry)enumeration.nextElement();
            if (((CatalogEntry)object).getEntryType() != DELEGATE_PUBLIC && ((CatalogEntry)object).getEntryType() != DELEGATE_SYSTEM && ((CatalogEntry)object).getEntryType() != DELEGATE_URI) continue;
            Catalog catalog = this.newCatalog();
            catalog.parseCatalog(((CatalogEntry)object).getEntryArg(1));
        }
    }

    public String resolveDoctype(String string, String string2, String string3) throws MalformedURLException, IOException {
        String string4 = null;
        this.catalogManager.debug.message(3, "resolveDoctype(" + string + "," + string2 + "," + string3 + ")");
        string3 = this.normalizeURI(string3);
        if (string2 != null && string2.startsWith("urn:publicid:")) {
            string2 = PublicId.decodeURN(string2);
        }
        if (string3 != null && string3.startsWith("urn:publicid:")) {
            string3 = PublicId.decodeURN(string3);
            if (string2 != null && !string2.equals(string3)) {
                this.catalogManager.debug.message(1, "urn:publicid: system identifier differs from public identifier; using public identifier");
                string3 = null;
            } else {
                string2 = string3;
                string3 = null;
            }
        }
        if (string3 != null && (string4 = this.resolveLocalSystem(string3)) != null) {
            return string4;
        }
        if (string2 != null && (string4 = this.resolveLocalPublic(DOCTYPE, string, string2, string3)) != null) {
            return string4;
        }
        boolean bl = this.default_override;
        Enumeration enumeration = this.catalogEntries.elements();
        while (enumeration.hasMoreElements()) {
            CatalogEntry catalogEntry = (CatalogEntry)enumeration.nextElement();
            if (catalogEntry.getEntryType() == OVERRIDE) {
                bl = catalogEntry.getEntryArg(0).equalsIgnoreCase("YES");
                continue;
            }
            if (catalogEntry.getEntryType() != DOCTYPE || !catalogEntry.getEntryArg(0).equals(string) || !bl && string3 != null) continue;
            return catalogEntry.getEntryArg(1);
        }
        return this.resolveSubordinateCatalogs(DOCTYPE, string, string2, string3);
    }

    public String resolveDocument() throws MalformedURLException, IOException {
        this.catalogManager.debug.message(3, "resolveDocument");
        Enumeration enumeration = this.catalogEntries.elements();
        while (enumeration.hasMoreElements()) {
            CatalogEntry catalogEntry = (CatalogEntry)enumeration.nextElement();
            if (catalogEntry.getEntryType() != DOCUMENT) continue;
            return catalogEntry.getEntryArg(0);
        }
        return this.resolveSubordinateCatalogs(DOCUMENT, null, null, null);
    }

    public String resolveEntity(String string, String string2, String string3) throws MalformedURLException, IOException {
        String string4 = null;
        this.catalogManager.debug.message(3, "resolveEntity(" + string + "," + string2 + "," + string3 + ")");
        string3 = this.normalizeURI(string3);
        if (string2 != null && string2.startsWith("urn:publicid:")) {
            string2 = PublicId.decodeURN(string2);
        }
        if (string3 != null && string3.startsWith("urn:publicid:")) {
            string3 = PublicId.decodeURN(string3);
            if (string2 != null && !string2.equals(string3)) {
                this.catalogManager.debug.message(1, "urn:publicid: system identifier differs from public identifier; using public identifier");
                string3 = null;
            } else {
                string2 = string3;
                string3 = null;
            }
        }
        if (string3 != null && (string4 = this.resolveLocalSystem(string3)) != null) {
            return string4;
        }
        if (string2 != null && (string4 = this.resolveLocalPublic(ENTITY, string, string2, string3)) != null) {
            return string4;
        }
        boolean bl = this.default_override;
        Enumeration enumeration = this.catalogEntries.elements();
        while (enumeration.hasMoreElements()) {
            CatalogEntry catalogEntry = (CatalogEntry)enumeration.nextElement();
            if (catalogEntry.getEntryType() == OVERRIDE) {
                bl = catalogEntry.getEntryArg(0).equalsIgnoreCase("YES");
                continue;
            }
            if (catalogEntry.getEntryType() != ENTITY || !catalogEntry.getEntryArg(0).equals(string) || !bl && string3 != null) continue;
            return catalogEntry.getEntryArg(1);
        }
        return this.resolveSubordinateCatalogs(ENTITY, string, string2, string3);
    }

    public String resolveNotation(String string, String string2, String string3) throws MalformedURLException, IOException {
        String string4 = null;
        this.catalogManager.debug.message(3, "resolveNotation(" + string + "," + string2 + "," + string3 + ")");
        string3 = this.normalizeURI(string3);
        if (string2 != null && string2.startsWith("urn:publicid:")) {
            string2 = PublicId.decodeURN(string2);
        }
        if (string3 != null && string3.startsWith("urn:publicid:")) {
            string3 = PublicId.decodeURN(string3);
            if (string2 != null && !string2.equals(string3)) {
                this.catalogManager.debug.message(1, "urn:publicid: system identifier differs from public identifier; using public identifier");
                string3 = null;
            } else {
                string2 = string3;
                string3 = null;
            }
        }
        if (string3 != null && (string4 = this.resolveLocalSystem(string3)) != null) {
            return string4;
        }
        if (string2 != null && (string4 = this.resolveLocalPublic(NOTATION, string, string2, string3)) != null) {
            return string4;
        }
        boolean bl = this.default_override;
        Enumeration enumeration = this.catalogEntries.elements();
        while (enumeration.hasMoreElements()) {
            CatalogEntry catalogEntry = (CatalogEntry)enumeration.nextElement();
            if (catalogEntry.getEntryType() == OVERRIDE) {
                bl = catalogEntry.getEntryArg(0).equalsIgnoreCase("YES");
                continue;
            }
            if (catalogEntry.getEntryType() != NOTATION || !catalogEntry.getEntryArg(0).equals(string) || !bl && string3 != null) continue;
            return catalogEntry.getEntryArg(1);
        }
        return this.resolveSubordinateCatalogs(NOTATION, string, string2, string3);
    }

    public String resolvePublic(String string, String string2) throws MalformedURLException, IOException {
        String string3;
        this.catalogManager.debug.message(3, "resolvePublic(" + string + "," + string2 + ")");
        string2 = this.normalizeURI(string2);
        if (string != null && string.startsWith("urn:publicid:")) {
            string = PublicId.decodeURN(string);
        }
        if (string2 != null && string2.startsWith("urn:publicid:")) {
            string2 = PublicId.decodeURN(string2);
            if (string != null && !string.equals(string2)) {
                this.catalogManager.debug.message(1, "urn:publicid: system identifier differs from public identifier; using public identifier");
                string2 = null;
            } else {
                string = string2;
                string2 = null;
            }
        }
        if (string2 != null && (string3 = this.resolveLocalSystem(string2)) != null) {
            return string3;
        }
        string3 = this.resolveLocalPublic(PUBLIC, null, string, string2);
        if (string3 != null) {
            return string3;
        }
        return this.resolveSubordinateCatalogs(PUBLIC, null, string, string2);
    }

    protected synchronized String resolveLocalPublic(int n, String string, String string2, String string3) throws MalformedURLException, IOException {
        Object object;
        Object object2;
        Object object3;
        String string4;
        string2 = PublicId.normalize(string2);
        if (string3 != null && (string4 = this.resolveLocalSystem(string3)) != null) {
            return string4;
        }
        boolean bl = this.default_override;
        Enumeration enumeration = this.catalogEntries.elements();
        while (enumeration.hasMoreElements()) {
            object3 = (CatalogEntry)enumeration.nextElement();
            if (((CatalogEntry)object3).getEntryType() == OVERRIDE) {
                bl = ((CatalogEntry)object3).getEntryArg(0).equalsIgnoreCase("YES");
                continue;
            }
            if (((CatalogEntry)object3).getEntryType() != PUBLIC || !((CatalogEntry)object3).getEntryArg(0).equals(string2) || !bl && string3 != null) continue;
            return ((CatalogEntry)object3).getEntryArg(1);
        }
        bl = this.default_override;
        enumeration = this.catalogEntries.elements();
        object3 = new Vector();
        while (enumeration.hasMoreElements()) {
            object2 = (CatalogEntry)enumeration.nextElement();
            if (((CatalogEntry)object2).getEntryType() == OVERRIDE) {
                bl = ((CatalogEntry)object2).getEntryArg(0).equalsIgnoreCase("YES");
                continue;
            }
            if (((CatalogEntry)object2).getEntryType() != DELEGATE_PUBLIC || !bl && string3 != null || ((String)(object = ((CatalogEntry)object2).getEntryArg(0))).length() > string2.length() || !((String)object).equals(string2.substring(0, ((String)object).length()))) continue;
            ((Vector)object3).addElement(((CatalogEntry)object2).getEntryArg(1));
        }
        if (((Vector)object3).size() > 0) {
            object2 = ((Vector)object3).elements();
            if (this.catalogManager.debug.getDebug() > 1) {
                this.catalogManager.debug.message(2, "Switching to delegated catalog(s):");
                while (object2.hasMoreElements()) {
                    object = (String)object2.nextElement();
                    this.catalogManager.debug.message(2, "\t" + (String)object);
                }
            }
            object = this.newCatalog();
            object2 = ((Vector)object3).elements();
            while (object2.hasMoreElements()) {
                String string5 = (String)object2.nextElement();
                ((Catalog)object).parseCatalog(string5);
            }
            return ((Catalog)object).resolvePublic(string2, null);
        }
        return null;
    }

    public String resolveSystem(String string) throws MalformedURLException, IOException {
        String string2;
        this.catalogManager.debug.message(3, "resolveSystem(" + string + ")");
        string = this.normalizeURI(string);
        if (string != null && string.startsWith("urn:publicid:")) {
            string = PublicId.decodeURN(string);
            return this.resolvePublic(string, null);
        }
        if (string != null && (string2 = this.resolveLocalSystem(string)) != null) {
            return string2;
        }
        return this.resolveSubordinateCatalogs(SYSTEM, null, null, string);
    }

    protected String resolveLocalSystem(String string) throws MalformedURLException, IOException {
        Object object;
        Object object2;
        Object object3;
        String string2;
        Object object4;
        Object object5;
        String string3 = System.getProperty("os.name");
        boolean bl = string3.indexOf("Windows") >= 0;
        Enumeration enumeration = this.catalogEntries.elements();
        while (enumeration.hasMoreElements()) {
            object5 = (CatalogEntry)enumeration.nextElement();
            if (((CatalogEntry)object5).getEntryType() != SYSTEM || !((CatalogEntry)object5).getEntryArg(0).equals(string) && (!bl || !((CatalogEntry)object5).getEntryArg(0).equalsIgnoreCase(string))) continue;
            return ((CatalogEntry)object5).getEntryArg(1);
        }
        enumeration = this.catalogEntries.elements();
        object5 = null;
        String string4 = null;
        while (enumeration.hasMoreElements()) {
            object4 = (CatalogEntry)enumeration.nextElement();
            if (((CatalogEntry)object4).getEntryType() != REWRITE_SYSTEM || (string2 = ((CatalogEntry)object4).getEntryArg(0)).length() > string.length() || !string2.equals(string.substring(0, string2.length())) || object5 != null && string2.length() <= ((String)object5).length()) continue;
            object5 = string2;
            string4 = ((CatalogEntry)object4).getEntryArg(1);
        }
        if (string4 != null) {
            return string4 + string.substring(((String)object5).length());
        }
        enumeration = this.catalogEntries.elements();
        object4 = null;
        string2 = null;
        while (enumeration.hasMoreElements()) {
            object3 = (CatalogEntry)enumeration.nextElement();
            if (((CatalogEntry)object3).getEntryType() != SYSTEM_SUFFIX || ((String)(object2 = ((CatalogEntry)object3).getEntryArg(0))).length() > string.length() || !string.endsWith((String)object2) || object4 != null && ((String)object2).length() <= ((String)object4).length()) continue;
            object4 = object2;
            string2 = ((CatalogEntry)object3).getEntryArg(1);
        }
        if (string2 != null) {
            return string2;
        }
        enumeration = this.catalogEntries.elements();
        object3 = new Vector();
        while (enumeration.hasMoreElements()) {
            object2 = (CatalogEntry)enumeration.nextElement();
            if (((CatalogEntry)object2).getEntryType() != DELEGATE_SYSTEM || ((String)(object = ((CatalogEntry)object2).getEntryArg(0))).length() > string.length() || !((String)object).equals(string.substring(0, ((String)object).length()))) continue;
            ((Vector)object3).addElement(((CatalogEntry)object2).getEntryArg(1));
        }
        if (((Vector)object3).size() > 0) {
            object2 = ((Vector)object3).elements();
            if (this.catalogManager.debug.getDebug() > 1) {
                this.catalogManager.debug.message(2, "Switching to delegated catalog(s):");
                while (object2.hasMoreElements()) {
                    object = (String)object2.nextElement();
                    this.catalogManager.debug.message(2, "\t" + (String)object);
                }
            }
            object = this.newCatalog();
            object2 = ((Vector)object3).elements();
            while (object2.hasMoreElements()) {
                String string5 = (String)object2.nextElement();
                ((Catalog)object).parseCatalog(string5);
            }
            return ((Catalog)object).resolveSystem(string);
        }
        return null;
    }

    public String resolveURI(String string) throws MalformedURLException, IOException {
        String string2;
        this.catalogManager.debug.message(3, "resolveURI(" + string + ")");
        string = this.normalizeURI(string);
        if (string != null && string.startsWith("urn:publicid:")) {
            string = PublicId.decodeURN(string);
            return this.resolvePublic(string, null);
        }
        if (string != null && (string2 = this.resolveLocalURI(string)) != null) {
            return string2;
        }
        return this.resolveSubordinateCatalogs(URI, null, null, string);
    }

    protected String resolveLocalURI(String string) throws MalformedURLException, IOException {
        Object object;
        Object object2;
        Object object3;
        String string2;
        Object object4;
        Object object5;
        Enumeration enumeration = this.catalogEntries.elements();
        while (enumeration.hasMoreElements()) {
            object5 = (CatalogEntry)enumeration.nextElement();
            if (((CatalogEntry)object5).getEntryType() != URI || !((CatalogEntry)object5).getEntryArg(0).equals(string)) continue;
            return ((CatalogEntry)object5).getEntryArg(1);
        }
        enumeration = this.catalogEntries.elements();
        object5 = null;
        String string3 = null;
        while (enumeration.hasMoreElements()) {
            object4 = (CatalogEntry)enumeration.nextElement();
            if (((CatalogEntry)object4).getEntryType() != REWRITE_URI || (string2 = ((CatalogEntry)object4).getEntryArg(0)).length() > string.length() || !string2.equals(string.substring(0, string2.length())) || object5 != null && string2.length() <= ((String)object5).length()) continue;
            object5 = string2;
            string3 = ((CatalogEntry)object4).getEntryArg(1);
        }
        if (string3 != null) {
            return string3 + string.substring(((String)object5).length());
        }
        enumeration = this.catalogEntries.elements();
        object4 = null;
        string2 = null;
        while (enumeration.hasMoreElements()) {
            object3 = (CatalogEntry)enumeration.nextElement();
            if (((CatalogEntry)object3).getEntryType() != URI_SUFFIX || ((String)(object2 = ((CatalogEntry)object3).getEntryArg(0))).length() > string.length() || !string.endsWith((String)object2) || object4 != null && ((String)object2).length() <= ((String)object4).length()) continue;
            object4 = object2;
            string2 = ((CatalogEntry)object3).getEntryArg(1);
        }
        if (string2 != null) {
            return string2;
        }
        enumeration = this.catalogEntries.elements();
        object3 = new Vector();
        while (enumeration.hasMoreElements()) {
            object2 = (CatalogEntry)enumeration.nextElement();
            if (((CatalogEntry)object2).getEntryType() != DELEGATE_URI || ((String)(object = ((CatalogEntry)object2).getEntryArg(0))).length() > string.length() || !((String)object).equals(string.substring(0, ((String)object).length()))) continue;
            ((Vector)object3).addElement(((CatalogEntry)object2).getEntryArg(1));
        }
        if (((Vector)object3).size() > 0) {
            object2 = ((Vector)object3).elements();
            if (this.catalogManager.debug.getDebug() > 1) {
                this.catalogManager.debug.message(2, "Switching to delegated catalog(s):");
                while (object2.hasMoreElements()) {
                    object = (String)object2.nextElement();
                    this.catalogManager.debug.message(2, "\t" + (String)object);
                }
            }
            object = this.newCatalog();
            object2 = ((Vector)object3).elements();
            while (object2.hasMoreElements()) {
                String string4 = (String)object2.nextElement();
                ((Catalog)object).parseCatalog(string4);
            }
            return ((Catalog)object).resolveURI(string);
        }
        return null;
    }

    protected synchronized String resolveSubordinateCatalogs(int n, String string, String string2, String string3) throws MalformedURLException, IOException {
        for (int i = 0; i < this.catalogs.size(); ++i) {
            Catalog catalog = null;
            try {
                catalog = (Catalog)this.catalogs.elementAt(i);
            }
            catch (ClassCastException classCastException) {
                String string4 = (String)this.catalogs.elementAt(i);
                catalog = this.newCatalog();
                try {
                    catalog.parseCatalog(string4);
                }
                catch (MalformedURLException malformedURLException) {
                    this.catalogManager.debug.message(1, "Malformed Catalog URL", string4);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.catalogManager.debug.message(1, "Failed to load catalog, file not found", string4);
                }
                catch (IOException iOException) {
                    this.catalogManager.debug.message(1, "Failed to load catalog, I/O error", string4);
                }
                this.catalogs.setElementAt(catalog, i);
            }
            String string5 = null;
            if (n == DOCTYPE) {
                string5 = catalog.resolveDoctype(string, string2, string3);
            } else if (n == DOCUMENT) {
                string5 = catalog.resolveDocument();
            } else if (n == ENTITY) {
                string5 = catalog.resolveEntity(string, string2, string3);
            } else if (n == NOTATION) {
                string5 = catalog.resolveNotation(string, string2, string3);
            } else if (n == PUBLIC) {
                string5 = catalog.resolvePublic(string2, string3);
            } else if (n == SYSTEM) {
                string5 = catalog.resolveSystem(string3);
            } else if (n == URI) {
                string5 = catalog.resolveURI(string3);
            }
            if (string5 == null) continue;
            return string5;
        }
        return null;
    }

    protected String fixSlashes(String string) {
        return string.replace('\\', '/');
    }

    protected String makeAbsolute(String string) {
        URL uRL = null;
        string = this.fixSlashes(string);
        try {
            uRL = new URL(this.base, string);
        }
        catch (MalformedURLException malformedURLException) {
            this.catalogManager.debug.message(1, "Malformed URL on system identifier", string);
        }
        if (uRL != null) {
            return uRL.toString();
        }
        return string;
    }

    protected String normalizeURI(String string) {
        byte[] byArray;
        String string2 = "";
        if (string == null) {
            return null;
        }
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.catalogManager.debug.message(1, "UTF-8 is an unsupported encoding!?");
            return string;
        }
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            string2 = n <= 32 || n > 127 || n == 34 || n == 60 || n == 62 || n == 92 || n == 94 || n == 96 || n == 123 || n == 124 || n == 125 || n == 127 ? string2 + this.encodedByte(n) : string2 + (char)byArray[i];
        }
        return string2;
    }

    protected String encodedByte(int n) {
        String string = Integer.toHexString(n).toUpperCase();
        if (string.length() < 2) {
            return "%0" + string;
        }
        return "%" + string;
    }

    protected void addDelegate(CatalogEntry catalogEntry) {
        int n = 0;
        String string = catalogEntry.getEntryArg(0);
        Enumeration enumeration = this.localDelegate.elements();
        while (enumeration.hasMoreElements()) {
            CatalogEntry catalogEntry2 = (CatalogEntry)enumeration.nextElement();
            String string2 = catalogEntry2.getEntryArg(0);
            if (string2.equals(string)) {
                return;
            }
            if (string2.length() > string.length()) {
                ++n;
            }
            if (string2.length() >= string.length()) continue;
            break;
        }
        if (this.localDelegate.size() == 0) {
            this.localDelegate.addElement(catalogEntry);
        } else {
            this.localDelegate.insertElementAt(catalogEntry, n);
        }
    }
}

