/*
 * Decompiled with CFR 0.152.
 */
package com.sun.servicetag;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Properties;
import sun.misc.Version;

public class Installer {
    private static String STCLIENT_SOLARIS = "/usr/bin/stclient";
    private static String STCLIENT_LINUX = "/opt/sun/servicetag/bin/stclient";
    private static String javaHome = System.getProperty("java.home");
    private static String serviceTagPathname;
    private static String stclient;
    private static boolean initialized;
    private static boolean verbose;
    private static String INSTANCE_URN_DESC;

    private static boolean isServiceTagSupported() {
        File file;
        if (!initialized && (file = System.getProperty("os.name").equals("SunOS") ? new File(STCLIENT_SOLARIS) : new File(STCLIENT_LINUX)).exists() && file.canExecute()) {
            stclient = file.getAbsolutePath();
        }
        return stclient != null;
    }

    public static void main(String[] stringArray) {
        block16: {
            String string;
            if (System.getProperty("servicetag.stclient.echo") != null) {
                stclient = "echo";
                initialized = true;
            }
            if (!Installer.isServiceTagSupported()) {
                return;
            }
            int n = Version.jdkMinorVersion();
            String string2 = "Manual";
            boolean bl = false;
            boolean bl2 = false;
            for (int i = 0; i < stringArray.length; ++i) {
                string = stringArray[i];
                if (!string.startsWith("-")) {
                    Installer.usage();
                    return;
                }
                if (string.equals("-source")) {
                    string2 = stringArray[++i];
                    continue;
                }
                if (string.equals("-delete")) {
                    bl = true;
                    continue;
                }
                if (string.equals("-update")) {
                    bl2 = true;
                    continue;
                }
                if (string.equals("-verbose")) {
                    verbose = true;
                    continue;
                }
                if (!string.equals("-help")) continue;
                Installer.usage();
                return;
            }
            string = "creating";
            try {
                String string3;
                if (bl2) {
                    string = "updating";
                    Installer.updateServiceTag(string2, n);
                } else if (bl) {
                    string = "deleting";
                    Installer.deleteServiceTag(true);
                } else {
                    string3 = Installer.getInstanceURN();
                    if (string3.isEmpty()) {
                        Installer.createServiceTag(string2, n);
                    }
                }
                if (verbose && !(string3 = Installer.getInstanceURN()).isEmpty()) {
                    Installer.printServiceTag(string3);
                }
            }
            catch (IOException iOException) {
                System.err.println("Error in " + string + " a service tag: " + iOException.getMessage());
                if (!verbose) break block16;
                iOException.printStackTrace();
            }
        }
    }

    private static void usage() {
        System.out.println("Usage:");
        System.out.print("    java com.sun.servicetag.Installer");
        System.out.println(" [-delete|-update|-source <source>]");
        System.out.println("       to create a service tag for the Java platform");
        System.out.println("");
        System.out.println("Options:");
        System.out.println("    -source: to specify the source of the service tag to be created");
        System.out.println("    -delete: to delete the service tag ");
        System.out.println("    -update: to update the servie tag");
        System.out.println("    -help:   to print this help message");
    }

    private static File getServiceTagFile() throws IOException {
        if (serviceTagPathname != null) {
            return new File(serviceTagPathname);
        }
        String string = System.getProperty("servicetag.file");
        if (string != null) {
            serviceTagPathname = string;
        } else {
            String string2 = javaHome + File.separator + "jre" + File.separator + "lib";
            File file = new File(string2);
            if (!file.isDirectory() && !(file = new File(string2 = javaHome + File.separator + "lib")).isDirectory()) {
                return null;
            }
            file = new File(string2 + File.separator + "servicetag");
            serviceTagPathname = file.getCanonicalPath();
        }
        return new File(serviceTagPathname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getInstanceURN() throws IOException {
        File file = Installer.getServiceTagFile();
        if (file != null && file.exists()) {
            BufferedReader bufferedReader = null;
            try {
                String string;
                bufferedReader = new BufferedReader(new FileReader(file));
                String string2 = string = bufferedReader.readLine().trim();
                return string2;
            }
            finally {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean createServiceTag(String string, int n) throws IOException {
        String string2;
        String string3;
        Properties properties = Installer.loadSwordfishEntries(n);
        String string4 = javaHome + File.separator + "jre";
        File file = new File(string4, "lib");
        if (!file.exists()) {
            string4 = javaHome;
        }
        if (string4.endsWith(File.separator + "jre")) {
            string3 = properties.getProperty("servicetag.jdk.urn");
            string2 = properties.getProperty("servicetag.jdk.name");
        } else {
            string3 = properties.getProperty("servicetag.jre.urn");
            string2 = properties.getProperty("servicetag.jre.name");
        }
        String string5 = Installer.getProductDefinedId(string4);
        if (string5.length() > 256) {
            System.err.println("Product defined instance ID exceeds the field limit:");
            System.err.println(string5);
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(stclient);
        arrayList.add("-a");
        arrayList.add("-p");
        arrayList.add(string2);
        arrayList.add("-e");
        arrayList.add(System.getProperty("java.version"));
        arrayList.add("-t");
        arrayList.add(string3);
        arrayList.add("-F");
        arrayList.add(properties.getProperty("servicetag.parent.urn"));
        arrayList.add("-P");
        arrayList.add(properties.getProperty("servicetag.parent.name"));
        arrayList.add("-I");
        arrayList.add(string5);
        arrayList.add("-m");
        arrayList.add("Sun Microsystems");
        arrayList.add("-A");
        arrayList.add(System.getProperty("os.arch"));
        arrayList.add("-z");
        arrayList.add(Installer.getZoneName());
        arrayList.add("-S");
        arrayList.add(string);
        BufferedReader bufferedReader = null;
        BufferedWriter bufferedWriter = null;
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
            Process process = processBuilder.start();
            String string6 = Installer.commandOutput(process);
            if (verbose) {
                System.out.println(string6);
            }
            if (process.exitValue() == 0) {
                bufferedReader = new BufferedReader(new StringReader(string6));
                String string7 = null;
                String string8 = System.getProperty("servicetag.instance.urn", "");
                while ((string7 = bufferedReader.readLine()) != null) {
                    if (!string7.startsWith(INSTANCE_URN_DESC)) continue;
                    string8 = string7.substring(INSTANCE_URN_DESC.length());
                    break;
                }
                if ((file = Installer.getServiceTagFile()) != null) {
                    try {
                        bufferedWriter = new BufferedWriter(new FileWriter(file));
                        bufferedWriter.write(string8);
                        bufferedWriter.newLine();
                    }
                    catch (IOException iOException) {
                        System.err.println("Service tag created but failed to write instance URN=" + string8 + " to file \"" + serviceTagPathname + "\".");
                        throw iOException;
                    }
                } else {
                    System.err.println("Service tag created but instance URN=" + string8 + " cannot be saved at file \"" + serviceTagPathname + "\".");
                }
            }
            boolean bl = process.exitValue() == 0;
            return bl;
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (bufferedWriter != null) {
                bufferedWriter.close();
            }
        }
    }

    private static boolean deleteServiceTag(boolean bl) throws IOException {
        boolean bl2 = true;
        String string = Installer.getInstanceURN();
        if (!string.isEmpty() && (bl2 = Installer.deleteServiceTag(string, "Failed to delete service tag")) && bl && !(bl2 = Installer.getServiceTagFile().delete())) {
            System.err.println("Service tag deleted: instance urn=" + string);
            System.err.println("   but failed to remove " + serviceTagPathname);
        }
        return bl2;
    }

    private static boolean deleteServiceTag(String string, String string2) throws IOException {
        if (string.isEmpty()) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(stclient);
        arrayList.add("-d");
        arrayList.add("-i");
        arrayList.add(string);
        ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
        Process process = processBuilder.start();
        String string3 = Installer.commandOutput(process);
        if (verbose) {
            System.out.println(string3);
        }
        if (process.exitValue() != 0) {
            System.err.println(string2 + " instance urn=" + string + " is not deleted: " + string3.trim());
        }
        return process.exitValue() == 0;
    }

    private static boolean updateServiceTag(String string, int n) throws IOException {
        String string2 = Installer.getInstanceURN();
        boolean bl = false;
        if (!string2.isEmpty()) {
            bl = Installer.deleteServiceTag(string2, "Old service tag");
        }
        if (!Installer.createServiceTag(string, n)) {
            if (bl) {
                Installer.getServiceTagFile().delete();
            }
            return false;
        }
        return true;
    }

    private static void printServiceTag(String string) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(stclient);
        arrayList.add("-g");
        arrayList.add("-i");
        arrayList.add(string);
        ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
        Process process = processBuilder.start();
        String string2 = Installer.commandOutput(process);
        if (verbose) {
            System.out.println(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadSwordfishEntries(int n) throws IOException {
        String string = "/com/sun/servicetag/resources/javase_" + n + "_swordfish.properties";
        InputStream inputStream = Installer.class.getClass().getResourceAsStream(string);
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        finally {
            inputStream.close();
        }
        return properties;
    }

    private static String getProductDefinedId(String string) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("id=");
        stringBuilder.append(System.getProperty("java.runtime.version"));
        File file = new File(string + File.separator + "lib");
        if (file.isDirectory()) {
            String[] stringArray;
            for (String string2 : stringArray = file.list()) {
                File file2 = new File(file, string2 + File.separator + "libjava.so");
                if (!file2.exists()) continue;
                stringBuilder.append(" " + string2);
            }
        }
        stringBuilder.append(",dir=");
        stringBuilder.append(javaHome);
        return stringBuilder.toString();
    }

    private static String getZoneName() throws IOException {
        String string = "global";
        String string2 = "/usr/bin/zonename";
        File file = new File(string2);
        if (file.exists() && file.canExecute()) {
            ProcessBuilder processBuilder = new ProcessBuilder(string2);
            Process process = processBuilder.start();
            String string3 = Installer.commandOutput(process);
            if (process.exitValue() == 0) {
                string = string3.trim();
            }
        }
        return string;
    }

    private static String commandOutput(Process process) throws IOException {
        String string;
        String string2;
        block2: {
            InputStreamReader inputStreamReader = new InputStreamReader(process.getInputStream(), "UTF-8");
            InputStreamReader inputStreamReader2 = new InputStreamReader(process.getErrorStream(), "UTF-8");
            string2 = Installer.commandOutput(inputStreamReader);
            string = Installer.commandOutput(inputStreamReader2);
            try {
                process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                if (!verbose) break block2;
                interruptedException.printStackTrace();
            }
        }
        return string2 + string.trim();
    }

    private static String commandOutput(Reader reader) throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        while ((n = reader.read()) > 0) {
            if (n == 13) continue;
            stringBuilder.append((char)n);
        }
        return stringBuilder.toString();
    }

    static {
        stclient = null;
        initialized = false;
        verbose = false;
        INSTANCE_URN_DESC = "Product instance URN=";
    }
}

