/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.URI;
import java.util.List;
import sun.security.util.SecurityConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProxySelector {
    private static ProxySelector theProxySelector;

    public static ProxySelector getDefault() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SecurityConstants.GET_PROXYSELECTOR_PERMISSION);
        }
        return theProxySelector;
    }

    public static void setDefault(ProxySelector proxySelector) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SecurityConstants.SET_PROXYSELECTOR_PERMISSION);
        }
        theProxySelector = proxySelector;
    }

    public abstract List<Proxy> select(URI var1);

    public abstract void connectFailed(URI var1, SocketAddress var2, IOException var3);

    static {
        try {
            Class<?> clazz = Class.forName("sun.net.spi.DefaultProxySelector");
            if (clazz != null && ProxySelector.class.isAssignableFrom(clazz)) {
                theProxySelector = (ProxySelector)clazz.newInstance();
            }
        }
        catch (Exception exception) {
            theProxySelector = null;
        }
    }
}

