/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;

final class UNIXProcess
extends Process {
    private FileDescriptor stdin_fd = new FileDescriptor();
    private FileDescriptor stdout_fd = new FileDescriptor();
    private FileDescriptor stderr_fd = new FileDescriptor();
    private int pid;
    private int exitcode;
    private boolean hasExited;
    private OutputStream stdin_stream;
    private BufferedInputStream stdout_stream;
    private DeferredCloseInputStream stdout_inner_stream;
    private DeferredCloseInputStream stderr_stream;

    private native int waitForProcessExit(int var1);

    private native int forkAndExec(byte[] var1, byte[] var2, int var3, byte[] var4, int var5, byte[] var6, boolean var7, FileDescriptor var8, FileDescriptor var9, FileDescriptor var10) throws IOException;

    UNIXProcess(byte[] byArray, byte[] byArray2, int n, byte[] byArray3, int n2, byte[] byArray4, boolean bl) throws IOException {
        this.pid = this.forkAndExec(byArray, byArray2, n, byArray3, n2, byArray4, bl, this.stdin_fd, this.stdout_fd, this.stderr_fd);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                UNIXProcess.this.stdin_stream = new BufferedOutputStream(new FileOutputStream(UNIXProcess.this.stdin_fd));
                UNIXProcess.this.stdout_inner_stream = new DeferredCloseInputStream(UNIXProcess.this.stdout_fd);
                UNIXProcess.this.stdout_stream = new BufferedInputStream(UNIXProcess.this.stdout_inner_stream);
                UNIXProcess.this.stderr_stream = new DeferredCloseInputStream(UNIXProcess.this.stderr_fd);
                return null;
            }
        });
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread thread = new Thread("process reaper"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        int n = UNIXProcess.this.waitForProcessExit(UNIXProcess.this.pid);
                        UNIXProcess uNIXProcess = UNIXProcess.this;
                        synchronized (uNIXProcess) {
                            UNIXProcess.this.hasExited = true;
                            UNIXProcess.this.exitcode = n;
                            UNIXProcess.this.notifyAll();
                        }
                    }
                };
                thread.setDaemon(true);
                thread.start();
                return null;
            }
        });
    }

    public OutputStream getOutputStream() {
        return this.stdin_stream;
    }

    public InputStream getInputStream() {
        return this.stdout_stream;
    }

    public InputStream getErrorStream() {
        return this.stderr_stream;
    }

    public synchronized int waitFor() throws InterruptedException {
        while (!this.hasExited) {
            this.wait();
        }
        return this.exitcode;
    }

    public synchronized int exitValue() {
        if (!this.hasExited) {
            throw new IllegalThreadStateException("process hasn't exited");
        }
        return this.exitcode;
    }

    private static native void destroyProcess(int var0);

    public synchronized void destroy() {
        if (!this.hasExited) {
            UNIXProcess.destroyProcess(this.pid);
        }
        try {
            this.stdin_stream.close();
            this.stdout_inner_stream.closeDeferred(this.stdout_stream);
            this.stderr_stream.closeDeferred(this.stderr_stream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static native void initIDs();

    static {
        UNIXProcess.initIDs();
    }

    private static class DeferredCloseInputStream
    extends FileInputStream {
        private Object lock = new Object();
        private boolean closePending = false;
        private int useCount = 0;
        private InputStream streamToClose;

        private DeferredCloseInputStream(FileDescriptor fileDescriptor) {
            super(fileDescriptor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void raise() {
            Object object = this.lock;
            synchronized (object) {
                ++this.useCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void lower() throws IOException {
            Object object = this.lock;
            synchronized (object) {
                --this.useCount;
                if (this.useCount == 0 && this.closePending) {
                    this.streamToClose.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closeDeferred(InputStream inputStream) throws IOException {
            Object object = this.lock;
            synchronized (object) {
                if (this.useCount == 0) {
                    inputStream.close();
                } else {
                    this.closePending = true;
                    this.streamToClose = inputStream;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            Object object = this.lock;
            synchronized (object) {
                this.useCount = 0;
                this.closePending = false;
            }
            super.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read() throws IOException {
            this.raise();
            try {
                int n = super.read();
                return n;
            }
            finally {
                this.lower();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] byArray) throws IOException {
            this.raise();
            try {
                int n = super.read(byArray);
                return n;
            }
            finally {
                this.lower();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] byArray, int n, int n2) throws IOException {
            this.raise();
            try {
                int n3 = super.read(byArray, n, n2);
                return n3;
            }
            finally {
                this.lower();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long skip(long l) throws IOException {
            this.raise();
            try {
                long l2 = super.skip(l);
                return l2;
            }
            finally {
                this.lower();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int available() throws IOException {
            this.raise();
            try {
                int n = super.available();
                return n;
            }
            finally {
                this.lower();
            }
        }
    }
}

