/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.fastinfoset.algorithm;

import com.sun.xml.internal.fastinfoset.CommonResourceBundle;
import com.sun.xml.internal.fastinfoset.algorithm.BuiltInEncodingAlgorithm;
import com.sun.xml.internal.fastinfoset.algorithm.IntegerEncodingAlgorithm;
import com.sun.xml.internal.org.jvnet.fastinfoset.EncodingAlgorithmException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;

public class ShortEncodingAlgorithm
extends IntegerEncodingAlgorithm {
    public final int getPrimtiveLengthFromOctetLength(int n) throws EncodingAlgorithmException {
        if (n % 2 != 0) {
            throw new EncodingAlgorithmException(CommonResourceBundle.getInstance().getString("message.lengthNotMultipleOfShort", new Object[]{new Integer(2)}));
        }
        return n / 2;
    }

    public int getOctetLengthFromPrimitiveLength(int n) {
        return n * 2;
    }

    public final Object decodeFromBytes(byte[] byArray, int n, int n2) throws EncodingAlgorithmException {
        short[] sArray = new short[this.getPrimtiveLengthFromOctetLength(n2)];
        this.decodeFromBytesToShortArray(sArray, 0, byArray, n, n2);
        return sArray;
    }

    public final Object decodeFromInputStream(InputStream inputStream) throws IOException {
        return this.decodeFromInputStreamToShortArray(inputStream);
    }

    public void encodeToOutputStream(Object object, OutputStream outputStream) throws IOException {
        if (!(object instanceof short[])) {
            throw new IllegalArgumentException(CommonResourceBundle.getInstance().getString("message.dataNotShortArray"));
        }
        short[] sArray = (short[])object;
        this.encodeToOutputStreamFromShortArray(sArray, outputStream);
    }

    public final Object convertFromCharacters(char[] cArray, int n, int n2) {
        final CharBuffer charBuffer = CharBuffer.wrap(cArray, n, n2);
        final ArrayList arrayList = new ArrayList();
        this.matchWhiteSpaceDelimnatedWords(charBuffer, new BuiltInEncodingAlgorithm.WordListener(){

            public void word(int n, int n2) {
                String string = ((Object)charBuffer.subSequence(n, n2)).toString();
                arrayList.add(Short.valueOf(string));
            }
        });
        return this.generateArrayFromList(arrayList);
    }

    public final void convertToCharacters(Object object, StringBuffer stringBuffer) {
        if (!(object instanceof short[])) {
            throw new IllegalArgumentException(CommonResourceBundle.getInstance().getString("message.dataNotShortArray"));
        }
        short[] sArray = (short[])object;
        this.convertToCharactersFromShortArray(sArray, stringBuffer);
    }

    public final void decodeFromBytesToShortArray(short[] sArray, int n, byte[] byArray, int n2, int n3) {
        int n4 = n3 / 2;
        for (int i = 0; i < n4; ++i) {
            sArray[n++] = (short)((byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF);
        }
    }

    public final short[] decodeFromInputStreamToShortArray(InputStream inputStream) throws IOException {
        ArrayList<Short> arrayList = new ArrayList<Short>();
        byte[] byArray = new byte[2];
        while (true) {
            int n;
            int n2;
            if ((n2 = inputStream.read(byArray)) != 2) {
                if (n2 == -1) break;
                while (n2 != 2) {
                    n = inputStream.read(byArray, n2, 2 - n2);
                    if (n == -1) {
                        throw new EOFException();
                    }
                    n2 += n;
                }
            }
            n = (byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF;
            arrayList.add(new Short((short)n));
        }
        return this.generateArrayFromList(arrayList);
    }

    public final void encodeToOutputStreamFromShortArray(short[] sArray, OutputStream outputStream) throws IOException {
        for (int i = 0; i < sArray.length; ++i) {
            short s = sArray[i];
            outputStream.write(s >>> 8 & 0xFF);
            outputStream.write(s & 0xFF);
        }
    }

    public final void encodeToBytes(Object object, int n, int n2, byte[] byArray, int n3) {
        this.encodeToBytesFromShortArray((short[])object, n, n2, byArray, n3);
    }

    public final void encodeToBytesFromShortArray(short[] sArray, int n, int n2, byte[] byArray, int n3) {
        int n4 = n + n2;
        for (int i = n; i < n4; ++i) {
            short s = sArray[i];
            byArray[n3++] = (byte)(s >>> 8 & 0xFF);
            byArray[n3++] = (byte)(s & 0xFF);
        }
    }

    public final void convertToCharactersFromShortArray(short[] sArray, StringBuffer stringBuffer) {
        int n = sArray.length - 1;
        for (int i = 0; i <= n; ++i) {
            stringBuffer.append(Short.toString(sArray[i]));
            if (i == n) continue;
            stringBuffer.append(' ');
        }
    }

    public final short[] generateArrayFromList(List list) {
        short[] sArray = new short[list.size()];
        for (int i = 0; i < sArray.length; ++i) {
            sArray[i] = (Short)list.get(i);
        }
        return sArray;
    }
}

