/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net.cookie;

import com.sun.deploy.net.cookie.CookieHandler;
import com.sun.deploy.net.cookie.CookieUnavailableException;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.services.Service;
import com.sun.deploy.services.ServiceManager;
import com.sun.deploy.util.Trace;
import java.net.URL;
import java.util.HashMap;

public class DeployCookieManager {
    private static HashMap cookieTable = new HashMap();
    private static CookieHandler cookieHandler = null;

    public static synchronized void setCookieInfo(URL uRL, String string) {
        DeployCookieManager.initialize();
        Trace.msgNetPrintln("net.cookie.server", new Object[]{uRL, string});
        try {
            if (cookieHandler != null) {
                cookieHandler.setCookieInfo(uRL, string);
            }
        }
        catch (CookieUnavailableException cookieUnavailableException) {
            System.out.println(ResourceManager.getMessage("net.cookie.ignore.setcookie"));
        }
    }

    public static synchronized String getCookieInfo(URL uRL) {
        DeployCookieManager.initialize();
        String string = null;
        try {
            String string2 = uRL.getProtocol() + uRL.getHost() + uRL.getFile();
            int n = string2.lastIndexOf(47);
            if (n < 0) {
                return null;
            }
            string2 = string2.substring(0, n);
            try {
                if (cookieHandler != null) {
                    string = cookieHandler.getCookieInfo(uRL);
                }
                if (!(string == null || string.equals("") || string.equals("\n") || string.equals("\r\n"))) {
                    cookieTable.put(string2, string);
                } else {
                    cookieTable.put(string2, "");
                    string = null;
                }
            }
            catch (CookieUnavailableException cookieUnavailableException) {
                System.out.println(ResourceManager.getMessage("net.cookie.noservice"));
                string = (String)cookieTable.get(string2);
            }
            if (string != null) {
                Trace.msgNetPrintln("net.cookie.connect", new Object[]{uRL, string});
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return string;
    }

    private static void initialize() {
        if (cookieHandler == null) {
            Service service = ServiceManager.getService();
            cookieHandler = service.getCookieHandler();
        }
    }
}

