/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pipe;

import sun.java2d.pipe.Region;
import sun.java2d.pipe.RegionIterator;
import sun.java2d.pipe.SpanIterator;

public class RegionSpanIterator
implements SpanIterator {
    RegionIterator ri;
    int lox;
    int loy;
    int hix;
    int hiy;
    int curloy;
    int curhiy;
    boolean done = false;
    boolean isrect;

    public RegionSpanIterator(Region region) {
        int[] nArray = new int[4];
        region.getBounds(nArray);
        this.lox = nArray[0];
        this.loy = nArray[1];
        this.hix = nArray[2];
        this.hiy = nArray[3];
        this.isrect = region.isRectangular();
        this.ri = region.getIterator();
    }

    public void getPathBox(int[] nArray) {
        nArray[0] = this.lox;
        nArray[1] = this.loy;
        nArray[2] = this.hix;
        nArray[3] = this.hiy;
    }

    public void intersectClipBox(int n, int n2, int n3, int n4) {
        if (n > this.lox) {
            this.lox = n;
        }
        if (n2 > this.loy) {
            this.loy = n2;
        }
        if (n3 < this.hix) {
            this.hix = n3;
        }
        if (n4 < this.hiy) {
            this.hiy = n4;
        }
        this.done = this.lox >= this.hix || this.loy >= this.hiy;
    }

    public boolean nextSpan(int[] nArray) {
        int n;
        int n2;
        if (this.done) {
            return false;
        }
        if (this.isrect) {
            this.getPathBox(nArray);
            this.done = true;
            return true;
        }
        int n3 = this.curloy;
        int n4 = this.curhiy;
        while (true) {
            if (!this.ri.nextXBand(nArray)) {
                if (!this.ri.nextYRange(nArray)) {
                    this.done = true;
                    return false;
                }
                n3 = nArray[1];
                n4 = nArray[3];
                if (n3 < this.loy) {
                    n3 = this.loy;
                }
                if (n4 > this.hiy) {
                    n4 = this.hiy;
                }
                if (n3 < this.hiy) continue;
                this.done = true;
                return false;
            }
            n2 = nArray[0];
            n = nArray[2];
            if (n2 < this.lox) {
                n2 = this.lox;
            }
            if (n > this.hix) {
                n = this.hix;
            }
            if (n2 < n && n3 < n4) break;
        }
        nArray[0] = n2;
        nArray[1] = this.curloy = n3;
        nArray[2] = n;
        nArray[3] = this.curhiy = n4;
        return true;
    }

    public void skipDownTo(int n) {
        this.loy = n;
    }

    public long getNativeIterator() {
        return 0L;
    }
}

