/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.MutableBigInteger;
import java.math.RoundingMode;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigDecimal
extends Number
implements Comparable<BigDecimal> {
    private volatile BigInteger intVal;
    private int scale;
    private transient int precision;
    private transient String stringCache;
    static final long INFLATED = Long.MIN_VALUE;
    private transient long intCompact;
    private static final int MAX_COMPACT_DIGITS = 18;
    private static final int MAX_BIGINT_BITS = 62;
    private static final long serialVersionUID = 6108874887143696463L;
    private static final ThreadLocal<StringBuilderHelper> threadLocalStringBuilderHelper = new ThreadLocal<StringBuilderHelper>(){

        @Override
        protected StringBuilderHelper initialValue() {
            return new StringBuilderHelper();
        }
    };
    private static final BigDecimal[] zeroThroughTen = new BigDecimal[]{new BigDecimal(BigInteger.ZERO, 0L, 0, 1), new BigDecimal(BigInteger.ONE, 1L, 0, 1), new BigDecimal(BigInteger.valueOf(2L), 2L, 0, 1), new BigDecimal(BigInteger.valueOf(3L), 3L, 0, 1), new BigDecimal(BigInteger.valueOf(4L), 4L, 0, 1), new BigDecimal(BigInteger.valueOf(5L), 5L, 0, 1), new BigDecimal(BigInteger.valueOf(6L), 6L, 0, 1), new BigDecimal(BigInteger.valueOf(7L), 7L, 0, 1), new BigDecimal(BigInteger.valueOf(8L), 8L, 0, 1), new BigDecimal(BigInteger.valueOf(9L), 9L, 0, 1), new BigDecimal(BigInteger.TEN, 10L, 0, 2)};
    private static final BigDecimal[] ZERO_SCALED_BY = new BigDecimal[]{zeroThroughTen[0], new BigDecimal(BigInteger.ZERO, 0L, 1, 1), new BigDecimal(BigInteger.ZERO, 0L, 2, 1), new BigDecimal(BigInteger.ZERO, 0L, 3, 1), new BigDecimal(BigInteger.ZERO, 0L, 4, 1), new BigDecimal(BigInteger.ZERO, 0L, 5, 1), new BigDecimal(BigInteger.ZERO, 0L, 6, 1), new BigDecimal(BigInteger.ZERO, 0L, 7, 1), new BigDecimal(BigInteger.ZERO, 0L, 8, 1), new BigDecimal(BigInteger.ZERO, 0L, 9, 1), new BigDecimal(BigInteger.ZERO, 0L, 10, 1), new BigDecimal(BigInteger.ZERO, 0L, 11, 1), new BigDecimal(BigInteger.ZERO, 0L, 12, 1), new BigDecimal(BigInteger.ZERO, 0L, 13, 1), new BigDecimal(BigInteger.ZERO, 0L, 14, 1), new BigDecimal(BigInteger.ZERO, 0L, 15, 1)};
    private static final long HALF_LONG_MAX_VALUE = 0x3FFFFFFFFFFFFFFFL;
    private static final long HALF_LONG_MIN_VALUE = -4611686018427387904L;
    public static final BigDecimal ZERO = zeroThroughTen[0];
    public static final BigDecimal ONE = zeroThroughTen[1];
    public static final BigDecimal TEN = zeroThroughTen[10];
    public static final int ROUND_UP = 0;
    public static final int ROUND_DOWN = 1;
    public static final int ROUND_CEILING = 2;
    public static final int ROUND_FLOOR = 3;
    public static final int ROUND_HALF_UP = 4;
    public static final int ROUND_HALF_DOWN = 5;
    public static final int ROUND_HALF_EVEN = 6;
    public static final int ROUND_UNNECESSARY = 7;
    private static final long[] LONG_TEN_POWERS_TABLE = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};
    private static volatile BigInteger[] BIG_TEN_POWERS_TABLE = new BigInteger[]{BigInteger.ONE, BigInteger.valueOf(10L), BigInteger.valueOf(100L), BigInteger.valueOf(1000L), BigInteger.valueOf(10000L), BigInteger.valueOf(100000L), BigInteger.valueOf(1000000L), BigInteger.valueOf(10000000L), BigInteger.valueOf(100000000L), BigInteger.valueOf(1000000000L), BigInteger.valueOf(10000000000L), BigInteger.valueOf(100000000000L), BigInteger.valueOf(1000000000000L), BigInteger.valueOf(10000000000000L), BigInteger.valueOf(100000000000000L), BigInteger.valueOf(1000000000000000L), BigInteger.valueOf(10000000000000000L), BigInteger.valueOf(100000000000000000L), BigInteger.valueOf(1000000000000000000L)};
    private static final int BIG_TEN_POWERS_TABLE_INITLEN = BIG_TEN_POWERS_TABLE.length;
    private static final int BIG_TEN_POWERS_TABLE_MAX = 16 * BIG_TEN_POWERS_TABLE_INITLEN;
    private static final long[] THRESHOLDS_TABLE = new long[]{Long.MAX_VALUE, 0xCCCCCCCCCCCCCCCL, 92233720368547758L, 9223372036854775L, 922337203685477L, 92233720368547L, 9223372036854L, 922337203685L, 92233720368L, 9223372036L, 922337203L, 92233720L, 0x8CBCCCL, 922337L, 92233L, 9223L, 922L, 92L, 9L};

    BigDecimal(BigInteger bigInteger, long l, int n, int n2) {
        this.scale = n;
        this.precision = n2;
        this.intCompact = l;
        this.intVal = bigInteger;
    }

    public BigDecimal(char[] cArray, int n, int n2) {
        if (n + n2 > cArray.length || n < 0) {
            throw new NumberFormatException();
        }
        int n3 = 0;
        int n4 = 0;
        long l = 0L;
        BigInteger bigInteger = null;
        try {
            boolean bl = false;
            if (cArray[n] == '-') {
                bl = true;
                ++n;
                --n2;
            } else if (cArray[n] == '+') {
                ++n;
                --n2;
            }
            boolean bl2 = false;
            int n5 = n;
            long l2 = 0L;
            boolean bl3 = n2 <= 18;
            char[] cArray2 = bl3 ? null : new char[n2];
            int n6 = 0;
            while (n2 > 0) {
                int n7;
                char c = cArray[n];
                if (c >= '0' && c <= '9' || Character.isDigit(c)) {
                    if (bl3) {
                        n7 = Character.digit(c, 10);
                        if (n7 == 0) {
                            if (n3 == 0) {
                                n3 = 1;
                            } else if (l != 0L) {
                                l *= 10L;
                                ++n3;
                            }
                        } else {
                            if (n3 != 1 || l != 0L) {
                                ++n3;
                            }
                            l = l * 10L + (long)n7;
                        }
                    } else if (c == '0' || Character.digit(c, 10) == 0) {
                        if (n3 == 0) {
                            cArray2[n6] = c;
                            n3 = 1;
                        } else if (n6 != 0) {
                            cArray2[n6++] = c;
                            ++n3;
                        }
                    } else {
                        if (n3 != 1 || n6 != 0) {
                            ++n3;
                        }
                        cArray2[n6++] = c;
                    }
                    if (bl2) {
                        ++n4;
                    }
                } else if (c == '.') {
                    if (bl2) {
                        throw new NumberFormatException();
                    }
                    bl2 = true;
                } else {
                    if (c != 'e' && c != 'E') {
                        throw new NumberFormatException();
                    }
                    c = cArray[++n];
                    --n2;
                    int n8 = n7 = c == '-' ? 1 : 0;
                    if (n7 != 0 || c == '+') {
                        c = cArray[++n];
                        --n2;
                    }
                    if (n2 <= 0) {
                        throw new NumberFormatException();
                    }
                    while (n2 > 10 && Character.digit(c, 10) == 0) {
                        c = cArray[++n];
                        --n2;
                    }
                    if (n2 > 10) {
                        throw new NumberFormatException();
                    }
                    while (true) {
                        int n9;
                        if (c >= '0' && c <= '9') {
                            n9 = c - 48;
                        } else {
                            n9 = Character.digit(c, 10);
                            if (n9 < 0) {
                                throw new NumberFormatException();
                            }
                        }
                        l2 = l2 * 10L + (long)n9;
                        if (n2 == 1) break;
                        c = cArray[++n];
                        --n2;
                    }
                    if (n7 != 0) {
                        l2 = -l2;
                    }
                    if ((long)((int)l2) == l2) break;
                    throw new NumberFormatException();
                }
                ++n;
                --n2;
            }
            if (n3 == 0) {
                throw new NumberFormatException();
            }
            if (l2 != 0L) {
                long l3 = (long)n4 - l2;
                if (l3 > Integer.MAX_VALUE || l3 < Integer.MIN_VALUE) {
                    throw new NumberFormatException("Scale out of range.");
                }
                n4 = (int)l3;
            }
            if (bl3) {
                l = bl ? -l : l;
            } else {
                char[] cArray3;
                if (!bl) {
                    cArray3 = cArray2.length != n3 ? Arrays.copyOf(cArray2, n3) : cArray2;
                } else {
                    cArray3 = new char[n3 + 1];
                    cArray3[0] = 45;
                    System.arraycopy(cArray2, 0, cArray3, 1, n3);
                }
                bigInteger = new BigInteger(cArray3);
                l = BigDecimal.compactValFor(bigInteger);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new NumberFormatException();
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            throw new NumberFormatException();
        }
        this.scale = n4;
        this.precision = n3;
        this.intCompact = l;
        this.intVal = bigInteger;
    }

    public BigDecimal(char[] cArray, int n, int n2, MathContext mathContext) {
        this(cArray, n, n2);
        if (mathContext.precision > 0) {
            this.roundThis(mathContext);
        }
    }

    public BigDecimal(char[] cArray) {
        this(cArray, 0, cArray.length);
    }

    public BigDecimal(char[] cArray, MathContext mathContext) {
        this(cArray, 0, cArray.length, mathContext);
    }

    public BigDecimal(String string) {
        this(string.toCharArray(), 0, string.length());
    }

    public BigDecimal(String string, MathContext mathContext) {
        this(string.toCharArray(), 0, string.length());
        if (mathContext.precision > 0) {
            this.roundThis(mathContext);
        }
    }

    public BigDecimal(double d) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new NumberFormatException("Infinite or NaN");
        }
        long l = Double.doubleToLongBits(d);
        int n = l >> 63 == 0L ? 1 : -1;
        int n2 = (int)(l >> 52 & 0x7FFL);
        long l2 = n2 == 0 ? (l & 0xFFFFFFFFFFFFFL) << 1 : l & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
        n2 -= 1075;
        if (l2 == 0L) {
            this.intVal = BigInteger.ZERO;
            this.intCompact = 0L;
            this.precision = 1;
            return;
        }
        while ((l2 & 1L) == 0L) {
            l2 >>= 1;
            ++n2;
        }
        this.intVal = BigInteger.valueOf((long)n * l2);
        if (n2 < 0) {
            this.intVal = this.intVal.multiply(BigInteger.valueOf(5L).pow(-n2));
            this.scale = -n2;
        } else if (n2 > 0) {
            this.intVal = this.intVal.multiply(BigInteger.valueOf(2L).pow(n2));
        }
        this.intCompact = BigDecimal.compactValFor(this.intVal);
    }

    public BigDecimal(double d, MathContext mathContext) {
        this(d);
        if (mathContext.precision > 0) {
            this.roundThis(mathContext);
        }
    }

    public BigDecimal(BigInteger bigInteger) {
        this.intVal = bigInteger;
        this.intCompact = BigDecimal.compactValFor(bigInteger);
    }

    public BigDecimal(BigInteger bigInteger, MathContext mathContext) {
        this(bigInteger);
        if (mathContext.precision > 0) {
            this.roundThis(mathContext);
        }
    }

    public BigDecimal(BigInteger bigInteger, int n) {
        this(bigInteger);
        this.scale = n;
    }

    public BigDecimal(BigInteger bigInteger, int n, MathContext mathContext) {
        this(bigInteger);
        this.scale = n;
        if (mathContext.precision > 0) {
            this.roundThis(mathContext);
        }
    }

    public BigDecimal(int n) {
        this.intCompact = n;
    }

    public BigDecimal(int n, MathContext mathContext) {
        this.intCompact = n;
        if (mathContext.precision > 0) {
            this.roundThis(mathContext);
        }
    }

    public BigDecimal(long l) {
        this.intCompact = l;
        this.intVal = l == Long.MIN_VALUE ? BigInteger.valueOf(l) : null;
    }

    public BigDecimal(long l, MathContext mathContext) {
        this(l);
        if (mathContext.precision > 0) {
            this.roundThis(mathContext);
        }
    }

    public static BigDecimal valueOf(long l, int n) {
        if (n == 0) {
            return BigDecimal.valueOf(l);
        }
        if (l == 0L) {
            if (n > 0 && n < ZERO_SCALED_BY.length) {
                return ZERO_SCALED_BY[n];
            }
            return new BigDecimal(BigInteger.ZERO, 0L, n, 1);
        }
        return new BigDecimal(l == Long.MIN_VALUE ? BigInteger.valueOf(l) : null, l, n, 0);
    }

    public static BigDecimal valueOf(long l) {
        if (l >= 0L && l < (long)zeroThroughTen.length) {
            return zeroThroughTen[(int)l];
        }
        if (l != Long.MIN_VALUE) {
            return new BigDecimal(null, l, 0, 0);
        }
        return new BigDecimal(BigInteger.valueOf(l), l, 0, 0);
    }

    public static BigDecimal valueOf(double d) {
        return new BigDecimal(Double.toString(d));
    }

    public BigDecimal add(BigDecimal bigDecimal) {
        long l;
        long l2 = this.intCompact;
        long l3 = bigDecimal.intCompact;
        BigInteger bigInteger = this.intCompact != Long.MIN_VALUE ? null : this.intVal;
        BigInteger bigInteger2 = bigDecimal.intCompact != Long.MIN_VALUE ? null : bigDecimal.intVal;
        int n = this.scale;
        long l4 = (long)n - (long)bigDecimal.scale;
        if (l4 != 0L) {
            int n2;
            if (l4 < 0L) {
                n2 = this.checkScale(-l4);
                n = bigDecimal.scale;
                if (l2 == Long.MIN_VALUE || (l2 = BigDecimal.longMultiplyPowerTen(l2, n2)) == Long.MIN_VALUE) {
                    bigInteger = this.bigMultiplyPowerTen(n2);
                }
            } else {
                n2 = bigDecimal.checkScale(l4);
                if (l3 == Long.MIN_VALUE || (l3 = BigDecimal.longMultiplyPowerTen(l3, n2)) == Long.MIN_VALUE) {
                    bigInteger2 = bigDecimal.bigMultiplyPowerTen(n2);
                }
            }
        }
        if (l2 != Long.MIN_VALUE && l3 != Long.MIN_VALUE && (((l = l2 + l3) ^ l2) & (l ^ l3)) >= 0L) {
            return BigDecimal.valueOf(l, n);
        }
        if (bigInteger == null) {
            bigInteger = BigInteger.valueOf(l2);
        }
        if (bigInteger2 == null) {
            bigInteger2 = BigInteger.valueOf(l3);
        }
        BigInteger bigInteger3 = bigInteger.add(bigInteger2);
        return bigInteger.signum == bigInteger2.signum ? new BigDecimal(bigInteger3, Long.MIN_VALUE, n, 0) : new BigDecimal(bigInteger3, BigDecimal.compactValFor(bigInteger3), n, 0);
    }

    public BigDecimal add(BigDecimal bigDecimal, MathContext mathContext) {
        Object object;
        boolean bl;
        if (mathContext.precision == 0) {
            return this.add(bigDecimal);
        }
        BigDecimal bigDecimal2 = this;
        this.inflate();
        bigDecimal.inflate();
        boolean bl2 = bigDecimal2.signum() == 0;
        boolean bl3 = bl = bigDecimal.signum() == 0;
        if (bl2 || bl) {
            int n;
            BigDecimal bigDecimal3;
            int n2 = Math.max(bigDecimal2.scale(), bigDecimal.scale());
            if (bl2 && bl) {
                return new BigDecimal(BigInteger.ZERO, 0L, n2, 0);
            }
            BigDecimal bigDecimal4 = bigDecimal3 = bl2 ? BigDecimal.doRound(bigDecimal, mathContext) : BigDecimal.doRound(bigDecimal2, mathContext);
            if (bigDecimal3.scale() == n2) {
                return bigDecimal3;
            }
            if (bigDecimal3.scale() > n2) {
                BigDecimal bigDecimal5 = new BigDecimal(bigDecimal3.intVal, bigDecimal3.intCompact, bigDecimal3.scale, 0);
                bigDecimal5.stripZerosToMatchScale(n2);
                return bigDecimal5;
            }
            int n3 = mathContext.precision - bigDecimal3.precision();
            if (n3 >= (n = n2 - bigDecimal3.scale())) {
                return bigDecimal3.setScale(n2);
            }
            return bigDecimal3.setScale(bigDecimal3.scale() + n3);
        }
        long l = (long)bigDecimal2.scale - (long)bigDecimal.scale;
        if (l != 0L) {
            object = this.preAlign(bigDecimal2, bigDecimal, l, mathContext);
            BigDecimal.matchScale(object);
            bigDecimal2 = object[0];
            bigDecimal = object[1];
        }
        object = new BigDecimal(bigDecimal2.inflate().add(bigDecimal.inflate()), bigDecimal2.scale);
        return BigDecimal.doRound((BigDecimal)object, mathContext);
    }

    private BigDecimal[] preAlign(BigDecimal bigDecimal, BigDecimal bigDecimal2, long l, MathContext mathContext) {
        BigDecimal bigDecimal3;
        BigDecimal bigDecimal4;
        assert (l != 0L);
        if (l < 0L) {
            bigDecimal4 = bigDecimal;
            bigDecimal3 = bigDecimal2;
        } else {
            bigDecimal4 = bigDecimal2;
            bigDecimal3 = bigDecimal;
        }
        long l2 = (long)bigDecimal4.scale - (long)bigDecimal4.precision() + (long)mathContext.precision;
        long l3 = (long)bigDecimal3.scale - (long)bigDecimal3.precision() + 1L;
        if (l3 > (long)(bigDecimal4.scale + 2) && l3 > l2 + 2L) {
            bigDecimal3 = BigDecimal.valueOf(bigDecimal3.signum(), this.checkScale(Math.max((long)bigDecimal4.scale, l2) + 3L));
        }
        BigDecimal[] bigDecimalArray = new BigDecimal[]{bigDecimal4, bigDecimal3};
        return bigDecimalArray;
    }

    public BigDecimal subtract(BigDecimal bigDecimal) {
        return this.add(bigDecimal.negate());
    }

    public BigDecimal subtract(BigDecimal bigDecimal, MathContext mathContext) {
        BigDecimal bigDecimal2 = bigDecimal.negate();
        if (mathContext.precision == 0) {
            return this.add(bigDecimal2);
        }
        return this.add(bigDecimal2, mathContext);
    }

    public BigDecimal multiply(BigDecimal bigDecimal) {
        long l = this.intCompact;
        long l2 = bigDecimal.intCompact;
        int n = this.checkScale((long)this.scale + (long)bigDecimal.scale);
        if (l != Long.MIN_VALUE && l2 != Long.MIN_VALUE) {
            long l3 = l * l2;
            if (Math.abs(l) >>> 31 == 0L && Math.abs(l2) >>> 31 == 0L || l2 == 0L || l3 / l2 == l) {
                return BigDecimal.valueOf(l3, n);
            }
            return new BigDecimal(BigInteger.valueOf(l).multiply(l2), Long.MIN_VALUE, n, 0);
        }
        BigInteger bigInteger = l == Long.MIN_VALUE && l2 == Long.MIN_VALUE ? this.intVal.multiply(bigDecimal.intVal) : (l != Long.MIN_VALUE ? bigDecimal.intVal.multiply(l) : this.intVal.multiply(l2));
        return new BigDecimal(bigInteger, Long.MIN_VALUE, n, 0);
    }

    public BigDecimal multiply(BigDecimal bigDecimal, MathContext mathContext) {
        if (mathContext.precision == 0) {
            return this.multiply(bigDecimal);
        }
        return BigDecimal.doRound(this.multiply(bigDecimal), mathContext);
    }

    public BigDecimal divide(BigDecimal bigDecimal, int n, int n2) {
        if (n2 < 0 || n2 > 7) {
            throw new IllegalArgumentException("Invalid rounding mode");
        }
        BigDecimal bigDecimal2 = this;
        if (this.checkScale((long)n + (long)bigDecimal.scale) > this.scale) {
            bigDecimal2 = this.setScale(n + bigDecimal.scale, 7);
        } else {
            bigDecimal = bigDecimal.setScale(this.checkScale((long)this.scale - (long)n), 7);
        }
        return BigDecimal.divideAndRound(bigDecimal2.intCompact, bigDecimal2.intVal, bigDecimal.intCompact, bigDecimal.intVal, n, n2, n);
    }

    private static BigDecimal divideAndRound(long l, BigInteger bigInteger, long l2, BigInteger bigInteger2, int n, int n2, int n3) {
        BigDecimal bigDecimal;
        int n4;
        boolean bl;
        boolean bl2;
        long l3 = 0L;
        long l4 = 0L;
        MutableBigInteger mutableBigInteger = null;
        MutableBigInteger mutableBigInteger2 = null;
        MutableBigInteger mutableBigInteger3 = null;
        boolean bl3 = bl2 = l != Long.MIN_VALUE && l2 != Long.MIN_VALUE;
        if (bl2) {
            l3 = l / l2;
            if (n2 == 1 && n == n3) {
                return new BigDecimal(null, l3, n, 0);
            }
            l4 = l % l2;
            bl = l4 == 0L;
            n4 = l < 0L == l2 < 0L ? 1 : -1;
        } else {
            if (bigInteger == null) {
                bigInteger = BigInteger.valueOf(l);
            }
            MutableBigInteger mutableBigInteger4 = new MutableBigInteger(bigInteger.mag);
            mutableBigInteger = new MutableBigInteger();
            if (l2 != Long.MIN_VALUE) {
                l4 = mutableBigInteger4.divide(l2, mutableBigInteger);
                bl = l4 == 0L;
                n4 = l2 < 0L ? -bigInteger.signum : bigInteger.signum;
            } else {
                mutableBigInteger3 = new MutableBigInteger(bigInteger2.mag);
                mutableBigInteger2 = mutableBigInteger4.divide(mutableBigInteger3, mutableBigInteger);
                bl = mutableBigInteger2.isZero();
                n4 = bigInteger.signum != bigInteger2.signum ? -1 : 1;
            }
        }
        boolean bl4 = false;
        if (!bl) {
            if (n2 == 7) {
                throw new ArithmeticException("Rounding necessary");
            }
            if (n2 == 0) {
                bl4 = true;
            } else if (n2 == 1) {
                bl4 = false;
            } else if (n2 == 2) {
                bl4 = n4 > 0;
            } else if (n2 == 3) {
                bl4 = n4 < 0;
            } else {
                int n5 = bl2 || l2 != Long.MIN_VALUE ? (l4 <= -4611686018427387904L || l4 > 0x3FFFFFFFFFFFFFFFL ? 1 : BigDecimal.longCompareMagnitude(2L * l4, l2)) : mutableBigInteger2.compareHalf(mutableBigInteger3);
                if (n5 < 0) {
                    bl4 = false;
                } else if (n5 > 0) {
                    bl4 = true;
                } else if (n2 == 4) {
                    bl4 = true;
                } else if (n2 == 5) {
                    bl4 = false;
                } else {
                    boolean bl5 = bl2 ? (l3 & 1L) != 0L : (bl4 = mutableBigInteger.isOdd());
                }
            }
        }
        if (bl2) {
            bigDecimal = new BigDecimal(null, bl4 ? l3 + (long)n4 : l3, n, 0);
        } else {
            if (bl4) {
                mutableBigInteger.add(MutableBigInteger.ONE);
            }
            bigDecimal = mutableBigInteger.toBigDecimal(n4, n);
        }
        if (bl && n3 != n) {
            bigDecimal.stripZerosToMatchScale(n3);
        }
        return bigDecimal;
    }

    public BigDecimal divide(BigDecimal bigDecimal, int n, RoundingMode roundingMode) {
        return this.divide(bigDecimal, n, roundingMode.oldMode);
    }

    public BigDecimal divide(BigDecimal bigDecimal, int n) {
        return this.divide(bigDecimal, this.scale, n);
    }

    public BigDecimal divide(BigDecimal bigDecimal, RoundingMode roundingMode) {
        return this.divide(bigDecimal, this.scale, roundingMode.oldMode);
    }

    public BigDecimal divide(BigDecimal bigDecimal) {
        BigDecimal bigDecimal2;
        if (bigDecimal.signum() == 0) {
            if (this.signum() == 0) {
                throw new ArithmeticException("Division undefined");
            }
            throw new ArithmeticException("Division by zero");
        }
        int n = BigDecimal.saturateLong((long)this.scale - (long)bigDecimal.scale);
        if (this.signum() == 0) {
            return 0 <= n && n < ZERO_SCALED_BY.length ? ZERO_SCALED_BY[n] : BigDecimal.valueOf(0L, n);
        }
        this.inflate();
        bigDecimal.inflate();
        MathContext mathContext = new MathContext((int)Math.min((long)this.precision() + (long)Math.ceil(10.0 * (double)bigDecimal.precision() / 3.0), Integer.MAX_VALUE), RoundingMode.UNNECESSARY);
        try {
            bigDecimal2 = this.divide(bigDecimal, mathContext);
        }
        catch (ArithmeticException arithmeticException) {
            throw new ArithmeticException("Non-terminating decimal expansion; no exact representable decimal result.");
        }
        int n2 = bigDecimal2.scale();
        if (n > n2) {
            return bigDecimal2.setScale(n, 7);
        }
        return bigDecimal2;
    }

    public BigDecimal divide(BigDecimal bigDecimal, MathContext mathContext) {
        int n;
        int n2 = mathContext.precision;
        if (n2 == 0) {
            return this.divide(bigDecimal);
        }
        BigDecimal bigDecimal2 = this;
        long l = (long)bigDecimal2.scale - (long)bigDecimal.scale;
        if (bigDecimal.signum() == 0) {
            if (bigDecimal2.signum() == 0) {
                throw new ArithmeticException("Division undefined");
            }
            throw new ArithmeticException("Division by zero");
        }
        if (bigDecimal2.signum() == 0) {
            return new BigDecimal(BigInteger.ZERO, 0L, BigDecimal.saturateLong(l), 1);
        }
        int n3 = bigDecimal2.precision();
        if ((bigDecimal2 = new BigDecimal(bigDecimal2.intVal, bigDecimal2.intCompact, n3, n3)).compareMagnitude(bigDecimal = new BigDecimal(bigDecimal.intVal, bigDecimal.intCompact, n = bigDecimal.precision(), n)) > 0) {
            n = --bigDecimal.scale;
        }
        int n4 = this.checkScale(l + (long)n - (long)n3 + (long)n2);
        if (this.checkScale((long)n2 + (long)n) > n3) {
            bigDecimal2 = bigDecimal2.setScale(n2 + n, 7);
        } else {
            bigDecimal = bigDecimal.setScale(this.checkScale((long)n3 - (long)n2), 7);
        }
        BigDecimal bigDecimal3 = BigDecimal.divideAndRound(bigDecimal2.intCompact, bigDecimal2.intVal, bigDecimal.intCompact, bigDecimal.intVal, n4, mathContext.roundingMode.oldMode, this.checkScale(l));
        bigDecimal3 = BigDecimal.doRound(bigDecimal3, mathContext);
        return bigDecimal3;
    }

    public BigDecimal divideToIntegralValue(BigDecimal bigDecimal) {
        int n = BigDecimal.saturateLong((long)this.scale - (long)bigDecimal.scale);
        if (this.compareMagnitude(bigDecimal) < 0) {
            return BigDecimal.valueOf(0L, n);
        }
        if (this.signum() == 0 && bigDecimal.signum() != 0) {
            return this.setScale(n, 7);
        }
        int n2 = (int)Math.min((long)this.precision() + (long)Math.ceil(10.0 * (double)bigDecimal.precision() / 3.0) + Math.abs((long)this.scale() - (long)bigDecimal.scale()) + 2L, Integer.MAX_VALUE);
        BigDecimal bigDecimal2 = this.divide(bigDecimal, new MathContext(n2, RoundingMode.DOWN));
        if (bigDecimal2.scale > 0) {
            bigDecimal2 = bigDecimal2.setScale(0, RoundingMode.DOWN);
            bigDecimal2.stripZerosToMatchScale(n);
        }
        if (bigDecimal2.scale < n) {
            bigDecimal2 = bigDecimal2.setScale(n, 7);
        }
        return bigDecimal2;
    }

    public BigDecimal divideToIntegralValue(BigDecimal bigDecimal, MathContext mathContext) {
        int n;
        if (mathContext.precision == 0 || this.compareMagnitude(bigDecimal) < 0) {
            return this.divideToIntegralValue(bigDecimal);
        }
        int n2 = BigDecimal.saturateLong((long)this.scale - (long)bigDecimal.scale);
        BigDecimal bigDecimal2 = this.divide(bigDecimal, new MathContext(mathContext.precision, RoundingMode.DOWN));
        if (bigDecimal2.scale() < 0) {
            BigDecimal bigDecimal3 = bigDecimal2.multiply(bigDecimal);
            if (this.subtract(bigDecimal3).compareMagnitude(bigDecimal) >= 0) {
                throw new ArithmeticException("Division impossible");
            }
        } else if (bigDecimal2.scale() > 0) {
            bigDecimal2 = bigDecimal2.setScale(0, RoundingMode.DOWN);
        }
        if (n2 > bigDecimal2.scale() && (n = mathContext.precision - bigDecimal2.precision()) > 0) {
            return bigDecimal2.setScale(bigDecimal2.scale() + Math.min(n, n2 - bigDecimal2.scale));
        }
        bigDecimal2.stripZerosToMatchScale(n2);
        return bigDecimal2;
    }

    public BigDecimal remainder(BigDecimal bigDecimal) {
        BigDecimal[] bigDecimalArray = this.divideAndRemainder(bigDecimal);
        return bigDecimalArray[1];
    }

    public BigDecimal remainder(BigDecimal bigDecimal, MathContext mathContext) {
        BigDecimal[] bigDecimalArray = this.divideAndRemainder(bigDecimal, mathContext);
        return bigDecimalArray[1];
    }

    public BigDecimal[] divideAndRemainder(BigDecimal bigDecimal) {
        BigDecimal[] bigDecimalArray;
        bigDecimalArray = new BigDecimal[]{this.divideToIntegralValue(bigDecimal), this.subtract(bigDecimalArray[0].multiply(bigDecimal))};
        return bigDecimalArray;
    }

    public BigDecimal[] divideAndRemainder(BigDecimal bigDecimal, MathContext mathContext) {
        if (mathContext.precision == 0) {
            return this.divideAndRemainder(bigDecimal);
        }
        BigDecimal[] bigDecimalArray = new BigDecimal[2];
        BigDecimal bigDecimal2 = this;
        bigDecimalArray[0] = bigDecimal2.divideToIntegralValue(bigDecimal, mathContext);
        bigDecimalArray[1] = bigDecimal2.subtract(bigDecimalArray[0].multiply(bigDecimal));
        return bigDecimalArray;
    }

    public BigDecimal pow(int n) {
        if (n < 0 || n > 999999999) {
            throw new ArithmeticException("Invalid operation");
        }
        int n2 = this.checkScale((long)this.scale * (long)n);
        this.inflate();
        return new BigDecimal(this.intVal.pow(n), n2);
    }

    public BigDecimal pow(int n, MathContext mathContext) {
        if (mathContext.precision == 0) {
            return this.pow(n);
        }
        if (n < -999999999 || n > 999999999) {
            throw new ArithmeticException("Invalid operation");
        }
        if (n == 0) {
            return ONE;
        }
        this.inflate();
        BigDecimal bigDecimal = this;
        MathContext mathContext2 = mathContext;
        int n2 = Math.abs(n);
        if (mathContext.precision > 0) {
            int n3 = BigDecimal.longDigitLength(n2);
            if (n3 > mathContext.precision) {
                throw new ArithmeticException("Invalid operation");
            }
            mathContext2 = new MathContext(mathContext.precision + n3 + 1, mathContext.roundingMode);
        }
        BigDecimal bigDecimal2 = ONE;
        boolean bl = false;
        int n4 = 1;
        while (true) {
            if ((n2 += n2) < 0) {
                bl = true;
                bigDecimal2 = bigDecimal2.multiply(bigDecimal, mathContext2);
            }
            if (n4 == 31) break;
            if (bl) {
                bigDecimal2 = bigDecimal2.multiply(bigDecimal2, mathContext2);
            }
            ++n4;
        }
        if (n < 0) {
            bigDecimal2 = ONE.divide(bigDecimal2, mathContext2);
        }
        return BigDecimal.doRound(bigDecimal2, mathContext);
    }

    public BigDecimal abs() {
        return this.signum() < 0 ? this.negate() : this;
    }

    public BigDecimal abs(MathContext mathContext) {
        return this.signum() < 0 ? this.negate(mathContext) : this.plus(mathContext);
    }

    public BigDecimal negate() {
        BigInteger bigInteger;
        long l;
        if (this.intCompact == Long.MIN_VALUE) {
            l = Long.MIN_VALUE;
            bigInteger = this.intVal.negate();
        } else {
            l = -this.intCompact;
            bigInteger = null;
        }
        return new BigDecimal(bigInteger, l, this.scale, this.precision);
    }

    public BigDecimal negate(MathContext mathContext) {
        return this.negate().plus(mathContext);
    }

    public BigDecimal plus() {
        return this;
    }

    public BigDecimal plus(MathContext mathContext) {
        if (mathContext.precision == 0) {
            return this;
        }
        return BigDecimal.doRound(this, mathContext);
    }

    public int signum() {
        return this.intCompact != Long.MIN_VALUE ? Long.signum(this.intCompact) : this.intVal.signum();
    }

    public int scale() {
        return this.scale;
    }

    public int precision() {
        int n = this.precision;
        if (n == 0) {
            long l = this.intCompact;
            n = l != Long.MIN_VALUE ? BigDecimal.longDigitLength(l) : BigDecimal.bigDigitLength(this.inflate());
            this.precision = n;
        }
        return n;
    }

    public BigInteger unscaledValue() {
        return this.inflate();
    }

    public BigDecimal round(MathContext mathContext) {
        return this.plus(mathContext);
    }

    public BigDecimal setScale(int n, RoundingMode roundingMode) {
        return this.setScale(n, roundingMode.oldMode);
    }

    public BigDecimal setScale(int n, int n2) {
        if (n2 < 0 || n2 > 7) {
            throw new IllegalArgumentException("Invalid rounding mode");
        }
        int n3 = this.scale;
        if (n == n3) {
            return this;
        }
        if (this.signum() == 0) {
            return BigDecimal.valueOf(0L, n);
        }
        long l = this.intCompact;
        if (n > n3) {
            int n4 = this.checkScale((long)n - (long)n3);
            BigInteger bigInteger = null;
            if (l == Long.MIN_VALUE || (l = BigDecimal.longMultiplyPowerTen(l, n4)) == Long.MIN_VALUE) {
                bigInteger = this.bigMultiplyPowerTen(n4);
            }
            return new BigDecimal(bigInteger, l, n, this.precision > 0 ? this.precision + n4 : 0);
        }
        int n5 = this.checkScale((long)n3 - (long)n);
        if (n5 < LONG_TEN_POWERS_TABLE.length) {
            return BigDecimal.divideAndRound(l, this.intVal, LONG_TEN_POWERS_TABLE[n5], null, n, n2, n);
        }
        return BigDecimal.divideAndRound(l, this.intVal, Long.MIN_VALUE, BigDecimal.bigTenToThe(n5), n, n2, n);
    }

    public BigDecimal setScale(int n) {
        return this.setScale(n, 7);
    }

    public BigDecimal movePointLeft(int n) {
        int n2 = this.checkScale((long)this.scale + (long)n);
        BigDecimal bigDecimal = new BigDecimal(this.intVal, this.intCompact, n2, 0);
        return bigDecimal.scale < 0 ? bigDecimal.setScale(0, 7) : bigDecimal;
    }

    public BigDecimal movePointRight(int n) {
        int n2 = this.checkScale((long)this.scale - (long)n);
        BigDecimal bigDecimal = new BigDecimal(this.intVal, this.intCompact, n2, 0);
        return bigDecimal.scale < 0 ? bigDecimal.setScale(0, 7) : bigDecimal;
    }

    public BigDecimal scaleByPowerOfTen(int n) {
        return new BigDecimal(this.intVal, this.intCompact, this.checkScale((long)this.scale - (long)n), this.precision);
    }

    public BigDecimal stripTrailingZeros() {
        this.inflate();
        BigDecimal bigDecimal = new BigDecimal(this.intVal, this.scale);
        bigDecimal.stripZerosToMatchScale(Long.MIN_VALUE);
        return bigDecimal;
    }

    @Override
    public int compareTo(BigDecimal bigDecimal) {
        int n;
        int n2;
        if (this.scale == bigDecimal.scale) {
            long l = this.intCompact;
            long l2 = bigDecimal.intCompact;
            if (l != Long.MIN_VALUE && l2 != Long.MIN_VALUE) {
                return l != l2 ? (l > l2 ? 1 : -1) : 0;
            }
        }
        if ((n2 = this.signum()) != (n = bigDecimal.signum())) {
            return n2 > n ? 1 : -1;
        }
        if (n2 == 0) {
            return 0;
        }
        int n3 = this.compareMagnitude(bigDecimal);
        return n2 > 0 ? n3 : -n3;
    }

    private int compareMagnitude(BigDecimal bigDecimal) {
        long l = bigDecimal.intCompact;
        long l2 = this.intCompact;
        if (l2 == 0L) {
            return l == 0L ? 0 : -1;
        }
        if (l == 0L) {
            return 1;
        }
        int n = this.scale - bigDecimal.scale;
        if (n != 0) {
            int n2;
            int n3 = this.precision() - this.scale;
            if (n3 < (n2 = bigDecimal.precision() - bigDecimal.scale)) {
                return -1;
            }
            if (n3 > n2) {
                return 1;
            }
            BigInteger bigInteger = null;
            if (n < 0) {
                if ((l2 == Long.MIN_VALUE || (l2 = BigDecimal.longMultiplyPowerTen(l2, -n)) == Long.MIN_VALUE) && l == Long.MIN_VALUE) {
                    bigInteger = this.bigMultiplyPowerTen(-n);
                    return bigInteger.compareMagnitude(bigDecimal.intVal);
                }
            } else if ((l == Long.MIN_VALUE || (l = BigDecimal.longMultiplyPowerTen(l, n)) == Long.MIN_VALUE) && l2 == Long.MIN_VALUE) {
                bigInteger = bigDecimal.bigMultiplyPowerTen(n);
                return this.intVal.compareMagnitude(bigInteger);
            }
        }
        if (l2 != Long.MIN_VALUE) {
            return l != Long.MIN_VALUE ? BigDecimal.longCompareMagnitude(l2, l) : -1;
        }
        if (l != Long.MIN_VALUE) {
            return 1;
        }
        return this.intVal.compareMagnitude(bigDecimal.intVal);
    }

    public boolean equals(Object object) {
        if (!(object instanceof BigDecimal)) {
            return false;
        }
        BigDecimal bigDecimal = (BigDecimal)object;
        if (object == this) {
            return true;
        }
        if (this.scale != bigDecimal.scale) {
            return false;
        }
        long l = this.intCompact;
        long l2 = bigDecimal.intCompact;
        if (l != Long.MIN_VALUE) {
            if (l2 == Long.MIN_VALUE) {
                l2 = BigDecimal.compactValFor(bigDecimal.intVal);
            }
            return l2 == l;
        }
        if (l2 != Long.MIN_VALUE) {
            return l2 == BigDecimal.compactValFor(this.intVal);
        }
        return this.inflate().equals(bigDecimal.inflate());
    }

    public BigDecimal min(BigDecimal bigDecimal) {
        return this.compareTo(bigDecimal) <= 0 ? this : bigDecimal;
    }

    public BigDecimal max(BigDecimal bigDecimal) {
        return this.compareTo(bigDecimal) >= 0 ? this : bigDecimal;
    }

    public int hashCode() {
        if (this.intCompact != Long.MIN_VALUE) {
            long l = this.intCompact < 0L ? -this.intCompact : this.intCompact;
            int n = (int)((long)((int)(l >>> 32) * 31) + (l & 0xFFFFFFFFL));
            return 31 * (this.intCompact < 0L ? -n : n) + this.scale;
        }
        return 31 * this.intVal.hashCode() + this.scale;
    }

    public String toString() {
        String string = this.stringCache;
        if (string == null) {
            this.stringCache = string = this.layoutChars(true);
        }
        return string;
    }

    public String toEngineeringString() {
        return this.layoutChars(false);
    }

    public String toPlainString() {
        BigDecimal bigDecimal = this;
        if (bigDecimal.scale < 0) {
            bigDecimal = bigDecimal.setScale(0);
        }
        bigDecimal.inflate();
        if (bigDecimal.scale == 0) {
            return bigDecimal.intVal.toString();
        }
        return bigDecimal.getValueString(bigDecimal.signum(), bigDecimal.intVal.abs().toString(), bigDecimal.scale);
    }

    private String getValueString(int n, String string, int n2) {
        StringBuilder stringBuilder;
        int n3 = string.length() - n2;
        if (n3 == 0) {
            return (n < 0 ? "-0." : "0.") + string;
        }
        if (n3 > 0) {
            stringBuilder = new StringBuilder(string);
            stringBuilder.insert(n3, '.');
            if (n < 0) {
                stringBuilder.insert(0, '-');
            }
        } else {
            stringBuilder = new StringBuilder(3 - n3 + string.length());
            stringBuilder.append(n < 0 ? "-0." : "0.");
            for (int i = 0; i < -n3; ++i) {
                stringBuilder.append('0');
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public BigInteger toBigInteger() {
        return this.setScale(0, 1).inflate();
    }

    public BigInteger toBigIntegerExact() {
        return this.setScale(0, 7).inflate();
    }

    @Override
    public long longValue() {
        return this.intCompact != Long.MIN_VALUE && this.scale == 0 ? this.intCompact : this.toBigInteger().longValue();
    }

    public long longValueExact() {
        if (this.intCompact != Long.MIN_VALUE && this.scale == 0) {
            return this.intCompact;
        }
        if (this.precision() - this.scale > 19) {
            throw new ArithmeticException("Overflow");
        }
        if (this.signum() == 0) {
            return 0L;
        }
        if (this.precision() - this.scale <= 0) {
            throw new ArithmeticException("Rounding necessary");
        }
        BigDecimal bigDecimal = this.setScale(0, 7);
        if (bigDecimal.precision() >= 19) {
            LongOverflow.check(bigDecimal);
        }
        return bigDecimal.inflate().longValue();
    }

    @Override
    public int intValue() {
        return this.intCompact != Long.MIN_VALUE && this.scale == 0 ? (int)this.intCompact : this.toBigInteger().intValue();
    }

    public int intValueExact() {
        long l = this.longValueExact();
        if ((long)((int)l) != l) {
            throw new ArithmeticException("Overflow");
        }
        return (int)l;
    }

    public short shortValueExact() {
        long l = this.longValueExact();
        if ((long)((short)l) != l) {
            throw new ArithmeticException("Overflow");
        }
        return (short)l;
    }

    public byte byteValueExact() {
        long l = this.longValueExact();
        if ((long)((byte)l) != l) {
            throw new ArithmeticException("Overflow");
        }
        return (byte)l;
    }

    @Override
    public float floatValue() {
        if (this.scale == 0 && this.intCompact != Long.MIN_VALUE) {
            return this.intCompact;
        }
        return Float.parseFloat(this.toString());
    }

    @Override
    public double doubleValue() {
        if (this.scale == 0 && this.intCompact != Long.MIN_VALUE) {
            return this.intCompact;
        }
        return Double.parseDouble(this.toString());
    }

    public BigDecimal ulp() {
        return BigDecimal.valueOf(1L, this.scale());
    }

    private String layoutChars(boolean bl) {
        StringBuilder stringBuilder;
        block20: {
            long l;
            block22: {
                int n;
                int n2;
                char[] cArray;
                int n3;
                block23: {
                    block21: {
                        block19: {
                            if (this.scale == 0) {
                                return this.intCompact != Long.MIN_VALUE ? Long.toString(this.intCompact) : this.intVal.toString();
                            }
                            StringBuilderHelper stringBuilderHelper = threadLocalStringBuilderHelper.get();
                            if (this.intCompact != Long.MIN_VALUE) {
                                n3 = stringBuilderHelper.putIntCompact(Math.abs(this.intCompact));
                                cArray = stringBuilderHelper.getCompactCharArray();
                            } else {
                                n3 = 0;
                                cArray = this.intVal.abs().toString().toCharArray();
                            }
                            stringBuilder = stringBuilderHelper.getStringBuilder();
                            if (this.signum() < 0) {
                                stringBuilder.append('-');
                            }
                            n2 = cArray.length - n3;
                            l = -((long)this.scale) + (long)(n2 - 1);
                            if (this.scale < 0 || l < -6L) break block19;
                            int n4 = this.scale - n2;
                            if (n4 >= 0) {
                                stringBuilder.append('0');
                                stringBuilder.append('.');
                                while (n4 > 0) {
                                    stringBuilder.append('0');
                                    --n4;
                                }
                                stringBuilder.append(cArray, n3, n2);
                            } else {
                                stringBuilder.append(cArray, n3, -n4);
                                stringBuilder.append('.');
                                stringBuilder.append(cArray, -n4 + n3, this.scale);
                            }
                            break block20;
                        }
                        if (!bl) break block21;
                        stringBuilder.append(cArray[n3]);
                        if (n2 > 1) {
                            stringBuilder.append('.');
                            stringBuilder.append(cArray, n3 + 1, n2 - 1);
                        }
                        break block22;
                    }
                    n = (int)(l % 3L);
                    if (n < 0) {
                        n += 3;
                    }
                    l -= (long)n;
                    ++n;
                    if (this.signum() != 0) break block23;
                    switch (n) {
                        case 1: {
                            stringBuilder.append('0');
                            break block22;
                        }
                        case 2: {
                            stringBuilder.append("0.00");
                            l += 3L;
                            break block22;
                        }
                        case 3: {
                            stringBuilder.append("0.0");
                            l += 3L;
                            break block22;
                        }
                        default: {
                            throw new AssertionError((Object)("Unexpected sig value " + n));
                        }
                    }
                }
                if (n >= n2) {
                    stringBuilder.append(cArray, n3, n2);
                    for (int i = n - n2; i > 0; --i) {
                        stringBuilder.append('0');
                    }
                } else {
                    stringBuilder.append(cArray, n3, n);
                    stringBuilder.append('.');
                    stringBuilder.append(cArray, n3 + n, n2 - n);
                }
            }
            if (l != 0L) {
                stringBuilder.append('E');
                if (l > 0L) {
                    stringBuilder.append('+');
                }
                stringBuilder.append(l);
            }
        }
        return stringBuilder.toString();
    }

    private static BigInteger bigTenToThe(int n) {
        if (n < 0) {
            return BigInteger.ZERO;
        }
        if (n < BIG_TEN_POWERS_TABLE_MAX) {
            BigInteger[] bigIntegerArray = BIG_TEN_POWERS_TABLE;
            if (n < bigIntegerArray.length) {
                return bigIntegerArray[n];
            }
            return BigDecimal.expandBigIntegerTenPowers(n);
        }
        char[] cArray = new char[n + 1];
        cArray[0] = 49;
        for (int i = 1; i <= n; ++i) {
            cArray[i] = 48;
        }
        return new BigInteger(cArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BigInteger expandBigIntegerTenPowers(int n) {
        Class<BigDecimal> clazz = BigDecimal.class;
        synchronized (BigDecimal.class) {
            BigInteger[] bigIntegerArray = BIG_TEN_POWERS_TABLE;
            int n2 = bigIntegerArray.length;
            if (n2 <= n) {
                int n3;
                for (n3 = n2 << 1; n3 <= n; n3 <<= 1) {
                }
                bigIntegerArray = Arrays.copyOf(bigIntegerArray, n3);
                for (int i = n2; i < n3; ++i) {
                    bigIntegerArray[i] = bigIntegerArray[i - 1].multiply(BigInteger.TEN);
                }
                BIG_TEN_POWERS_TABLE = bigIntegerArray;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return bigIntegerArray[n];
        }
    }

    private static long longMultiplyPowerTen(long l, int n) {
        if (l == 0L || n <= 0) {
            return l;
        }
        long[] lArray = LONG_TEN_POWERS_TABLE;
        long[] lArray2 = THRESHOLDS_TABLE;
        if (n < lArray.length && n < lArray2.length) {
            long l2 = lArray[n];
            if (l == 1L) {
                return l2;
            }
            if (Math.abs(l) <= lArray2[n]) {
                return l * l2;
            }
        }
        return Long.MIN_VALUE;
    }

    private BigInteger bigMultiplyPowerTen(int n) {
        if (n <= 0) {
            return this.inflate();
        }
        if (this.intCompact != Long.MIN_VALUE) {
            return BigDecimal.bigTenToThe(n).multiply(this.intCompact);
        }
        return this.intVal.multiply(BigDecimal.bigTenToThe(n));
    }

    private BigInteger inflate() {
        if (this.intVal == null) {
            this.intVal = BigInteger.valueOf(this.intCompact);
        }
        return this.intVal;
    }

    private static void matchScale(BigDecimal[] bigDecimalArray) {
        if (bigDecimalArray[0].scale == bigDecimalArray[1].scale) {
            return;
        }
        if (bigDecimalArray[0].scale < bigDecimalArray[1].scale) {
            bigDecimalArray[0] = bigDecimalArray[0].setScale(bigDecimalArray[1].scale, 7);
        } else if (bigDecimalArray[1].scale < bigDecimalArray[0].scale) {
            bigDecimalArray[1] = bigDecimalArray[1].setScale(bigDecimalArray[0].scale, 7);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.intVal == null) {
            String string = "BigDecimal: null intVal in stream";
            throw new StreamCorruptedException(string);
        }
        this.intCompact = BigDecimal.compactValFor(this.intVal);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.inflate();
        objectOutputStream.defaultWriteObject();
    }

    private static int longDigitLength(long l) {
        long[] lArray;
        int n;
        assert (l != Long.MIN_VALUE);
        if (l < 0L) {
            l = -l;
        }
        if (l < 10L) {
            return 1;
        }
        int n2 = 64;
        int n3 = (int)(l >>> 32);
        if (n3 == 0) {
            n2 -= 32;
            n3 = (int)l;
        }
        if (n3 >>> 16 == 0) {
            n2 -= 16;
            n3 <<= 16;
        }
        if (n3 >>> 24 == 0) {
            n2 -= 8;
            n3 <<= 8;
        }
        if (n3 >>> 28 == 0) {
            n2 -= 4;
            n3 <<= 4;
        }
        if (n3 >>> 30 == 0) {
            n2 -= 2;
            n3 <<= 2;
        }
        return (n = ((n3 >>> 31) + n2) * 1233 >>> 12) >= (lArray = LONG_TEN_POWERS_TABLE).length || l < lArray[n] ? n : n + 1;
    }

    private static int bigDigitLength(BigInteger bigInteger) {
        if (bigInteger.signum == 0) {
            return 1;
        }
        int n = (int)(((long)bigInteger.bitLength() + 1L) * 646456993L >>> 31);
        return bigInteger.compareMagnitude(BigDecimal.bigTenToThe(n)) < 0 ? n : n + 1;
    }

    private BigDecimal stripZerosToMatchScale(long l) {
        BigInteger[] bigIntegerArray;
        boolean bl = this.intCompact != Long.MIN_VALUE;
        this.inflate();
        while (this.intVal.compareMagnitude(BigInteger.TEN) >= 0 && (long)this.scale > l && !this.intVal.testBit(0) && (bigIntegerArray = this.intVal.divideAndRemainder(BigInteger.TEN))[1].signum() == 0) {
            this.intVal = bigIntegerArray[0];
            this.scale = this.checkScale((long)this.scale - 1L);
            if (this.precision <= 0) continue;
            --this.precision;
        }
        if (this.intVal != null) {
            this.intCompact = BigDecimal.compactValFor(this.intVal);
        }
        return this;
    }

    private int checkScale(long l) {
        int n = (int)l;
        if ((long)n != l) {
            BigInteger bigInteger;
            int n2 = n = l > Integer.MAX_VALUE ? Integer.MAX_VALUE : Integer.MIN_VALUE;
            if (this.intCompact != 0L && ((bigInteger = this.intVal) == null || bigInteger.signum() != 0)) {
                throw new ArithmeticException(n > 0 ? "Underflow" : "Overflow");
            }
        }
        return n;
    }

    private BigDecimal roundOp(MathContext mathContext) {
        BigDecimal bigDecimal = BigDecimal.doRound(this, mathContext);
        return bigDecimal;
    }

    private void roundThis(MathContext mathContext) {
        BigDecimal bigDecimal = BigDecimal.doRound(this, mathContext);
        if (bigDecimal == this) {
            return;
        }
        this.intVal = bigDecimal.intVal;
        this.intCompact = bigDecimal.intCompact;
        this.scale = bigDecimal.scale;
        this.precision = bigDecimal.precision;
    }

    private static BigDecimal doRound(BigDecimal bigDecimal, MathContext mathContext) {
        int n;
        int n2 = mathContext.precision;
        while ((n = bigDecimal.precision() - n2) > 0) {
            int n3 = bigDecimal.checkScale((long)bigDecimal.scale - (long)n);
            int n4 = mathContext.roundingMode.oldMode;
            if (n < LONG_TEN_POWERS_TABLE.length) {
                bigDecimal = BigDecimal.divideAndRound(bigDecimal.intCompact, bigDecimal.intVal, LONG_TEN_POWERS_TABLE[n], null, n3, n4, n3);
                continue;
            }
            bigDecimal = BigDecimal.divideAndRound(bigDecimal.intCompact, bigDecimal.intVal, Long.MIN_VALUE, BigDecimal.bigTenToThe(n), n3, n4, n3);
        }
        return bigDecimal;
    }

    private static long compactValFor(BigInteger bigInteger) {
        int[] nArray = bigInteger.mag;
        int n = nArray.length;
        if (n == 0) {
            return 0L;
        }
        int n2 = nArray[0];
        if (n > 2 || n == 2 && n2 < 0) {
            return Long.MIN_VALUE;
        }
        long l = n == 2 ? ((long)nArray[1] & 0xFFFFFFFFL) + ((long)n2 << 32) : (long)n2 & 0xFFFFFFFFL;
        return bigInteger.signum < 0 ? -l : l;
    }

    private static int longCompareMagnitude(long l, long l2) {
        if (l < 0L) {
            l = -l;
        }
        if (l2 < 0L) {
            l2 = -l2;
        }
        return l < l2 ? -1 : (l == l2 ? 0 : 1);
    }

    private static int saturateLong(long l) {
        int n = (int)l;
        return l == (long)n ? n : (l < 0L ? Integer.MIN_VALUE : Integer.MAX_VALUE);
    }

    private static void print(String string, BigDecimal bigDecimal) {
        System.err.format("%s:\tintCompact %d\tintVal %d\tscale %d\tprecision %d%n", string, bigDecimal.intCompact, bigDecimal.intVal, bigDecimal.scale, bigDecimal.precision);
    }

    private BigDecimal audit() {
        if (this.intCompact == Long.MIN_VALUE) {
            if (this.intVal == null) {
                BigDecimal.print("audit", this);
                throw new AssertionError((Object)"null intVal");
            }
            if (this.precision > 0 && this.precision != BigDecimal.bigDigitLength(this.intVal)) {
                BigDecimal.print("audit", this);
                throw new AssertionError((Object)"precision mismatch");
            }
        } else {
            long l;
            if (this.intVal != null && (l = this.intVal.longValue()) != this.intCompact) {
                BigDecimal.print("audit", this);
                throw new AssertionError((Object)("Inconsistent state, intCompact=" + this.intCompact + "\t intVal=" + l));
            }
            if (this.precision > 0 && this.precision != BigDecimal.longDigitLength(this.intCompact)) {
                BigDecimal.print("audit", this);
                throw new AssertionError((Object)"precision mismatch");
            }
        }
        return this;
    }

    private static class LongOverflow {
        private static final BigInteger LONGMIN = BigInteger.valueOf(Long.MIN_VALUE);
        private static final BigInteger LONGMAX = BigInteger.valueOf(Long.MAX_VALUE);

        private LongOverflow() {
        }

        public static void check(BigDecimal bigDecimal) {
            bigDecimal.inflate();
            if (bigDecimal.intVal.compareTo(LONGMIN) < 0 || bigDecimal.intVal.compareTo(LONGMAX) > 0) {
                throw new ArithmeticException("Overflow");
            }
        }
    }

    static class StringBuilderHelper {
        final StringBuilder sb = new StringBuilder();
        final char[] cmpCharArray = new char[19];
        static final char[] DIGIT_TENS = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
        static final char[] DIGIT_ONES = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

        StringBuilderHelper() {
        }

        StringBuilder getStringBuilder() {
            this.sb.setLength(0);
            return this.sb;
        }

        char[] getCompactCharArray() {
            return this.cmpCharArray;
        }

        int putIntCompact(long l) {
            int n;
            assert (l >= 0L);
            int n2 = this.cmpCharArray.length;
            while (l > Integer.MAX_VALUE) {
                long l2 = l / 100L;
                n = (int)(l - l2 * 100L);
                l = l2;
                this.cmpCharArray[--n2] = DIGIT_ONES[n];
                this.cmpCharArray[--n2] = DIGIT_TENS[n];
            }
            int n3 = (int)l;
            while (n3 >= 100) {
                int n4 = n3 / 100;
                n = n3 - n4 * 100;
                n3 = n4;
                this.cmpCharArray[--n2] = DIGIT_ONES[n];
                this.cmpCharArray[--n2] = DIGIT_TENS[n];
            }
            this.cmpCharArray[--n2] = DIGIT_ONES[n3];
            if (n3 >= 10) {
                this.cmpCharArray[--n2] = DIGIT_TENS[n3];
            }
            return n2;
        }
    }
}

