/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.security.CertStore;
import com.sun.deploy.util.Trace;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Random;

public final class SessionCertStore
implements CertStore {
    private KeyStore sessionKS = null;

    public void load() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        this.load(false);
    }

    public void load(boolean bl) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Trace.msgSecurityPrintln("sessioncertstore.cert.loading");
        if (this.sessionKS == null) {
            try {
                this.sessionKS = KeyStore.getInstance("JKS");
                this.sessionKS.load(null, new char[0]);
            }
            catch (IOException iOException) {
                Trace.msgSecurityPrintln(iOException.getMessage());
            }
            catch (KeyStoreException keyStoreException) {
                Trace.msgSecurityPrintln(keyStoreException.getMessage());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                Trace.msgSecurityPrintln(noSuchAlgorithmException.getMessage());
            }
            catch (CertificateException certificateException) {
                Trace.msgSecurityPrintln(certificateException.getMessage());
            }
        }
        Trace.msgSecurityPrintln("sessioncertstore.cert.loaded");
    }

    public void save() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Trace.msgSecurityPrintln("sessioncertstore.cert.saving");
        Trace.msgSecurityPrintln("sessioncertstore.cert.saved");
    }

    public boolean add(Certificate certificate) throws KeyStoreException {
        return this.add(certificate, false);
    }

    public boolean add(Certificate certificate, boolean bl) throws KeyStoreException {
        Trace.msgSecurityPrintln("sessioncertstore.cert.adding");
        String string = this.sessionKS.getCertificateAlias(certificate);
        boolean bl2 = true;
        if (string != null) {
            try {
                if (bl || string.indexOf("$tsflag") == -1) {
                    bl2 = false;
                } else {
                    this.remove(certificate);
                }
            }
            catch (IOException iOException) {
                Trace.securityPrintException(iOException);
            }
        }
        if (bl2) {
            Random random = new Random();
            String string2 = null;
            while (this.sessionKS.getCertificate(string2 = bl ? "deploymentsessioncert$tsflag" + random.nextLong() : "deploymentsessioncert" + random.nextLong()) != null) {
            }
            this.sessionKS.setCertificateEntry(string2, certificate);
            Trace.msgSecurityPrintln("sessioncertstore.cert.added");
        }
        return true;
    }

    public boolean remove(Certificate certificate) throws IOException, KeyStoreException {
        Trace.msgSecurityPrintln("sessioncertstore.cert.removing");
        String string = this.sessionKS.getCertificateAlias(certificate);
        if (string != null) {
            this.sessionKS.deleteEntry(string);
        }
        Trace.msgSecurityPrintln("sessioncertstore.cert.removed");
        return true;
    }

    public boolean contains(Certificate certificate) throws KeyStoreException {
        return this.contains(certificate, false);
    }

    public boolean contains(Certificate certificate, boolean bl) throws KeyStoreException {
        Trace.msgSecurityPrintln("sessioncertstore.cert.instore");
        String string = this.sessionKS.getCertificateAlias(certificate);
        if (bl) {
            return string != null && string.indexOf("$tsflag") > -1;
        }
        return string != null;
    }

    public boolean verify(Certificate certificate) throws KeyStoreException {
        Trace.msgSecurityPrintln("sessioncertstore.cert.canverify");
        return false;
    }

    public Collection getCertificates() throws KeyStoreException {
        Trace.msgSecurityPrintln("sessioncertstore.cert.getcertificates");
        ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
        Enumeration<String> enumeration = this.sessionKS.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            Certificate certificate = this.sessionKS.getCertificate(string);
            arrayList.add(certificate);
        }
        return arrayList;
    }
}

