/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.naming.namingutil;

import com.sun.corba.se.impl.logging.NamingSystemException;
import com.sun.corba.se.impl.naming.namingutil.IIOPEndpointInfo;
import com.sun.corba.se.impl.naming.namingutil.INSURLBase;
import com.sun.corba.se.impl.naming.namingutil.Utility;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class CorbalocURL
extends INSURLBase {
    static NamingSystemException wrapper = NamingSystemException.get("naming.read");

    public CorbalocURL(String string) {
        String string2 = string;
        if (string2 != null) {
            try {
                string2 = Utility.cleanEscapes(string2);
            }
            catch (Exception exception) {
                this.badAddress(exception);
            }
            int n = string2.indexOf(47);
            if (n == -1) {
                n = string2.length();
            }
            if (n == 0) {
                this.badAddress(null);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2.substring(0, n), ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                IIOPEndpointInfo iIOPEndpointInfo = null;
                if (string3.startsWith("iiop:")) {
                    iIOPEndpointInfo = this.handleIIOPColon(string3);
                } else if (string3.startsWith("rir:")) {
                    this.handleRIRColon(string3);
                    this.rirFlag = true;
                } else if (string3.startsWith(":")) {
                    iIOPEndpointInfo = this.handleColon(string3);
                } else {
                    this.badAddress(null);
                }
                if (this.rirFlag) continue;
                if (this.theEndpointInfo == null) {
                    this.theEndpointInfo = new ArrayList();
                }
                this.theEndpointInfo.add(iIOPEndpointInfo);
            }
            if (string2.length() > n + 1) {
                this.theKeyString = string2.substring(n + 1);
            }
        }
    }

    private void badAddress(Throwable throwable) {
        throw wrapper.insBadAddress(throwable);
    }

    private IIOPEndpointInfo handleIIOPColon(String string) {
        string = string.substring(4);
        return this.handleColon(string);
    }

    private IIOPEndpointInfo handleColon(String string) {
        String string2 = string = string.substring(1);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "@");
        IIOPEndpointInfo iIOPEndpointInfo = new IIOPEndpointInfo();
        int n = stringTokenizer.countTokens();
        if (n == 0 || n > 2) {
            this.badAddress(null);
        }
        if (n == 2) {
            String string3 = stringTokenizer.nextToken();
            int n2 = string3.indexOf(46);
            if (n2 == -1) {
                this.badAddress(null);
            }
            try {
                iIOPEndpointInfo.setVersion(Integer.parseInt(string3.substring(0, n2)), Integer.parseInt(string3.substring(n2 + 1)));
                string2 = stringTokenizer.nextToken();
            }
            catch (Throwable throwable) {
                this.badAddress(throwable);
            }
        }
        try {
            int n3 = string2.indexOf(91);
            if (n3 != -1) {
                String string4 = this.getIPV6Port(string2);
                if (string4 != null) {
                    iIOPEndpointInfo.setPort(Integer.parseInt(string4));
                }
                iIOPEndpointInfo.setHost(this.getIPV6Host(string2));
                return iIOPEndpointInfo;
            }
            stringTokenizer = new StringTokenizer(string2, ":");
            if (stringTokenizer.countTokens() == 2) {
                iIOPEndpointInfo.setHost(stringTokenizer.nextToken());
                iIOPEndpointInfo.setPort(Integer.parseInt(stringTokenizer.nextToken()));
            } else if (string2 != null && string2.length() != 0) {
                iIOPEndpointInfo.setHost(string2);
            }
        }
        catch (Throwable throwable) {
            this.badAddress(throwable);
        }
        Utility.validateGIOPVersion(iIOPEndpointInfo);
        return iIOPEndpointInfo;
    }

    private void handleRIRColon(String string) {
        if (string.length() != 4) {
            this.badAddress(null);
        }
    }

    private String getIPV6Port(String string) {
        int n = string.indexOf(93);
        if (n + 1 != string.length()) {
            if (string.charAt(n + 1) != ':') {
                throw new RuntimeException("Host and Port is not separated by ':'");
            }
            return string.substring(n + 2);
        }
        return null;
    }

    private String getIPV6Host(String string) {
        int n = string.indexOf(93);
        String string2 = string.substring(1, n);
        return string2;
    }

    public boolean isCorbanameURL() {
        return false;
    }
}

