/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.encoding.xml;

import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.pipe.Codec;
import com.sun.xml.internal.ws.api.pipe.ContentType;
import com.sun.xml.internal.ws.api.streaming.XMLStreamWriterFactory;
import com.sun.xml.internal.ws.encoding.ContentTypeImpl;
import com.sun.xml.internal.ws.encoding.xml.XMLMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.ws.WebServiceException;

public final class XMLCodec
implements Codec {
    public static final String XML_APPLICATION_MIME_TYPE = "application/xml";
    public static final String XML_TEXT_MIME_TYPE = "text/xml";
    private static final ContentType contentType = new ContentTypeImpl("text/xml");

    public String getMimeType() {
        return XML_APPLICATION_MIME_TYPE;
    }

    public ContentType getStaticContentType(Packet packet) {
        return contentType;
    }

    public ContentType encode(Packet packet, OutputStream outputStream) {
        XMLStreamWriter xMLStreamWriter = XMLStreamWriterFactory.create(outputStream);
        try {
            if (packet.getMessage().hasPayload()) {
                packet.getMessage().writePayloadTo(xMLStreamWriter);
                xMLStreamWriter.flush();
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new WebServiceException(xMLStreamException);
        }
        return contentType;
    }

    public ContentType encode(Packet packet, WritableByteChannel writableByteChannel) {
        throw new UnsupportedOperationException();
    }

    public Codec copy() {
        return this;
    }

    public void decode(InputStream inputStream, String string, Packet packet) throws IOException {
        Message message = XMLMessage.create(string, inputStream);
        packet.setMessage(message);
    }

    public void decode(ReadableByteChannel readableByteChannel, String string, Packet packet) {
        throw new UnsupportedOperationException();
    }
}

