/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.fastinfoset.dom;

import com.sun.xml.internal.fastinfoset.CommonResourceBundle;
import com.sun.xml.internal.fastinfoset.Decoder;
import com.sun.xml.internal.fastinfoset.DecoderStateTables;
import com.sun.xml.internal.fastinfoset.QualifiedName;
import com.sun.xml.internal.fastinfoset.algorithm.BuiltInEncodingAlgorithmFactory;
import com.sun.xml.internal.fastinfoset.util.CharArray;
import com.sun.xml.internal.fastinfoset.util.CharArrayString;
import com.sun.xml.internal.org.jvnet.fastinfoset.EncodingAlgorithm;
import com.sun.xml.internal.org.jvnet.fastinfoset.EncodingAlgorithmException;
import com.sun.xml.internal.org.jvnet.fastinfoset.FastInfosetException;
import java.io.IOException;
import java.io.InputStream;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DOMDocumentParser
extends Decoder {
    protected Document _document;
    protected Node _currentNode;
    protected Element _currentElement;
    protected Attr[] _namespaceAttributes = new Attr[16];
    protected int _namespaceAttributesIndex;
    protected int[] _namespacePrefixes = new int[16];
    protected int _namespacePrefixesIndex;

    public void parse(Document document, InputStream inputStream) throws FastInfosetException, IOException {
        this._document = document;
        this._currentNode = this._document;
        this._namespaceAttributesIndex = 0;
        this.parse(inputStream);
    }

    protected final void parse(InputStream inputStream) throws FastInfosetException, IOException {
        this.setInputStream(inputStream);
        this.parse();
    }

    protected void resetOnError() {
        this._namespacePrefixesIndex = 0;
        if (this._v == null) {
            this._prefixTable.clearCompletely();
        }
        this._duplicateAttributeVerifier.clear();
    }

    protected final void parse() throws FastInfosetException, IOException {
        try {
            this.reset();
            this.decodeHeader();
            this.processDII();
        }
        catch (RuntimeException runtimeException) {
            this.resetOnError();
            throw new FastInfosetException(runtimeException);
        }
        catch (FastInfosetException fastInfosetException) {
            this.resetOnError();
            throw fastInfosetException;
        }
        catch (IOException iOException) {
            this.resetOnError();
            throw iOException;
        }
    }

    protected final void processDII() throws FastInfosetException, IOException {
        this._b = this.read();
        if (this._b > 0) {
            this.processDIIOptionalProperties();
        }
        boolean bl = false;
        boolean bl2 = false;
        block24: while (!this._terminate || !bl) {
            this._b = this.read();
            switch (DecoderStateTables.DII[this._b]) {
                case 0: {
                    this.processEII(this._elementNameTable._array[this._b], false);
                    bl = true;
                    continue block24;
                }
                case 1: {
                    this.processEII(this._elementNameTable._array[this._b & 0x1F], true);
                    bl = true;
                    continue block24;
                }
                case 2: {
                    this.processEII(this.decodeEIIIndexMedium(), (this._b & 0x40) > 0);
                    bl = true;
                    continue block24;
                }
                case 3: {
                    this.processEII(this.decodeEIIIndexLarge(), (this._b & 0x40) > 0);
                    bl = true;
                    continue block24;
                }
                case 5: {
                    QualifiedName qualifiedName = this.processLiteralQualifiedName(this._b & 3, this._elementNameTable.getNext());
                    this._elementNameTable.add(qualifiedName);
                    this.processEII(qualifiedName, (this._b & 0x40) > 0);
                    bl = true;
                    continue block24;
                }
                case 4: {
                    this.processEIIWithNamespaces();
                    bl = true;
                    continue block24;
                }
                case 20: {
                    if (bl2) {
                        throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.secondOccurenceOfDTDII"));
                    }
                    bl2 = true;
                    QualifiedName qualifiedName = (this._b & 2) > 0 ? this.decodeIdentifyingNonEmptyStringOnFirstBit(this._v.otherURI) : null;
                    String string = (this._b & 1) > 0 ? this.decodeIdentifyingNonEmptyStringOnFirstBit(this._v.otherURI) : null;
                    this._b = this.read();
                    while (this._b == 225) {
                        switch (this.decodeNonIdentifyingStringOnFirstBit()) {
                            case 0: {
                                if (!this._addToTable) break;
                                this._v.otherString.add(new CharArray(this._charBuffer, 0, this._charBufferLength, true));
                                break;
                            }
                            case 2: {
                                throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.processingIIWithEncodingAlgorithm"));
                            }
                            case 1: {
                                break;
                            }
                        }
                        this._b = this.read();
                    }
                    if ((this._b & 0xF0) != 240) {
                        throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.processingInstructionIIsNotTerminatedCorrectly"));
                    }
                    if (this._b == 255) {
                        this._terminate = true;
                    }
                    this._notations.clear();
                    this._unparsedEntities.clear();
                    continue block24;
                }
                case 18: {
                    this.processCommentII();
                    continue block24;
                }
                case 19: {
                    this.processProcessingII();
                    continue block24;
                }
                case 23: {
                    this._doubleTerminate = true;
                }
                case 22: {
                    this._terminate = true;
                    continue block24;
                }
            }
            throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.IllegalStateDecodingDII"));
        }
        block26: while (!this._terminate) {
            this._b = this.read();
            switch (DecoderStateTables.DII[this._b]) {
                case 18: {
                    this.processCommentII();
                    continue block26;
                }
                case 19: {
                    this.processProcessingII();
                    continue block26;
                }
                case 23: {
                    this._doubleTerminate = true;
                }
                case 22: {
                    this._terminate = true;
                    continue block26;
                }
            }
            throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.IllegalStateDecodingDII"));
        }
    }

    protected final void processDIIOptionalProperties() throws FastInfosetException, IOException {
        if (this._b == 32) {
            this.decodeInitialVocabulary();
            return;
        }
        if ((this._b & 0x40) > 0) {
            this.decodeAdditionalData();
        }
        if ((this._b & 0x20) > 0) {
            this.decodeInitialVocabulary();
        }
        if ((this._b & 0x10) > 0) {
            this.decodeNotations();
        }
        if ((this._b & 8) > 0) {
            this.decodeUnparsedEntities();
        }
        if ((this._b & 4) > 0) {
            String string = this.decodeCharacterEncodingScheme();
        }
        if ((this._b & 2) > 0) {
            boolean bl;
            boolean bl2 = bl = this.read() > 0;
        }
        if ((this._b & 1) > 0) {
            this.decodeVersion();
        }
    }

    protected final void processEII(QualifiedName qualifiedName, boolean bl) throws FastInfosetException, IOException {
        int n;
        if (this._prefixTable._currentInScope[qualifiedName.prefixIndex] != qualifiedName.namespaceNameIndex) {
            throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.qnameOfEIINotInScope"));
        }
        Node node = this._currentNode;
        this._currentElement = this.createElement(qualifiedName.namespaceName, qualifiedName.qName, qualifiedName.localName);
        this._currentNode = this._currentElement;
        if (this._namespaceAttributesIndex > 0) {
            for (n = 0; n < this._namespaceAttributesIndex; ++n) {
                this._currentElement.setAttributeNode(this._namespaceAttributes[n]);
                this._namespaceAttributes[n] = null;
            }
            this._namespaceAttributesIndex = 0;
        }
        if (bl) {
            this.processAIIs();
        }
        node.appendChild(this._currentElement);
        block26: while (!this._terminate) {
            this._b = this.read();
            switch (DecoderStateTables.EII[this._b]) {
                case 0: {
                    this.processEII(this._elementNameTable._array[this._b], false);
                    continue block26;
                }
                case 1: {
                    this.processEII(this._elementNameTable._array[this._b & 0x1F], true);
                    continue block26;
                }
                case 2: {
                    this.processEII(this.decodeEIIIndexMedium(), (this._b & 0x40) > 0);
                    continue block26;
                }
                case 3: {
                    this.processEII(this.decodeEIIIndexLarge(), (this._b & 0x40) > 0);
                    continue block26;
                }
                case 5: {
                    QualifiedName qualifiedName2 = this.processLiteralQualifiedName(this._b & 3, this._elementNameTable.getNext());
                    this._elementNameTable.add(qualifiedName2);
                    this.processEII(qualifiedName2, (this._b & 0x40) > 0);
                    continue block26;
                }
                case 4: {
                    this.processEIIWithNamespaces();
                    continue block26;
                }
                case 6: {
                    this._octetBufferLength = (this._b & 1) + 1;
                    this.processUtf8CharacterString();
                    continue block26;
                }
                case 7: {
                    this._octetBufferLength = this.read() + 3;
                    this.processUtf8CharacterString();
                    continue block26;
                }
                case 8: {
                    this._octetBufferLength = this.read() << 24 | this.read() << 16 | this.read() << 8 | this.read();
                    this._octetBufferLength += 259;
                    this.processUtf8CharacterString();
                    continue block26;
                }
                case 9: {
                    this._octetBufferLength = (this._b & 1) + 1;
                    String string = this.decodeUtf16StringAsString();
                    if ((this._b & 0x10) > 0) {
                        this._characterContentChunkTable.add(this._charBuffer, this._charBufferLength);
                    }
                    this._currentNode.appendChild(this._document.createTextNode(string));
                    continue block26;
                }
                case 10: {
                    this._octetBufferLength = this.read() + 3;
                    String string = this.decodeUtf16StringAsString();
                    if ((this._b & 0x10) > 0) {
                        this._characterContentChunkTable.add(this._charBuffer, this._charBufferLength);
                    }
                    this._currentNode.appendChild(this._document.createTextNode(string));
                    continue block26;
                }
                case 11: {
                    this._octetBufferLength = this.read() << 24 | this.read() << 16 | this.read() << 8 | this.read();
                    this._octetBufferLength += 259;
                    String string = this.decodeUtf16StringAsString();
                    if ((this._b & 0x10) > 0) {
                        this._characterContentChunkTable.add(this._charBuffer, this._charBufferLength);
                    }
                    this._currentNode.appendChild(this._document.createTextNode(string));
                    continue block26;
                }
                case 12: {
                    n = (this._b & 0x10) > 0 ? 1 : 0;
                    this._identifier = (this._b & 2) << 6;
                    this._b = this.read();
                    this._identifier |= (this._b & 0xFC) >> 2;
                    this.decodeOctetsOnSeventhBitOfNonIdentifyingStringOnThirdBit(this._b);
                    String string2 = this.decodeRestrictedAlphabetAsString();
                    if (n != 0) {
                        this._characterContentChunkTable.add(this._charBuffer, this._charBufferLength);
                    }
                    this._currentNode.appendChild(this._document.createTextNode(string2));
                    continue block26;
                }
                case 13: {
                    if ((this._b & 0x40) > 0) {
                        throw new EncodingAlgorithmException(CommonResourceBundle.getInstance().getString("message.addToTableNotSupported"));
                    }
                    this._identifier = (this._b & 2) << 6;
                    this._b = this.read();
                    this._identifier |= (this._b & 0xFC) >> 2;
                    this.decodeOctetsOnSeventhBitOfNonIdentifyingStringOnThirdBit(this._b);
                    String string = this.convertEncodingAlgorithmDataToCharacters(false);
                    this._currentNode.appendChild(this._document.createTextNode(string));
                    continue block26;
                }
                case 14: {
                    String string = this._characterContentChunkTable.getString(this._b & 0xF);
                    this._currentNode.appendChild(this._document.createTextNode(string));
                    continue block26;
                }
                case 15: {
                    n = ((this._b & 3) << 8 | this.read()) + 16;
                    String string2 = this._characterContentChunkTable.getString(n);
                    this._currentNode.appendChild(this._document.createTextNode(string2));
                    continue block26;
                }
                case 16: {
                    n = (this._b & 3) << 16 | this.read() << 8 | this.read();
                    String string2 = this._characterContentChunkTable.getString(n += 1040);
                    this._currentNode.appendChild(this._document.createTextNode(string2));
                    continue block26;
                }
                case 17: {
                    n = this.read() << 16 | this.read() << 8 | this.read();
                    String string2 = this._characterContentChunkTable.getString(n += 263184);
                    this._currentNode.appendChild(this._document.createTextNode(string2));
                    continue block26;
                }
                case 18: {
                    this.processCommentII();
                    continue block26;
                }
                case 19: {
                    this.processProcessingII();
                    continue block26;
                }
                case 21: {
                    String string = this.decodeIdentifyingNonEmptyStringOnFirstBit(this._v.otherNCName);
                    String string2 = (this._b & 2) > 0 ? this.decodeIdentifyingNonEmptyStringOnFirstBit(this._v.otherURI) : null;
                    String string3 = (this._b & 1) > 0 ? this.decodeIdentifyingNonEmptyStringOnFirstBit(this._v.otherURI) : null;
                    continue block26;
                }
                case 23: {
                    this._doubleTerminate = true;
                }
                case 22: {
                    this._terminate = true;
                    continue block26;
                }
            }
            throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.IllegalStateDecodingEII"));
        }
        this._terminate = this._doubleTerminate;
        this._doubleTerminate = false;
        this._currentNode = node;
    }

    private final void processUtf8CharacterString() throws FastInfosetException, IOException {
        if ((this._b & 0x10) > 0) {
            this._characterContentChunkTable.ensureSize(this._octetBufferLength);
            int n = this._characterContentChunkTable._arrayIndex;
            this.decodeUtf8StringAsCharBuffer(this._characterContentChunkTable._array, n);
            this._characterContentChunkTable.add(this._charBufferLength);
            this._currentNode.appendChild(this._document.createTextNode(this._characterContentChunkTable.getString(this._characterContentChunkTable._cachedIndex)));
        } else {
            this.decodeUtf8StringAsCharBuffer();
            this._currentNode.appendChild(this._document.createTextNode(new String(this._charBuffer, 0, this._charBufferLength)));
        }
    }

    protected final void processEIIWithNamespaces() throws FastInfosetException, IOException {
        boolean bl;
        boolean bl2 = bl = (this._b & 0x40) > 0;
        if (++this._prefixTable._declarationId == Integer.MAX_VALUE) {
            this._prefixTable.clearDeclarationIds();
        }
        Attr attr = null;
        int n = this._namespacePrefixesIndex;
        int n2 = this.read();
        while ((n2 & 0xFC) == 204) {
            Object[] objectArray;
            if (this._namespaceAttributesIndex == this._namespaceAttributes.length) {
                objectArray = new Attr[this._namespaceAttributesIndex * 3 / 2 + 1];
                System.arraycopy(this._namespaceAttributes, 0, objectArray, 0, this._namespaceAttributesIndex);
                this._namespaceAttributes = objectArray;
            }
            if (this._namespacePrefixesIndex == this._namespacePrefixes.length) {
                objectArray = new int[this._namespacePrefixesIndex * 3 / 2 + 1];
                System.arraycopy(this._namespacePrefixes, 0, objectArray, 0, this._namespacePrefixesIndex);
                this._namespacePrefixes = (int[])objectArray;
            }
            switch (n2 & 3) {
                case 0: {
                    attr = this.createAttribute("http://www.w3.org/2000/xmlns/", "xmlns", "xmlns");
                    attr.setValue("");
                    this._namespacePrefixes[this._namespacePrefixesIndex++] = -1;
                    this._namespaceNameIndex = -1;
                    this._prefixIndex = -1;
                    break;
                }
                case 1: {
                    attr = this.createAttribute("http://www.w3.org/2000/xmlns/", "xmlns", "xmlns");
                    attr.setValue(this.decodeIdentifyingNonEmptyStringOnFirstBitAsNamespaceName(false));
                    this._namespacePrefixes[this._namespacePrefixesIndex++] = -1;
                    this._prefixIndex = -1;
                    break;
                }
                case 2: {
                    String string = this.decodeIdentifyingNonEmptyStringOnFirstBitAsPrefix(false);
                    attr = this.createAttribute("http://www.w3.org/2000/xmlns/", this.createQualifiedNameString(XMLNS_NAMESPACE_PREFIX_CHARS, string), string);
                    attr.setValue("");
                    this._namespaceNameIndex = -1;
                    this._namespacePrefixes[this._namespacePrefixesIndex++] = this._prefixIndex;
                    break;
                }
                case 3: {
                    String string = this.decodeIdentifyingNonEmptyStringOnFirstBitAsPrefix(true);
                    attr = this.createAttribute("http://www.w3.org/2000/xmlns/", this.createQualifiedNameString(XMLNS_NAMESPACE_PREFIX_CHARS, string), string);
                    attr.setValue(this.decodeIdentifyingNonEmptyStringOnFirstBitAsNamespaceName(true));
                    this._namespacePrefixes[this._namespacePrefixesIndex++] = this._prefixIndex;
                }
            }
            this._prefixTable.pushScope(this._prefixIndex, this._namespaceNameIndex);
            this._namespaceAttributes[this._namespaceAttributesIndex++] = attr;
            n2 = this.read();
        }
        if (n2 != 240) {
            throw new IOException(CommonResourceBundle.getInstance().getString("message.EIInamespaceNameNotTerminatedCorrectly"));
        }
        int n3 = this._namespacePrefixesIndex;
        this._b = this.read();
        switch (DecoderStateTables.EII[this._b]) {
            case 0: {
                this.processEII(this._elementNameTable._array[this._b], bl);
                break;
            }
            case 2: {
                this.processEII(this.decodeEIIIndexMedium(), bl);
                break;
            }
            case 3: {
                this.processEII(this.decodeEIIIndexLarge(), bl);
                break;
            }
            case 5: {
                QualifiedName qualifiedName = this.processLiteralQualifiedName(this._b & 3, this._elementNameTable.getNext());
                this._elementNameTable.add(qualifiedName);
                this.processEII(qualifiedName, bl);
                break;
            }
            default: {
                throw new IOException(CommonResourceBundle.getInstance().getString("message.IllegalStateDecodingEIIAfterAIIs"));
            }
        }
        for (int i = n; i < n3; ++i) {
            this._prefixTable.popScope(this._namespacePrefixes[i]);
        }
        this._namespacePrefixesIndex = n;
    }

    protected final QualifiedName processLiteralQualifiedName(int n, QualifiedName qualifiedName) throws FastInfosetException, IOException {
        if (qualifiedName == null) {
            qualifiedName = new QualifiedName();
        }
        switch (n) {
            case 0: {
                return qualifiedName.set(null, null, this.decodeIdentifyingNonEmptyStringOnFirstBit(this._v.localName), -1, -1, this._identifier, null);
            }
            case 1: {
                return qualifiedName.set(null, this.decodeIdentifyingNonEmptyStringIndexOnFirstBitAsNamespaceName(false), this.decodeIdentifyingNonEmptyStringOnFirstBit(this._v.localName), -1, this._namespaceNameIndex, this._identifier, null);
            }
            case 2: {
                throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.qNameMissingNamespaceName"));
            }
            case 3: {
                return qualifiedName.set(this.decodeIdentifyingNonEmptyStringIndexOnFirstBitAsPrefix(true), this.decodeIdentifyingNonEmptyStringIndexOnFirstBitAsNamespaceName(true), this.decodeIdentifyingNonEmptyStringOnFirstBit(this._v.localName), this._prefixIndex, this._namespaceNameIndex, this._identifier, this._charBuffer);
            }
        }
        throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.decodingEII"));
    }

    protected final QualifiedName processLiteralQualifiedName(int n) throws FastInfosetException, IOException {
        switch (n) {
            case 0: {
                return new QualifiedName(null, null, this.decodeIdentifyingNonEmptyStringOnFirstBit(this._v.localName), -1, -1, this._identifier, null);
            }
            case 1: {
                return new QualifiedName(null, this.decodeIdentifyingNonEmptyStringIndexOnFirstBitAsNamespaceName(false), this.decodeIdentifyingNonEmptyStringOnFirstBit(this._v.localName), -1, this._namespaceNameIndex, this._identifier, null);
            }
            case 2: {
                throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.qNameMissingNamespaceName"));
            }
            case 3: {
                return new QualifiedName(this.decodeIdentifyingNonEmptyStringIndexOnFirstBitAsPrefix(true), this.decodeIdentifyingNonEmptyStringIndexOnFirstBitAsNamespaceName(true), this.decodeIdentifyingNonEmptyStringOnFirstBit(this._v.localName), this._prefixIndex, this._namespaceNameIndex, this._identifier, this._charBuffer);
            }
        }
        throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.decodingEII"));
    }

    protected final void processAIIs() throws FastInfosetException, IOException {
        if (++this._duplicateAttributeVerifier._currentIteration == Integer.MAX_VALUE) {
            this._duplicateAttributeVerifier.clear();
        }
        block22: do {
            QualifiedName qualifiedName;
            int n = this.read();
            switch (DecoderStateTables.AII[n]) {
                case 0: {
                    qualifiedName = this._attributeNameTable._array[n];
                    break;
                }
                case 1: {
                    int n2 = ((n & 0x1F) << 8 | this.read()) + 64;
                    qualifiedName = this._attributeNameTable._array[n2];
                    break;
                }
                case 2: {
                    int n3 = ((n & 0xF) << 16 | this.read() << 8 | this.read()) + 8256;
                    qualifiedName = this._attributeNameTable._array[n3];
                    break;
                }
                case 3: {
                    qualifiedName = this.processLiteralQualifiedName(n & 3, this._attributeNameTable.getNext());
                    qualifiedName.createAttributeValues(256);
                    this._attributeNameTable.add(qualifiedName);
                    break;
                }
                case 5: {
                    this._doubleTerminate = true;
                }
                case 4: {
                    this._terminate = true;
                    continue block22;
                }
                default: {
                    throw new IOException(CommonResourceBundle.getInstance().getString("message.decodingAIIs"));
                }
            }
            if (qualifiedName.prefixIndex > 0 && this._prefixTable._currentInScope[qualifiedName.prefixIndex] != qualifiedName.namespaceNameIndex) {
                throw new FastInfosetException(CommonResourceBundle.getInstance().getString("message.AIIqNameNotInScope"));
            }
            this._duplicateAttributeVerifier.checkForDuplicateAttribute(qualifiedName.attributeHash, qualifiedName.attributeId);
            Attr attr = this.createAttribute(qualifiedName.namespaceName, qualifiedName.qName, qualifiedName.localName);
            n = this.read();
            switch (DecoderStateTables.NISTRING[n]) {
                case 0: {
                    int n4 = (n & 0x40) > 0 ? 1 : 0;
                    this._octetBufferLength = (n & 7) + 1;
                    String string = this.decodeUtf8StringAsString();
                    if (n4 != 0) {
                        this._attributeValueTable.add(string);
                    }
                    attr.setValue(string);
                    this._currentElement.setAttributeNode(attr);
                    break;
                }
                case 1: {
                    int n4 = (n & 0x40) > 0 ? 1 : 0;
                    this._octetBufferLength = this.read() + 9;
                    String string = this.decodeUtf8StringAsString();
                    if (n4 != 0) {
                        this._attributeValueTable.add(string);
                    }
                    attr.setValue(string);
                    this._currentElement.setAttributeNode(attr);
                    break;
                }
                case 2: {
                    int n4 = (n & 0x40) > 0 ? 1 : 0;
                    int n5 = this.read() << 24 | this.read() << 16 | this.read() << 8 | this.read();
                    this._octetBufferLength = n5 + 265;
                    String string = this.decodeUtf8StringAsString();
                    if (n4 != 0) {
                        this._attributeValueTable.add(string);
                    }
                    attr.setValue(string);
                    this._currentElement.setAttributeNode(attr);
                    break;
                }
                case 3: {
                    int n4 = (n & 0x40) > 0 ? 1 : 0;
                    this._octetBufferLength = (n & 7) + 1;
                    String string = this.decodeUtf16StringAsString();
                    if (n4 != 0) {
                        this._attributeValueTable.add(string);
                    }
                    attr.setValue(string);
                    this._currentElement.setAttributeNode(attr);
                    break;
                }
                case 4: {
                    int n4 = (n & 0x40) > 0 ? 1 : 0;
                    this._octetBufferLength = this.read() + 9;
                    String string = this.decodeUtf16StringAsString();
                    if (n4 != 0) {
                        this._attributeValueTable.add(string);
                    }
                    attr.setValue(string);
                    this._currentElement.setAttributeNode(attr);
                    break;
                }
                case 5: {
                    int n4 = (n & 0x40) > 0 ? 1 : 0;
                    int n5 = this.read() << 24 | this.read() << 16 | this.read() << 8 | this.read();
                    this._octetBufferLength = n5 + 265;
                    String string = this.decodeUtf16StringAsString();
                    if (n4 != 0) {
                        this._attributeValueTable.add(string);
                    }
                    attr.setValue(string);
                    this._currentElement.setAttributeNode(attr);
                    break;
                }
                case 6: {
                    int n4 = (n & 0x40) > 0 ? 1 : 0;
                    this._identifier = (n & 0xF) << 4;
                    n = this.read();
                    this._identifier |= (n & 0xF0) >> 4;
                    this.decodeOctetsOnFifthBitOfNonIdentifyingStringOnFirstBit(n);
                    String string = this.decodeRestrictedAlphabetAsString();
                    if (n4 != 0) {
                        this._attributeValueTable.add(string);
                    }
                    attr.setValue(string);
                    this._currentElement.setAttributeNode(attr);
                    break;
                }
                case 7: {
                    if ((n & 0x40) > 0) {
                        throw new EncodingAlgorithmException(CommonResourceBundle.getInstance().getString("message.addToTableNotSupported"));
                    }
                    this._identifier = (n & 0xF) << 4;
                    n = this.read();
                    this._identifier |= (n & 0xF0) >> 4;
                    this.decodeOctetsOnFifthBitOfNonIdentifyingStringOnFirstBit(n);
                    String string = this.convertEncodingAlgorithmDataToCharacters(true);
                    attr.setValue(string);
                    this._currentElement.setAttributeNode(attr);
                    break;
                }
                case 8: {
                    String string = this._attributeValueTable._array[n & 0x3F];
                    attr.setValue(string);
                    this._currentElement.setAttributeNode(attr);
                    break;
                }
                case 9: {
                    int n4 = ((n & 0x1F) << 8 | this.read()) + 64;
                    String string = this._attributeValueTable._array[n4];
                    attr.setValue(string);
                    this._currentElement.setAttributeNode(attr);
                    break;
                }
                case 10: {
                    int n4 = ((n & 0xF) << 16 | this.read() << 8 | this.read()) + 8256;
                    String string = this._attributeValueTable._array[n4];
                    attr.setValue(string);
                    this._currentElement.setAttributeNode(attr);
                    break;
                }
                case 11: {
                    attr.setValue("");
                    this._currentElement.setAttributeNode(attr);
                    break;
                }
                default: {
                    throw new IOException(CommonResourceBundle.getInstance().getString("message.decodingAIIValue"));
                }
            }
        } while (!this._terminate);
        this._duplicateAttributeVerifier._poolCurrent = this._duplicateAttributeVerifier._poolHead;
        this._terminate = this._doubleTerminate;
        this._doubleTerminate = false;
    }

    protected final void processCommentII() throws FastInfosetException, IOException {
        switch (this.decodeNonIdentifyingStringOnFirstBit()) {
            case 0: {
                String string = new String(this._charBuffer, 0, this._charBufferLength);
                if (this._addToTable) {
                    this._v.otherString.add(new CharArrayString(string, false));
                }
                this._currentNode.appendChild(this._document.createComment(string));
                break;
            }
            case 2: {
                throw new IOException(CommonResourceBundle.getInstance().getString("message.commentIIAlgorithmNotSupported"));
            }
            case 1: {
                String string = this._v.otherString.get(this._integer).toString();
                this._currentNode.appendChild(this._document.createComment(string));
                break;
            }
            case 3: {
                this._currentNode.appendChild(this._document.createComment(""));
            }
        }
    }

    protected final void processProcessingII() throws FastInfosetException, IOException {
        String string = this.decodeIdentifyingNonEmptyStringOnFirstBit(this._v.otherNCName);
        switch (this.decodeNonIdentifyingStringOnFirstBit()) {
            case 0: {
                String string2 = new String(this._charBuffer, 0, this._charBufferLength);
                if (this._addToTable) {
                    this._v.otherString.add(new CharArrayString(string2, false));
                }
                this._currentNode.appendChild(this._document.createProcessingInstruction(string, string2));
                break;
            }
            case 2: {
                throw new IOException(CommonResourceBundle.getInstance().getString("message.processingIIWithEncodingAlgorithm"));
            }
            case 1: {
                String string3 = this._v.otherString.get(this._integer).toString();
                this._currentNode.appendChild(this._document.createProcessingInstruction(string, string3));
                break;
            }
            case 3: {
                this._currentNode.appendChild(this._document.createProcessingInstruction(string, ""));
            }
        }
    }

    protected Element createElement(String string, String string2, String string3) {
        return this._document.createElementNS(string, string2);
    }

    protected Attr createAttribute(String string, String string2, String string3) {
        return this._document.createAttributeNS(string, string2);
    }

    protected String convertEncodingAlgorithmDataToCharacters(boolean bl) throws FastInfosetException, IOException {
        StringBuffer stringBuffer = new StringBuffer();
        if (this._identifier < 9) {
            Object object = BuiltInEncodingAlgorithmFactory.table[this._identifier].decodeFromBytes(this._octetBuffer, this._octetBufferStart, this._octetBufferLength);
            BuiltInEncodingAlgorithmFactory.table[this._identifier].convertToCharacters(object, stringBuffer);
        } else {
            if (this._identifier == 9) {
                if (!bl) {
                    this._octetBufferOffset -= this._octetBufferLength;
                    return this.decodeUtf8StringAsString();
                }
                throw new EncodingAlgorithmException(CommonResourceBundle.getInstance().getString("message.CDATAAlgorithmNotSupported"));
            }
            if (this._identifier >= 32) {
                String string = this._v.encodingAlgorithm.get(this._identifier - 32);
                EncodingAlgorithm encodingAlgorithm = (EncodingAlgorithm)this._registeredEncodingAlgorithms.get(string);
                if (encodingAlgorithm != null) {
                    Object object = encodingAlgorithm.decodeFromBytes(this._octetBuffer, this._octetBufferStart, this._octetBufferLength);
                    encodingAlgorithm.convertToCharacters(object, stringBuffer);
                } else {
                    throw new EncodingAlgorithmException(CommonResourceBundle.getInstance().getString("message.algorithmDataCannotBeReported"));
                }
            }
        }
        return stringBuffer.toString();
    }
}

