/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.panel;

import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.panel.ControlPanel;
import com.sun.deploy.panel.JreFindDialog;
import com.sun.deploy.panel.PathEditor;
import com.sun.deploy.panel.PathRenderer;
import com.sun.deploy.panel.PluginTableModel;
import com.sun.deploy.panel.SpecialTableRenderer;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.ui.DialogTemplate;
import com.sun.deploy.util.Trace;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class PluginJreDialog
extends JDialog
implements ListSelectionListener {
    private JTable jresTable;
    private JButton okBtn;
    private JButton cancelBtn;
    private JButton findBtn;
    private JButton addBtn;
    private JButton removeBtn;

    public PluginJreDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
    }

    private void initComponents() {
        Serializable serializable;
        this.setTitle(this.getMessage("jpi.jres.dialog.title"));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PluginJreDialog.this.closeDialog(windowEvent);
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(new TitledBorder(this.getMessage("jpi.jres.dialog.border")));
        this.jresTable = new JTable(new PluginTableModel());
        this.jresTable.setBorder(new LineBorder(Color.black));
        this.jresTable.setPreferredScrollableViewportSize(new Dimension(500, 70));
        this.jresTable.getSelectionModel().addListSelectionListener(this);
        this.jresTable.getTableHeader().setFocusable(false);
        Enumeration<TableColumn> enumeration = this.jresTable.getColumnModel().getColumns();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            serializable = enumeration.nextElement();
            if (n < 4) {
                serializable.setCellRenderer(new SpecialTableRenderer());
            }
            ++n;
        }
        this.jresTable.getColumnModel().getColumn(2).setCellRenderer(new PathRenderer());
        this.jresTable.getColumnModel().getColumn(2).setCellEditor(new PathEditor());
        serializable = new JScrollPane(this.jresTable);
        jPanel.add((Component)serializable, "Center");
        JPanel jPanel2 = new JPanel(new FlowLayout(2));
        this.findBtn = new JButton(this.getMessage("jnlp.jre.find.button"));
        this.findBtn.setMnemonic(ResourceManager.getVKCode("jnlp.jre.find.button.mnemonic"));
        this.findBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PluginJreDialog.this.findJREs();
            }
        });
        this.addBtn = new JButton(this.getMessage("common.add_btn"));
        this.addBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PluginJreDialog.this.addBtnActionPerformed(actionEvent);
            }
        });
        this.addBtn.setToolTipText(this.getMessage("vm.options.add_btn.tooltip"));
        this.addBtn.setMnemonic(ResourceManager.getVKCode("common.add_btn.mnemonic"));
        this.removeBtn = new JButton(this.getMessage("common.remove_btn"));
        this.removeBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PluginJreDialog.this.removeBtnActionPerformed(actionEvent);
            }
        });
        this.removeBtn.setMnemonic(ResourceManager.getVKCode("common.remove_btn.mnemonic"));
        this.removeBtn.setEnabled(false);
        this.removeBtn.setToolTipText(this.getMessage("vm.options.remove_btn.tooltip"));
        JButton[] jButtonArray = new JButton[]{this.findBtn, this.addBtn, this.removeBtn};
        DialogTemplate.resizeButtons(jButtonArray);
        jPanel2.add(this.findBtn);
        jPanel2.add(this.addBtn);
        jPanel2.add(this.removeBtn);
        jPanel.add((Component)jPanel2, "South");
        this.getContentPane().add((Component)jPanel, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(2, 10, 5));
        this.okBtn = new JButton(this.getMessage("common.ok_btn"));
        this.okBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PluginJreDialog.this.okBtnActionPerformed(actionEvent);
            }
        });
        jPanel3.add(this.okBtn);
        this.cancelBtn = new JButton(this.getMessage("common.cancel_btn"));
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                PluginJreDialog.this.cancelBtnActionPerformed(actionEvent);
            }
        };
        this.cancelBtn.addActionListener(abstractAction);
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "cancel");
        this.getRootPane().getActionMap().put("cancel", abstractAction);
        JButton[] jButtonArray2 = new JButton[]{this.okBtn, this.cancelBtn};
        DialogTemplate.resizeButtons(jButtonArray2);
        jPanel3.add(this.cancelBtn);
        this.getContentPane().add((Component)jPanel3, "South");
        this.getRootPane().setDefaultButton(this.okBtn);
        this.pack();
    }

    private void addBtnActionPerformed(ActionEvent actionEvent) {
        PluginTableModel pluginTableModel = (PluginTableModel)this.jresTable.getModel();
        pluginTableModel.add(new JREInfo(null, null, null, null, "", Config.getOSName(), Config.getOSArch(), true, false), false, true);
        int n = pluginTableModel.getRowCount() - 1;
        this.jresTable.requestFocus();
        this.jresTable.setRowSelectionInterval(n, n);
    }

    private void removeBtnActionPerformed(ActionEvent actionEvent) {
        ((PluginTableModel)this.jresTable.getModel()).remove(this.jresTable.getSelectedRows());
    }

    private void okBtnActionPerformed(ActionEvent actionEvent) {
        PluginTableModel pluginTableModel;
        if (this.jresTable.isEditing()) {
            this.jresTable.getCellEditor().stopCellEditing();
        }
        if ((pluginTableModel = (PluginTableModel)this.jresTable.getModel()).getRowCount() >= 0) {
            JREInfo.clear();
            for (int i = 0; i < pluginTableModel.getRowCount(); ++i) {
                JREInfo.addJRE(pluginTableModel.getJRE(i));
            }
            JREInfo.addHomeJRE2SystemList();
        }
        ControlPanel.propertyHasChanged();
        this.setVisible(false);
        this.dispose();
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    private void setProductTableColumn(TableColumn tableColumn) {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem(this.getMessage("jpi.jre.string"));
        jComboBox.addItem(this.getMessage("jpi.jdk.string"));
        tableColumn.setCellEditor(new DefaultCellEditor(jComboBox));
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        defaultTableCellRenderer.setToolTipText(this.getMessage("jpi.jres.dialog.product.tooltip"));
        tableColumn.setCellRenderer(defaultTableCellRenderer);
    }

    private String getMessage(String string) {
        return ResourceManager.getMessage(string);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.enableButtons();
    }

    private void enableButtons() {
        int[] nArray = this.jresTable.getSelectedRows();
        PluginTableModel pluginTableModel = (PluginTableModel)this.jresTable.getModel();
        for (int i = 0; i < nArray.length; ++i) {
            if (pluginTableModel.getJRE(nArray[i]).isRegistered()) {
                this.removeBtn.setEnabled(false);
                break;
            }
            this.removeBtn.setEnabled(true);
        }
    }

    private void findJREs() {
        PluginTableModel pluginTableModel = (PluginTableModel)this.jresTable.getModel();
        try {
            JREInfo[] jREInfoArray = JreFindDialog.search(this, true);
            if (jREInfoArray != null) {
                for (int i = 0; i < jREInfoArray.length; ++i) {
                    pluginTableModel.add(new JREInfo(jREInfoArray[i]), false, true);
                }
            }
        }
        catch (Exception exception) {
            Trace.ignoredException(exception);
        }
    }
}

