/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.setup.Controller;

import java.io.File;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.openoffice.setup.InstallData;
import org.openoffice.setup.Installer.Installer;
import org.openoffice.setup.Installer.InstallerFactory;
import org.openoffice.setup.Panel.ChooseDirectory;
import org.openoffice.setup.PanelController;
import org.openoffice.setup.ResourceManager;
import org.openoffice.setup.SetupData.PackageDescription;
import org.openoffice.setup.SetupData.SetupDataProvider;
import org.openoffice.setup.Util.Controller;
import org.openoffice.setup.Util.Dumper;
import org.openoffice.setup.Util.Informer;
import org.openoffice.setup.Util.InstallChangeCtrl;
import org.openoffice.setup.Util.LogManager;
import org.openoffice.setup.Util.ModuleCtrl;
import org.openoffice.setup.Util.PackageCollector;
import org.openoffice.setup.Util.SystemManager;

public class ChooseDirectoryCtrl
extends PanelController {
    private String helpFile = "String_Helpfile_ChooseDirectory";

    public ChooseDirectoryCtrl() {
        super("ChooseDirectory", new ChooseDirectory());
    }

    public String getNext() {
        InstallData data = InstallData.getInstance();
        if (data.olderVersionExists()) {
            return new String("InstallationImminent");
        }
        if (data.sameVersionExists()) {
            return new String("ChooseComponents");
        }
        return new String("ChooseInstallationType");
    }

    public String getPrevious() {
        return new String("AcceptLicense");
    }

    public final String getHelpFileName() {
        return this.helpFile;
    }

    private String removeEndingDelimiter(String s) {
        s.trim();
        if (s.endsWith("/") || s.endsWith("\\")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public void beforeShow() {
        ChooseDirectory panel = (ChooseDirectory)this.getPanel();
        InstallData data = InstallData.getInstance();
        panel.setDirectory(data.getInstallDir());
        if (data.isSolarisUserInstallation()) {
            if (data.getInstallRoot() == null) {
                String rootDir = "/";
                if (System.getProperty("HOME") != null && !System.getProperty("HOME").equals("")) {
                    rootDir = System.getProperty("user.home");
                }
                data.setInstallRoot(rootDir);
            }
            panel.setRootDirectory(data.getInstallRoot());
        }
        if (data.isRootInstallation() && data.isChangeInstallation()) {
            String dialogTitle;
            panel.setDirectory(data.getInstallDir());
            panel.disableDirectoryField();
            panel.disableBrowseButton();
            if (data.sameVersionExists()) {
                dialogTitle = ResourceManager.getString("String_ChooseDirectory1_Maintain");
                panel.setTitleText(dialogTitle);
            }
            if (data.olderVersionExists()) {
                dialogTitle = ResourceManager.getString("String_ChooseDirectory1_Update");
                panel.setTitleText(dialogTitle);
            }
        }
    }

    public boolean afterShow(boolean nextButtonPressed) {
        boolean repeatDialog = false;
        ChooseDirectory panel = (ChooseDirectory)this.getPanel();
        String dir = panel.getDirectory();
        dir = this.removeEndingDelimiter(dir);
        InstallData data = InstallData.getInstance();
        data.setInstallDir(dir);
        if (data.isSolarisUserInstallation()) {
            String rootDir = panel.getRootDirectory();
            rootDir = this.removeEndingDelimiter(rootDir);
            data.setInstallRoot(rootDir);
            File completeDir = new File(rootDir, dir);
            dir = completeDir.getPath();
        }
        SetupDataProvider.setNewMacro("DIR", dir);
        if (nextButtonPressed) {
            if (SystemManager.exists_directory(dir) && !Controller.createdSubDirectory(dir)) {
                repeatDialog = true;
            }
            if (!SystemManager.exists_directory(dir)) {
                String title = ResourceManager.getString("String_ChooseDirectory4_Question_Title");
                String message = null;
                message = ResourceManager.getString("String_ChooseDirectory5_Question_Message");
                int returnValue = JOptionPane.showConfirmDialog(null, message, title, 0, 3);
                if (returnValue == 0) {
                    if (!Controller.createdDirectory(dir)) {
                        repeatDialog = true;
                    }
                } else if (returnValue == 1) {
                    repeatDialog = true;
                }
            }
            if (!repeatDialog) {
                int discSpace = SystemManager.calculateDiscSpace(dir);
                data.setAvailableDiscSpace(discSpace);
                Installer installer = InstallerFactory.getInstance();
                if (data.isUserInstallation()) {
                    String oldDatabasePath = data.getDatabasePath();
                    installer.defineDatabasePath();
                    if (oldDatabasePath == null || !oldDatabasePath.equals(data.getDatabasePath())) {
                        data.setDatabaseAnalyzed(false);
                    } else {
                        data.setDatabaseAnalyzed(true);
                    }
                }
                if (data.isUserInstallation()) {
                    LogManager.setCommandsHeaderLine("Checking change installation");
                    InstallChangeCtrl.checkInstallChange(data);
                }
                if (data.newerVersionExists()) {
                    String message = ResourceManager.getString("String_Newer_Version_Installed_Found") + "\n" + data.getInstallDir() + "\n" + ResourceManager.getString("String_Newer_Version_Database") + ": " + data.getDatabasePath() + "\n" + ResourceManager.getString("String_Newer_Version_Tip");
                    String title = ResourceManager.getString("String_Error");
                    Informer.showErrorMessage(message, title);
                    repeatDialog = true;
                }
                if (!repeatDialog && !data.databaseAnalyzed()) {
                    PackageDescription packageData = SetupDataProvider.getPackageDescription();
                    if (data.startSelectionStateSaved()) {
                        ModuleCtrl.restoreStartSelectionStates(packageData);
                    } else {
                        ModuleCtrl.saveStartSelectionStates(packageData);
                        data.setStartSelectionStateSaved(true);
                    }
                    if (data.olderVersionExists()) {
                        if (data.logModuleStates()) {
                            Dumper.logModuleStates(packageData, "ChooseDirectory: Before setUpdateOlderProductSettings");
                        }
                        ModuleCtrl.setUpdateOlderProductSettings(packageData, data, installer);
                        if (data.logModuleStates()) {
                            Dumper.logModuleStates(packageData, "ChooseDirectory: After setUpdateOlderProductSettings");
                        }
                        ModuleCtrl.disableNonExistingPackages(packageData, data);
                        if (data.logModuleStates()) {
                            Dumper.logModuleStates(packageData, "ChooseDirectory: After disableNonExistingPackages");
                        }
                        if (data.isUserInstallation()) {
                            ModuleCtrl.setShowInUserInstallFlags(packageData);
                            if (data.logModuleStates()) {
                                Dumper.logModuleStates(packageData, "ChooseDirectory: After setShowInUserInstallFlags");
                            }
                        }
                        Vector installPackages = new Vector();
                        PackageCollector.collectInstallPackages(packageData, installPackages);
                        data.setInstallPackages(installPackages);
                    } else {
                        data.setTypicalSelectionStateSaved(false);
                        data.setCustomSelectionStateSaved(false);
                        if (data.logModuleStates()) {
                            Dumper.logModuleStates(packageData, "analyzeDatabase: Start");
                        }
                        LogManager.setCommandsHeaderLine("Analyzing system database");
                        ModuleCtrl.setDatabaseSettings(packageData, data, installer);
                        if (data.logModuleStates()) {
                            Dumper.logModuleStates(packageData, "analyzeDatabase: After setDatabaseSettings");
                        }
                        ModuleCtrl.disableNonExistingPackages(packageData, data);
                        if (data.logModuleStates()) {
                            Dumper.logModuleStates(packageData, "ChooseDirectory: After disableNonExistingPackages");
                        }
                        if (data.isUserInstallation()) {
                            ModuleCtrl.setShowInUserInstallFlags(packageData);
                            if (data.logModuleStates()) {
                                Dumper.logModuleStates(packageData, "ChooseDirectory: After setShowInUserInstallFlags");
                            }
                        }
                        ModuleCtrl.setParentDefaultModuleSettings(packageData);
                        if (data.logModuleStates()) {
                            Dumper.logModuleStates(packageData, "ChooseDirectory: After setParentDefaultModuleSettings");
                        }
                    }
                    data.setDatabaseAnalyzed(true);
                }
            }
        }
        return repeatDialog;
    }
}

