/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.setup.Controller;

import java.io.File;
import javax.swing.JOptionPane;
import org.openoffice.setup.InstallData;
import org.openoffice.setup.Installer.Installer;
import org.openoffice.setup.Installer.InstallerFactory;
import org.openoffice.setup.Panel.ChooseDirectory;
import org.openoffice.setup.PanelController;
import org.openoffice.setup.ResourceManager;
import org.openoffice.setup.SetupData.SetupDataProvider;
import org.openoffice.setup.Util.Controller;
import org.openoffice.setup.Util.Informer;
import org.openoffice.setup.Util.InstallChangeCtrl;
import org.openoffice.setup.Util.LogManager;
import org.openoffice.setup.Util.ModuleCtrl;
import org.openoffice.setup.Util.SystemManager;

public class ChooseDirectoryCtrl
extends PanelController {
    private String helpFile = "String_Helpfile_ChooseDirectory";

    public ChooseDirectoryCtrl() {
        super("ChooseDirectory", new ChooseDirectory());
    }

    public String getNext() {
        InstallData data = InstallData.getInstance();
        if (data.olderVersionExists()) {
            return new String("InstallationImminent");
        }
        if (data.sameVersionExists()) {
            return new String("ChooseComponents");
        }
        return new String("ChooseInstallationType");
    }

    public String getPrevious() {
        InstallData data = InstallData.getInstance();
        if (data.hideEula()) {
            return new String("Prologue");
        }
        return new String("AcceptLicense");
    }

    public final String getHelpFileName() {
        return this.helpFile;
    }

    private String removeEndingDelimiter(String s) {
        s.trim();
        if (s.endsWith("/") || s.endsWith("\\")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public void beforeShow() {
        ChooseDirectory panel = (ChooseDirectory)this.getPanel();
        InstallData data = InstallData.getInstance();
        if (data.getInstallDir() == null) {
            String installDir = data.getDefaultDir();
            if (data.isUserInstallation() && System.getProperty("HOME") != null && !System.getProperty("HOME").equals("")) {
                installDir = System.getProperty("user.home");
            }
            data.setInstallDir(installDir);
        }
        panel.setDirectory(data.getInstallDir());
    }

    public boolean afterShow(boolean nextButtonPressed) {
        boolean repeatDialog = false;
        ChooseDirectory panel = (ChooseDirectory)this.getPanel();
        String dir = panel.getDirectory();
        dir = this.removeEndingDelimiter(dir);
        InstallData data = InstallData.getInstance();
        data.setInstallDir(dir);
        File installDefaultDir = new File(dir, data.getDefaultDir());
        data.setInstallDefaultDir(installDefaultDir.getPath());
        SetupDataProvider.setNewMacro("DIR", installDefaultDir.getPath());
        if (nextButtonPressed) {
            if (SystemManager.exists_directory(dir) && !Controller.createdSubDirectory(dir)) {
                repeatDialog = true;
            }
            if (!SystemManager.exists_directory(dir)) {
                String title = ResourceManager.getString("String_ChooseDirectory4_Question_Title");
                String message = null;
                message = ResourceManager.getString("String_ChooseDirectory5_Question_Message");
                int returnValue = JOptionPane.showConfirmDialog(null, message, title, 0, 3);
                if (returnValue == 0) {
                    if (!Controller.createdDirectory(dir)) {
                        repeatDialog = true;
                    }
                } else if (returnValue == 1) {
                    repeatDialog = true;
                }
            }
            if (!repeatDialog) {
                String title;
                int discSpace = SystemManager.calculateDiscSpace(dir);
                data.setAvailableDiscSpace(discSpace);
                Installer installer = InstallerFactory.getInstance();
                if (data.isUserInstallation()) {
                    String oldDatabasePath = data.getDatabasePath();
                    installer.defineDatabasePath();
                    if (oldDatabasePath == null || !oldDatabasePath.equals(data.getDatabasePath())) {
                        data.setDatabaseAnalyzed(false);
                        data.setDatabaseQueried(false);
                    } else {
                        data.setDatabaseAnalyzed(true);
                    }
                }
                if (data.isUserInstallation()) {
                    LogManager.setCommandsHeaderLine("Checking change installation");
                    InstallChangeCtrl.checkInstallChange(data);
                }
                if (data.newerVersionExists()) {
                    String message = ResourceManager.getString("String_Newer_Version_Installed_Found") + "\n" + data.getInstallDir() + "\n" + ResourceManager.getString("String_Newer_Version_Database") + ": " + data.getDatabasePath() + "\n" + ResourceManager.getString("String_Newer_Version_Tip");
                    title = ResourceManager.getString("String_Error");
                    Informer.showErrorMessage(message, title);
                    repeatDialog = true;
                }
                if (data.olderVersionExists() && data.dontUpdate()) {
                    String message = ResourceManager.getString("String_Older_Version_Installed_Found") + "\n" + data.getInstallDir() + "\n" + ResourceManager.getString("String_Newer_Version_Database") + ": " + data.getDatabasePath() + "\n" + ResourceManager.getString("String_Newer_Version_Tip");
                    title = ResourceManager.getString("String_Error");
                    Informer.showErrorMessage(message, title);
                    repeatDialog = true;
                }
                if (!repeatDialog && !data.databaseAnalyzed()) {
                    ModuleCtrl.defaultDatabaseAnalysis(data);
                    data.setDatabaseAnalyzed(true);
                }
            }
        }
        return repeatDialog;
    }
}

