/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.setup.Installer;

import java.io.File;
import java.util.HashMap;
import java.util.Vector;
import org.openoffice.setup.InstallData;
import org.openoffice.setup.Installer.Installer;
import org.openoffice.setup.InstallerHelper.SolarisHelper;
import org.openoffice.setup.ResourceManager;
import org.openoffice.setup.SetupData.PackageDescription;
import org.openoffice.setup.Util.Converter;
import org.openoffice.setup.Util.ExecuteProcess;
import org.openoffice.setup.Util.Informer;
import org.openoffice.setup.Util.LogManager;

public class SolarisInstaller
extends Installer {
    SolarisHelper helper = new SolarisHelper();

    public void defineDatabasePath() {
        InstallData data = InstallData.getInstance();
        String oldDatabasePath = data.getDatabasePath();
        data.setDatabasePath(null);
        if (data.isUserInstallation()) {
            String databasePath = this.helper.getSolarisDatabasePath(data);
            data.setDatabasePath(databasePath);
            if (!databasePath.equals(oldDatabasePath)) {
                data.setDatabaseAnalyzed(false);
                data.setDatabaseQueried(false);
            }
        }
    }

    public void preInstallationOngoing() {
        InstallData data = InstallData.getInstance();
        if (data.isInstallationMode()) {
            boolean makeRelocatableAdminFile = true;
            this.helper.createAdminFile(makeRelocatableAdminFile);
            this.helper.createAdminFile(!makeRelocatableAdminFile);
        }
        if (data.isUserInstallation()) {
            this.helper.setEnvironmentForUserInstall();
        }
    }

    public void postInstallationOngoing() {
        InstallData data = InstallData.getInstance();
        this.helper.removeSolarisLockFile();
    }

    public void postInstall(PackageDescription packageData) {
        InstallData data = InstallData.getInstance();
        if (!data.isAbortedInstallation()) {
            data.setStillRunning(true);
            this.helper.saveModulesLogFile(data);
            data.setStillRunning(false);
        }
    }

    public void postUninstallationOngoing() {
        this.helper.removeSolarisLockFile();
    }

    public String getChangeInstallDir(PackageDescription packageData) {
        String installDir = null;
        String packageName = packageData.getPackageName();
        if (packageName != null) {
            String pkgCommand = "pkginfo -r " + packageName;
            String[] pkgCommandArray = new String[]{"pkginfo", "-r", packageName};
            Vector returnVector = new Vector();
            Vector returnErrorVector = new Vector();
            int returnValue = ExecuteProcess.executeProcessReturnVector(pkgCommandArray, returnVector, returnErrorVector);
            String returnString = (String)returnVector.get(0);
            String log = pkgCommand + "<br><b>Returns: " + returnString + "</b><br>";
            LogManager.addCommandsLogfileComment(log);
            installDir = returnString;
        }
        return installDir;
    }

    public void installPackage(PackageDescription packageData) {
        String packageName;
        InstallData data = InstallData.getInstance();
        String log = "<br><b>Package: " + packageData.getName() + "</b>";
        LogManager.addCommandsLogfileComment(log);
        String rootDir = data.getInstallDir();
        String packagePath = data.getPackagePath();
        if (packageData.getPkgSubdir() != null && !packageData.getPkgSubdir().equals("")) {
            File completePackageFile = new File(packagePath, packageData.getPkgSubdir());
            packagePath = completePackageFile.getPath();
        }
        if ((packageName = packageData.getPackageName()).equals("") || packageName == null) {
            log = "<b>No package name specified. Nothing to do</b>";
            LogManager.addCommandsLogfileComment(log);
        } else {
            log = "<b>Package Name: " + packageName + "</b>";
            LogManager.addCommandsLogfileComment(log);
            File completePackage = new File(packagePath, packageName);
            if (completePackage.exists()) {
                int returnValue;
                String[] pkgCommandArray;
                String pkgCommand = "";
                String adminFileName = "";
                Vector returnVector = new Vector();
                Vector returnErrorVector = new Vector();
                adminFileName = packageData.isRelocatable() ? data.getAdminFileNameReloc() : data.getAdminFileNameNoReloc();
                if (data.isUserInstallation()) {
                    HashMap env = data.getShellEnvironment();
                    String[] envStringArray = Converter.convertHashmapToStringArray(env);
                    pkgCommand = "/usr/sbin/pkgadd -n -d " + packagePath + " -R " + rootDir + " -a " + adminFileName + " " + packageName;
                    pkgCommandArray = new String[]{"/usr/sbin/pkgadd", "-n", "-d", packagePath, "-R", rootDir, "-a", adminFileName, packageName};
                    returnValue = ExecuteProcess.executeProcessReturnVectorEnv(pkgCommandArray, envStringArray, returnVector, returnErrorVector);
                } else {
                    pkgCommand = "/usr/sbin/pkgadd -n -d " + packagePath + " -a " + adminFileName + " " + packageName;
                    pkgCommandArray = new String[]{"/usr/sbin/pkgadd", "-n", "-d", packagePath, "-a", adminFileName, packageName};
                    returnValue = ExecuteProcess.executeProcessReturnVector(pkgCommandArray, returnVector, returnErrorVector);
                }
                if (returnValue == 0) {
                    log = pkgCommand + "<br><b>Returns: " + returnValue + " Successful installation</b><br>";
                    LogManager.addCommandsLogfileComment(log);
                } else if (packageData.installCanFail()) {
                    log = pkgCommand + "<br><b>Returns: " + returnValue + " Problem during installation. Can be ignored.</b><br>";
                    LogManager.addCommandsLogfileComment(log);
                } else {
                    log = pkgCommand + "<br><b>Returns: " + returnValue + " Error during installation</b><br>";
                    LogManager.addCommandsLogfileComment(log);
                    System.err.println("Error during installation:");
                    for (int i = 0; i < returnErrorVector.size(); ++i) {
                        LogManager.addCommandsLogfileComment((String)returnErrorVector.get(i));
                        System.err.println(returnErrorVector.get(i));
                    }
                    data.setIsErrorInstallation(true);
                }
            } else {
                log = "<b>Error: Did not find package " + packageName + "</b><br>";
                System.err.println(log);
                String message = ResourceManager.getString("String_File_Not_Found") + ": " + packageName;
                String title = ResourceManager.getString("String_Error");
                Informer.showErrorMessage(message, title);
                LogManager.addCommandsLogfileComment(log);
                data.setIsErrorInstallation(true);
            }
        }
    }

    public void uninstallPackage(PackageDescription packageData) {
        int returnValue;
        String[] pkgCommandArray;
        InstallData data = InstallData.getInstance();
        String log = "<br><b>Package: " + packageData.getName() + "</b>";
        LogManager.addCommandsLogfileComment(log);
        String installRoot = data.getInstallDir();
        String packageName = packageData.getPackageName();
        String adminFileName = "";
        adminFileName = packageData.isRelocatable() ? data.getAdminFileNameReloc() : data.getAdminFileNameNoReloc();
        String pkgCommand = "";
        Vector returnVector = new Vector();
        Vector returnErrorVector = new Vector();
        if (data.isUserInstallation()) {
            pkgCommand = "/usr/sbin/pkgrm -n -R " + installRoot + " -a " + adminFileName + " " + packageName;
            pkgCommandArray = new String[]{"/usr/sbin/pkgrm", "-n", "-R", installRoot, "-a", adminFileName, packageName};
            HashMap env = data.getShellEnvironment();
            String[] envStringArray = Converter.convertHashmapToStringArray(env);
            returnValue = ExecuteProcess.executeProcessReturnVectorEnv(pkgCommandArray, envStringArray, returnVector, returnErrorVector);
        } else {
            pkgCommand = "/usr/sbin/pkgrm -n -a " + adminFileName + " " + packageName;
            pkgCommandArray = new String[]{"/usr/sbin/pkgrm", "-n", "-a", adminFileName, packageName};
            returnValue = ExecuteProcess.executeProcessReturnVector(pkgCommandArray, returnVector, returnErrorVector);
        }
        if (returnValue == 0) {
            log = pkgCommand + "<br><b>Returns: " + returnValue + " Successful uninstallation</b><br>";
            LogManager.addCommandsLogfileComment(log);
        } else {
            log = pkgCommand + "<br><b>Returns: " + returnValue + " Error during uninstallation</b><br>";
            LogManager.addCommandsLogfileComment(log);
            System.err.println("Error during uninstallation:");
            for (int i = 0; i < returnErrorVector.size(); ++i) {
                LogManager.addCommandsLogfileComment((String)returnErrorVector.get(i));
                System.err.println(returnErrorVector.get(i));
            }
            data.setIsErrorInstallation(true);
        }
    }

    public boolean isPackageNameInstalledClassic(String packageName, InstallData installData) {
        String[] pkgCommandArray;
        String pkgCommand;
        String rootString = "";
        String rootPath = null;
        boolean useLocalRoot = false;
        boolean isInstalled = false;
        if (installData.isUserInstallation()) {
            rootPath = installData.getDatabasePath();
        }
        if (rootPath != null && !rootPath.equals("null")) {
            rootString = "-R";
            useLocalRoot = true;
        }
        if (useLocalRoot) {
            pkgCommand = "pkginfo " + rootString + " " + rootPath + " " + packageName;
            pkgCommandArray = new String[]{"pkginfo", rootString, rootPath, packageName};
        } else {
            pkgCommand = "pkginfo " + packageName;
            pkgCommandArray = new String[]{"pkginfo", packageName};
        }
        int returnValue = ExecuteProcess.executeProcessReturnValue(pkgCommandArray);
        if (returnValue == 0) {
            isInstalled = true;
            String log = pkgCommand + "<br><b>Returns: " + returnValue + " Package is installed" + "</b><br>";
            LogManager.addCommandsLogfileComment(log);
        } else {
            String log = pkgCommand + "<br><b>Returns: " + returnValue + " Package is not installed" + "</b><br>";
            LogManager.addCommandsLogfileComment(log);
        }
        return isInstalled;
    }

    private void queryAllDatabase(InstallData installData) {
        String[] pkgCommandArray;
        String pkgCommand;
        String rootString = "";
        String rootPath = null;
        boolean useLocalRoot = false;
        HashMap<String, String> map = new HashMap<String, String>();
        if (installData.isUserInstallation()) {
            rootPath = installData.getDatabasePath();
        }
        if (rootPath != null && !rootPath.equals("null")) {
            rootString = "-R";
            useLocalRoot = true;
        }
        if (useLocalRoot) {
            pkgCommand = "pkginfo " + rootString + " " + rootPath;
            pkgCommandArray = new String[]{"pkginfo", "-x", rootString, rootPath};
        } else {
            pkgCommand = "pkginfo -x";
            pkgCommandArray = new String[]{"pkginfo", "-x"};
        }
        Vector returnVector = new Vector();
        Vector returnErrorVector = new Vector();
        int returnValue = ExecuteProcess.executeProcessReturnVector(pkgCommandArray, returnVector, returnErrorVector);
        String log = pkgCommand + "<br><b>Returns: " + returnValue + "</b><br>";
        LogManager.addCommandsLogfileComment(log);
        String value = "1";
        if (!returnVector.isEmpty()) {
            for (int i = 0; i < returnVector.size(); ++i) {
                String onePackage = (String)returnVector.get(i);
                int pos1 = onePackage.indexOf(" ");
                map.put(onePackage.substring(0, pos1), value);
            }
        }
        installData.setDatabaseQueried(true);
        installData.setDatabaseMap(map);
    }

    public boolean isPackageNameInstalled(String packageName, InstallData installData) {
        boolean isInstalled = false;
        HashMap map = null;
        if (!installData.databaseQueried()) {
            this.queryAllDatabase(installData);
        }
        if ((map = installData.getDatabaseMap()).containsKey(packageName)) {
            isInstalled = true;
        }
        return isInstalled;
    }

    public boolean isPackageInstalled(PackageDescription packageData, InstallData installData) {
        boolean isInstalled = false;
        String packageName = packageData.getPackageName();
        if (packageName.equals("")) {
            packageName = null;
        }
        if (packageName != null) {
            isInstalled = this.isPackageNameInstalled(packageName, installData);
        }
        return isInstalled;
    }

    public boolean isInstallSetPackageOlder(PackageDescription packageData, InstallData installData) {
        boolean installSetPackageIsOlder = false;
        boolean checkIfInstalledIsOlder = false;
        installSetPackageIsOlder = this.findOlderPackage(packageData, installData, checkIfInstalledIsOlder);
        return installSetPackageIsOlder;
    }

    public boolean isInstalledPackageOlder(PackageDescription packageData, InstallData installData) {
        boolean installedPackageIsOlder = false;
        boolean checkIfInstalledIsOlder = true;
        installedPackageIsOlder = this.findOlderPackage(packageData, installData, checkIfInstalledIsOlder);
        return installedPackageIsOlder;
    }

    private boolean findOlderPackage(PackageDescription packageData, InstallData installData, boolean checkIfInstalledIsOlder) {
        String log;
        boolean firstPackageIsOlder = false;
        String packageName = packageData.getPackageName();
        if (packageName.equals("")) {
            packageName = null;
        }
        if (packageName != null) {
            String[] pkgCommandArray;
            String pkgCommand;
            String rootString = "";
            String rootPath = null;
            boolean useLocalRoot = false;
            if (installData.isUserInstallation()) {
                rootPath = installData.getDatabasePath();
            }
            if (rootPath != null && !rootPath.equals("null")) {
                rootString = "-R";
                useLocalRoot = true;
            }
            if (useLocalRoot) {
                pkgCommand = "pkginfo -x " + rootString + " " + rootPath + " " + packageName;
                pkgCommandArray = new String[]{"pkginfo", "-x", rootString, rootPath, packageName};
            } else {
                pkgCommand = "pkginfo -x " + packageName;
                pkgCommandArray = new String[]{"pkginfo", "-x", packageName};
            }
            Vector returnVector = new Vector();
            Vector returnErrorVector = new Vector();
            int returnValue = ExecuteProcess.executeProcessReturnVector(pkgCommandArray, returnVector, returnErrorVector);
            log = pkgCommand + "<br><b>Returns:</b>";
            LogManager.addCommandsLogfileComment(log);
            for (int i = 0; i < returnVector.size(); ++i) {
                log = "<b>" + returnVector.get(i) + "</b>";
                LogManager.addCommandsLogfileComment(log);
            }
            String installedPackageVersion = this.helper.getVersionString(returnVector);
            String newPackageVersion = packageData.getPkgVersion();
            if (installedPackageVersion != null && newPackageVersion != null) {
                firstPackageIsOlder = checkIfInstalledIsOlder ? this.helper.comparePackageVersions(installedPackageVersion, newPackageVersion) : this.helper.comparePackageVersions(newPackageVersion, installedPackageVersion);
            }
        }
        if (checkIfInstalledIsOlder) {
            if (firstPackageIsOlder) {
                log = "<b>-> Installed package is older</b><br>";
                LogManager.addCommandsLogfileComment(log);
            } else {
                log = "<b>-> Installed package is not older</b><br>";
                LogManager.addCommandsLogfileComment(log);
            }
        } else if (firstPackageIsOlder) {
            log = "<b>-> Package in installation set is older</b><br>";
            LogManager.addCommandsLogfileComment(log);
        } else {
            log = "<b>-> Package in installation set is not older</b><br>";
            LogManager.addCommandsLogfileComment(log);
        }
        return firstPackageIsOlder;
    }
}

