/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.setup.Util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import org.openoffice.setup.Util.ExecuteProcess;
import org.openoffice.setup.Util.FileExtensionFilter;

public class SystemManager {
    private SystemManager() {
    }

    public static File getJarFilePath() {
        File jarFile = null;
        try {
            Class<?> c = Class.forName("org.openoffice.setup.ResourceManager");
            URL url = c.getResource("setupfiles.properties");
            String urlString = url.toString();
            if (urlString.startsWith("jar:")) {
                urlString = urlString.substring(4, urlString.lastIndexOf("!"));
                jarFile = new File(new URI(urlString));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        if (jarFile != null) {
            System.err.println("Jar file: " + jarFile.getPath());
        } else {
            System.err.println("No jar file used for installation!");
        }
        return jarFile;
    }

    public static File getResourceRoot() {
        File dir = null;
        try {
            Class<?> c = Class.forName("org.openoffice.setup.ResourceManager");
            URL url = c.getResource("setupfiles.properties");
            String urlString = url.toString();
            urlString = urlString.startsWith("jar:") ? urlString.substring(4, urlString.lastIndexOf("!")) : urlString.substring(0, urlString.lastIndexOf("/org/openoffice/setup/setupfiles.properties"));
            dir = new File(new URI(urlString));
            dir = dir.getParentFile();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        if (dir == null) {
            System.err.println("No resource root found!");
        }
        return dir;
    }

    public static String getPackagePath(String subdir) {
        String path = null;
        File dir = SystemManager.getResourceRoot();
        if (dir != null) {
            if (!(dir = new File(dir, subdir)).exists()) {
                System.err.println("Error: Directory \"" + subdir + "\" does not exist at resouce root");
            } else {
                path = dir.getPath();
            }
        }
        if (path != null && !path.endsWith("/")) {
            path = path + "/";
        }
        if (path != null) {
            System.err.println("Path to packages: " + path);
        } else {
            System.err.println("No path to packages found!");
        }
        return path;
    }

    public static boolean find_file(String fileName) {
        boolean found = false;
        File file = new File(fileName);
        found = file.exists();
        return found;
    }

    public static boolean exists_directory(String directory) {
        File dir = new File(directory);
        return dir.exists();
    }

    public static boolean create_directory(String directory) throws SecurityException {
        boolean created = false;
        File dir = new File(directory);
        created = dir.mkdirs();
        return created;
    }

    public static String getParentDirectory(String dir) {
        File installFile = new File(dir);
        String parentDir = installFile.getParent();
        if (parentDir == null) {
            parentDir = "/";
        }
        return parentDir;
    }

    public static String getInstallationPrivileges() {
        String type = "";
        String user = System.getProperty("user.name");
        if (user.equalsIgnoreCase("root")) {
            type = "root";
            System.err.println("Root privileges");
        } else {
            type = "user";
            System.err.println("User privileges");
        }
        return type;
    }

    public static boolean isUserInstallation() {
        boolean isUserInstallation = false;
        String user = System.getProperty("user.name");
        if (user.equalsIgnoreCase("root")) {
            isUserInstallation = false;
            System.err.println("Root privileges");
        } else {
            isUserInstallation = true;
            System.err.println("User privileges");
        }
        return isUserInstallation;
    }

    public static boolean isRootInstallation() {
        boolean isRootInstallation = false;
        String user = System.getProperty("user.name");
        isRootInstallation = user.equalsIgnoreCase("root");
        return isRootInstallation;
    }

    public static String getOSType() {
        String osVersion = System.getProperty("os.name");
        System.err.println("OS: " + osVersion);
        return osVersion;
    }

    public static String getOSArchitecture() {
        String osArchitecture = System.getProperty("os.arch");
        System.out.println("OSArchitecture: " + osArchitecture);
        return osArchitecture;
    }

    public static String getOSVersion() {
        String osVersion = System.getProperty("os.version");
        System.out.println("OSVersion: " + osVersion);
        return osVersion;
    }

    public static HashMap getEnvironmentHashMap() {
        Properties props = System.getProperties();
        HashMap<Object, Object> myMap = new HashMap<Object, Object>(props);
        return myMap;
    }

    public static void dumpStringArray(String[] myStringArray) {
        for (int i = 0; i < myStringArray.length; ++i) {
            System.out.println(myStringArray[i]);
        }
    }

    public static void dumpFile(String baseFileName, String dumpFileName) {
        Vector fileContent = SystemManager.readCharFileVector(baseFileName);
        SystemManager.saveCharFileVector(dumpFileName, fileContent);
    }

    public static Vector readCharFileVector(String fileName) {
        Vector<String> fileContent = new Vector<String>();
        File file = new File(fileName);
        if (file.exists()) {
            try {
                String zeile;
                FileInputStream fs = new FileInputStream(file);
                BufferedReader bs = new BufferedReader(new InputStreamReader(fs));
                while ((zeile = bs.readLine()) != null) {
                    fileContent.addElement(zeile);
                }
            }
            catch (IOException e) {
                System.out.println(e);
            }
        } else {
            System.out.println("Error: File not found: " + fileName);
        }
        return fileContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void saveCharFileVector(String fileName, Vector fileContent) {
        block12: {
            FileWriter fw = null;
            fw = new FileWriter(fileName);
            String fileContentStr = "";
            for (int i = 0; i < fileContent.size(); ++i) {
                fileContentStr = fileContentStr + fileContent.get(i) + "\n";
            }
            fw.write(fileContentStr);
            Object var6_6 = null;
            try {
                if (fw != null) {
                    fw.close();
                }
                break block12;
            }
            catch (IOException e2) {}
            break block12;
            {
                catch (IOException e) {
                    System.out.println("Could not create file: " + fileName);
                    Object var6_7 = null;
                    try {
                        if (fw != null) {
                            fw.close();
                        }
                        break block12;
                    }
                    catch (IOException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    if (fw != null) {
                        fw.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public static void copyAllFiles(File source, File dest) {
        File[] file = source.listFiles();
        if (file != null) {
            for (int i = 0; i < file.length; ++i) {
                SystemManager.copy(file[i].getPath(), dest.getPath());
            }
        }
    }

    public static void copyAllFiles(File source, File dest, String ext) {
        File[] file = source.listFiles(new FileExtensionFilter(ext));
        if (file != null) {
            for (int i = 0; i < file.length; ++i) {
                SystemManager.copy(file[i].getPath(), dest.getPath());
            }
        }
    }

    public static boolean copy(String source, String dest) {
        FileOutputStream fos;
        FileInputStream fis;
        File dir = new File(dest);
        if (dir.isDirectory()) {
            File sourceFile = new File(source);
            String fileName = sourceFile.getName();
            File destFile = new File(dest, fileName);
            dest = destFile.getPath();
        }
        boolean file_copied = false;
        try {
            fis = new FileInputStream(source);
            fos = new FileOutputStream(dest);
        }
        catch (FileNotFoundException ex) {
            throw new Error("File not found");
        }
        BufferedInputStream bis = new BufferedInputStream(fis);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        try {
            byte[] b = new byte[bis.available()];
            bis.read(b);
            bos.write(b);
            bis.close();
            bos.close();
            file_copied = true;
        }
        catch (IOException e) {
            System.out.println("Dateien wurden nicht kopiert!");
        }
        return file_copied;
    }

    public static boolean deleteFile(File file) {
        boolean success = false;
        if (file.exists() && file != null) {
            success = file.delete();
        }
        return success;
    }

    public static boolean createDirectory(File dir) throws SecurityException {
        boolean created = false;
        created = dir.mkdirs();
        return created;
    }

    public static void removeDirectory(File dir) {
        if (dir.exists() && dir.isDirectory()) {
            File[] file = dir.listFiles();
            if (file != null) {
                for (int i = 0; i < file.length; ++i) {
                    SystemManager.deleteFile(file[i]);
                }
            }
            dir.delete();
        }
    }

    public static boolean logModuleStates() {
        boolean logStates = false;
        String logStatesEnv = System.getProperty("LOG_MODULE_STATES");
        if (logStatesEnv != null) {
            logStates = true;
        }
        return logStates;
    }

    public static void setUnixPrivileges(String fileName, String unixRights) {
        String[] commandArray = new String[]{"chmod", unixRights, fileName};
        int value = ExecuteProcess.executeProcessReturnValue(commandArray);
    }

    public static void setUnixPrivilegesDirectory(File directoryName, String ext, String unixRights) {
        File[] file = directoryName.listFiles(new FileExtensionFilter(ext));
        if (file != null) {
            for (int i = 0; i < file.length; ++i) {
                SystemManager.setUnixPrivileges(file[i].getPath(), unixRights);
            }
        }
    }

    public static int calculateDiscSpace(String directory) {
        int max;
        String command = "df -k " + directory;
        String[] commandArray = new String[]{"df", "-k", directory};
        int size = 0;
        Vector returnVector = new Vector();
        Vector returnErrorVector = new Vector();
        int returnValue = ExecuteProcess.executeProcessReturnVector(commandArray, returnVector, returnErrorVector);
        if (returnValue == 0 && (max = returnVector.size()) > 0) {
            String[] returnArray;
            String returnLine = (String)returnVector.get(max - 1);
            int position = 3;
            if (returnLine.startsWith(" ")) {
                position = 2;
            }
            if ((returnArray = (returnLine = returnLine.trim()).split("\\s+")).length > 3) {
                String sizeString = returnArray[position];
                size = Integer.parseInt(sizeString);
            }
        }
        return size;
    }
}

