/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.client.sei;

import com.sun.xml.internal.bind.api.Bridge;
import com.sun.xml.internal.ws.api.message.Headers;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.client.sei.ValueGetter;
import com.sun.xml.internal.ws.message.ByteArrayAttachment;
import com.sun.xml.internal.ws.message.DataHandlerAttachment;
import com.sun.xml.internal.ws.message.JAXBAttachment;
import com.sun.xml.internal.ws.model.ParameterImpl;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.xml.transform.Source;
import javax.xml.ws.WebServiceException;

abstract class MessageFiller {
    protected final int methodPos;

    protected MessageFiller(int n) {
        this.methodPos = n;
    }

    abstract void fillIn(Object[] var1, Message var2);

    private static boolean isXMLMimeType(String string) {
        return string.equals("text/xml") || string.equals("application/xml");
    }

    static abstract class AttachmentFiller
    extends MessageFiller {
        protected final ParameterImpl param;
        protected final ValueGetter getter;
        protected final String mimeType;
        private final String contentIdPart;

        protected AttachmentFiller(ParameterImpl parameterImpl, ValueGetter valueGetter) {
            super(parameterImpl.getIndex());
            this.param = parameterImpl;
            this.getter = valueGetter;
            this.mimeType = parameterImpl.getBinding().getMimeType();
            try {
                this.contentIdPart = URLEncoder.encode(parameterImpl.getPartName(), "UTF-8") + '=';
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new WebServiceException(unsupportedEncodingException);
            }
        }

        public static MessageFiller createAttachmentFiller(ParameterImpl parameterImpl, ValueGetter valueGetter) {
            Class clazz = (Class)parameterImpl.getTypeReference().type;
            if (DataHandler.class.isAssignableFrom(clazz) || Source.class.isAssignableFrom(clazz)) {
                return new DataHandlerFiller(parameterImpl, valueGetter);
            }
            if (byte[].class == clazz) {
                return new ByteArrayFiller(parameterImpl, valueGetter);
            }
            if (MessageFiller.isXMLMimeType(parameterImpl.getBinding().getMimeType())) {
                return new JAXBFiller(parameterImpl, valueGetter);
            }
            return new DataHandlerFiller(parameterImpl, valueGetter);
        }

        String getContentId() {
            return this.contentIdPart + UUID.randomUUID() + "@jaxws.sun.com";
        }
    }

    private static class ByteArrayFiller
    extends AttachmentFiller {
        protected ByteArrayFiller(ParameterImpl parameterImpl, ValueGetter valueGetter) {
            super(parameterImpl, valueGetter);
        }

        void fillIn(Object[] objectArray, Message message) {
            String string = this.getContentId();
            Object object = this.getter.get(objectArray[this.methodPos]);
            ByteArrayAttachment byteArrayAttachment = new ByteArrayAttachment(string, (byte[])object, this.mimeType);
            message.getAttachments().add(byteArrayAttachment);
        }
    }

    private static class DataHandlerFiller
    extends AttachmentFiller {
        protected DataHandlerFiller(ParameterImpl parameterImpl, ValueGetter valueGetter) {
            super(parameterImpl, valueGetter);
        }

        void fillIn(Object[] objectArray, Message message) {
            String string = this.getContentId();
            Object object = this.getter.get(objectArray[this.methodPos]);
            DataHandler dataHandler = object instanceof DataHandler ? (DataHandler)object : new DataHandler(object, this.mimeType);
            DataHandlerAttachment dataHandlerAttachment = new DataHandlerAttachment(string, dataHandler);
            message.getAttachments().add(dataHandlerAttachment);
        }
    }

    static final class Header
    extends MessageFiller {
        private final Bridge bridge;
        private final ValueGetter getter;

        protected Header(int n, Bridge bridge, ValueGetter valueGetter) {
            super(n);
            this.bridge = bridge;
            this.getter = valueGetter;
        }

        void fillIn(Object[] objectArray, Message message) {
            Object object = this.getter.get(objectArray[this.methodPos]);
            message.getHeaders().add(Headers.create(this.bridge, object));
        }
    }

    private static class JAXBFiller
    extends AttachmentFiller {
        protected JAXBFiller(ParameterImpl parameterImpl, ValueGetter valueGetter) {
            super(parameterImpl, valueGetter);
        }

        void fillIn(Object[] objectArray, Message message) {
            String string = this.getContentId();
            Object object = this.getter.get(objectArray[this.methodPos]);
            JAXBAttachment jAXBAttachment = new JAXBAttachment(string, object, this.param.getBridge(), this.mimeType);
            message.getAttachments().add(jAXBAttachment);
        }
    }
}

