untrusted comment: verify with openbsd-67-base.pub
RWRmkIA877Io3iOALsV4WZ5n+NCgTOlkTBzM96c8quq5f45Zqkh1rBtUNbh3apkh9PdNZwTDk0SXQKhSlsRfXRhbOGtmpQvPNws=

OpenBSD 6.7 errata 035, February 24, 2021:

A sequence of overlapping IPv4 fragments could crash the kernel in
pf due to an assertion.

Apply by doing:
    signify -Vep /etc/signify/openbsd-67-base.pub -x 035_pffrag.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/net/pf_norm.c
===================================================================
RCS file: /cvs/src/sys/net/pf_norm.c,v
diff -u -p -r1.218 pf_norm.c
--- sys/net/pf_norm.c	28 Feb 2019 20:20:47 -0000	1.218
+++ sys/net/pf_norm.c	18 Feb 2021 17:55:00 -0000
@@ -671,10 +671,35 @@ pf_fillup_fragment(struct pf_frnode *key
 
 		aftercut = frent->fe_off + frent->fe_len - after->fe_off;
 		if (aftercut < after->fe_len) {
+			int old_index, new_index;
+
 			DPFPRINTF(LOG_NOTICE, "frag tail overlap %d", aftercut);
 			m_adj(after->fe_m, aftercut);
+			old_index = pf_frent_index(after);
 			after->fe_off += aftercut;
 			after->fe_len -= aftercut;
+			new_index = pf_frent_index(after);
+			if (old_index != new_index) {
+				DPFPRINTF(LOG_DEBUG, "frag index %d, new %d",
+				    old_index, new_index);
+				/* Fragment switched queue as fe_off changed */
+				after->fe_off -= aftercut;
+				after->fe_len += aftercut;
+				/* Remove restored fragment from old queue */
+				pf_frent_remove(frag, after);
+				after->fe_off += aftercut;
+				after->fe_len -= aftercut;
+				/* Insert into correct queue */
+				if (pf_frent_insert(frag, after, prev)) {
+					DPFPRINTF(LOG_WARNING,
+					    "fragment requeue limit exceeded");
+					m_freem(after->fe_m);
+					pool_put(&pf_frent_pl, after);
+					pf_nfrents--;
+					/* There is not way to recover */
+					goto free_fragment;
+				}
+			}
 			break;
 		}
 
