/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.interop;

import java.io.File;
import java.io.FileInputStream;
import java.security.Key;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.test.TestUtils;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class InteropTest
extends TestCase {
    static Log log = LogFactory.getLog((String)(class$org$apache$xml$security$test$interop$BaltimoreTest == null ? (class$org$apache$xml$security$test$interop$BaltimoreTest = InteropTest.class$("org.apache.xml.security.test.interop.BaltimoreTest")) : class$org$apache$xml$security$test$interop$BaltimoreTest).getName());
    static DocumentBuilderFactory dbf = null;
    static /* synthetic */ Class class$org$apache$xml$security$test$interop$BaltimoreTest;

    public InteropTest(String string) {
        super(string);
    }

    protected void setUp() {
        dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
    }

    public boolean verifyHMAC(String string, ResourceResolverSpi resourceResolverSpi, boolean bl, byte[] byArray) throws Exception {
        File file = new File(string);
        DocumentBuilder documentBuilder = dbf.newDocumentBuilder();
        Document document = documentBuilder.parse(new FileInputStream(file));
        Element element = TestUtils.createDSctx(document, "ds", "http://www.w3.org/2000/09/xmldsig#");
        Element element2 = (Element)XPathAPI.selectSingleNode((Node)document, (String)"//ds:Signature[1]", (Node)element);
        XMLSignature xMLSignature = new XMLSignature(element2, file.toURL().toString());
        if (resourceResolverSpi != null) {
            xMLSignature.addResourceResolver(resourceResolverSpi);
        }
        xMLSignature.setFollowNestedManifests(bl);
        byte[] byArray2 = byArray;
        SecretKey secretKey = xMLSignature.createSecretKey(byArray2);
        return xMLSignature.checkSignatureValue((Key)secretKey);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean verify(String string, ResourceResolverSpi resourceResolverSpi, boolean bl) throws Exception {
        File file = new File(string);
        DocumentBuilder documentBuilder = dbf.newDocumentBuilder();
        Document document = documentBuilder.parse(file);
        Element element = TestUtils.createDSctx(document, "ds", "http://www.w3.org/2000/09/xmldsig#");
        Element element2 = (Element)XPathAPI.selectSingleNode((Node)document, (String)"//ds:Signature[1]", (Node)element);
        XMLSignature xMLSignature = new XMLSignature(element2, file.toURL().toString());
        if (resourceResolverSpi != null) {
            xMLSignature.addResourceResolver(resourceResolverSpi);
        }
        xMLSignature.setFollowNestedManifests(bl);
        KeyInfo keyInfo = xMLSignature.getKeyInfo();
        boolean bl2 = false;
        if (keyInfo == null) throw new RuntimeException("Did not find a KeyInfo");
        X509Certificate x509Certificate = keyInfo.getX509Certificate();
        if (x509Certificate != null) {
            bl2 = xMLSignature.checkSignatureValue(x509Certificate);
        } else {
            PublicKey publicKey = keyInfo.getPublicKey();
            if (publicKey == null) throw new RuntimeException("Did not find a public key, so I can't check the signature");
            bl2 = xMLSignature.checkSignatureValue((Key)publicKey);
        }
        if (bl2) return bl2;
        for (int i = 0; i < xMLSignature.getSignedInfo().getLength(); ++i) {
            boolean bl3 = xMLSignature.getSignedInfo().getVerificationResult(i);
            if (bl3) {
                log.debug((Object)("Reference " + i + " was OK"));
                continue;
            }
            log.debug((Object)("Reference " + i + " was not OK"));
        }
        return bl2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

