/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.security;

import com.sun.jmx.remote.security.JMXSubjectDomainCombiner;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.management.remote.SubjectDelegationPermission;
import javax.security.auth.Subject;

public class SubjectDelegator {
    public AccessControlContext delegatedContext(AccessControlContext accessControlContext, Subject subject, boolean bl) throws SecurityException {
        if (System.getSecurityManager() != null && accessControlContext == null) {
            throw new SecurityException("Illegal AccessControlContext: null");
        }
        Collection<Principal> collection = SubjectDelegator.getSubjectPrincipals(subject);
        final ArrayList<SubjectDelegationPermission> arrayList = new ArrayList<SubjectDelegationPermission>(collection.size());
        for (Principal principal : collection) {
            String string = principal.getClass().getName() + "." + principal.getName();
            arrayList.add(new SubjectDelegationPermission(string));
        }
        PrivilegedAction<Void> privilegedAction = new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                for (Permission permission : arrayList) {
                    AccessController.checkPermission(permission);
                }
                return null;
            }
        };
        AccessController.doPrivileged(privilegedAction, accessControlContext);
        return this.getDelegatedAcc(subject, bl);
    }

    private AccessControlContext getDelegatedAcc(Subject subject, boolean bl) {
        if (bl) {
            return JMXSubjectDomainCombiner.getDomainCombinerContext(subject);
        }
        return JMXSubjectDomainCombiner.getContext(subject);
    }

    public static synchronized boolean checkRemoveCallerContext(Subject subject) {
        try {
            for (Principal principal : SubjectDelegator.getSubjectPrincipals(subject)) {
                String string = principal.getClass().getName() + "." + principal.getName();
                SubjectDelegationPermission subjectDelegationPermission = new SubjectDelegationPermission(string);
                AccessController.checkPermission(subjectDelegationPermission);
            }
        }
        catch (SecurityException securityException) {
            return false;
        }
        return true;
    }

    private static Collection<Principal> getSubjectPrincipals(Subject subject) {
        if (subject.isReadOnly()) {
            return subject.getPrincipals();
        }
        List<Principal> list = Arrays.asList(subject.getPrincipals().toArray(new Principal[0]));
        return Collections.unmodifiableList(list);
    }
}

