/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class UnassignPrivateIPAddresses
extends BaseCmd {
    public static final String[] NETWORK_INTERFACE_DESC = new String[]{"The ID of the network interface from which the specified addresses", "will be unassigned ."};
    public static final String[] SECONDARY_PRIVATE_IP_ADDRESS_DESC = new String[]{"Secondary private IP address to be unassigned from the ", "the specified network interface."};

    public UnassignPrivateIPAddresses(String[] args) {
        super("ec2upip", "ec2-unassign-private-ip-addresses");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options o = new Options();
        OptionBuilder.withLongOpt((String)"network-interface");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"NETWORKINTERFACE");
        OptionBuilder.withDescription((String)UnassignPrivateIPAddresses.joinDescription(NETWORK_INTERFACE_DESC));
        o.addOption(OptionBuilder.create((String)"n"));
        OptionBuilder.withLongOpt((String)"secondary-private-ip-address");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"SECONDARY-PRIVATE-IP-ADDRESS");
        OptionBuilder.withDescription((String)UnassignPrivateIPAddresses.joinDescription(SECONDARY_PRIVATE_IP_ADDRESS_DESC));
        o.addOption(OptionBuilder.create(null));
        return o;
    }

    @Override
    protected String getOptionString() {
        return "-n NETWORK_INTERFACE_ID --secondary-private-ip-address SECONDARY_PRIVATE_IP_ADDRESS [--secondary-private-ip-address SECONDARY_PRIVATE_IP_ADDRESS ...])";
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("network-interface");
        this.printOption("secondary-private-ip-address");
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Unassign secondary private IP addresses from the specified network ");
        System.out.println("     interface.");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.assertOptionSet("network-interface");
        this.assertOptionSet("secondary-private-ip-address");
        String networkInterfaceId = this.getOptionValue("network-interface");
        List<String> privateIPAddresses = Arrays.asList(this.getOptionValues("secondary-private-ip-address"));
        this.warnIfTooManyNonOptions();
        RequestResultPair resPair = jec2.unassignPrivateIPAddresses(networkInterfaceId, privateIPAddresses);
        out.output(System.out, (Boolean)resPair.getResponse());
        return true;
    }

    public static void main(String[] args) {
        new UnassignPrivateIPAddresses(args).invoke();
    }
}

