/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.draw.geom;

import java.awt.geom.Path2D;
import org.apache.poi.sl.draw.geom.ClosePathCommand;
import org.apache.poi.sl.draw.geom.Context;
import org.apache.poi.sl.draw.geom.PathCommand;
import org.apache.poi.sl.draw.geom.PathIf;
import org.apache.poi.sl.usermodel.PaintStyle;
import org.apache.poi.xslf.draw.geom.XSLFArcTo;
import org.apache.poi.xslf.draw.geom.XSLFCurveTo;
import org.apache.poi.xslf.draw.geom.XSLFLineTo;
import org.apache.poi.xslf.draw.geom.XSLFMoveTo;
import org.apache.poi.xslf.draw.geom.XSLFQuadTo;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPath2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPath2DArcTo;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPath2DClose;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPath2DCubicBezierTo;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPath2DLineTo;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPath2DMoveTo;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPath2DQuadBezierTo;
import org.openxmlformats.schemas.drawingml.x2006.main.STPathFillMode;

public class XSLFPath
implements PathIf {
    private final CTPath2D pathXml;

    public XSLFPath(CTPath2D pathXml) {
        this.pathXml = pathXml;
    }

    public void addCommand(PathCommand cmd) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path2D.Double getPath(Context ctx) {
        Path2D.Double path2D = new Path2D.Double();
        XmlCursor cur = this.pathXml.newCursor();
        try {
            boolean hasNext = cur.toFirstChild();
            while (hasNext) {
                block13: {
                    Object pc;
                    block8: {
                        XmlObject xo;
                        block12: {
                            block11: {
                                block10: {
                                    block9: {
                                        block7: {
                                            xo = cur.getObject();
                                            if (!(xo instanceof CTPath2DArcTo)) break block7;
                                            pc = new XSLFArcTo((CTPath2DArcTo)xo);
                                            break block8;
                                        }
                                        if (!(xo instanceof CTPath2DCubicBezierTo)) break block9;
                                        pc = new XSLFCurveTo((CTPath2DCubicBezierTo)xo);
                                        break block8;
                                    }
                                    if (!(xo instanceof CTPath2DMoveTo)) break block10;
                                    pc = new XSLFMoveTo((CTPath2DMoveTo)xo);
                                    break block8;
                                }
                                if (!(xo instanceof CTPath2DLineTo)) break block11;
                                pc = new XSLFLineTo((CTPath2DLineTo)xo);
                                break block8;
                            }
                            if (!(xo instanceof CTPath2DQuadBezierTo)) break block12;
                            pc = new XSLFQuadTo((CTPath2DQuadBezierTo)xo);
                            break block8;
                        }
                        if (!(xo instanceof CTPath2DClose)) break block13;
                        pc = new ClosePathCommand();
                    }
                    pc.execute(path2D, ctx);
                }
                hasNext = cur.toNextSibling();
            }
        }
        finally {
            cur.dispose();
        }
        return path2D;
    }

    public boolean isStroked() {
        return this.pathXml.getStroke();
    }

    public void setStroke(boolean stroke) {
        this.pathXml.setStroke(stroke);
    }

    public boolean isFilled() {
        return this.pathXml.getFill() != STPathFillMode.NONE;
    }

    public PaintStyle.PaintModifier getFill() {
        switch (this.pathXml.getFill().intValue()) {
            default: {
                return PaintStyle.PaintModifier.NONE;
            }
            case 2: {
                return PaintStyle.PaintModifier.NORM;
            }
            case 3: {
                return PaintStyle.PaintModifier.LIGHTEN;
            }
            case 4: {
                return PaintStyle.PaintModifier.LIGHTEN_LESS;
            }
            case 5: {
                return PaintStyle.PaintModifier.DARKEN;
            }
            case 6: 
        }
        return PaintStyle.PaintModifier.DARKEN_LESS;
    }

    public void setFill(PaintStyle.PaintModifier fill) {
        STPathFillMode.Enum f;
        switch (fill) {
            default: {
                f = STPathFillMode.NONE;
                break;
            }
            case NORM: {
                f = STPathFillMode.NORM;
                break;
            }
            case LIGHTEN: {
                f = STPathFillMode.LIGHTEN;
                break;
            }
            case LIGHTEN_LESS: {
                f = STPathFillMode.LIGHTEN_LESS;
                break;
            }
            case DARKEN: {
                f = STPathFillMode.DARKEN;
                break;
            }
            case DARKEN_LESS: {
                f = STPathFillMode.DARKEN_LESS;
            }
        }
        this.pathXml.setFill(f);
    }

    public long getW() {
        return this.pathXml.getW();
    }

    public void setW(long w) {
        this.pathXml.setW(w);
    }

    public long getH() {
        return this.pathXml.getH();
    }

    public void setH(long h) {
        this.pathXml.setH(h);
    }

    public boolean isExtrusionOk() {
        return this.pathXml.getExtrusionOk();
    }

    public void setExtrusionOk(boolean extrusionOk) {
        this.pathXml.setExtrusionOk(extrusionOk);
    }
}

