/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.geocoder;

import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.ws.rs.client.Client;
import org.traccar.geocoder.Address;
import org.traccar.geocoder.AddressFormat;
import org.traccar.geocoder.JsonGeocoder;

public class TomTomGeocoder
extends JsonGeocoder {
    private static String formatUrl(String url, String key) {
        if (url == null) {
            url = "https://api.tomtom.com/search/2/reverseGeocode/";
        }
        url = (String)url + "%f,%f.json?key=" + key;
        return url;
    }

    public TomTomGeocoder(Client client, String url, String key, int cacheSize, AddressFormat addressFormat) {
        super(client, TomTomGeocoder.formatUrl(url, key), cacheSize, addressFormat);
    }

    @Override
    public Address parseAddress(JsonObject json) {
        JsonObject record;
        JsonArray addresses = json.getJsonArray("addresses");
        if (addresses != null && (record = addresses.getJsonObject(0)) != null) {
            JsonObject location = record.getJsonObject("address");
            Address address = new Address();
            if (location.containsKey((Object)"streetNumber")) {
                address.setHouse(location.getString("streetNumber"));
            }
            if (location.containsKey((Object)"street")) {
                address.setStreet(location.getString("street"));
            }
            if (location.containsKey((Object)"municipality")) {
                address.setSettlement(location.getString("municipality"));
            }
            if (location.containsKey((Object)"municipalitySubdivision")) {
                address.setDistrict(location.getString("municipalitySubdivision"));
            }
            if (location.containsKey((Object)"countrySubdivision")) {
                address.setState(location.getString("countrySubdivision"));
            }
            if (location.containsKey((Object)"country")) {
                address.setCountry(location.getString("country").toUpperCase());
            }
            if (location.containsKey((Object)"postalCode")) {
                address.setPostcode(location.getString("postalCode"));
            }
            return address;
        }
        return null;
    }
}

