/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jxls.common.JxlsException;

public class CellRefUtil {
    private static final char DELIMITER = '\'';
    private static final Pattern CELL_REF_PATTERN = Pattern.compile("([A-Za-z]+)([0-9]+)");
    public static final char SHEET_NAME_DELIMITER = '!';
    private static final char CELL_DELIMITER = ':';
    public static final char ABSOLUTE_REFERENCE_MARKER = '$';
    private static final char SPECIAL_NAME_DELIMITER = '\'';

    public static String convertNumToColString(int col) {
        int excelColNum;
        String colRef = "";
        int colRemain = excelColNum = col + 1;
        while (colRemain > 0) {
            int thisPart = colRemain % 26;
            if (thisPart == 0) {
                thisPart = 26;
            }
            colRemain = (colRemain - thisPart) / 26;
            char colChar = (char)(thisPart + 64);
            colRef = colChar + colRef;
        }
        return colRef;
    }

    public static void appendFormat(StringBuilder out, String rawSheetName) {
        boolean needsQuotes = CellRefUtil.needsDelimiting(rawSheetName);
        if (needsQuotes) {
            out.append('\'');
            CellRefUtil.appendAndEscape(out, rawSheetName);
            out.append('\'');
        } else {
            out.append(rawSheetName);
        }
    }

    static void appendAndEscape(StringBuilder sb, String rawSheetName) {
        int len = rawSheetName.length();
        for (int i = 0; i < len; ++i) {
            char ch = rawSheetName.charAt(i);
            if (ch == '\'') {
                sb.append('\'');
            }
            sb.append(ch);
        }
    }

    static boolean needsDelimiting(String rawSheetName) {
        int len = rawSheetName.length();
        if (len < 1) {
            throw new JxlsException("Zero length string is an invalid sheet name");
        }
        if (Character.isDigit(rawSheetName.charAt(0))) {
            return true;
        }
        for (int i = 0; i < len; ++i) {
            char ch = rawSheetName.charAt(i);
            if (!CellRefUtil.isSpecialChar(ch)) continue;
            return true;
        }
        if (Character.isLetter(rawSheetName.charAt(0)) && Character.isDigit(rawSheetName.charAt(len - 1)) && CellRefUtil.nameLooksLikePlainCellReference(rawSheetName)) {
            return true;
        }
        return CellRefUtil.nameLooksLikeBooleanLiteral(rawSheetName);
    }

    static boolean nameLooksLikePlainCellReference(String rawSheetName) {
        Matcher matcher = CELL_REF_PATTERN.matcher(rawSheetName);
        if (!matcher.matches()) {
            return false;
        }
        String lettersPrefix = matcher.group(1);
        String numbersSuffix = matcher.group(2);
        return CellRefUtil.cellReferenceIsWithinRange(lettersPrefix, numbersSuffix);
    }

    private static boolean cellReferenceIsWithinRange(String lettersPrefix, String numbersSuffix) {
        return CellRefUtil.cellReferenceIsWithinRange(lettersPrefix, numbersSuffix, 256, 65536);
    }

    public static boolean cellReferenceIsWithinRange(String colStr, String rowStr, int lastColumnIndex, int lastRowIndex) {
        if (!CellRefUtil.isColumnWithnRange(colStr, lastColumnIndex)) {
            return false;
        }
        return CellRefUtil.isRowWithnRange(rowStr, lastRowIndex);
    }

    public static boolean isColumnWithnRange(String colStr, int lastColumnIndex) {
        String lastCol = CellRefUtil.convertNumToColString(lastColumnIndex);
        int lastColLength = lastCol.length();
        int numberOfLetters = colStr.length();
        if (numberOfLetters > lastColLength) {
            return false;
        }
        return numberOfLetters != lastColLength || colStr.toUpperCase().compareTo(lastCol) <= 0;
    }

    public static boolean isRowWithnRange(String rowStr, int lastRowIndex) {
        int rowNum = Integer.parseInt(rowStr);
        if (rowNum < 0) {
            throw new IllegalStateException("Invalid rowStr '" + rowStr + "'.");
        }
        if (rowNum == 0) {
            return false;
        }
        return rowNum <= lastRowIndex;
    }

    static boolean nameLooksLikeBooleanLiteral(String rawSheetName) {
        switch (rawSheetName.charAt(0)) {
            case 'T': 
            case 't': {
                return "TRUE".equalsIgnoreCase(rawSheetName);
            }
            case 'F': 
            case 'f': {
                return "FALSE".equalsIgnoreCase(rawSheetName);
            }
        }
        return false;
    }

    static boolean isSpecialChar(char ch) {
        if (Character.isLetterOrDigit(ch)) {
            return false;
        }
        switch (ch) {
            case '.': 
            case '_': {
                return false;
            }
            case '\t': 
            case '\n': 
            case '\r': {
                throw new JxlsException("Illegal character (0x" + Integer.toHexString(ch) + ") found in sheet name");
            }
        }
        return true;
    }

    public static int convertColStringToIndex(String ref) {
        int pos = 0;
        int retval = 0;
        for (int k = ref.length() - 1; k >= 0; --k) {
            char thechar = ref.charAt(k);
            if (thechar == '$') {
                if (k == 0) break;
                throw new IllegalArgumentException("Bad col ref format '" + ref + "'");
            }
            int shift = (int)Math.pow(26.0, pos);
            retval += (Character.getNumericValue(thechar) - 9) * shift;
            ++pos;
        }
        return retval - 1;
    }

    public static String[] separateRefParts(String reference) {
        char ch;
        int plingPos = reference.lastIndexOf(33);
        String sheetName = CellRefUtil.parseSheetName(reference, plingPos);
        int start = plingPos + 1;
        int length = reference.length();
        int loc = start;
        if (reference.charAt(loc) == '$') {
            ++loc;
        }
        while (loc < length && !Character.isDigit(ch = reference.charAt(loc)) && ch != '$') {
            ++loc;
        }
        return new String[]{sheetName, reference.substring(start, loc), reference.substring(loc)};
    }

    public static String parseSheetName(String reference, int indexOfSheetNameDelimiter) {
        boolean isQuoted;
        if (indexOfSheetNameDelimiter < 0) {
            return null;
        }
        boolean bl = isQuoted = reference.charAt(0) == '\'';
        if (!isQuoted) {
            return reference.substring(0, indexOfSheetNameDelimiter);
        }
        int lastQuotePos = indexOfSheetNameDelimiter - 1;
        if (reference.charAt(lastQuotePos) != '\'') {
            throw new JxlsException("Mismatched quotes: (" + reference + ")");
        }
        StringBuilder sb = new StringBuilder(indexOfSheetNameDelimiter);
        for (int i = 1; i < lastQuotePos; ++i) {
            char ch = reference.charAt(i);
            if (ch != '\'') {
                sb.append(ch);
                continue;
            }
            if (i < lastQuotePos && reference.charAt(i + 1) == '\'') {
                ++i;
                sb.append(ch);
                continue;
            }
            throw new JxlsException("Bad sheet name quote escaping: (" + reference + ")");
        }
        return sb.toString();
    }

    public static String[] separateAreaRefs(String reference) {
        int len = reference.length();
        int delimiterPos = -1;
        boolean insideDelimitedName = false;
        block4: for (int i = 0; i < len; ++i) {
            switch (reference.charAt(i)) {
                case ':': {
                    if (!insideDelimitedName) {
                        if (delimiterPos >= 0) {
                            throw new IllegalArgumentException("More than one cell delimiter ':' appears in area reference '" + reference + "'");
                        }
                        delimiterPos = i;
                    }
                }
                default: {
                    continue block4;
                }
                case '\'': {
                    if (!insideDelimitedName) {
                        insideDelimitedName = true;
                        continue block4;
                    }
                    if (i >= len - 1) {
                        throw new IllegalArgumentException("Area reference '" + reference + "' ends with special name delimiter '" + '\'' + "'");
                    }
                    if (reference.charAt(i + 1) == '\'') {
                        ++i;
                        continue block4;
                    }
                    insideDelimitedName = false;
                }
            }
        }
        if (delimiterPos < 0) {
            return new String[]{reference};
        }
        String partA = reference.substring(0, delimiterPos);
        String partB = reference.substring(delimiterPos + 1);
        if (partB.indexOf(33) >= 0) {
            throw new JxlsException("Unexpected ! in second cell reference of '" + reference + "'");
        }
        int plingPos = partA.lastIndexOf(33);
        if (plingPos < 0) {
            return new String[]{partA, partB};
        }
        String sheetName = partA.substring(0, plingPos + 1);
        return new String[]{partA, sheetName + partB};
    }

    public static boolean isPlainColumn(String refPart) {
        for (int i = refPart.length() - 1; i >= 0; --i) {
            char ch = refPart.charAt(i);
            if (ch == '$' && i == 0 || ch >= 'A' && ch <= 'Z') continue;
            return false;
        }
        return true;
    }
}

