/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.LinkedList;
import java.util.List;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.Relation;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.Task;
import net.sf.mpxj.listener.ProjectListener;

public class EventManager {
    private List<ProjectListener> m_projectListeners;

    public void fireTaskReadEvent(Task task) {
        if (this.m_projectListeners != null) {
            for (ProjectListener projectListener : this.m_projectListeners) {
                projectListener.taskRead(task);
            }
        }
    }

    public void fireTaskWrittenEvent(Task task) {
        if (this.m_projectListeners != null) {
            for (ProjectListener projectListener : this.m_projectListeners) {
                projectListener.taskWritten(task);
            }
        }
    }

    public void fireResourceReadEvent(Resource resource) {
        if (this.m_projectListeners != null) {
            for (ProjectListener projectListener : this.m_projectListeners) {
                projectListener.resourceRead(resource);
            }
        }
    }

    public void fireResourceWrittenEvent(Resource resource) {
        if (this.m_projectListeners != null) {
            for (ProjectListener projectListener : this.m_projectListeners) {
                projectListener.resourceWritten(resource);
            }
        }
    }

    public void fireCalendarReadEvent(ProjectCalendar projectCalendar) {
        if (this.m_projectListeners != null) {
            for (ProjectListener projectListener : this.m_projectListeners) {
                projectListener.calendarRead(projectCalendar);
            }
        }
    }

    public void fireAssignmentReadEvent(ResourceAssignment resourceAssignment) {
        if (this.m_projectListeners != null) {
            for (ProjectListener projectListener : this.m_projectListeners) {
                projectListener.assignmentRead(resourceAssignment);
            }
        }
    }

    public void fireAssignmentWrittenEvent(ResourceAssignment resourceAssignment) {
        if (this.m_projectListeners != null) {
            for (ProjectListener projectListener : this.m_projectListeners) {
                projectListener.assignmentWritten(resourceAssignment);
            }
        }
    }

    public void fireRelationReadEvent(Relation relation) {
        if (this.m_projectListeners != null) {
            for (ProjectListener projectListener : this.m_projectListeners) {
                projectListener.relationRead(relation);
            }
        }
    }

    public void fireRelationWrittenEvent(Relation relation) {
        if (this.m_projectListeners != null) {
            for (ProjectListener projectListener : this.m_projectListeners) {
                projectListener.relationWritten(relation);
            }
        }
    }

    public void fireCalendarWrittenEvent(ProjectCalendar projectCalendar) {
        if (this.m_projectListeners != null) {
            for (ProjectListener projectListener : this.m_projectListeners) {
                projectListener.calendarWritten(projectCalendar);
            }
        }
    }

    public void addProjectListener(ProjectListener projectListener) {
        if (this.m_projectListeners == null) {
            this.m_projectListeners = new LinkedList<ProjectListener>();
        }
        this.m_projectListeners.add(projectListener);
    }

    public void addProjectListeners(List<ProjectListener> list) {
        if (list != null) {
            for (ProjectListener projectListener : list) {
                this.addProjectListener(projectListener);
            }
        }
    }

    public void removeProjectListener(ProjectListener projectListener) {
        if (this.m_projectListeners != null) {
            this.m_projectListeners.remove(projectListener);
        }
    }
}

