/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.pm.graphic.model.event;

import com.projectlibre1.pm.graphic.model.event.CacheEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import org.apache.commons.collections.ListUtils;

public class CompositeCacheEvent
extends EventObject {
    protected List nodeEvents;
    protected List edgeEvents;
    protected List insertedNodes;
    protected List removedNodes;
    protected List updatedNodes;
    protected List insertedEdges;
    protected List removedEdges;
    protected List updatedEdges;
    protected boolean diffListsGenerated = false;

    public CompositeCacheEvent(Object object, List list, List list2) {
        super(object);
        this.nodeEvents = list;
        this.edgeEvents = list2;
    }

    public List getEdgeEvents() {
        return this.edgeEvents;
    }

    public void setEdgeEvents(List list) {
        this.edgeEvents = list;
    }

    public List getNodeEvents() {
        return this.nodeEvents;
    }

    public void setNodeEvents(List list) {
        this.nodeEvents = list;
    }

    @Override
    public String toString() {
        return "CompositeGraphicNodeEvent: \n\t" + String.valueOf(this.nodeEvents) + " \n\t" + String.valueOf(this.edgeEvents);
    }

    private void generateDiffLists() {
        List list;
        if (this.diffListsGenerated) {
            return;
        }
        block10: for (CacheEvent cacheEvent : this.nodeEvents) {
            list = cacheEvent.getNodes();
            switch (cacheEvent.getType()) {
                case 0: {
                    if (list == null || list.size() <= 0) continue block10;
                    if (this.updatedNodes == null) {
                        this.updatedNodes = new ArrayList(list.size());
                    }
                    this.updatedNodes.addAll(list);
                    continue block10;
                }
                case 1: {
                    List list2;
                    if (this.removedNodes != null && (list2 = ListUtils.intersection(list, this.removedNodes)).size() > 0) {
                        this.removedNodes.removeAll(list2);
                        list.removeAll(list2);
                        if (this.updatedNodes == null) {
                            this.updatedNodes = new ArrayList(list.size());
                        }
                        this.updatedNodes.addAll(list2);
                    }
                    if (list == null || list.size() <= 0) continue block10;
                    if (this.insertedNodes == null) {
                        this.insertedNodes = new ArrayList(list.size());
                    }
                    this.insertedNodes.addAll(list);
                    continue block10;
                }
                case 2: {
                    if (list == null || list.size() <= 0) continue block10;
                    if (this.removedNodes == null) {
                        this.removedNodes = new ArrayList(list.size());
                    }
                    this.removedNodes.addAll(list);
                    continue block10;
                }
            }
        }
        block11: for (CacheEvent cacheEvent : this.edgeEvents) {
            list = cacheEvent.getNodes();
            switch (cacheEvent.getType()) {
                case 0: {
                    if (list == null || list.size() <= 0) continue block11;
                    if (this.updatedEdges == null) {
                        this.updatedEdges = new ArrayList(list.size());
                    }
                    this.updatedEdges.addAll(list);
                    continue block11;
                }
                case 1: {
                    if (list == null || list.size() <= 0) continue block11;
                    if (this.insertedEdges == null) {
                        this.insertedEdges = new ArrayList(list.size());
                    }
                    this.insertedEdges.addAll(list);
                    continue block11;
                }
                case 2: {
                    if (list == null || list.size() <= 0) continue block11;
                    if (this.removedEdges == null) {
                        this.removedEdges = new ArrayList(list.size());
                    }
                    this.removedEdges.addAll(list);
                    continue block11;
                }
            }
        }
        this.diffListsGenerated = true;
    }

    public List getInsertedNodes() {
        this.generateDiffLists();
        return this.insertedNodes;
    }

    public List getRemovedNodes() {
        this.generateDiffLists();
        return this.removedNodes;
    }

    public List getUpdatedNodes() {
        this.generateDiffLists();
        return this.updatedNodes;
    }

    public List getInsertedEdges() {
        this.generateDiffLists();
        return this.insertedEdges;
    }

    public List getRemovedEdges() {
        this.generateDiffLists();
        return this.removedEdges;
    }

    public List getUpdatedEdges() {
        this.generateDiffLists();
        return this.updatedEdges;
    }

    public boolean isNodeHierarchy() {
        return this.nodeEvents != null;
    }
}

