/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.rest.core.internal.channel;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.config.core.ConfigDescription;
import org.openhab.core.config.core.ConfigDescriptionRegistry;
import org.openhab.core.config.core.dto.ConfigDescriptionDTO;
import org.openhab.core.config.core.dto.ConfigDescriptionDTOMapper;
import org.openhab.core.io.rest.LocaleService;
import org.openhab.core.io.rest.RESTResource;
import org.openhab.core.io.rest.Stream2JSONInputStream;
import org.openhab.core.thing.dto.ChannelTypeDTO;
import org.openhab.core.thing.profiles.ProfileType;
import org.openhab.core.thing.profiles.ProfileTypeRegistry;
import org.openhab.core.thing.profiles.TriggerProfileType;
import org.openhab.core.thing.type.ChannelKind;
import org.openhab.core.thing.type.ChannelType;
import org.openhab.core.thing.type.ChannelTypeRegistry;
import org.openhab.core.thing.type.ChannelTypeUID;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JSONRequired;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsApplicationSelect;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsName;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;

@Path(value="channel-types")
@RolesAllowed(value={"administrator"})
@SecurityRequirement(name="oauth2", scopes={"admin"})
@Tag(name="channel-types")
@Component
@JaxrsResource
@JaxrsName(value="channel-types")
@JaxrsApplicationSelect(value="(osgi.jaxrs.name=openhab)")
@JSONRequired
@NonNullByDefault
public class ChannelTypeResource
implements RESTResource {
    public static final String PATH_CHANNEL_TYPES = "channel-types";
    private final ChannelTypeRegistry channelTypeRegistry;
    private final ConfigDescriptionRegistry configDescriptionRegistry;
    private final LocaleService localeService;
    private final ProfileTypeRegistry profileTypeRegistry;

    @Activate
    public ChannelTypeResource(@Reference ChannelTypeRegistry channelTypeRegistry, @Reference ConfigDescriptionRegistry configDescriptionRegistry, @Reference LocaleService localeService, @Reference ProfileTypeRegistry profileTypeRegistry) {
        this.channelTypeRegistry = channelTypeRegistry;
        this.configDescriptionRegistry = configDescriptionRegistry;
        this.localeService = localeService;
        this.profileTypeRegistry = profileTypeRegistry;
    }

    @GET
    @Produces(value={"application/json"})
    @Operation(operationId="getChannelTypes", summary="Gets all available channel types.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ChannelTypeDTO.class), uniqueItems=true))})})
    public Response getAll(@HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language, @QueryParam(value="prefixes") @Parameter(description="filter UIDs by prefix (multiple comma-separated prefixes allowed, for example: 'system,mqtt')") @Nullable String prefixes) {
        Locale locale = this.localeService.getLocale(language);
        Stream<ChannelTypeDTO> channelStream = this.channelTypeRegistry.getChannelTypes(locale).stream().map(c -> this.convertToChannelTypeDTO((ChannelType)c, locale));
        if (prefixes != null) {
            Predicate<ChannelTypeDTO> filter = ct -> false;
            String[] stringArray = prefixes.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String prefix = stringArray[n2];
                filter = filter.or(ct -> ct.UID.startsWith(prefix + ":"));
                ++n2;
            }
            channelStream = channelStream.filter(filter);
        }
        return Response.ok((Object)new Stream2JSONInputStream(channelStream)).build();
    }

    @GET
    @Path(value="/{channelTypeUID}")
    @Produces(value={"application/json"})
    @Operation(operationId="getChannelTypeByUID", summary="Gets channel type by UID.", responses={@ApiResponse(responseCode="200", description="Channel type with provided channelTypeUID does not exist.", content={@Content(schema=@Schema(implementation=ChannelTypeDTO.class))}), @ApiResponse(responseCode="404", description="No content")})
    public Response getByUID(@PathParam(value="channelTypeUID") @Parameter(description="channelTypeUID") String channelTypeUID, @HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language) {
        Locale locale = this.localeService.getLocale(language);
        ChannelType channelType = this.channelTypeRegistry.getChannelType(new ChannelTypeUID(channelTypeUID), locale);
        if (channelType != null) {
            return Response.ok((Object)this.convertToChannelTypeDTO(channelType, locale)).build();
        }
        return Response.noContent().build();
    }

    @GET
    @Path(value="/{channelTypeUID}/linkableItemTypes")
    @Produces(value={"application/json"})
    @Operation(operationId="getLinkableItemTypesByChannelTypeUID", summary="Gets the item types the given trigger channel type UID can be linked to.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=String.class), uniqueItems=true))}), @ApiResponse(responseCode="204", description="No content: channel type has no linkable items or is no trigger channel."), @ApiResponse(responseCode="404", description="Given channel type UID not found.")})
    public Response getLinkableItemTypes(@PathParam(value="channelTypeUID") @Parameter(description="channelTypeUID") String channelTypeUID) {
        ChannelTypeUID ctUID = new ChannelTypeUID(channelTypeUID);
        ChannelType channelType = this.channelTypeRegistry.getChannelType(ctUID);
        if (channelType == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (channelType.getKind() != ChannelKind.TRIGGER) {
            return Response.noContent().build();
        }
        HashSet result = new HashSet();
        for (ProfileType profileType : this.profileTypeRegistry.getProfileTypes()) {
            TriggerProfileType type;
            if (!(profileType instanceof TriggerProfileType) || !(type = (TriggerProfileType)profileType).getSupportedChannelTypeUIDs().contains(ctUID)) continue;
            result.addAll(profileType.getSupportedItemTypes());
        }
        if (result.isEmpty()) {
            return Response.noContent().build();
        }
        return Response.ok(result).build();
    }

    private ChannelTypeDTO convertToChannelTypeDTO(ChannelType channelType, Locale locale) {
        URI descURI = channelType.getConfigDescriptionURI();
        ConfigDescription configDescription = descURI == null ? null : this.configDescriptionRegistry.getConfigDescription(descURI, locale);
        ConfigDescriptionDTO configDescriptionDTO = configDescription == null ? null : ConfigDescriptionDTOMapper.map((ConfigDescription)configDescription);
        List parameters = configDescriptionDTO == null ? List.of() : configDescriptionDTO.parameters;
        List parameterGroups = configDescriptionDTO == null ? List.of() : configDescriptionDTO.parameterGroups;
        return new ChannelTypeDTO(channelType.getUID().toString(), channelType.getLabel(), channelType.getDescription(), channelType.getCategory(), channelType.getItemType(), channelType.getUnitHint(), channelType.getKind(), parameters, parameterGroups, channelType.getState(), channelType.getTags(), channelType.isAdvanced(), channelType.getCommandDescription());
    }
}

