%% Generated by lilypond-book
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************

#(ly:set-option 'eps-box-padding 3.000000)



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
}

\layout {
  
}




% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "snippets/generating-custom-flags.ly"
\sourcefileline 0
%% DO NOT EDIT this file manually; it was automatically
%% generated from `Documentation/snippets/new/`.
%%
%% Make any changes in `Documentation/snippets/new/`,
%% then run `scripts/auxiliar/makelsr.pl --new`.
%%
%% This file is in the public domain.
%%
%% Note: this file works from version 2.23.14.

\version "2.23.14"

\header {
%% Translation of GIT committish: a8a85e19654e46d725563e6deba44083ef137a2c
  texidocja = "
@code{Flag} Grob の @code{stencil} プロパティをカスタム Scheme 関数に@c
セットし、符尾のグリフを生成することができます。
"
  doctitleja = "符尾をカスタマイズする"

%% Translation of GIT committish: a3fd5364fc4f247579da0ed2bfea887ab37285c6
  texidocfr = "
Une fonction Scheme personnalisée permet de redéfinir la propriété
@code{stencil} de l'objet @code{Flag}, de sorte à modifier le glyphe
utilisé pour les crochets de croche.
"

  doctitlefr = "Génération de crochets personnalisés"

%% Translation of GIT committish: ff9ca62acddb818b7788d7818a5c7eb0ddb6cdcb
  texidoces = "
La propiedad @code{stencil} del grob @code{Flag} (el objeto gráfico corchete)
se puede fijar a una función de Scheme personalizada que genere el
glifo del corchete.

"
  doctitlees = "Generar corchetes personalizados"

%% Translation of GIT committish: ff9ca62acddb818b7788d7818a5c7eb0ddb6cdcb
  texidocca = "
La propietat @code{stencil} del grob @code{Flag} (l'objecte gràfic
claudàtor) es pot fixar a un funció de l'Scheme personalitzat que
genera el glif del claudàtor.

"
  doctitleca = "Generar claudàtors personalitzats"

  lsrtags = "rhythms, tweaks-and-overrides"

  texidoc = "
The @code{stencil} property of the @code{Flag} grob can be set to a
custom scheme function to generate the glyph for the flag.
"

  doctitle = "Generating custom flags"
} % begin verbatim


#(define-public (weight-flag grob)
   (let* ((stem-grob (ly:grob-parent grob X))
          (log (- (ly:grob-property stem-grob 'duration-log) 2))
          (is-up? (eqv? (ly:grob-property stem-grob 'direction) UP))
          (yext (if is-up? (cons (* log -0.8) 0) (cons 0 (* log 0.8))))
          (flag-stencil (make-filled-box-stencil '(-0.4 . 0.4) yext))
          (stroke-style (ly:grob-property grob 'stroke-style))
          (stroke-stencil (if (equal? stroke-style "grace")
                              (make-line-stencil 0.2 -0.9 -0.4 0.9 -0.4)
                              empty-stencil)))
     (ly:stencil-add flag-stencil stroke-stencil)))


% Create a flag stencil by looking up the glyph from the font
#(define (inverted-flag grob)
   (let* ((stem-grob (ly:grob-parent grob X))
          (dir (if (eqv? (ly:grob-property stem-grob 'direction) UP) "d" "u"))
          (flag (retrieve-glyph-flag "" dir "" grob))
          (line-thickness (ly:staff-symbol-line-thickness grob))
          (stem-thickness (ly:grob-property stem-grob 'thickness))
          (stem-width (* line-thickness stem-thickness))
          (stroke-style (ly:grob-property grob 'stroke-style))
          (stencil (if (null? stroke-style)
                       flag
                       (add-stroke-glyph flag stem-grob dir stroke-style "")))
          (rotated-flag (ly:stencil-rotate-absolute stencil 180 0 0)))
     (ly:stencil-translate rotated-flag (cons (- (/ stem-width 2)) 0))))

snippetexamplenotes =
{
  \autoBeamOff c'8 d'16 c'32 d'64 \acciaccatura {c'8} d'64
}

{
  \time 1/4
  \textMark "Normal flags"
  \snippetexamplenotes

  \textMark "Custom flag: inverted"
  \override Flag.stencil = #inverted-flag
  \snippetexamplenotes

  \textMark "Custom flag: weight"
  \override Flag.stencil = #weight-flag
  \snippetexamplenotes

  \textMark "Revert to normal"
  \revert Flag.stencil
  \snippetexamplenotes
}



% ****************************************************************
% end ly snippet
% ****************************************************************
