%% Generated by lilypond-book
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************

#(ly:set-option 'eps-box-padding 3.000000)



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
}

\layout {
  
}




% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "snippets/measure-centered-bar-numbers.ly"
\sourcefileline 0
%% DO NOT EDIT this file manually; it was automatically
%% generated from `Documentation/snippets/new/`.
%%
%% Make any changes in `Documentation/snippets/new/`,
%% then run `scripts/auxiliar/makelsr.pl --new`.
%%
%% This file is in the public domain.
%%
%% Note: this file works from version 2.23.9.

\version "2.23.13"

\header {
%% Translation of GIT committish: a3fd5364fc4f247579da0ed2bfea887ab37285c6
  texidocfr = "
Il est d'usage, dans les partitions de musique de film, de trouver les
numéros de mesure centrés sur leur mesure. Ceci s'obtient en activant la
propriété de contexte @code{centerBarNumbers}. Lorsque cette propriété
est utilisée, le type de @emph{grob} (objet graphique) @code{BarNumber}
est remplacé par @code{CenteredBarNumber} .

L'exemple ci-dessous illustre plusieurs réglages : les numéros de mesure
sont à la fois centrés, encadrés, et disposés sous les portées.
"

  doctitlefr = "Centrage des numéros de mesure"

  lsrtags = "tweaks-and-overrides"

  texidoc = "
For film scores, a common convention is to center bar
numbers within their measure.  This is achieved through setting
the @code{centerBarNumbers} context property to true.  When this
is used, the type of the bar number grobs is @code{CenteredBarNumber}
rather than @code{BarNumber}.

This example demonstrates a number of settings: the centered bar
numbers are boxed and placed below the staves.
"

  doctitle = "Measure-centered bar numbers"
} % begin verbatim


\layout {
  \context {
    \Score
    centerBarNumbers = ##t
    barNumberVisibility = #all-bar-numbers-visible
    \override CenteredBarNumber.stencil
      = #(make-stencil-boxer 0.1 0.25 ly:text-interface::print)
    \override CenteredBarNumberLineSpanner.direction = #DOWN
  }
}

\new StaffGroup <<
  \new Staff \relative c' {
    d4-. f8( e d4) bes'-> |
    d,-. f8( e d4) cis'-> |
    g-. f8( d e4) g-> |
    a,1-> |
  }
  \new Staff \relative c {
    \clef bass
    d4 f8 e d2~ |
    4 f8 e d2~ |
    4 4 2 |
    a1 |
  }
>>



% ****************************************************************
% end ly snippet
% ****************************************************************
