<?php
/**
 * ChecksService
 * PHP version 5
 *
 * @category Class
 * @package  InfluxDB2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * InfluxDB OSS API Service
 *
 * The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.
 *
 * OpenAPI spec version: 2.0.0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 3.3.4
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace InfluxDB2\Service;

use InfluxDB2\DefaultApi;
use InfluxDB2\HeaderSelector;
use InfluxDB2\ObjectSerializer;

/**
 * ChecksService Class Doc Comment
 *
 * @category Class
 * @package  InfluxDB2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class ChecksService
{
    /**
     * @var DefaultApi
     */
    protected $defaultApi;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @param DefaultApi $defaultApi
     * @param HeaderSelector  $selector
     */
    public function __construct(DefaultApi $defaultApi)
    {
        $this->defaultApi = $defaultApi;
        $this->headerSelector = new HeaderSelector();
    }


    /**
     * Operation createCheck
     *
     * Add new check
     *
     * @param  \InfluxDB2\Model\Check $check Check to create (required)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Check|\InfluxDB2\Model\Error
     */
    public function createCheck($check)
    {
        list($response) = $this->createCheckWithHttpInfo($check);
        return $response;
    }

    /**
     * Operation createCheckWithHttpInfo
     *
     * Add new check
     *
     * @param  \InfluxDB2\Model\Check $check Check to create (required)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Check|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createCheckWithHttpInfo($check)
    {
        $request = $this->createCheckRequest($check);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Check';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'createCheck'
     *
     * @param  \InfluxDB2\Model\Check $check Check to create (required)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function createCheckRequest($check)
    {
        // verify the required parameter 'check' is set
        if ($check === null || (is_array($check) && count($check) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $check when calling createCheck'
            );
        }

        $resourcePath = '/api/v2/checks';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // body params
        $_tempBody = null;
        if (isset($check)) {
            $_tempBody = $check;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('POST', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation deleteChecksID
     *
     * Delete a check
     *
     * @param  string $check_id The check ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteChecksID($check_id, $zap_trace_span = null)
    {
        $this->deleteChecksIDWithHttpInfo($check_id, $zap_trace_span);
    }

    /**
     * Operation deleteChecksIDWithHttpInfo
     *
     * Delete a check
     *
     * @param  string $check_id The check ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteChecksIDWithHttpInfo($check_id, $zap_trace_span = null)
    {
        $request = $this->deleteChecksIDRequest($check_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        return [null, $response->getStatusCode(), $response->getHeaders()];
    }

    /**
     * Create request for operation 'deleteChecksID'
     *
     * @param  string $check_id The check ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function deleteChecksIDRequest($check_id, $zap_trace_span = null)
    {
        // verify the required parameter 'check_id' is set
        if ($check_id === null || (is_array($check_id) && count($check_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $check_id when calling deleteChecksID'
            );
        }

        $resourcePath = '/api/v2/checks/{checkID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($check_id !== null) {
            $resourcePath = str_replace(
                '{' . 'checkID' . '}',
                ObjectSerializer::toPathValue($check_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('DELETE', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation deleteChecksIDLabelsID
     *
     * Delete label from a check
     *
     * @param  string $check_id The check ID. (required)
     * @param  string $label_id The ID of the label to delete. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteChecksIDLabelsID($check_id, $label_id, $zap_trace_span = null)
    {
        $this->deleteChecksIDLabelsIDWithHttpInfo($check_id, $label_id, $zap_trace_span);
    }

    /**
     * Operation deleteChecksIDLabelsIDWithHttpInfo
     *
     * Delete label from a check
     *
     * @param  string $check_id The check ID. (required)
     * @param  string $label_id The ID of the label to delete. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteChecksIDLabelsIDWithHttpInfo($check_id, $label_id, $zap_trace_span = null)
    {
        $request = $this->deleteChecksIDLabelsIDRequest($check_id, $label_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        return [null, $response->getStatusCode(), $response->getHeaders()];
    }

    /**
     * Create request for operation 'deleteChecksIDLabelsID'
     *
     * @param  string $check_id The check ID. (required)
     * @param  string $label_id The ID of the label to delete. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function deleteChecksIDLabelsIDRequest($check_id, $label_id, $zap_trace_span = null)
    {
        // verify the required parameter 'check_id' is set
        if ($check_id === null || (is_array($check_id) && count($check_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $check_id when calling deleteChecksIDLabelsID'
            );
        }
        // verify the required parameter 'label_id' is set
        if ($label_id === null || (is_array($label_id) && count($label_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $label_id when calling deleteChecksIDLabelsID'
            );
        }

        $resourcePath = '/api/v2/checks/{checkID}/labels/{labelID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($check_id !== null) {
            $resourcePath = str_replace(
                '{' . 'checkID' . '}',
                ObjectSerializer::toPathValue($check_id),
                $resourcePath
            );
        }
        // path params
        if ($label_id !== null) {
            $resourcePath = str_replace(
                '{' . 'labelID' . '}',
                ObjectSerializer::toPathValue($label_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('DELETE', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getChecks
     *
     * List all checks
     *
     * @param  string $org_id Only show checks that belong to a specific organization ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  int $offset The offset for pagination. The number of records to skip. (optional)
     * @param  int $limit Limits the number of records returned. Default is &#x60;20&#x60;. (optional, default to 20)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Checks|\InfluxDB2\Model\Error
     */
    public function getChecks($org_id, $zap_trace_span = null, $offset = null, $limit = 20)
    {
        list($response) = $this->getChecksWithHttpInfo($org_id, $zap_trace_span, $offset, $limit);
        return $response;
    }

    /**
     * Operation getChecksWithHttpInfo
     *
     * List all checks
     *
     * @param  string $org_id Only show checks that belong to a specific organization ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  int $offset The offset for pagination. The number of records to skip. (optional)
     * @param  int $limit Limits the number of records returned. Default is &#x60;20&#x60;. (optional, default to 20)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Checks|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getChecksWithHttpInfo($org_id, $zap_trace_span = null, $offset = null, $limit = 20)
    {
        $request = $this->getChecksRequest($org_id, $zap_trace_span, $offset, $limit);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Checks';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getChecks'
     *
     * @param  string $org_id Only show checks that belong to a specific organization ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  int $offset The offset for pagination. The number of records to skip. (optional)
     * @param  int $limit Limits the number of records returned. Default is &#x60;20&#x60;. (optional, default to 20)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getChecksRequest($org_id, $zap_trace_span = null, $offset = null, $limit = 20)
    {
        // verify the required parameter 'org_id' is set
        if ($org_id === null || (is_array($org_id) && count($org_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $org_id when calling getChecks'
            );
        }
        if ($offset !== null && $offset < 0) {
            throw new \InvalidArgumentException('invalid value for "$offset" when calling ChecksService.getChecks, must be bigger than or equal to 0.');
        }

        if ($limit !== null && $limit > 100) {
            throw new \InvalidArgumentException('invalid value for "$limit" when calling ChecksService.getChecks, must be smaller than or equal to 100.');
        }
        if ($limit !== null && $limit < 1) {
            throw new \InvalidArgumentException('invalid value for "$limit" when calling ChecksService.getChecks, must be bigger than or equal to 1.');
        }


        $resourcePath = '/api/v2/checks';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($offset !== null) {
            $queryParams['offset'] = ObjectSerializer::toQueryValue($offset);
        }
        // query params
        if ($limit !== null) {
            $queryParams['limit'] = ObjectSerializer::toQueryValue($limit);
        }
        // query params
        if ($org_id !== null) {
            $queryParams['orgID'] = ObjectSerializer::toQueryValue($org_id);
        }
        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getChecksID
     *
     * Retrieve a check
     *
     * @param  string $check_id The check ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Check|\InfluxDB2\Model\Error
     */
    public function getChecksID($check_id, $zap_trace_span = null)
    {
        list($response) = $this->getChecksIDWithHttpInfo($check_id, $zap_trace_span);
        return $response;
    }

    /**
     * Operation getChecksIDWithHttpInfo
     *
     * Retrieve a check
     *
     * @param  string $check_id The check ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Check|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getChecksIDWithHttpInfo($check_id, $zap_trace_span = null)
    {
        $request = $this->getChecksIDRequest($check_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Check';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getChecksID'
     *
     * @param  string $check_id The check ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getChecksIDRequest($check_id, $zap_trace_span = null)
    {
        // verify the required parameter 'check_id' is set
        if ($check_id === null || (is_array($check_id) && count($check_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $check_id when calling getChecksID'
            );
        }

        $resourcePath = '/api/v2/checks/{checkID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($check_id !== null) {
            $resourcePath = str_replace(
                '{' . 'checkID' . '}',
                ObjectSerializer::toPathValue($check_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getChecksIDLabels
     *
     * List all labels for a check
     *
     * @param  string $check_id The check ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\LabelsResponse|\InfluxDB2\Model\Error
     */
    public function getChecksIDLabels($check_id, $zap_trace_span = null)
    {
        list($response) = $this->getChecksIDLabelsWithHttpInfo($check_id, $zap_trace_span);
        return $response;
    }

    /**
     * Operation getChecksIDLabelsWithHttpInfo
     *
     * List all labels for a check
     *
     * @param  string $check_id The check ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\LabelsResponse|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getChecksIDLabelsWithHttpInfo($check_id, $zap_trace_span = null)
    {
        $request = $this->getChecksIDLabelsRequest($check_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\LabelsResponse';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getChecksIDLabels'
     *
     * @param  string $check_id The check ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getChecksIDLabelsRequest($check_id, $zap_trace_span = null)
    {
        // verify the required parameter 'check_id' is set
        if ($check_id === null || (is_array($check_id) && count($check_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $check_id when calling getChecksIDLabels'
            );
        }

        $resourcePath = '/api/v2/checks/{checkID}/labels';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($check_id !== null) {
            $resourcePath = str_replace(
                '{' . 'checkID' . '}',
                ObjectSerializer::toPathValue($check_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation getChecksIDQuery
     *
     * Retrieve a check query
     *
     * @param  string $check_id The check ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\FluxResponse|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error
     */
    public function getChecksIDQuery($check_id, $zap_trace_span = null)
    {
        list($response) = $this->getChecksIDQueryWithHttpInfo($check_id, $zap_trace_span);
        return $response;
    }

    /**
     * Operation getChecksIDQueryWithHttpInfo
     *
     * Retrieve a check query
     *
     * @param  string $check_id The check ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\FluxResponse|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getChecksIDQueryWithHttpInfo($check_id, $zap_trace_span = null)
    {
        $request = $this->getChecksIDQueryRequest($check_id, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\FluxResponse';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'getChecksIDQuery'
     *
     * @param  string $check_id The check ID. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function getChecksIDQueryRequest($check_id, $zap_trace_span = null)
    {
        // verify the required parameter 'check_id' is set
        if ($check_id === null || (is_array($check_id) && count($check_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $check_id when calling getChecksIDQuery'
            );
        }

        $resourcePath = '/api/v2/checks/{checkID}/query';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($check_id !== null) {
            $resourcePath = str_replace(
                '{' . 'checkID' . '}',
                ObjectSerializer::toPathValue($check_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('GET', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation patchChecksID
     *
     * Update a check
     *
     * @param  string $check_id The check ID. (required)
     * @param  \InfluxDB2\Model\CheckPatch $check_patch Check update to apply (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Check|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error
     */
    public function patchChecksID($check_id, $check_patch, $zap_trace_span = null)
    {
        list($response) = $this->patchChecksIDWithHttpInfo($check_id, $check_patch, $zap_trace_span);
        return $response;
    }

    /**
     * Operation patchChecksIDWithHttpInfo
     *
     * Update a check
     *
     * @param  string $check_id The check ID. (required)
     * @param  \InfluxDB2\Model\CheckPatch $check_patch Check update to apply (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Check|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function patchChecksIDWithHttpInfo($check_id, $check_patch, $zap_trace_span = null)
    {
        $request = $this->patchChecksIDRequest($check_id, $check_patch, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Check';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'patchChecksID'
     *
     * @param  string $check_id The check ID. (required)
     * @param  \InfluxDB2\Model\CheckPatch $check_patch Check update to apply (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function patchChecksIDRequest($check_id, $check_patch, $zap_trace_span = null)
    {
        // verify the required parameter 'check_id' is set
        if ($check_id === null || (is_array($check_id) && count($check_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $check_id when calling patchChecksID'
            );
        }
        // verify the required parameter 'check_patch' is set
        if ($check_patch === null || (is_array($check_patch) && count($check_patch) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $check_patch when calling patchChecksID'
            );
        }

        $resourcePath = '/api/v2/checks/{checkID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($check_id !== null) {
            $resourcePath = str_replace(
                '{' . 'checkID' . '}',
                ObjectSerializer::toPathValue($check_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($check_patch)) {
            $_tempBody = $check_patch;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('PATCH', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation postChecksIDLabels
     *
     * Add a label to a check
     *
     * @param  string $check_id The check ID. (required)
     * @param  \InfluxDB2\Model\LabelMapping $label_mapping Label to add (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\LabelResponse|\InfluxDB2\Model\Error
     */
    public function postChecksIDLabels($check_id, $label_mapping, $zap_trace_span = null)
    {
        list($response) = $this->postChecksIDLabelsWithHttpInfo($check_id, $label_mapping, $zap_trace_span);
        return $response;
    }

    /**
     * Operation postChecksIDLabelsWithHttpInfo
     *
     * Add a label to a check
     *
     * @param  string $check_id The check ID. (required)
     * @param  \InfluxDB2\Model\LabelMapping $label_mapping Label to add (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\LabelResponse|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function postChecksIDLabelsWithHttpInfo($check_id, $label_mapping, $zap_trace_span = null)
    {
        $request = $this->postChecksIDLabelsRequest($check_id, $label_mapping, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\LabelResponse';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'postChecksIDLabels'
     *
     * @param  string $check_id The check ID. (required)
     * @param  \InfluxDB2\Model\LabelMapping $label_mapping Label to add (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function postChecksIDLabelsRequest($check_id, $label_mapping, $zap_trace_span = null)
    {
        // verify the required parameter 'check_id' is set
        if ($check_id === null || (is_array($check_id) && count($check_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $check_id when calling postChecksIDLabels'
            );
        }
        // verify the required parameter 'label_mapping' is set
        if ($label_mapping === null || (is_array($label_mapping) && count($label_mapping) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $label_mapping when calling postChecksIDLabels'
            );
        }

        $resourcePath = '/api/v2/checks/{checkID}/labels';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($check_id !== null) {
            $resourcePath = str_replace(
                '{' . 'checkID' . '}',
                ObjectSerializer::toPathValue($check_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($label_mapping)) {
            $_tempBody = $label_mapping;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('POST', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation putChecksID
     *
     * Update a check
     *
     * @param  string $check_id The check ID. (required)
     * @param  \InfluxDB2\Model\Check $check Check update to apply (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\Check|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error
     */
    public function putChecksID($check_id, $check, $zap_trace_span = null)
    {
        list($response) = $this->putChecksIDWithHttpInfo($check_id, $check, $zap_trace_span);
        return $response;
    }

    /**
     * Operation putChecksIDWithHttpInfo
     *
     * Update a check
     *
     * @param  string $check_id The check ID. (required)
     * @param  \InfluxDB2\Model\Check $check Check update to apply (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\Check|\InfluxDB2\Model\Error|\InfluxDB2\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function putChecksIDWithHttpInfo($check_id, $check, $zap_trace_span = null)
    {
        $request = $this->putChecksIDRequest($check_id, $check, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\Check';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'putChecksID'
     *
     * @param  string $check_id The check ID. (required)
     * @param  \InfluxDB2\Model\Check $check Check update to apply (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function putChecksIDRequest($check_id, $check, $zap_trace_span = null)
    {
        // verify the required parameter 'check_id' is set
        if ($check_id === null || (is_array($check_id) && count($check_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $check_id when calling putChecksID'
            );
        }
        // verify the required parameter 'check' is set
        if ($check === null || (is_array($check) && count($check) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $check when calling putChecksID'
            );
        }

        $resourcePath = '/api/v2/checks/{checkID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }

        // path params
        if ($check_id !== null) {
            $resourcePath = str_replace(
                '{' . 'checkID' . '}',
                ObjectSerializer::toPathValue($check_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($check)) {
            $_tempBody = $check;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('PUT', $resourcePath, $httpBody, $headers, $queryParams);
    }

}
