/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.emoji.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class EmojiReference {
    public static final String githubUrl = "https://github.githubassets.com/images/icons/emoji/";
    private static ArrayList<Emoji> emojiList = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Emoji> getEmojiList() {
        if (emojiList != null) return emojiList;
        emojiList = new ArrayList(3000);
        String emojiReference = "/EmojiReference.txt";
        InputStream stream = EmojiReference.class.getResourceAsStream("/EmojiReference.txt");
        if (stream == null) {
            throw new IllegalStateException("Could not load /EmojiReference.txt classpath resource");
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
        try {
            String line = reader.readLine();
            while ((line = reader.readLine()) != null) {
                String[] fields = line.split("\t");
                try {
                    Emoji emoji = new Emoji(fields[0].charAt(0) == ' ' ? null : fields[0], fields[1].charAt(0) == ' ' ? null : fields[1], fields[2].charAt(0) == ' ' ? null : fields[2], fields[3].charAt(0) == ' ' ? null : fields[3], fields[4].charAt(0) == ' ' ? null : fields[4], fields[5].charAt(0) == ' ' ? null : fields[5], fields[6].charAt(0) == ' ' ? null : fields[6]);
                    emojiList.add(emoji);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new IllegalStateException("Error processing EmojiReference.txt", e);
                    return emojiList;
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Error processing EmojiReference.txt", e);
        }
    }

    public static class Emoji {
        public final String shortcut;
        public final String category;
        public final String emojiCheatSheetFile;
        public final String githubFile;
        public final String unicodeChars;
        public final String unicodeSampleFile;
        public final String unicodeCldr;

        public Emoji(String shortcut, String category, String emojiCheatSheetFile, String githubFile, String unicodeChars, String unicodeSampleFile, String unicodeCldr) {
            this.shortcut = shortcut;
            this.category = category;
            this.emojiCheatSheetFile = emojiCheatSheetFile;
            this.githubFile = githubFile;
            this.unicodeChars = unicodeChars;
            this.unicodeSampleFile = unicodeSampleFile;
            this.unicodeCldr = unicodeCldr;
        }
    }
}

