/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.util.MessageUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class ApplicationStateInfo {
    private boolean partialStateSaving;
    private Set<String> fullStateViewIds;

    public ApplicationStateInfo() {
        WebConfiguration config = WebConfiguration.getInstance();
        this.partialStateSaving = config.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.PartialStateSaving);
        if (this.partialStateSaving) {
            String[] viewIds = config.getOptionValue(WebConfiguration.WebContextInitParameter.FullStateSavingViewIds, ",");
            this.fullStateViewIds = new HashSet<String>(viewIds.length, 1.0f);
            this.fullStateViewIds.addAll(Arrays.asList(viewIds));
        }
    }

    public boolean usePartialStateSaving(String viewId) {
        if (viewId == null) {
            throw new IllegalArgumentException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_VIEW_ID", new Object[0]));
        }
        return this.partialStateSaving && !this.fullStateViewIds.contains(viewId);
    }
}

