/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.repository;

import java.awt.Dialog;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.ui.repository.Bundle;
import org.netbeans.modules.mercurial.ui.repository.ChangesetPickerPanel;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;

public final class HeadRevisionPicker
implements PropertyChangeListener {
    private final RevisionsPanel panel;
    private final JButton okButton;
    private final JButton cancelButton;

    public HeadRevisionPicker(File repository, File[] roots) {
        this.panel = new RevisionsPanel(repository, roots);
        this.okButton = new JButton(Bundle.CTL_HeadRevisionPicker_Select());
        this.okButton.getAccessibleContext().setAccessibleDescription(Bundle.ACSD_HeadRevisionPicker_Select());
        this.cancelButton = new JButton(Bundle.CTL_HeadRevisionPicker_Cancel());
        this.cancelButton.getAccessibleContext().setAccessibleDescription(Bundle.ACSD_HeadRevisionPicker_Cancel());
        this.okButton.setEnabled(false);
        this.panel.addPropertyChangeListener(this);
        this.panel.loadRevisions();
    }

    public boolean showDialog() {
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.panel, Bundle.ASCD_HeadRevisionPicker_dialog());
        dialogDescriptor.setOptions(new Object[]{this.okButton, this.cancelButton});
        dialogDescriptor.setModal(true);
        dialogDescriptor.setHelpCtx(new HelpCtx(this.getClass()));
        dialogDescriptor.setValid(false);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(Bundle.ASCD_HeadRevisionPicker_dialog());
        dialog.setVisible(true);
        dialog.setResizable(false);
        boolean ret = dialogDescriptor.getValue() == this.okButton;
        return ret;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.okButton != null && "prop.valid".equals(evt.getPropertyName())) {
            boolean valid = (Boolean)evt.getNewValue();
            this.okButton.setEnabled(valid);
        }
    }

    public HgLogMessage getSelectionRevision() {
        if (this.panel == null) {
            return null;
        }
        return this.panel.getSelectedRevision();
    }

    public static class RevisionsPanel
    extends ChangesetPickerPanel {
        public RevisionsPanel(File repo, File[] roots) {
            super(repo, roots);
            this.initComponents();
            this.setInitMessageInfoFetcher(new HeadsInfoFetcher());
        }

        @Override
        protected String getRefreshLabel() {
            return Bundle.MSG_Refreshing_Update_Versions();
        }

        @Override
        protected boolean acceptSelection(HgLogMessage rev) {
            return rev != null && rev.getMessage() != null;
        }

        @Override
        protected void loadRevisions() {
            super.loadRevisions();
        }

        private void initComponents() {
            this.jLabel1.setVisible(false);
            this.jLabel2.setVisible(false);
        }

        private static final class HeadsInfoFetcher
        extends ChangesetPickerPanel.MessageInfoFetcher {
            private HeadsInfoFetcher() {
            }

            @Override
            protected HgLogMessage[] getMessageInfo(File repository, Set<File> setRoots, int fetchRevisionLimit, OutputLogger logger) {
                HgLogMessage[] messages;
                try {
                    messages = HgCommand.getHeadRevisionsInfo(repository, false, logger);
                }
                catch (HgException ex) {
                    Logger.getLogger(HeadRevisionPicker.class.getName()).log(Level.INFO, null, ex);
                    messages = new HgLogMessage[]{};
                }
                return messages;
            }
        }
    }
}

