/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.graph.filter;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.filter.DependencyNodeFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndDependencyNodeFilter
implements DependencyNodeFilter {
    private final List<DependencyNodeFilter> filters;

    public AndDependencyNodeFilter(DependencyNodeFilter filter1, DependencyNodeFilter filter2) {
        this(Arrays.asList(filter1, filter2));
    }

    public AndDependencyNodeFilter(List<DependencyNodeFilter> filters) {
        this.filters = Collections.unmodifiableList(filters);
    }

    @Override
    public boolean accept(DependencyNode node) {
        for (DependencyNodeFilter filter : this.filters) {
            if (filter.accept(node)) continue;
            return false;
        }
        return true;
    }

    public List<DependencyNodeFilter> getDependencyNodeFilters() {
        return this.filters;
    }
}

