/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.analyzer;

import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.modules.java.hints.analyzer.Analyzer;
import org.netbeans.modules.java.hints.providers.spi.HintMetadata;
import org.netbeans.modules.java.hints.spiimpl.options.HintsSettings;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;

public final class AnalyzeFolder
extends AbstractAction
implements ContextAwareAction {
    private final boolean def;
    private final Lookup context;
    private static final Set<String> SUPPORTED_IDS = new HashSet<String>(Arrays.asList("create-javadoc", "error-in-javadoc"));

    public AnalyzeFolder() {
        this.context = Utilities.actionsGlobalContext();
        this.def = true;
        this.putValue("Name", NbBundle.getMessage(AnalyzeFolder.class, (String)"CTL_AnalyzeFolder"));
    }

    @Override
    public boolean isEnabled() {
        if (!this.def) {
            return super.isEnabled();
        }
        return Analyzer.normalizeLookup(this.context) != null;
    }

    public AnalyzeFolder(Lookup context) {
        this.context = context;
        this.def = false;
        this.setEnabled(Analyzer.normalizeLookup(context) != null);
        this.putValue("Name", NbBundle.getMessage(AnalyzeFolder.class, (String)"CTL_AnalyzeFolder"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                final HintsSettings hintsSettings = new HintsSettings(){
                    private final HintsSettings delegate = HintsSettings.getGlobalSettings();

                    public boolean isEnabled(HintMetadata hint) {
                        return SUPPORTED_IDS.contains(hint.id);
                    }

                    public void setEnabled(HintMetadata hint, boolean value) {
                        throw new UnsupportedOperationException("Not supported.");
                    }

                    public Preferences getHintPreferences(HintMetadata hint) {
                        return this.delegate.getHintPreferences(hint);
                    }

                    public Severity getSeverity(HintMetadata hint) {
                        return Severity.VERIFIER;
                    }

                    public void setSeverity(HintMetadata hint, Severity severity) {
                        throw new UnsupportedOperationException("Not supported.");
                    }
                };
                final Lookup normalizedLookup = Analyzer.normalizeLookup(AnalyzeFolder.this.context);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Analyzer.process(normalizedLookup != null ? normalizedLookup : Lookup.EMPTY, hintsSettings);
                    }
                });
            }
        });
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new AnalyzeFolder(actionContext);
    }

    public static final class ToolsAction
    extends SystemAction
    implements ContextAwareAction {
        private Action delegate = new AnalyzeFolder();

        public ToolsAction() {
            this.putValue("noIconInMenu", Boolean.TRUE);
        }

        public boolean isEnabled() {
            return this.delegate.isEnabled();
        }

        public void actionPerformed(ActionEvent e) {
            this.delegate.actionPerformed(e);
        }

        public Action createContextAwareInstance(Lookup actionContext) {
            return new AnalyzeFolder(actionContext);
        }

        public String getName() {
            return NbBundle.getMessage(AnalyzeFolder.class, (String)"CTL_AnalyzeFolder");
        }

        public HelpCtx getHelpCtx() {
            return null;
        }
    }
}

