/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.debugger.models;

import java.beans.PropertyChangeListener;
import java.util.function.Supplier;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.lsp.client.debugger.DAPDebugger;
import org.netbeans.modules.lsp.client.debugger.DAPFrame;
import org.netbeans.modules.lsp.client.debugger.DAPThread;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.util.WeakListeners;

public class CurrentFrameTracker {
    protected final DAPDebugger debugger;
    private final ChangeListener threadListener;
    private final PropertyChangeListener frameListener;
    private volatile DAPThread currentThread;
    private volatile DAPFrame currentFrame;

    public CurrentFrameTracker(ContextProvider contextProvider) {
        this.debugger = (DAPDebugger)contextProvider.lookupFirst(null, DAPDebugger.class);
        this.currentThread = this.debugger.getCurrentThread();
        Supplier<DAPFrame> getCurrentThreadFrame = () -> {
            DAPThread cachedCurrentThread = this.currentThread;
            return cachedCurrentThread != null ? cachedCurrentThread.getCurrentFrame() : null;
        };
        this.currentFrame = getCurrentThreadFrame.get();
        Runnable frameChanged = () -> {
            DAPFrame prevFrame = this.currentFrame;
            DAPFrame newFrame = (DAPFrame)getCurrentThreadFrame.get();
            if (prevFrame != newFrame) {
                this.currentFrame = newFrame;
                this.frameChanged();
            }
        };
        this.frameListener = evt -> {
            if (evt.getPropertyName() == null || "currentFrame".equals(evt.getPropertyName())) {
                frameChanged.run();
            }
        };
        this.threadListener = evt -> {
            boolean changed;
            CurrentFrameTracker currentFrameTracker = this;
            synchronized (currentFrameTracker) {
                DAPThread prevThread = this.currentThread;
                DAPThread newThread = this.debugger.getCurrentThread();
                changed = prevThread != newThread;
                if (changed) {
                    this.currentThread = newThread;
                    if (prevThread != null) {
                        prevThread.removePropertyChangeListener(this.frameListener);
                    }
                    if (newThread != null) {
                        newThread.addPropertyChangeListener(this.frameListener);
                    }
                }
            }
            if (changed) {
                frameChanged.run();
            }
        };
        this.debugger.addChangeListener(WeakListeners.change((ChangeListener)this.threadListener, (Object)this.debugger));
    }

    protected final DAPFrame getCurrentFrame() {
        return this.currentFrame;
    }

    protected void frameChanged() {
    }
}

