/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.multiview;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import org.netbeans.modules.j2ee.dd.api.ejb.EntityAndSession;
import org.netbeans.modules.j2ee.ddloaders.multiview.EntityAndSessionHelper;
import org.netbeans.modules.j2ee.ddloaders.multiview.NonEditableDocument;
import org.netbeans.modules.j2ee.ddloaders.multiview.Utils;
import org.netbeans.modules.j2ee.ddloaders.multiview.ui.EjbImplementationAndInterfacesForm;
import org.netbeans.modules.xml.multiview.cookies.LinkCookie;
import org.netbeans.modules.xml.multiview.ui.LinkButton;
import org.netbeans.modules.xml.multiview.ui.SectionNodeView;

public class EjbImplementationAndInterfacesPanel
extends EjbImplementationAndInterfacesForm {
    private static final Logger LOGGER = Logger.getLogger(EjbImplementationAndInterfacesForm.class.getName());
    private EntityAndSessionHelper helper;
    private NonEditableDocument beanClassDocument = new NonEditableDocument(){

        @Override
        protected String retrieveText() {
            return EjbImplementationAndInterfacesPanel.this.helper == null ? null : EjbImplementationAndInterfacesPanel.this.helper.getEjbClass();
        }
    };
    private NonEditableDocument localComponentDocument = new NonEditableDocument(){

        @Override
        protected String retrieveText() {
            return EjbImplementationAndInterfacesPanel.this.helper == null ? null : EjbImplementationAndInterfacesPanel.this.helper.getLocal();
        }
    };
    private NonEditableDocument localHomeDocument = new NonEditableDocument(){

        @Override
        protected String retrieveText() {
            return EjbImplementationAndInterfacesPanel.this.helper == null ? null : EjbImplementationAndInterfacesPanel.this.helper.getLocalHome();
        }
    };
    private NonEditableDocument remoteComponentDocument = new NonEditableDocument(){

        @Override
        protected String retrieveText() {
            return EjbImplementationAndInterfacesPanel.this.helper == null ? null : EjbImplementationAndInterfacesPanel.this.helper.getRemote();
        }
    };
    private NonEditableDocument remoteHomeDocument = new NonEditableDocument(){

        @Override
        protected String retrieveText() {
            return EjbImplementationAndInterfacesPanel.this.helper == null ? null : EjbImplementationAndInterfacesPanel.this.helper.getHome();
        }
    };
    private static final String LINK_BEAN = "linkBean";
    private static final String LINK_LOCAL = "linkLocal";
    private static final String LINK_LOCAL_HOME = "linkLocalHome";
    private static final String LINK_REMOTE = "linkRemote";
    private static final String LINK_REMOTE_HOME = "linkRemoteHome";

    public EjbImplementationAndInterfacesPanel(SectionNodeView sectionNodeView, EntityAndSessionHelper helper) {
        super(sectionNodeView);
        this.helper = helper;
        this.getBeanClassTextField().setDocument(this.beanClassDocument);
        this.getLocalComponentTextField().setDocument(this.localComponentDocument);
        this.getLocalHomeTextField().setDocument(this.localHomeDocument);
        this.getRemoteComponentTextField().setDocument(this.remoteComponentDocument);
        this.getRemoteHomeTextField().setDocument(this.remoteHomeDocument);
        this.scheduleRefreshView();
        this.initLinkButton(this.getBeanClassLinkButton(), LINK_BEAN);
        this.initLinkButton(this.getLocalComponentLinkButton(), LINK_LOCAL);
        this.initLinkButton(this.getLocalHomeLinkButton(), LINK_LOCAL_HOME);
        this.initLinkButton(this.getRemoteComponentLinkButton(), LINK_REMOTE);
        this.initLinkButton(this.getRemoteHomeLinkButton(), LINK_REMOTE_HOME);
    }

    private void initLinkButton(AbstractButton button, String key) {
        LinkButton.initLinkButton((AbstractButton)button, (LinkCookie)this, null, (String)key);
    }

    public void refreshView() {
        this.beanClassDocument.init();
        this.localComponentDocument.init();
        this.localHomeDocument.init();
        this.remoteComponentDocument.init();
        this.remoteHomeDocument.init();
    }

    public void dataModelPropertyChange(Object source, String propertyName, Object oldValue, Object newValue) {
        if (source instanceof EntityAndSession) {
            this.scheduleRefreshView();
        }
    }

    @Override
    public void linkButtonPressed(Object ddBean, String ddProperty) {
        String javaClass = null;
        if (LINK_BEAN.equals(ddProperty)) {
            javaClass = this.helper.getEjbClass();
        } else if (LINK_LOCAL.equals(ddProperty)) {
            javaClass = this.helper.getLocal();
        } else if (LINK_LOCAL_HOME.equals(ddProperty)) {
            javaClass = this.helper.getLocalHome();
        } else if (LINK_REMOTE.equals(ddProperty)) {
            javaClass = this.helper.getRemote();
        } else if (LINK_REMOTE_HOME.equals(ddProperty)) {
            javaClass = this.helper.getHome();
        }
        if (javaClass == null || "".equals(javaClass.trim())) {
            LOGGER.log(Level.INFO, "Could not resolve class for ddProperty:" + ddProperty);
            return;
        }
        Utils.openEditorFor(this.helper.ejbJarFile, javaClass);
    }
}

