/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser.ir;

import com.oracle.js.parser.ir.Expression;
import com.oracle.js.parser.ir.FunctionNode;
import com.oracle.js.parser.ir.IdentNode;
import com.oracle.js.parser.ir.LexicalContext;
import com.oracle.js.parser.ir.Node;
import com.oracle.js.parser.ir.PropertyNode;
import com.oracle.js.parser.ir.visitor.NodeVisitor;
import com.oracle.js.parser.ir.visitor.TranslatorNodeVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ClassElement
extends PropertyNode {
    private static final int KIND_METHOD = 1;
    private static final int KIND_ACCESSOR = 2;
    private static final int KIND_FIELD = 4;
    private static final int KIND_STATIC_INIT = 8;
    private static final int KIND_AUTO_ACCESSOR = 16;
    private final int kind;

    private ClassElement(long token, int finish, int kind, Expression key, Expression value, FunctionNode get, FunctionNode set, List<Expression> decorators, boolean hasComputedKey, boolean isStatic) {
        super(token, finish, key, value, get, set, isStatic, hasComputedKey, decorators);
        this.kind = kind;
    }

    private ClassElement(ClassElement element, int kind, Expression key, Expression value, FunctionNode get, FunctionNode set, List<Expression> decorators, boolean hasComputedKey, boolean isStatic) {
        super(element.getToken(), element.finish, key, value, get, set, isStatic, hasComputedKey, decorators);
        this.kind = kind;
    }

    public static ClassElement createMethod(long token, int finish, Expression key, Expression value, List<Expression> decorators, boolean isStatic, boolean hasComputedKey) {
        return new ClassElement(token, finish, 1, key, value, null, null, decorators, hasComputedKey, isStatic);
    }

    public static ClassElement createAccessor(long token, int finish, Expression key, FunctionNode get, FunctionNode set, List<Expression> decorators, boolean isStatic, boolean hasComputedKey) {
        return new ClassElement(token, finish, 2, key, null, get, set, decorators, hasComputedKey, isStatic);
    }

    public static ClassElement createField(long token, int finish, Expression key, Expression initialize, List<Expression> decorators, boolean isStatic, boolean hasComputedKey) {
        return new ClassElement(token, finish, 4, key, initialize, null, null, decorators, hasComputedKey, isStatic);
    }

    public static ClassElement createDefaultConstructor(long token, int finish, Expression key, Expression value) {
        return new ClassElement(token, finish, 1, key, value, null, null, Collections.emptyList(), false, false);
    }

    public static ClassElement createStaticInitializer(long token, int finish, FunctionNode functionNode) {
        return new ClassElement(token, finish, 8, null, functionNode, null, null, Collections.emptyList(), false, true);
    }

    public static ClassElement createAutoAccessor(long token, int finish, Expression key, FunctionNode initializer, List<Expression> classElementDecorators, boolean isStatic, boolean hasComputedKey) {
        return new ClassElement(token, finish, 16, key, initializer, null, null, classElementDecorators, hasComputedKey, isStatic);
    }

    @Override
    public Node accept(NodeVisitor<? extends LexicalContext> visitor) {
        if (visitor.enterClassElement(this)) {
            ClassElement element = this.setKey(this.key == null ? null : (Expression)this.key.accept(visitor)).setValue(this.value == null ? null : (Expression)this.value.accept(visitor)).setGetter(this.getter == null ? null : (FunctionNode)this.getter.accept(visitor)).setSetter(this.setter == null ? null : (FunctionNode)this.setter.accept(visitor));
            element = this.decorators != null ? element.setDecorators(Node.accept(visitor, new ArrayList())) : element.setDecorators(null);
            return visitor.leaveClassElement(element);
        }
        return this;
    }

    @Override
    public <R> R accept(TranslatorNodeVisitor<? extends LexicalContext, R> visitor) {
        return visitor.enterClassElement(this);
    }

    @Override
    public List<Expression> getDecorators() {
        return Collections.unmodifiableList(this.decorators);
    }

    public ClassElement setDecorators(List<Expression> decorators) {
        if (this.decorators == decorators) {
            return this;
        }
        return new ClassElement(this, this.kind, this.key, this.value, this.getter, this.setter, decorators, this.computed, this.isStatic);
    }

    @Override
    public ClassElement setGetter(FunctionNode get) {
        if (this.getter == get) {
            return this;
        }
        return new ClassElement(this, this.kind, this.key, this.value, get, this.setter, this.decorators, this.computed, this.isStatic);
    }

    public ClassElement setKey(Expression key) {
        if (this.key == key) {
            return this;
        }
        return new ClassElement(this, this.kind, key, this.value, this.getter, this.setter, this.decorators, this.computed, this.isStatic);
    }

    @Override
    public ClassElement setSetter(FunctionNode set) {
        if (this.setter == set) {
            return this;
        }
        return new ClassElement(this, this.kind, this.key, this.value, this.getter, set, this.decorators, this.computed, this.isStatic);
    }

    @Override
    public ClassElement setValue(Expression value) {
        if (this.value == value) {
            return this;
        }
        return new ClassElement(this, this.kind, this.key, value, this.getter, this.setter, this.decorators, this.computed, this.isStatic);
    }

    public boolean isAccessor() {
        return (this.kind & 2) != 0;
    }

    public boolean isAutoAccessor() {
        return (this.kind & 0x10) != 0;
    }

    public boolean isClassField() {
        return (this.kind & 4) != 0;
    }

    public boolean isClassFieldOrAutoAccessor() {
        return this.isClassField() || this.isAutoAccessor();
    }

    public boolean isClassStaticBlock() {
        return (this.kind & 8) != 0;
    }

    public boolean isMethod() {
        return (this.kind & 1) != 0;
    }

    public boolean isMethodOrAccessor() {
        return this.isMethod() || this.isAccessor() || this.isAutoAccessor();
    }

    public boolean isPrivate() {
        return this.key instanceof IdentNode && ((IdentNode)this.key).isPrivate();
    }

    @Override
    public boolean isStatic() {
        return this.isStatic;
    }

    @Override
    public void toString(StringBuilder sb, boolean printType) {
        if (this.decorators != null) {
            for (Expression decorator : this.decorators) {
                sb.append("@");
                decorator.toString(sb, printType);
                sb.append(" ");
            }
        }
        if (this.isStatic()) {
            sb.append("static ");
            if (this.isClassStaticBlock()) {
                sb.append("{}");
            }
        }
        if (this.isAutoAccessor()) {
            sb.append("accessor ");
        }
        if (this.isMethod()) {
            this.toStringKey(sb, printType);
            ((FunctionNode)this.value).toString(sb, printType);
        }
        if (this.isAccessor()) {
            if (this.getter != null) {
                sb.append("get ");
                this.toStringKey(sb, printType);
                this.getter.toString(sb, printType);
            }
            if (this.setter != null) {
                sb.append("set ");
                this.toStringKey(sb, printType);
                this.setter.toString(sb, printType);
            }
        }
        if (this.isClassFieldOrAutoAccessor()) {
            this.toStringKey(sb, printType);
            if (this.value != null) {
                sb.append(" = ");
                this.value.toString(sb, printType);
            }
        }
    }

    private void toStringKey(StringBuilder sb, boolean printType) {
        if (this.computed) {
            sb.append('[');
        }
        this.key.toString(sb, printType);
        if (this.computed) {
            sb.append(']');
        }
    }
}

