/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.spi.newproject;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.gradle.api.execute.GradleDistributionManager;
import org.netbeans.modules.gradle.newproject.GradleInitPanel;
import org.netbeans.modules.gradle.spi.GradleSettings;
import org.netbeans.modules.gradle.spi.newproject.BaseGradleWizardIterator;
import org.netbeans.modules.gradle.spi.newproject.Bundle;
import org.netbeans.modules.gradle.spi.newproject.TemplateOperation;
import org.openide.WizardDescriptor;
import org.openide.util.Exceptions;

public final class GradleInitWizard {
    public static final String PROP_JAVA_VERSIONS = "javaVersions";
    public static final String PROP_JAVA_VERSION = "javaVersion";
    public static final String PROP_TEST_FRAMEWORKS = "testFrameworks";
    public static final String PROP_TEST_FRAMEWORK = "testFramework";
    public static final String PROP_DSL = "DSL";
    public static final String PROP_COMMENTS = "comments";
    private final String type;
    private final String title;
    private Integer preferredJavaVersion;
    private TestFramework preferredTestFramework;
    private List<Integer> javaVersions;
    private List<TestFramework> testFrameworks;
    private List<String> important = List.of();

    private GradleInitWizard(String type, String title) {
        this.type = type;
        this.title = title;
    }

    public static GradleInitWizard create(String type, String title) {
        return new GradleInitWizard(type, title);
    }

    public GradleInitWizard withJavaVersions(List<Integer> javaVersions) {
        this.javaVersions = javaVersions;
        return this;
    }

    public GradleInitWizard withTestframeworks(List<TestFramework> testFrameworks) {
        this.testFrameworks = testFrameworks;
        return this;
    }

    public GradleInitWizard withPreferredJava(Integer version) {
        this.preferredJavaVersion = version;
        return this;
    }

    public GradleInitWizard withPreferredTestFramework(TestFramework framework) {
        this.preferredTestFramework = framework;
        return this;
    }

    public GradleInitWizard withImportantPaths(List<String> important) {
        this.important = important;
        return this;
    }

    public BaseGradleWizardIterator build() {
        return new GradleInitWizardIterator(this.type, this.title, this.important){

            @Override
            protected WizardDescriptor initData(WizardDescriptor data) {
                if (GradleInitWizard.this.javaVersions != null) {
                    data.putProperty(GradleInitWizard.PROP_JAVA_VERSIONS, GradleInitWizard.this.javaVersions);
                }
                if (GradleInitWizard.this.testFrameworks != null) {
                    data.putProperty(GradleInitWizard.PROP_TEST_FRAMEWORKS, GradleInitWizard.this.testFrameworks);
                }
                if (GradleInitWizard.this.preferredJavaVersion != null) {
                    data.putProperty(GradleInitWizard.PROP_JAVA_VERSION, (Object)GradleInitWizard.this.preferredJavaVersion);
                }
                if (GradleInitWizard.this.preferredTestFramework != null) {
                    data.putProperty(GradleInitWizard.PROP_TEST_FRAMEWORK, (Object)GradleInitWizard.this.preferredTestFramework);
                }
                return data;
            }
        };
    }

    public static enum TestFramework {
        CPP_TEST("cpptest"),
        JUNIT("junit"),
        JUNIT_5("junit-jupiter"),
        KOTLIN_TEST("kotlintest"),
        SCALA_TEST("scalatest"),
        SPOCK("spock"),
        TESTNG("testng"),
        XCTEST("xctest");

        private final String id;

        private TestFramework(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public String toString() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case CPP_TEST -> Bundle.LBL_TFW_CPP_TEST();
                case JUNIT -> Bundle.LBL_TFW_JUNIT();
                case JUNIT_5 -> Bundle.LBL_TFW_JUNIT_5();
                case KOTLIN_TEST -> Bundle.LBL_TFW_KOTLIN_TEST();
                case SCALA_TEST -> Bundle.LBL_TFW_SCALA_TEST();
                case SPOCK -> Bundle.LBL_TFW_SPOCK();
                case TESTNG -> Bundle.LBL_TFW_TESTNG();
                case XCTEST -> Bundle.LBL_TFW_XCTEST();
            };
        }
    }

    private static class GradleInitWizardIterator
    extends BaseGradleWizardIterator {
        private final String type;
        private final String title;
        private final List<String> important;

        private GradleInitWizardIterator(String type, String title, List<String> important) {
            this.type = type;
            this.title = title;
            this.important = important;
        }

        @Override
        protected void collectOperations(TemplateOperation ops, Map<String, Object> params) {
            GradleDSL dsl;
            String name = (String)params.get("name");
            String packageBase = (String)params.get("packageBase");
            File loc = (File)params.get("projdir");
            File root = new File(loc, name);
            TemplateOperation.InitOperation init = ops.createGradleInit(root, this.type);
            init.projectName(name);
            if (packageBase != null) {
                init.basePackage(packageBase);
            }
            init.dsl((dsl = (GradleDSL)((Object)params.get(GradleInitWizard.PROP_DSL))) == GradleDSL.KOTLIN ? "kotlin" : "groovy");
            if (params.get(GradleInitWizard.PROP_JAVA_VERSION) != null) {
                init.javaVersion(params.get(GradleInitWizard.PROP_JAVA_VERSION).toString());
            }
            if (params.get(GradleInitWizard.PROP_TEST_FRAMEWORK) != null) {
                init.testFramework(((TestFramework)((Object)params.get(GradleInitWizard.PROP_TEST_FRAMEWORK))).getId());
            }
            init.comments((Boolean)params.get(GradleInitWizard.PROP_COMMENTS));
            init.add();
            if (!GradleSettings.getDefault().isOffline()) {
                try {
                    init.gradleVersion(GradleDistributionManager.get().latestSupportedDistribution().getVersion());
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            List<String> open = this.important.stream().map(s -> packageBase != null ? s.replace("${package}", packageBase.replace('.', '/')) : s).map(s -> s.replace("${projectName}", name)).toList();
            ops.addProjectPreload(root, open);
        }

        @Override
        protected List<? extends WizardDescriptor.Panel<WizardDescriptor>> createPanels() {
            return List.of(new GradleInitPanel());
        }

        @Override
        protected String getTitle() {
            return this.title;
        }
    }

    public static enum GradleDSL {
        GROOVY,
        KOTLIN;


        public String toString() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case GROOVY -> Bundle.LBL_DSL_GROOVY();
                case KOTLIN -> Bundle.LBL_DSL_KOTLIN();
            };
        }
    }
}

