/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.laf.dark;

import java.awt.Color;
import java.awt.image.RGBImageFilter;

public class DarkIconFilter
extends RGBImageFilter {
    private static final float DARK_ICON_BRIGHTEN = 0.1f;

    @Override
    public int filterRGB(int x, int y, int color) {
        int a = color & 0xFF000000;
        int[] rgb = this.decode(color);
        int[] inverted = this.invert(rgb);
        int[] result = this.invertHueBrighten(inverted, 0.1f);
        return a | this.encode(result);
    }

    private int[] invert(int[] rgb) {
        return new int[]{255 - rgb[0], 255 - rgb[1], 255 - rgb[2]};
    }

    private int[] invertHueBrighten(int[] rgb, float brighten) {
        float[] hsb = new float[3];
        Color.RGBtoHSB(rgb[0], rgb[1], rgb[2], hsb);
        return this.decode(Color.HSBtoRGB(hsb[0] > 0.5f ? hsb[0] - 0.5f : hsb[0] + 0.5f, hsb[1], hsb[2] + (1.0f - hsb[2]) * brighten));
    }

    private int[] decode(int rgb) {
        return new int[]{(rgb & 0xFF0000) >> 16, (rgb & 0xFF00) >> 8, rgb & 0xFF};
    }

    private int encode(int[] rgb) {
        return this.toBoundaries(rgb[0]) << 16 | this.toBoundaries(rgb[1]) << 8 | this.toBoundaries(rgb[2]);
    }

    private int toBoundaries(int color) {
        return Math.max(0, Math.min(255, color));
    }
}

